/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util.helpmanagement;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.subsystemmanagement.SubsystemInfo;
import com.swimap.iview.framework.subsystemmanagement.SubsystemManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.InternalFrame;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.DebugTracer;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.RegistryUtilities;
import com.swimap.iview.util.helpmanagement.AbstractHelpManager;
import com.swimap.iview.util.helpmanagement.HelpClient;
import com.swimap.iview.util.helpmanagement.HelpIntegrator;
import com.swimap.iview.util.helpmanagement.HelpManagerUtil;
import com.swimap.iview.util.helpmanagement.IHedexHelpInterface;
import com.swimap.iview.util.helpmanagement.IHelpIntegrator;
import com.swimap.iview.util.helpmanagement.IHelpManager;
import com.swimap.iview.util.helpmanagement.IViewHelpBroker;
import com.swimap.iview.util.helpmanagement.IViewHelpSet;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Button;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JRootPane;

public final class HelpManager
extends AbstractHelpManager
implements IHelpManager {
    private static IviewLogger logger = IviewLogger.getLogger(HelpManager.class, (String)"IVIEW");
    static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/util/helpmanagement/Res");
    public static final String ANCHOR_SEPARATOR = "ANCHOR200703130318";
    public static final String HELP_ID_PROPERTY = "HELP_ID_PROPERTY";
    private static String destinationFileNameHeader = "help";
    public static final String CONFIRMEXITCMD = "mainprogramexitwithconfirm";
    public static final String ENDFLG = "mainprogramexit";
    public static final String CHANGEHELPSET = "changehelpsetcommand";
    public static final String SHAKEHANDCOMMAND = "shakehandcommand";
    public static final String SHOWHELPMENUFLG = "showhelpmenuflg";
    public static final String HELPSETPATHANDNAME = "helpsetpathandname";
    public static final String SUBHELPSETFILENAME = "subhelpsetfilename";
    public static final String REMOVESUBHELPSETFILENAME = "removesubhelpsetfilename";
    public static final String ADDSUBHELPSET = "addsubhelpsetcommand";
    public static final String REMOVESUBHELPSET = "removesubhelpsetcommand";
    private static final String HELP_FAST_LOAD = "fasthelpmode";
    static final int BUFFER_LENGTH = 1024;
    private static String baseFileNameHeader = "base";
    private static HelpClient helpClient = null;
    private static String helpSetName = "";
    private static ResourceBundle helpIDRes = null;
    private static File tmpFileDir = CommonUtil.getAbsoluteFile((String)"./help");
    public static final String Index_suffix = "_index.xml";
    public static final String Toc_suffix = "_toc.xml";
    public static final String Map_suffix = "_map.jhm";
    public static final String HS_FILE = "help.hs";
    public static final String Index_Dir = "plugin/index/";
    public static final String Toc_Dir = "plugin/toc/";
    public static final String Map_Dir = "plugin/map/";
    public static final String HELPSET_DIR = "plugin/hs/";
    public static final String SUBSYSTEM_HELP_DIR = "subsystemhelp";
    private static final String HELP_CLASSNAME_PARAM_NAME = "-DProductHelpClass";
    private static boolean isPreLaunch = false;
    private static IHelpIntegrator productHelpImp = null;
    private static HashMap<String, String> hedexParamMap = new HashMap(5);
    private static List<IHedexHelpInterface> hedexHelpListeners = null;
    static final String[] browsers = new String[]{"firefox", "netscape", "opera", "konqueror", "epiphany", "seamonkey", "galeon", "kazehakase", "mozilla"};
    private static HelpManager instance;
    private static String browserPath;
    private static Process process;
    private IViewHelpBroker helpBroker = null;
    private HelpSet helpSet = null;
    private Hashtable subHelpTable = new Hashtable(15);
    private Hashtable subHelpSetInHelpConfigureFile = new Hashtable(12);

    private HelpManager() {
        if (null == productHelpImp) {
            if (this.isNeedMerge()) {
                HelpManager.merge(baseFileNameHeader);
            }
            this.loadHelpSet();
        }
        if (!HelpManager.isWebBrowserEnabled()) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    HelpManagerUtil.getInstance().removeReadLock();
                    HelpManager.getInstance().launchHelper(HelpManager.ENDFLG);
                    DebugTracer.cleanup();
                }
            });
        }
    }

    public static HelpManager getInstance() {
        if (instance == null) {
            instance = new HelpManager();
        }
        return instance;
    }

    public static void updateHelpSet() {
        logger.debug((Object)"invoke the updateHelpSet() method!");
        StringBuffer helpSetNameBuf = new StringBuffer("");
        helpSetNameBuf.append("help");
        helpSetNameBuf.append(File.separator);
        helpSetNameBuf.append(Locale.getDefault().toString());
        helpSetNameBuf.append(File.separator);
        try {
            helpSetNameBuf.append(destinationFileNameHeader);
            if (!helpSetNameBuf.toString().endsWith(".hs")) {
                helpSetNameBuf.append(".hs");
            }
            HelpManager.setHelpSetName(helpSetNameBuf.toString());
        }
        catch (Exception ee) {
            logger.trace((Object)ee.getMessage(), (Throwable)ee);
        }
    }

    public static void setHelpSetName(String helpsetName) {
        HelpManager.getInstance().launchHelper(ENDFLG);
        helpSetName = helpsetName;
        logger.debug((Object)"invoke setHelpSetName()");
        HelpManager.getInstance().reloadHelpIdRes(helpSetName);
        HelpManager.getInstance().loadHelpSet(helpSetName);
        HelpManager.sendRemoteHelp(CHANGEHELPSET + helpsetName);
    }

    public void launchHelper(JDialog parent, String helpID) {
        if (null == productHelpImp) {
            try {
                HelpManager.sendRemoteHelp(helpID);
            }
            catch (Exception ex) {
                logger.trace((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            productHelpImp.launchHelper(parent, helpID);
        }
    }

    public synchronized void launchHelper(String helpID) {
        if (null == productHelpImp) {
            try {
                HelpManager.sendRemoteHelp(helpID);
            }
            catch (Exception ex) {
                logger.trace((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            productHelpImp.launchHelper(helpID);
        }
    }

    public synchronized void launchHelper(String helpID, String anchor) {
        if (productHelpImp instanceof HelpIntegrator) {
            ((HelpIntegrator)productHelpImp).launchHelper(helpID, anchor);
        } else {
            StringBuffer newID = new StringBuffer(40);
            newID.append(helpID);
            if (anchor != null && anchor.length() > 0) {
                newID.append(ANCHOR_SEPARATOR);
                newID.append(anchor);
            }
            this.launchHelper(newID.toString());
        }
    }

    @Override
    public void launchHelper() {
        if (null == productHelpImp) {
            String homeID = "";
            homeID = HelpManager.isWebBrowserEnabled() ? System.getProperty("homepage") : this.getHomeID();
            this.launchHelper(homeID);
        } else {
            productHelpImp.launchHelper();
        }
    }

    public void preLaunchHelp() {
        boolean isHelpLoaded = this.getStartFlg();
        if (!isHelpLoaded) {
            HelpManager.setIsHelpPreLaunch(true);
            this.launchHelper();
            HelpManager.setIsHelpPreLaunch(false);
        }
    }

    public static boolean isHelpPreLaunch() {
        return isPreLaunch;
    }

    private static void setIsHelpPreLaunch(boolean isHelpPreLaunch) {
        isPreLaunch = isHelpPreLaunch;
    }

    public static boolean isFastLoadingMode() {
        String isFastHelpLoading = System.getProperty(HELP_FAST_LOAD);
        if (null == isFastHelpLoading) {
            isFastHelpLoading = "true";
        }
        return Boolean.valueOf(isFastHelpLoading) != false && productHelpImp == null;
    }

    public void enableHelpOnButton(Component comp, String id) throws Exception {
        if (null == productHelpImp) {
            if (!(comp instanceof AbstractButton) && !(comp instanceof Button)) {
                throw new IllegalArgumentException("Invalid Component");
            }
            try {
                if (helpIDRes != null) {
                    id = helpIDRes.getString(id);
                }
            }
            catch (Exception ex) {
                logger.warn((Object)("Can not find the resource for help ID " + id + " in file ./help/helpid.properties"));
            }
            final String nid = id;
            if (nid == null) {
                throw new Exception("id is null");
            }
            if (comp instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)comp;
                ActionListener[] actionListeners = abstractButton.getActionListeners();
                this.removeHelpListener(abstractButton, actionListeners);
                abstractButton.addActionListener(new LaunchHelpListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HelpManager.this.launchHelper(nid);
                    }
                });
            } else if (comp instanceof Button) {
                Button button = (Button)comp;
                ActionListener[] actionListeners = button.getActionListeners();
                this.removeHelpListener(button, actionListeners);
                button.addActionListener(new LaunchHelpListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HelpManager.this.launchHelper(nid);
                    }
                });
            }
        } else {
            productHelpImp.enableHelpOnButton(comp, id);
        }
    }

    private void removeHelpListener(Component component, ActionListener[] actionListeners) {
        if (null != actionListeners && null != component) {
            for (int i = 0; i < actionListeners.length; ++i) {
                if (!(actionListeners[i] instanceof LaunchHelpListener)) continue;
                logger.trace((Object)("Removing the old action listener " + actionListeners[i]));
                if (component instanceof AbstractButton) {
                    ((AbstractButton)component).removeActionListener(actionListeners[i]);
                    continue;
                }
                if (!(component instanceof Button)) continue;
                ((Button)component).removeActionListener(actionListeners[i]);
            }
        }
    }

    public void enableHelpOnButton(MenuItem comp, String id) throws Exception {
        if (null == productHelpImp) {
            if (comp == null) {
                throw new IllegalArgumentException("Invalid Component");
            }
            try {
                if (helpIDRes != null) {
                    id = helpIDRes.getString(id);
                }
            }
            catch (Exception ex) {
                logger.warn((Object)("Can not find the resource for help ID " + id + " in file ./help/helpid.properties"));
            }
            final String nid = id;
            if (nid == null) {
                throw new Exception("id is null");
            }
            comp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HelpManager.this.launchHelper(nid);
                }
            });
        } else {
            productHelpImp.enableHelpOnButton(comp, id);
        }
    }

    public void enableHelpKey(Component comp, String id) {
        if (null == productHelpImp) {
            if (comp instanceof InternalFrame) {
                this.enableHelpKey(((InternalFrame)comp).getContentPane(), id);
            } else if (comp instanceof JRootPane && ((JRootPane)comp).getParent() instanceof InternalFrame) {
                this.enableHelpKey(((JRootPane)comp).getContentPane(), id);
            }
            if (helpIDRes != null) {
                try {
                    this.helpBroker.enableHelpKey(comp, helpIDRes.getString(id), this.helpSet);
                    return;
                }
                catch (Exception ex) {
                    logger.warn((Object)("Can not find the resource for help ID " + id + " in file ./help/helpid.properties"));
                }
            }
            try {
                this.helpBroker.enableHelpKey(comp, id, this.helpSet);
            }
            catch (Exception e) {
                logger.warn((Object)("Can not find the help ID " + id));
            }
        } else {
            productHelpImp.enableHelpKey(comp, id);
        }
    }

    public void enableHelpKey(Component comp, String id, String anchor) {
        if (productHelpImp instanceof HelpIntegrator) {
            ((HelpIntegrator)productHelpImp).enableHelpKey(comp, id, anchor);
        } else {
            StringBuffer newID = new StringBuffer(40);
            newID.append(id);
            if (anchor != null && anchor.length() > 0) {
                newID.append(ANCHOR_SEPARATOR);
                newID.append(anchor);
            }
            this.enableHelpKey(comp, newID.toString());
        }
    }

    public void loadHelpSet(String helpsetname) {
        block4: {
            try {
                this.helpSet = this.getHelpSet(helpsetname);
                if (this.helpBroker == null) {
                    this.helpBroker = new IViewHelpBroker(this.helpSet);
                } else {
                    this.helpBroker.setHelpSet(this.helpSet);
                }
            }
            catch (Exception ee) {
                logger.trace((Object)ee.getMessage(), (Throwable)ee);
                if (!HelpManager.isWebBrowserEnabled()) break block4;
                this.helpBroker = new IViewHelpBroker();
            }
        }
    }

    public void loadHelpSet() {
        StringBuffer helpSetNameBuf = new StringBuffer("");
        helpSetNameBuf.append("help");
        helpSetNameBuf.append(File.separator);
        helpSetNameBuf.append(Locale.getDefault().toString());
        helpSetNameBuf.append(File.separator);
        String tempStr = helpSetNameBuf.toString();
        try {
            helpSetNameBuf.append(destinationFileNameHeader);
            if (!helpSetNameBuf.toString().endsWith(".hs")) {
                helpSetNameBuf.append(".hs");
            }
            this.loadHelpSet(helpSetNameBuf.toString());
            this.addSubsystemSubHelpSet(tempStr);
        }
        catch (Exception ee) {
            logger.trace((Object)ee.getMessage(), (Throwable)ee);
        }
    }

    private void addSubsystemSubHelpSet(String path) {
        path = path + SUBSYSTEM_HELP_DIR + File.separator;
        List infoList = SubsystemManager.getInstance().getAllSubsystem();
        if (null == this.helpSet) {
            logger.debug((Object)("helpSet is null. " + destinationFileNameHeader + ".hs is missing in help/en_US(or zh_CN) folder."));
            return;
        }
        for (SubsystemInfo info : infoList) {
            String subSystemHelpSet = path + info.getId() + File.separator + destinationFileNameHeader + ".hs";
            this.addSubHelpSet(subSystemHelpSet);
        }
    }

    private HelpSet getHelpSet(String helpSetName) throws HelpSetException {
        IViewHelpSet tmpHelpSet = null;
        if (null == helpSetName || helpSetName.trim().length() == 0) {
            logger.debug((Object)"helpSetName is null or length equals zero.");
            return tmpHelpSet;
        }
        ClassLoader loader = this.getClass().getClassLoader();
        String fullHelpSetName = "";
        StringBuffer helpSetNameBuf = new StringBuffer("");
        URL url = null;
        if (helpSetName.toLowerCase().startsWith("jar:file:")) {
            fullHelpSetName = helpSetName;
        } else {
            helpSetNameBuf.append("file:");
            helpSetNameBuf.append(System.getProperty("user.dir"));
            helpSetNameBuf.append(File.separator);
            helpSetNameBuf.append(helpSetName);
            if (!helpSetNameBuf.toString().endsWith(".hs")) {
                helpSetNameBuf.append(".hs");
            }
            fullHelpSetName = helpSetNameBuf.toString();
        }
        logger.debug((Object)("fullHelpSetName=" + fullHelpSetName));
        url = HelpSet.findHelpSet((ClassLoader)loader, (String)fullHelpSetName);
        if (null == url) {
            try {
                url = new URL(fullHelpSetName.replace("#", "%23"));
            }
            catch (MalformedURLException mue) {
                logger.trace((Object)mue.getMessage(), (Throwable)mue);
            }
        }
        tmpHelpSet = new IViewHelpSet(loader, url);
        return tmpHelpSet;
    }

    public void enableHelp(Component comp, String id) {
        if (null == productHelpImp) {
            if (helpIDRes != null) {
                try {
                    this.helpBroker.enableHelp(comp, helpIDRes.getString(id), this.helpSet);
                    return;
                }
                catch (Exception ex) {
                    logger.warn((Object)("Can not find the resource for help ID " + id + " in file ./help/helpid.properties"));
                }
            }
            try {
                this.helpBroker.enableHelp(comp, id, this.helpSet);
            }
            catch (Exception e) {
                logger.warn((Object)("Can not find the help ID " + id));
                logger.trace((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            productHelpImp.enableHelp(comp, id);
        }
    }

    static void sendRemoteHelp(String helpID) {
        if (null != FrameworkUtilities.getTerminalManager() && FrameworkUtilities.getTerminalManager().isLockOrUnLockDialogshown()) {
            logger.trace((Object)"Client is locked. Help window will not be shown.");
            return;
        }
        if (HelpManager.isWebBrowserEnabled()) {
            if (ENDFLG.equals(helpID)) {
                return;
            }
            if (helpID != null && (helpID.startsWith(CHANGEHELPSET) || helpID.startsWith(ADDSUBHELPSET) || helpID.startsWith(REMOVESUBHELPSET))) {
                return;
            }
            if (!HelpManager.isHelpPreLaunch()) {
                HelpManager.launchHelpBrowser(helpID);
                return;
            }
            return;
        }
        if (helpClient == null) {
            logger.trace((Object)"HelpManger sendRemoteHelp");
            if (ENDFLG.equals(helpID)) {
                return;
            }
            if (helpID != null && (helpID.startsWith(CHANGEHELPSET) || helpID.startsWith(ADDSUBHELPSET) || helpID.startsWith(REMOVESUBHELPSET))) {
                return;
            }
            try {
                helpClient = new HelpClient();
            }
            catch (Exception e) {
                logger.trace((Object)e.getMessage(), (Throwable)e);
                return;
            }
        }
        helpClient.sendMessage(helpID);
    }

    public static String getHedexServerURL(String helpId, boolean displayTreeStructure) {
        String url = HelpManager.getURL(helpId);
        if (null != url && !displayTreeStructure) {
            url = url + "&ui=1";
        }
        return url;
    }

    private static String getURL(String helpID) {
        String url = null;
        url = helpID == null || helpID.equals(System.getProperty("homepage")) ? System.getProperty("homepage") : System.getProperty("webhost") + helpID;
        url = HelpManager.changeURL(url);
        url = HelpManager.replaceHedexIPandPort(url);
        String protocol = System.getProperty("hedexWebProtocol");
        if (null != protocol && (protocol.equalsIgnoreCase("https") || protocol.equalsIgnoreCase("http"))) {
            String regex = "http(s)?";
            url = url.replaceFirst(regex, protocol);
            logger.trace((Object)("Replaced HTTP url = " + url));
        }
        for (Map.Entry<String, String> map : hedexParamMap.entrySet()) {
            url = HelpManager.setHedexParamProperty(map.getKey(), map.getValue(), url);
        }
        logger.trace((Object)("URL is :" + url));
        return url;
    }

    private static String replaceHedexIPandPort(String url) {
        String modifiedURL = url;
        String IPAddress = System.getProperty("hedexWebIP");
        String portNumber = System.getProperty("hedexWebPort");
        if (null != IPAddress && null != portNumber) {
            URL urlObj = null;
            String hostName = null;
            try {
                urlObj = new URL(url);
            }
            catch (MalformedURLException ex) {
                logger.trace((Object)ex.getMessage());
                return modifiedURL;
            }
            if (null != urlObj) {
                hostName = urlObj.getHost();
            }
            try {
                InetAddress hostObj = InetAddress.getByName(hostName);
                InetAddress hedexIPObj = InetAddress.getByName(IPAddress);
                if (hostObj instanceof Inet4Address && hedexIPObj instanceof Inet6Address) {
                    String IPv6Address = '[' + IPAddress + ']';
                    modifiedURL = modifiedURL.replace(hostName, IPv6Address);
                } else {
                    modifiedURL = modifiedURL.replace(hostName, IPAddress);
                }
            }
            catch (UnknownHostException ex) {
                logger.trace((Object)("Failed to replace the IP set by Hedex" + ex.getMessage()));
            }
            if (null != urlObj) {
                String portName = String.valueOf(urlObj.getPort());
                modifiedURL = modifiedURL.replace(portName + '/', portNumber + '/');
            }
            logger.trace((Object)("Replaced url = " + modifiedURL));
        }
        return modifiedURL;
    }

    private static String setHedexParamProperty(String key, String value, String webhost) {
        String webHostURL = webhost;
        Matcher matcherStr = Pattern.compile("([\\?&]" + key + "=([^&$]*))").matcher(webHostURL);
        boolean isKey = false;
        StringBuffer strWebhost = new StringBuffer();
        String str = "";
        while (matcherStr.find()) {
            isKey = true;
            str = matcherStr.group(1);
            str = str.replaceAll(matcherStr.group(2), value);
            matcherStr.appendReplacement(strWebhost, str);
        }
        if (isKey) {
            matcherStr.appendTail(strWebhost);
            return strWebhost.toString();
        }
        int i = webHostURL.indexOf(63);
        if (i != -1) {
            StringBuffer strTemp = new StringBuffer();
            String srtFirst = webHostURL.substring(0, i + 1);
            strTemp.append(srtFirst);
            strTemp.append(key).append('=').append(value);
            String strLast = webHostURL.substring(i + 1, webHostURL.length());
            strTemp.append('&').append(strLast);
            return strTemp.toString();
        }
        webHostURL = webHostURL + key + '=' + value;
        return webHostURL;
    }

    private static boolean launchUrlWithDesktop(String urlText) {
        boolean isSuccess = false;
        Desktop desktop = null;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            try {
                HelpManager.showChmHelp();
                isSuccess = true;
            }
            catch (Exception e) {
                DebugTracer.trace((Exception)e);
            }
        }
        return isSuccess;
    }

    private static void showChmHelp() {
        String strCurrPath = DCHelpManager.getInstance().getiMapInstallationPath();
        StringBuffer temp = new StringBuffer();
        temp.append(Locale.getDefault().getLanguage());
        temp.append("_");
        temp.append(Locale.getDefault().getCountry());
        String local = temp.toString();
        String strHelpName = ResourceManager.getInstance().getResString("CHM_HELP_FILE_NAME");
        String chmPath = "hh.exe \"" + strCurrPath + "\\client\\help\\" + local + "\\" + strHelpName + ".chm" + "\"";
        if (process != null) {
            process.destroy();
        }
        try {
            process = Runtime.getRuntime().exec(chmPath);
        }
        catch (IOException e) {
            DCDebugTracer.trace(e);
        }
    }

    private static boolean launchHelpBrowser(String helpID) {
        block18: {
            HelpManager.fireHedexWillLaunch();
            if (null != helpID) {
                helpID = helpID.replaceAll("\\s", "%20");
            }
            String url = HelpManager.getURL(helpID);
            try {
                String osName = System.getProperty("os.name");
                if (null != osName && osName.contains("Windows")) {
                    if (HelpManager.launchUrlWithDesktop(url)) {
                        logger.trace((Object)"Help is displayed in browser (using Java Desktop)");
                        HelpManager.fireHedexHelpLaunched();
                        return true;
                    }
                    boolean isRegistryRead = false;
                    if (null == browserPath) {
                        HelpManager.setBrowserPath();
                        isRegistryRead = true;
                    }
                    boolean isHelpNotShown = true;
                    if (null != browserPath) {
                        File filePath = new File(browserPath);
                        if (filePath.exists()) {
                            logger.trace((Object)"file path exists");
                            isHelpNotShown = false;
                            Runtime.getRuntime().exec(browserPath + "  " + url);
                            HelpManager.fireHedexHelpLaunched();
                        } else if (!isRegistryRead) {
                            logger.trace((Object)"file path doesn't exists read again from registry");
                            browserPath = null;
                            HelpManager.setBrowserPath();
                            if (null != browserPath) {
                                filePath = new File(browserPath);
                                if (filePath.exists()) {
                                    logger.trace((Object)"file path exists");
                                    isHelpNotShown = false;
                                    Runtime.getRuntime().exec(browserPath + "  " + url);
                                    HelpManager.fireHedexHelpLaunched();
                                } else {
                                    logger.trace((Object)"file path doesn't exists");
                                }
                            }
                        }
                    }
                    if (isHelpNotShown) {
                        logger.trace((Object)"showing message dialog");
                        String errorMessage = res.getString("HelpClient_Browser_NotAvailable");
                        OptionPane.showLineWrapOptionDialog((Component)FrameworkUtilities.getMainFrame(), (Object)errorMessage, (int)0);
                        return false;
                    }
                    break block18;
                }
                try {
                    boolean found = false;
                    for (String browser : browsers) {
                        boolean bl = found = Runtime.getRuntime().exec(new String[]{"which", browser}).waitFor() == 0;
                        if (!found) continue;
                        Runtime.getRuntime().exec(new String[]{browser, url});
                        break;
                    }
                    if (!found) {
                        logger.trace((Object)"There is no supported browsers found");
                        break block18;
                    }
                    HelpManager.fireHedexHelpLaunched();
                }
                catch (InterruptedException e) {
                    logger.trace((Object)("Exception while opening browser : " + e));
                }
            }
            catch (IOException e1) {
                logger.trace((Object)("Exception while opening browser : " + e1));
                return false;
            }
        }
        logger.trace((Object)"Help is displayed in browser.");
        return true;
    }

    private static void setBrowserPath() {
        File filePath;
        String absPATH;
        String iePATH = RegistryUtilities.getCurrentUserBrowserPath();
        if (iePATH != null) {
            absPATH = null;
            absPATH = iePATH.startsWith("\"") ? iePATH.substring(1, iePATH.length() - 1) : iePATH;
            filePath = new File(absPATH);
            if (filePath.exists()) {
                browserPath = absPATH;
                logger.trace((Object)("Browser path : " + browserPath));
            } else {
                logger.trace((Object)"Browser path in CURRENT_USER Registry doesn't exist");
            }
        } else {
            logger.trace((Object)"Registry for Browser Path not found in CURRENT_USER");
        }
        if (null == browserPath) {
            iePATH = RegistryUtilities.getLocalMachineBrowserPath();
            if (iePATH != null) {
                absPATH = null;
                absPATH = iePATH.startsWith("\"") ? iePATH.substring(1, iePATH.length() - 1) : iePATH;
                filePath = new File(absPATH);
                if (filePath.exists()) {
                    browserPath = absPATH;
                    logger.trace((Object)("Browser path : " + browserPath));
                } else {
                    logger.trace((Object)"Browser path in LOCAL_MACHINE Registry doesn't exist");
                }
            } else {
                logger.trace((Object)"Registry for Browser Path not found in LOCAL_MACHINE ");
            }
        }
        if (null == browserPath) {
            File[] drives = File.listRoots();
            if (null != drives) {
                for (File file : drives) {
                    String explorerPath = file.getAbsolutePath() + "Program Files\\Internet Explorer\\iexplore.exe";
                    if (!new File(explorerPath).exists()) continue;
                    iePATH = explorerPath;
                }
            }
            if (iePATH != null) {
                String absPATH2 = null;
                absPATH2 = iePATH.startsWith("\"") ? iePATH.substring(1, iePATH.length() - 1) : iePATH;
                File filePath2 = new File(absPATH2);
                if (filePath2.exists()) {
                    browserPath = absPATH2;
                    logger.trace((Object)("Browser path : " + browserPath));
                } else {
                    logger.trace((Object)"Browser path is not found");
                }
            } else {
                logger.trace((Object)"Internet Explorer is not installed ");
            }
        }
    }

    private boolean isNeedMerge() {
        String indexFileName = null;
        String tocFileName = null;
        String mapFileName = null;
        String helpsetDir = "help/" + Locale.getDefault().toString() + '/';
        indexFileName = helpsetDir + destinationFileNameHeader + Index_suffix;
        tocFileName = helpsetDir + destinationFileNameHeader + Toc_suffix;
        mapFileName = helpsetDir + destinationFileNameHeader + Map_suffix;
        return !this.isFileExit(indexFileName) || !this.isFileExit(tocFileName) || !this.isFileExit(mapFileName);
    }

    private boolean isFileExit(String fileName) {
        File file = new File(fileName);
        return file.exists();
    }

    public void addSubHelpSet(String fileName) {
        this.addSubHelpSet(fileName, false);
    }

    void addSubHelpSet(String fileName, boolean serverFlg) {
        if (null == fileName || fileName.trim().length() == 0) {
            throw new IllegalArgumentException("fileName argument shouldn't be null and fileName's length shouldn't be zero. ");
        }
        if (this.subHelpTable.containsKey(fileName)) {
            logger.debug((Object)("SubHelpTable has contain the key:" + fileName));
            return;
        }
        if (serverFlg) {
            try {
                HelpSet helpSet = this.getHelpSet(fileName);
                this.subHelpTable.put(fileName, helpSet);
                this.getHelpSet().add(helpSet);
            }
            catch (Exception ex) {
                logger.trace((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            this.subHelpTable.put(fileName, fileName);
            HelpManager.sendRemoteHelp(ADDSUBHELPSET + fileName);
        }
    }

    public void removeSubHelpSet(String subHelpName) {
        this.removeSubHelpSet(subHelpName, false);
    }

    void removeSubHelpSet(String fileName, boolean flg) {
        if (null == fileName || fileName.trim().length() == 0) {
            throw new IllegalArgumentException("fileName argument shouldn't be null and fileName's length shouldn't be zero. ");
        }
        if (!this.subHelpTable.containsKey(fileName)) {
            logger.debug((Object)("SubHelpTable don't contain the key:" + fileName));
        }
        if (flg) {
            HelpSet helpSet = (HelpSet)this.subHelpTable.get(fileName);
            boolean ret = this.getHelpSet().remove(helpSet);
            if (ret) {
                this.subHelpTable.remove(fileName);
            } else {
                logger.error((Object)("Failed to Remove helpset" + fileName));
            }
        } else {
            this.subHelpTable.remove(fileName);
            HelpManager.sendRemoteHelp(REMOVESUBHELPSET + fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String createTmpFile() {
        if (this.subHelpTable.isEmpty()) {
            return null;
        }
        StringBuffer buff = new StringBuffer(1024);
        Enumeration keys = this.subHelpTable.keys();
        while (keys.hasMoreElements()) {
            buff.append(keys.nextElement());
            buff.append(System.getProperty("line.separator"));
        }
        File tmpFile = null;
        BufferedWriter out = null;
        try {
            tmpFile = File.createTempFile("helpset", "tmp", tmpFileDir);
            tmpFile.deleteOnExit();
            out = new BufferedWriter(new BufferedWriter(new FileWriter(tmpFile)));
            out.write(buff.toString());
        }
        catch (Exception ex) {
            logger.trace((Object)ex.getMessage(), (Throwable)ex);
            String string = null;
            return string;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                    out = null;
                }
            }
            catch (IOException ex) {
                logger.trace((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return tmpFile.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String saveSupHelpSet2TempFile() {
        if (this.subHelpSetInHelpConfigureFile.isEmpty()) {
            return null;
        }
        StringBuffer buff = new StringBuffer(1024);
        Enumeration keys = this.subHelpSetInHelpConfigureFile.keys();
        while (keys.hasMoreElements()) {
            buff.append(keys.nextElement());
            buff.append(System.getProperty("line.separator"));
        }
        File tmpFile = null;
        BufferedWriter out = null;
        try {
            tmpFile = File.createTempFile("subhelpset", "tmp", tmpFileDir);
            tmpFile.deleteOnExit();
            out = new BufferedWriter(new BufferedWriter(new FileWriter(tmpFile)));
            out.write(buff.toString());
        }
        catch (Exception ex) {
            logger.trace((Object)ex.getMessage(), (Throwable)ex);
            String string = null;
            return string;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                    out = null;
                }
            }
            catch (IOException ex) {
                logger.trace((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return tmpFile.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readTmpFile(String fileName) {
        File file = new File(tmpFileDir, fileName);
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
            String tmpStr = in.readLine();
            while (null != tmpStr) {
                logger.debug((Object)("Reading subHelpSet path is " + tmpStr));
                this.addSubHelpSet(tmpStr, true);
                tmpStr = in.readLine();
            }
        }
        catch (Exception ex) {
            logger.trace((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                    in = null;
                    boolean ret = file.delete();
                    if (!ret) {
                        logger.debug((Object)"Failed to delete temp file.");
                    }
                }
            }
            catch (IOException e) {
                logger.trace((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private static IHelpIntegrator getPruductHelpImp() {
        Main main = Main.instance();
        if (null == main) {
            return null;
        }
        String[] args = main.getRuntimeArgs();
        if (null == args) {
            return null;
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                if (!HELP_CLASSNAME_PARAM_NAME.equals(args[i].trim())) continue;
                if (null != args[++i]) {
                    String className = args[i].trim();
                    Class<?> pruductHelpClass = Class.forName(className);
                    return (IHelpIntegrator)pruductHelpClass.newInstance();
                }
                break;
            }
        }
        catch (Exception ex) {
            logger.trace((Object)ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    private static void fireHedexWillLaunch() {
        if (null == hedexHelpListeners) {
            return;
        }
        IHedexHelpInterface listener = null;
        int listCnt = hedexHelpListeners.size();
        for (int i = 0; i < listCnt; ++i) {
            listener = hedexHelpListeners.get(i);
            listener.hedexHelpWillLaunch();
        }
    }

    private static void fireHedexHelpLaunched() {
        if (null == hedexHelpListeners) {
            return;
        }
        IHedexHelpInterface listener = null;
        int listCnt = hedexHelpListeners.size();
        for (int i = 0; i < listCnt; ++i) {
            listener = hedexHelpListeners.get(i);
            listener.hedexHelpLaunched();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        productHelpImp = HelpManager.getPruductHelpImp();
        if (null == productHelpImp) {
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(CommonUtil.getAbsolutePath((String)"./help/helpid.properties")));
                helpIDRes = new PropertyResourceBundle(in);
            }
            catch (Exception e) {
                logger.warn((Object)"Read resource file helpid.properties error: ");
                logger.trace((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (null != in) {
                        in.close();
                        in = null;
                    }
                }
                catch (Exception ex) {
                    logger.trace((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        instance = new HelpManager();
        browserPath = null;
    }

    private static abstract class LaunchHelpListener
    implements ActionListener {
        private LaunchHelpListener() {
        }
    }
}

