/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.util.helpmanagement;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.subsystemmanagement.SubsystemManager;
import com.swimap.iview.templates.utils.timer.IviewTimerTask;
import com.swimap.iview.templates.utils.timer.IviewUtilTimer;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.DebugTracer;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.adapter.FrameworkHelper;
import com.swimap.iview.util.helpmanagement.CSH;
import com.swimap.iview.util.helpmanagement.HelpAdapter;
import com.swimap.iview.util.helpmanagement.HelpClient;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.helpmanagement.HelpManagerUtil;
import com.swimap.iview.util.helpmanagement.HelpServer;
import com.swimap.iview.util.helpmanagement.IHedexHelpInterface;
import com.swimap.iview.util.helpmanagement.IHelpIntegrator;
import com.swimap.iview.util.helpmanagement.IHelpManager;
import com.swimap.iview.util.helpmanagement.IViewHelpBroker;
import com.swimap.iview.util.helpmanagement.IViewHelpSet;
import com.swimap.iview.util.helpmanagement.XMLDocumentUtil;
import com.swimap.iview.util.helpmanagement.xml.Index;
import com.swimap.iview.util.helpmanagement.xml.Indexitem;
import com.swimap.iview.util.helpmanagement.xml.Map;
import com.swimap.iview.util.helpmanagement.xml.MapID;
import com.swimap.iview.util.helpmanagement.xml.Toc;
import com.swimap.iview.util.helpmanagement.xml.Tocitem;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.MenuItem;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.Map;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class AbstractHelpManager
implements IHelpManager {
    private static final String DTDPATTERN = "helpset_(\\d)_(\\d).dtd";
    private static final String HS_MERGE_COMMENT_BEGIN = "For_Subhelp_merge_Begin";
    private static final String HS_MERGE_COMMENT_END = "For_Subhelp_merge_End";
    private static IviewLogger logger = IviewLogger.getLogger(HelpManager.class, (String)"IVIEW");
    static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/util/helpmanagement/Res");
    public static final String ANCHOR_SEPARATOR = "ANCHOR200703130318";
    public static final String HELP_ID_PROPERTY = "HELP_ID_PROPERTY";
    private static String destinationFileNameHeader = "help";
    public static final String CONFIRMEXITCMD = "mainprogramexitwithconfirm";
    public static final String ENDFLG = "mainprogramexit";
    public static final String CHANGEHELPSET = "changehelpsetcommand";
    public static final String SHAKEHANDCOMMAND = "shakehandcommand";
    public static final String SHOWHELPMENUFLG = "showhelpmenuflg";
    public static final String HELPSETPATHANDNAME = "helpsetpathandname";
    public static final String SUBHELPSETFILENAME = "subhelpsetfilename";
    public static final String REMOVESUBHELPSETFILENAME = "removesubhelpsetfilename";
    public static final String ADDSUBHELPSET = "addsubhelpsetcommand";
    public static final String REMOVESUBHELPSET = "removesubhelpsetcommand";
    static final int BUFFER_LENGTH = 1024;
    private static final int DEFAULT_PORT = 5000;
    private static JFrame defaultMainFrame = null;
    private static String baseFileNameHeader = "base";
    private IViewHelpBroker helpBroker = null;
    private HelpSet helpSet = null;
    private static HelpClient helpClient = null;
    private static HelpServer helpServer = null;
    private static boolean showHelpMenuFlg = true;
    private static String mainClassName = "com.swimap.iview.util.helpmanagement.HelpAdapter";
    private static ImageIcon helpFrameIcon = null;
    private static String aboutDlgClassName = "javax.swing.JDialog";
    private static String helpSetName = "";
    private volatile boolean started = false;
    private volatile boolean starting = false;
    private static String startTime = null;
    private static ResourceBundle helpIDRes = null;
    private static final long INTERVAL = 30000L;
    private Hashtable subHelpTable = new Hashtable(15);
    private Hashtable subHelpSetInHelpConfigureFile = new Hashtable(12);
    private static File tmpFileDir = CommonUtil.getAbsoluteFile((String)"./help");
    public static final String Index_suffix = "_index.xml";
    public static final String Toc_suffix = "_toc.xml";
    public static final String Map_suffix = "_map.jhm";
    public static final String HS_FILE = "help.hs";
    public static final String Index_Dir = "plugin/index/";
    public static final String Toc_Dir = "plugin/toc/";
    public static final String Map_Dir = "plugin/map/";
    public static final String HELPSET_DIR = "plugin/hs/";
    public static final String SUBSYSTEM_HELP_DIR = "subsystemhelp";
    private static final String HELP_CLASSNAME_PARAM_NAME = "-DProductHelpClass";
    private static HashMap<String, String> hedexParamMap = new HashMap(5);
    private static List<IHedexHelpInterface> hedexHelpListeners = null;
    static final String[] browsers = new String[]{"firefox", "netscape", "opera", "konqueror", "epiphany", "seamonkey", "galeon", "kazehakase", "mozilla"};
    private static final String SUBHELPSET = "subhelpset";
    private static Process process;

    public static void setDefaultLocale(Locale locale) {
        try {
            Locale.setDefault(locale);
        }
        catch (Exception npe) {
            Locale.setDefault(Locale.US);
        }
    }

    public static void setDestinationFileNameHeader(String headname) {
        if (headname != null) {
            destinationFileNameHeader = headname;
        }
    }

    public static void setMainFrame(JFrame frame) {
        defaultMainFrame = frame;
    }

    public static JFrame getMainFrame() {
        return defaultMainFrame;
    }

    public static void setHelpFrameIcon(ImageIcon icon) {
        helpFrameIcon = icon;
    }

    public static ImageIcon getHelpFrameIcon() {
        return helpFrameIcon;
    }

    public static void setAboutDlgClassName(String name) {
        aboutDlgClassName = name;
    }

    public static String getAboutDlgClassName() {
        return aboutDlgClassName;
    }

    public static void setMainClassName(String className) {
        mainClassName = className;
    }

    public static String getMainClassName() {
        return mainClassName;
    }

    public static String getHelpSetName() {
        return helpSetName;
    }

    public static void setShowHelpMenuFlg(boolean flg) {
        showHelpMenuFlg = flg;
    }

    public static boolean getShowHelpMenuFlg() {
        return showHelpMenuFlg;
    }

    public static final String encodeHedexStr(String src) {
        if (null == src || "".equals(src)) {
            return "";
        }
        StringBuffer tmp = new StringBuffer();
        tmp.ensureCapacity(src.length() * 6);
        for (int i = 0; i < src.length(); ++i) {
            char j = src.charAt(i);
            if (Character.isDigit(j) || Character.isLowerCase(j) || Character.isUpperCase(j)) {
                if (j < '\u007f') {
                    tmp.append(j);
                    continue;
                }
                if (j < '\u0100') {
                    tmp.append("%");
                    if (j < '\u0010') {
                        tmp.append("0");
                    }
                    tmp.append(Integer.toString(j, 16));
                    continue;
                }
                tmp.append("%u");
                if (j < '\u1000') {
                    tmp.append("0");
                }
                tmp.append(Integer.toString(j, 16));
                continue;
            }
            if (j < '\u0100') {
                tmp.append("%");
                if (j < '\u0010') {
                    tmp.append("0");
                }
                tmp.append(Integer.toString(j, 16));
                continue;
            }
            tmp.append("%u");
            if (j < '\u1000') {
                tmp.append("0");
            }
            tmp.append(Integer.toString(j, 16));
        }
        return tmp.toString();
    }

    public String getHelpID(String compID) {
        if (null != helpIDRes) {
            return helpIDRes.getString(compID);
        }
        return null;
    }

    public void launchHelper() {
    }

    public IViewHelpBroker getHelpBroker() {
        return this.helpBroker;
    }

    public HelpSet getHelpSet() {
        return this.helpSet;
    }

    private HelpSet getHelpSet(String helpSetName) throws HelpSetException {
        IViewHelpSet tmpHelpSet = null;
        if (null == helpSetName || helpSetName.trim().length() == 0) {
            logger.debug((Object)"helpSetName is null or length equals zero.");
            return tmpHelpSet;
        }
        ClassLoader loader = this.getClass().getClassLoader();
        String fullHelpSetName = "";
        StringBuffer helpSetNameBuf = new StringBuffer("");
        URL url = null;
        if (helpSetName.toLowerCase().startsWith("jar:file:")) {
            fullHelpSetName = helpSetName;
        } else {
            helpSetNameBuf.append("file:");
            helpSetNameBuf.append(System.getProperty("user.dir"));
            helpSetNameBuf.append(File.separator);
            helpSetNameBuf.append(helpSetName);
            if (!helpSetNameBuf.toString().endsWith(".hs")) {
                helpSetNameBuf.append(".hs");
            }
            fullHelpSetName = helpSetNameBuf.toString();
        }
        logger.debug((Object)("fullHelpSetName=" + fullHelpSetName));
        url = HelpSet.findHelpSet((ClassLoader)loader, (String)fullHelpSetName);
        if (null == url) {
            try {
                url = new URL(fullHelpSetName.replace("#", "%23"));
            }
            catch (MalformedURLException mue) {
                logger.trace((Object)mue.getMessage(), (Throwable)mue);
            }
        }
        tmpHelpSet = new IViewHelpSet(loader, url);
        return tmpHelpSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadHelpIdRes(String helpsetname) {
        StringBuffer helpSetNameBuf = new StringBuffer("");
        helpSetNameBuf.append(System.getProperty("user.dir"));
        helpSetNameBuf.append(File.separator);
        helpSetNameBuf.append(helpsetname);
        File helpSetFile = CommonUtil.getAbsoluteFile((String)helpSetNameBuf.toString());
        String parentPath = helpSetFile.getParentFile().getParent();
        BufferedInputStream in = null;
        logger.debug((Object)"Invoke ReloadHelpIDRes method.");
        try {
            in = new BufferedInputStream(new FileInputStream(CommonUtil.getAbsolutePath((String)(parentPath + "/helpid.properties"))));
            helpIDRes = new PropertyResourceBundle(in);
        }
        catch (Exception e) {
            logger.warn((Object)"Read resource file helpid.properties error: ");
            logger.trace((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                    in = null;
                }
            }
            catch (Exception ex) {
                logger.trace((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void enableHelp(MenuItem comp, String id) {
        if (helpIDRes != null) {
            try {
                this.helpBroker.enableHelp(comp, helpIDRes.getString(id), this.helpSet);
                return;
            }
            catch (Exception ex) {
                logger.warn((Object)("Can not find the resource for help ID " + id + " in file ./help/helpid.properties"));
            }
        }
        try {
            this.helpBroker.enableHelp(comp, id, this.helpSet);
        }
        catch (Exception e) {
            logger.warn((Object)("Can not find the help ID " + id));
            logger.trace((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setCurrentID(Component comp) {
        this.helpBroker.setCurrentID(CSH.getHelpIDString((Component)comp));
    }

    public void setCurrentID(String id) {
        this.helpBroker.setCurrentID(id);
    }

    public String getHomeID() {
        String id = null;
        try {
            Map.ID homeID = this.helpSet.getHomeID();
            if (null != homeID) {
                id = homeID.id;
            }
        }
        catch (Exception e) {
            logger.trace((Object)e.getMessage(), (Throwable)e);
        }
        return id;
    }

    public void setHomeID(String id) {
        this.helpSet.setHomeID(id);
    }

    public void setDisplayed(boolean b) {
        this.helpBroker.setDisplayed(b);
    }

    public boolean isDisplayed() {
        return this.helpBroker.isDisplayed();
    }

    public Font getFont() {
        return this.helpBroker.getFont();
    }

    public void setFont(Font f) {
        this.helpBroker.setFont(f);
    }

    public Dimension getSize() {
        return this.helpBroker.getSize();
    }

    public void setSize(Dimension d) {
        this.helpBroker.setSize(d);
    }

    public Map.ID getCurrentID() {
        return this.helpBroker.getCurrentID();
    }

    public void setViewDisplayed(boolean b) {
        this.helpBroker.setViewDisplayed(b);
    }

    protected static boolean isWebBrowserEnabled() {
        String webBrowser = System.getProperty("webhost");
        String webHost = System.getProperty("homepage");
        return null != webBrowser && webBrowser.length() != 0 && null != webHost && webHost.length() != 0;
    }

    public void setHedexParam(String key, String value) {
        if ("id".equals(key)) {
            throw new IllegalArgumentException("id key can not be set dynamically. Its used internally.");
        }
        hedexParamMap.put(key, value);
    }

    public String getHedexParam(String key) {
        String value = hedexParamMap.get(key);
        if (null != value) {
            return value;
        }
        return this.getHedexParamProperty(key, System.getProperty("homepage"));
    }

    private String getHedexParamProperty(String key, String webhost) {
        if (null == webhost) {
            return null;
        }
        Matcher m = Pattern.compile("[\\?&]" + key + "=([^&$]*)").matcher(webhost);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public static Process getProcess() {
        return process;
    }

    public static boolean checkProcess(String name) {
        try {
            Process process = Runtime.getRuntime().exec("tasklist");
            Scanner in = new Scanner(process.getInputStream());
            while (in.hasNextLine()) {
                String p = in.nextLine();
                if (!p.contains(name)) continue;
                return true;
            }
        }
        catch (IOException e) {
            logger.error((Object)"IniFileOperation checkEXE Failed", (Throwable)e);
        }
        return false;
    }

    public static void killProcess(String name) {
        String order = String.format("taskkill /f /im %s ", name);
        try {
            if (Runtime.getRuntime().exec(order) == null) {
                logger.warn((Object)("execute cmd " + order + "failed."));
            }
        }
        catch (IOException e) {
            logger.error((Object)"DomainUpdateConfig killProcess Failed", (Throwable)e);
        }
    }

    static String changeURL(String url) {
        int endChar;
        if (null == url) {
            return url;
        }
        String subSystem = System.getProperty("subsystem");
        StringBuffer s = new StringBuffer(url);
        SubsystemManager.LoadMode mode = SubsystemManager.getInstance().getClientLoadMode();
        String libStr = "lib=";
        int libIndex = url.indexOf(libStr);
        if (libIndex > -1 && (endChar = url.indexOf(38, libIndex)) > -1) {
            if (mode == SubsystemManager.LoadMode.single) {
                s.replace(libIndex + libStr.length(), endChar, subSystem);
                url = s.toString();
            } else if (mode == SubsystemManager.LoadMode.complex && null != subSystem && subSystem.contains(";")) {
                s.replace(libIndex + libStr.length(), endChar, subSystem);
                url = s.toString();
            }
            logger.trace((Object)("URL is :" + url));
        }
        return url;
    }

    public static boolean startHelpServer() {
        int port = 5000;
        try {
            try {
                port = Integer.parseInt(System.getProperty("helpport"));
            }
            catch (Exception er) {
                port = 5000;
            }
            logger.trace((Object)("port=" + port));
            helpServer = new HelpServer(port);
            long time = System.currentTimeMillis();
            startTime = String.valueOf(time);
            logger.debug((Object)("startTime = " + startTime));
            HelpManagerUtil.getInstance().writeTimeStrToFile(port, startTime);
            return true;
        }
        catch (Exception e) {
            HelpManagerUtil.getInstance().sendMsg(HelpManager.getInstance().getHomeID(), port);
            return false;
        }
    }

    public void setStartFlg(boolean flg) {
        this.started = flg;
    }

    public boolean getStartFlg() {
        return this.started;
    }

    public void setStartingFlg(boolean flg) {
        this.starting = flg;
    }

    public boolean getStartingFlg() {
        return this.starting;
    }

    public static void stopHelpServer() {
        if (!FrameworkHelper.isOSGIHelpClient()) {
            AbstractHelpManager.cleanUpHelp();
        }
        HelpAdapter.exitTerminal();
    }

    public static void cleanUpHelp() {
        if (helpServer != null) {
            HelpManagerUtil.getInstance().deleteFile(helpServer.getPort());
            helpServer.close();
            helpServer = null;
        }
        if (helpClient != null) {
            helpClient.close();
            helpClient = null;
        }
        logger.debug((Object)"HelpManager exit.");
        DebugTracer.cleanup();
    }

    public static void stopServerWithConfirm(String confirmMsg) {
        IViewHelpBroker hb = HelpManager.getInstance().getHelpBroker();
        if (!hb.isDisplayed()) {
            logger.trace((Object)"HelpFrame is not show,so stop the server directly.");
            AbstractHelpManager.stopHelpServer();
            return;
        }
        IviewUtilTimer timer = new IviewUtilTimer();
        timer.schedule(new IviewTimerTask(){

            public void run() {
                logger.trace((Object)"Timer is run , to stop server.");
                AbstractHelpManager.stopHelpServer();
            }
        }, 30000L, 30000L);
        if (SwingUtilities.isEventDispatchThread()) {
            OptionPane.showMessageDialog((Component)hb.getHelpWindow(), (Object)confirmMsg);
            logger.trace((Object)"Close confrim dialog to stop server.");
            AbstractHelpManager.stopHelpServer();
        } else {
            SwingUtilities.invokeLater(new Runnable((HelpBroker)hb, confirmMsg){
                final /* synthetic */ HelpBroker val$hb;
                final /* synthetic */ String val$confirmMsg;
                {
                    this.val$hb = helpBroker;
                    this.val$confirmMsg = string;
                }

                @Override
                public void run() {
                    OptionPane.showMessageDialog((Component)((IViewHelpBroker)this.val$hb).getHelpWindow(), (Object)this.val$confirmMsg);
                    logger.trace((Object)"Close confrim dialog to stop server.");
                    AbstractHelpManager.stopHelpServer();
                }
            });
        }
    }

    public static void setStartTime(String timeStr) {
        logger.debug((Object)("startTime is " + timeStr));
        startTime = timeStr;
    }

    public static String getStartTime() {
        return startTime;
    }

    public static void setBaseFileNameHeader(String header) {
        baseFileNameHeader = header;
    }

    public static void merge() {
        String helpsetDir = "help/" + Locale.getDefault().toString() + '/';
        AbstractHelpManager.mergeIndex(helpsetDir);
        AbstractHelpManager.mergeToc(helpsetDir);
        AbstractHelpManager.mergeMap(helpsetDir);
        AbstractHelpManager.mergeHelpSet(helpsetDir);
    }

    public static void merge(String baseFilenameHeader) {
        AbstractHelpManager.setBaseFileNameHeader(baseFilenameHeader);
        AbstractHelpManager.merge();
    }

    private static void mergeHelpSet(String baseDir) {
        String hsDirName = baseDir + HELPSET_DIR;
        String baseFileName = baseDir + HS_FILE;
        logger.trace((Object)("Base file name = " + baseFileName));
        logger.trace((Object)("SubHelpSet Directory Path : " + hsDirName));
        String[] subHelpSetFileLocations = XMLDocumentUtil.getInstance().getFileLocations(hsDirName, ".hs");
        File baseHSFile = new File(baseFileName);
        if (!baseHSFile.exists() || null == subHelpSetFileLocations || subHelpSetFileLocations.length == 0) {
            logger.trace((Object)"The base file or the plugin files are not existing. Merge is ignored.");
            Document doc = XMLDocumentUtil.getInstance().createXMLDocument(baseHSFile, DTDPATTERN);
            if (null != doc) {
                doc.getDocumentElement().normalize();
                Node[] mergeCommentNode = AbstractHelpManager.isMergeCommentPresent(doc);
                if (mergeCommentNode.length != 2) {
                    return;
                }
                AbstractHelpManager.removeMergedSubHelpSetLocation(mergeCommentNode);
                String encoding = "UTF-8";
                if (baseDir.indexOf("zh_CN") > -1) {
                    encoding = "GBK";
                }
                String baseFile = baseDir + File.separator + HS_FILE;
                XMLDocumentUtil.getInstance().writeToXMLDoc(doc, encoding, baseFile);
            } else {
                logger.trace((Object)"The HS file was not properly parsed");
            }
            return;
        }
        AbstractHelpManager.mergeHSFiles(baseHSFile, subHelpSetFileLocations);
    }

    private static void mergeHSFiles(File file, String[] subHelpSetLocations) {
        String helpsetFilePath = file.getAbsolutePath();
        String baseDir = file.getParent();
        String location = "location";
        logger.trace((Object)("mergeHSFiles : Parsing Xml : " + helpsetFilePath));
        Document doc = XMLDocumentUtil.getInstance().createXMLDocument(file, DTDPATTERN);
        if (null == doc) {
            logger.trace((Object)"mergeHSFiles : The hs document was not created");
            return;
        }
        doc.getDocumentElement().normalize();
        Node[] mergeCommentNode = AbstractHelpManager.isMergeCommentPresent(doc);
        if (null == mergeCommentNode || mergeCommentNode.length != 2) {
            logger.trace((Object)"Proper Merge comments could not be found, subhelpset merging is aborted");
            return;
        }
        Element root = doc.getDocumentElement();
        AbstractHelpManager.removeMergedSubHelpSetLocation(mergeCommentNode);
        Document subHSNodes = null;
        int subHSNodeListCount = 0;
        Node subHSNode = null;
        NamedNodeMap subHSAttr = null;
        String subHSLocat = null;
        int subHSAttrLength = 0;
        Element subHelpSet = null;
        File subHSFile = null;
        for (int i = 0; i < subHelpSetLocations.length; ++i) {
            subHSFile = new File(subHelpSetLocations[i]);
            subHSNodes = XMLDocumentUtil.getInstance().createXMLDocument(subHSFile, DTDPATTERN);
            subHSNodes.getDocumentElement().normalize();
            NodeList subHSNodeList = subHSNodes.getElementsByTagName(SUBHELPSET);
            subHSNodeListCount = subHSNodeList.getLength();
            for (int j = 0; j < subHSNodeListCount; ++j) {
                subHSNode = subHSNodeList.item(j);
                subHSAttr = subHSNode.getAttributes();
                subHSAttrLength = subHSAttr.getLength();
                for (int k = 0; k < subHSAttrLength; ++k) {
                    if (!ResourceUtil.areEqualsIgnoreCase((String)((Attr)subHSAttr.item(k)).getNodeName(), (String)location)) continue;
                    subHSLocat = ((Attr)subHSAttr.item(k)).getNodeValue();
                }
                subHelpSet = doc.createElement(SUBHELPSET);
                subHelpSet.setAttribute("location", subHSLocat);
                root.insertBefore(subHelpSet, mergeCommentNode[1]);
            }
        }
        String encoding = "UTF-8";
        if (baseDir.indexOf("zh_CN") > -1) {
            encoding = "GBK";
        }
        String baseFile = baseDir + File.separator + HS_FILE;
        XMLDocumentUtil.getInstance().writeToXMLDoc(doc, encoding, baseFile);
    }

    private static Node[] isMergeCommentPresent(Document doc) {
        logger.trace((Object)"isMergeCommentPresent : Checking if the proper merge comments are present");
        int count = 0;
        DocumentTraversal docTrav = (DocumentTraversal)((Object)doc);
        NodeIterator iterator = docTrav.createNodeIterator(doc, 128, null, true);
        Node node = iterator.nextNode();
        Node[] mergeCommentNode = new Node[2];
        String nodeValue = null;
        String commentBegin = null;
        String commentEnd = null;
        while (node != null) {
            nodeValue = node.getNodeValue().toLowerCase();
            commentBegin = HS_MERGE_COMMENT_BEGIN.toLowerCase();
            commentEnd = HS_MERGE_COMMENT_END.toLowerCase();
            if (nodeValue.indexOf(commentBegin) >= 0) {
                logger.trace((Object)"For_Subhelp_merge_Beginis present");
                if (count > 1) break;
                mergeCommentNode[count] = node;
                ++count;
                node = iterator.nextNode();
                nodeValue = node.getNodeValue().toLowerCase();
                if (null != node && nodeValue.indexOf(commentEnd) >= 0) {
                    logger.trace((Object)"For_Subhelp_merge_End is present");
                    mergeCommentNode[count] = node;
                    ++count;
                    break;
                }
                iterator.previousNode();
                mergeCommentNode = new Node[2];
                count = 0;
            }
            node = iterator.nextNode();
        }
        if (count != 2) {
            logger.trace((Object)"No proper merge comments");
            return new Node[0];
        }
        return mergeCommentNode;
    }

    private static void removeMergedSubHelpSetLocation(Node[] mergeCommentNode) {
        String nodeComment = "#comment";
        logger.trace((Object)"removeMergedSubHelpSetLocation : Removing already existing subhelpsets...");
        Node parentNode = null;
        Node subHelpSetNode = mergeCommentNode[0].getNextSibling();
        Node tempNode = null;
        String nodeName = subHelpSetNode.getNodeName();
        String subHelpSetStr = SUBHELPSET;
        boolean isNodeComment = ResourceUtil.areEquals((String)nodeName, (String)nodeComment);
        while (!isNodeComment) {
            if (ResourceUtil.areEquals((String)(subHelpSetNode = subHelpSetNode.getNextSibling()).getNodeName(), (String)subHelpSetStr)) {
                tempNode = subHelpSetNode.getNextSibling();
                parentNode = subHelpSetNode.getParentNode();
                parentNode.removeChild(subHelpSetNode);
                subHelpSetNode = tempNode;
            }
            nodeName = subHelpSetNode.getNodeName();
            isNodeComment = ResourceUtil.areEquals((String)nodeName, (String)nodeComment);
        }
        logger.trace((Object)"removeMergedSubHelpSetLocation : Removed the existing subhelpsets");
    }

    private static void mergeIndex(String baseDir) {
        String indexDirName = baseDir + Index_Dir;
        try {
            File indexDir = CommonUtil.getAbsoluteFile((String)indexDirName);
            File[] files = indexDir.listFiles();
            String baseFileName = baseDir + baseFileNameHeader + Index_suffix;
            logger.debug((Object)("Base file name = " + baseFileName));
            File baseFile = CommonUtil.getAbsoluteFile((String)baseFileName);
            if (!(baseFile.exists() || files != null && files.length != 0)) {
                logger.debug((Object)"The base file and the plugin files are not existing. Merge is ignored.");
                return;
            }
            Index sourceIndex = Index.unmarshal((File)baseFile);
            if (sourceIndex == null) {
                sourceIndex = new Index();
            }
            if (files != null && files.length > 0) {
                Index secondIndex = null;
                for (int i = 0; i < files.length; ++i) {
                    secondIndex = Index.unmarshal((File)files[i]);
                    if (secondIndex == null) continue;
                    AbstractHelpManager.mergeHelpIndex(sourceIndex, secondIndex);
                }
            }
            try {
                sourceIndex.marshal(baseDir + destinationFileNameHeader + Index_suffix);
            }
            catch (IOException ioex) {
                logger.trace((Object)ioex.getMessage(), (Throwable)ioex);
            }
        }
        catch (Exception ex) {
            logger.trace((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private static void mergeToc(String baseDir) {
        String tocDirName = baseDir + Toc_Dir;
        try {
            File tocDir = CommonUtil.getAbsoluteFile((String)tocDirName);
            File[] files = tocDir.listFiles();
            String baseFileName = baseDir + baseFileNameHeader + Toc_suffix;
            logger.debug((Object)("Base file name = " + baseFileName));
            File baseFile = CommonUtil.getAbsoluteFile((String)baseFileName);
            if (!(baseFile.exists() || files != null && files.length != 0)) {
                logger.debug((Object)"The base file and the plugin files are not existing. Merge is ignored.");
                return;
            }
            Toc sourceToc = Toc.unmarshal((String)baseFileName);
            if (sourceToc == null) {
                sourceToc = new Toc();
            }
            if (files != null && files.length > 0) {
                Toc secondToc = null;
                for (int i = 0; i < files.length; ++i) {
                    secondToc = Toc.unmarshal((String)files[i].getAbsolutePath());
                    if (secondToc == null) continue;
                    AbstractHelpManager.mergeHelpToc(sourceToc, secondToc);
                }
            }
            try {
                sourceToc.marshal(baseDir + destinationFileNameHeader + Toc_suffix);
            }
            catch (IOException ioex) {
                logger.trace((Object)ioex.getMessage(), (Throwable)ioex);
            }
        }
        catch (Exception ex) {
            logger.trace((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private static void mergeMap(String baseDir) {
        String mapDirName = baseDir + Map_Dir;
        try {
            File mapDir = CommonUtil.getAbsoluteFile((String)mapDirName);
            File[] files = mapDir.listFiles();
            String baseFileName = baseDir + baseFileNameHeader + Map_suffix;
            logger.debug((Object)("Base file name = " + baseFileName));
            File baseFile = CommonUtil.getAbsoluteFile((String)baseFileName);
            if (!(baseFile.exists() || files != null && files.length != 0)) {
                logger.debug((Object)"The base file and the plugin files are not existing. Merge is ignored.");
                return;
            }
            Map sourceMap = Map.unmarshal((File)baseFile);
            if (sourceMap == null) {
                sourceMap = new Map();
            }
            if (files != null && files.length > 0) {
                Map secondMap = null;
                for (int i = 0; i < files.length; ++i) {
                    secondMap = Map.unmarshal((String)files[i].getAbsolutePath());
                    if (secondMap == null) continue;
                    AbstractHelpManager.mergeHelpMap(sourceMap, secondMap);
                }
            }
            try {
                sourceMap.marshal(baseDir + destinationFileNameHeader + Map_suffix);
            }
            catch (IOException ioex) {
                logger.trace((Object)ioex.getMessage(), (Throwable)ioex);
            }
        }
        catch (Exception ex) {
            logger.trace((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private static void mergeHelpIndex(Index source, Index second) {
        Indexitem[] childItem = second.getIndexitem();
        Indexitem secondIndexItem = null;
        String text = null;
        for (int i = 0; i < childItem.length; ++i) {
            secondIndexItem = childItem[i];
            if (secondIndexItem == null) continue;
            text = secondIndexItem.getText();
            if (source.contains(secondIndexItem)) {
                AbstractHelpManager.mergeHelpIndex(source.getChild(text), secondIndexItem);
                continue;
            }
            if (source.getChild(text) != null) {
                throw new RuntimeException("There has wrong with the index files: duplicate text = \"" + text + "\" with different values");
            }
            source.addIndexitem(secondIndexItem);
        }
    }

    private static void mergeHelpToc(Toc source, Toc second) {
        Tocitem[] childItems = second.getTocitem();
        Tocitem secondTocItem = null;
        String text = null;
        for (int i = 0; i < childItems.length; ++i) {
            secondTocItem = childItems[i];
            if (secondTocItem == null) continue;
            text = secondTocItem.getText();
            if (source.contains(secondTocItem)) {
                AbstractHelpManager.mergeHelpToc(source.getChild(text), secondTocItem);
                continue;
            }
            if (source.getChild(text) != null) {
                throw new RuntimeException("There has wrong with the toc files: duplicate text = \"" + text + "\" with different values");
            }
            source.addTocitem(secondTocItem);
        }
    }

    private static void mergeHelpIndex(Indexitem source, Indexitem second) {
        Indexitem[] childItems = second.getIndexitem();
        Indexitem secondIndexItem = null;
        String text = null;
        for (int i = 0; i < childItems.length; ++i) {
            secondIndexItem = childItems[i];
            if (secondIndexItem == null) continue;
            text = secondIndexItem.getText();
            if (source.contains(secondIndexItem)) {
                AbstractHelpManager.mergeHelpIndex(source.getChild(secondIndexItem.getText()), secondIndexItem);
                continue;
            }
            if (source.getChild(text) != null) {
                throw new RuntimeException("There has wrong with the index files: duplicate text = \"" + text + "\" with different values");
            }
            source.addIndexitem(secondIndexItem);
        }
    }

    private static void mergeHelpToc(Tocitem source, Tocitem second) {
        Tocitem[] childItems = second.getTocitem();
        Tocitem secondTocItem = null;
        String text = null;
        for (int i = 0; i < childItems.length; ++i) {
            secondTocItem = childItems[i];
            if (secondTocItem == null) continue;
            text = secondTocItem.getText();
            if (source.contains(secondTocItem)) {
                AbstractHelpManager.mergeHelpToc(source.getChild(secondTocItem.getText()), secondTocItem);
                continue;
            }
            if (source.getChild(text) != null) {
                throw new RuntimeException("There has wrong with the toc files: duplicate text = \"" + text + "\" with different values");
            }
            source.addTocitem(secondTocItem);
        }
    }

    private static void mergeHelpMap(Map source, Map second) {
        MapID[] childItems = second.getMapID();
        MapID secondMapID = null;
        String text = null;
        for (int i = 0; i < childItems.length; ++i) {
            secondMapID = childItems[i];
            if (secondMapID == null) continue;
            text = secondMapID.getTarget();
            if (source.contains(secondMapID)) continue;
            if (source.getChild(text) != null) {
                throw new RuntimeException("There has wrong with the toc files: duplicate text = \"" + text + "\" with different values");
            }
            source.addMapID(secondMapID);
        }
    }

    public void removeSubHelpSetFromHelpConfFile(String fileName) {
        if (null == fileName || fileName.trim().length() == 0) {
            throw new IllegalArgumentException("The fileName can not be null or empty");
        }
        if (this.subHelpSetInHelpConfigureFile.containsKey(fileName)) {
            logger.debug((Object)("This file name has been added previous: " + fileName));
            return;
        }
        this.subHelpSetInHelpConfigureFile.put(fileName, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String createTmpFile() {
        if (this.subHelpTable.isEmpty()) {
            return null;
        }
        StringBuffer buff = new StringBuffer(1024);
        Enumeration keys = this.subHelpTable.keys();
        while (keys.hasMoreElements()) {
            buff.append(keys.nextElement());
            buff.append(System.getProperty("line.separator"));
        }
        File tmpFile = null;
        BufferedWriter out = null;
        try {
            tmpFile = File.createTempFile("helpset", "tmp", tmpFileDir);
            tmpFile.deleteOnExit();
            out = new BufferedWriter(new BufferedWriter(new FileWriter(tmpFile)));
            out.write(buff.toString());
        }
        catch (Exception ex) {
            logger.trace((Object)ex.getMessage(), (Throwable)ex);
            String string = null;
            return string;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                    out = null;
                }
            }
            catch (IOException ex) {
                logger.trace((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return tmpFile.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String saveSupHelpSet2TempFile() {
        if (this.subHelpSetInHelpConfigureFile.isEmpty()) {
            return null;
        }
        StringBuffer buff = new StringBuffer(1024);
        Enumeration keys = this.subHelpSetInHelpConfigureFile.keys();
        while (keys.hasMoreElements()) {
            buff.append(keys.nextElement());
            buff.append(System.getProperty("line.separator"));
        }
        File tmpFile = null;
        BufferedWriter out = null;
        try {
            tmpFile = File.createTempFile(SUBHELPSET, "tmp", tmpFileDir);
            tmpFile.deleteOnExit();
            out = new BufferedWriter(new BufferedWriter(new FileWriter(tmpFile)));
            out.write(buff.toString());
        }
        catch (Exception ex) {
            logger.trace((Object)ex.getMessage(), (Throwable)ex);
            String string = null;
            return string;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                    out = null;
                }
            }
            catch (IOException ex) {
                logger.trace((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return tmpFile.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readRemoveSubHelpsetFile(String fileName) {
        File file = new File(tmpFileDir, fileName);
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
            String tmpStr = in.readLine();
            while (null != tmpStr) {
                logger.debug((Object)("Reading subHelpSet path is " + tmpStr));
                this.removeSubHelpsetFromConfigFile(tmpStr);
                tmpStr = in.readLine();
            }
        }
        catch (Exception ex) {
            logger.trace((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                    in = null;
                    boolean ret = file.delete();
                    if (!ret) {
                        logger.debug((Object)"Failed to delete temp file.");
                    }
                }
            }
            catch (IOException e) {
                logger.trace((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void removeSubHelpsetFromConfigFile(String subHelpSetName) {
        String fullHelpSetName = null;
        StringBuffer helpSetNameBuf = new StringBuffer(32);
        if (subHelpSetName.toLowerCase().startsWith("jar:file:")) {
            fullHelpSetName = subHelpSetName;
        } else {
            helpSetNameBuf.append("file:");
            helpSetNameBuf.append(System.getProperty("user.dir"));
            helpSetNameBuf.append(File.separator);
            helpSetNameBuf.append(subHelpSetName);
            if (!helpSetNameBuf.toString().endsWith(".hs")) {
                helpSetNameBuf.append(".hs");
            }
            fullHelpSetName = helpSetNameBuf.toString();
            fullHelpSetName = fullHelpSetName.replace('\\', '/');
        }
        logger.trace((Object)("Remove helpset name: " + fullHelpSetName));
        Enumeration e = this.helpSet.getHelpSets();
        HelpSet hs = null;
        String urlString = "";
        while (e.hasMoreElements()) {
            hs = (HelpSet)e.nextElement();
            urlString = hs.getHelpSetURL().toString();
            logger.trace((Object)("URLString: " + urlString));
            if (!ResourceUtil.areEquals((String)fullHelpSetName, (String)urlString)) continue;
            this.helpSet.remove(hs);
            return;
        }
    }

    public void removeHelpKey(Object comp) {
        if (comp instanceof Component) {
            CSH.setHelpIDString((Component)((Component)comp), null);
            CSH.setHelpSet((Component)((Component)comp), null);
        } else if (comp instanceof MenuItem) {
            CSH.setHelpIDString((MenuItem)((MenuItem)comp), null);
            CSH.setHelpSet((MenuItem)((MenuItem)comp), null);
        }
    }

    private static IHelpIntegrator getPruductHelpImp() {
        Main main = Main.instance();
        if (null == main) {
            return null;
        }
        String[] args = main.getRuntimeArgs();
        if (null == args) {
            return null;
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                if (!HELP_CLASSNAME_PARAM_NAME.equals(args[i].trim())) continue;
                if (null != args[++i]) {
                    String className = args[i].trim();
                    Class<?> pruductHelpClass = Class.forName(className);
                    return (IHelpIntegrator)pruductHelpClass.newInstance();
                }
                break;
            }
        }
        catch (Exception ex) {
            logger.trace((Object)ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    public void cleanSubHelptable() {
        if (FrameworkHelper.isOSGIHelpClient() && null != this.subHelpTable) {
            this.subHelpTable.clear();
        }
    }

    public static boolean isStopHelp() {
        String isStopHelpLoad = System.getProperty("iview.help.stop");
        return Boolean.valueOf(isStopHelpLoad);
    }

    public static int getHelpStopDelay() {
        String helpStopDelay = System.getProperty("iview.help.delaytime");
        int delay = 0;
        try {
            delay = Integer.parseInt(helpStopDelay);
        }
        catch (NumberFormatException e) {
            DebugTracer.trace((String)("Exception while reading delaytime :" + e));
        }
        return delay;
    }

    public static void addHedexHelpListeners(IHedexHelpInterface listener) {
        if (null == listener) {
            return;
        }
        if (null == hedexHelpListeners) {
            hedexHelpListeners = new ArrayList<IHedexHelpInterface>(1);
        }
        hedexHelpListeners.add(listener);
    }

    public void removeSelectionListener(IHedexHelpInterface listener) {
        if (null == listener || null == hedexHelpListeners) {
            return;
        }
        hedexHelpListeners.remove(listener);
    }
}

