/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.encryptv3;

import com.huawei.dc.adapter.swimap.external.cbb.baseutil.DCAESCipher;
import com.huawei.dc.common.asndatacenter.AsnDCGetAesPasswordReq;
import com.huawei.dc.common.asndatacenter.AsnDCGetAesPasswordRsp;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.security.DCEncryptServiceUtil;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.u2000.security.IRSACipherOper;
import com.huawei.u2000.security.RSACipherMgr;
import java.math.BigInteger;
import java.security.Key;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.commustru.fstru.FStruct;

public final class DCDynamicEncryptServiceUtil {
    private static DCDynamicEncryptServiceUtil instance = null;
    private static final String TIME_FORMAT = "yyyyMMddHHmmss";

    private DCDynamicEncryptServiceUtil() {
    }

    public static synchronized DCDynamicEncryptServiceUtil getInstance() {
        if (null == instance) {
            instance = new DCDynamicEncryptServiceUtil();
        }
        return instance;
    }

    public synchronized char[] getDecryptPassword(char[] pwd) {
        if (DCFrameWorkUtil.getIsSingleClient()) {
            return DCEncryptServiceUtil.decrypt(pwd);
        }
        if (StringUtils.isNullOrEmptyChar(pwd)) {
            return "".toCharArray();
        }
        DCDebugTracer.trace("DynamicAESUtil#getDecryptPwd  start..");
        String deskey = this.generatorSecretKey();
        if (null == deskey) {
            DCDebugTracer.trace("DynamicAESUtil#generatorSecretKey failed.");
            return pwd;
        }
        DCDebugTracer.trace("DynamicAESUtil#getDecryptPwd  generator AES128 secret key successful");
        AsnDCGetAesPasswordRsp oRsp = this.getPasswordFromServer(pwd, deskey);
        if (null == oRsp) {
            DCDebugTracer.trace("DynamicAESUtil#getPasswordFromServer failed.");
            return pwd;
        }
        char[] password = this.decryptPassword(deskey, oRsp);
        if (null == password) {
            DCDebugTracer.trace("DynamicAESUtil#decryptPassword failed.");
            return pwd;
        }
        DCDebugTracer.trace("DynamicAESUtil#getDecryptPwd  end.. successful");
        return password;
    }

    private char[] decryptPassword(String deskey, AsnDCGetAesPasswordRsp oRsp) {
        char[] password = null;
        try {
            password = DCAESCipher.decrypt((char[])DCCommonUtil.convertByteArrayToStr(oRsp.strPassword).toCharArray(), (Key)DCAESCipher.generateDynamicKey((char[])deskey.toCharArray()));
        }
        catch (Exception e) {
            DCDebugTracer.trace("DynamicAESUtil#decryptPassword  decrypt AES128  failed :");
        }
        if (null == password) {
            password = "".toCharArray();
        }
        return password;
    }

    private AsnDCGetAesPasswordRsp getPasswordFromServer(char[] pwd, String deskey) {
        AsnDCGetAesPasswordReq req = new AsnDCGetAesPasswordReq();
        IRSACipherOper rsaOper = RSACipherMgr.getInstance().getCipherOper();
        req.strPwdKey = rsaOper.encrypt(deskey.getBytes()).getBytes();
        req.strPassword = StringUtils.convertCharsToBytes(pwd);
        req.iLength = BigInteger.valueOf(deskey.length());
        AsnDCGetAesPasswordRsp oRsp = new AsnDCGetAesPasswordRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().sendSyncMsgWithSyncCommand(44098, (FStruct)req, (FStruct)oRsp);
        if (0 != iErrorCode) {
            DCDebugTracer.trace("DynamicAESUtil#getPasswordFromServer  send message error :  " + iErrorCode);
            return null;
        }
        if (null != oRsp.oErrorInfo.iErrorNo && 0 != oRsp.oErrorInfo.iErrorNo.intValue()) {
            DCDebugTracer.trace("DynamicAESUtil#getPasswordFromServer  dcserver Decrypt password failed.");
            return null;
        }
        return oRsp;
    }

    private String generatorSecretKey() {
        SimpleDateFormat oTimeStampFormat = new SimpleDateFormat(TIME_FORMAT);
        Date oTimeStampFolder = new Date();
        String strKey = DCFrameWorkUtil.getUserId() + oTimeStampFormat.format(oTimeStampFolder);
        IRSACipherOper rsaOper = RSACipherMgr.getInstance().getCipherOper();
        return rsaOper.encrypt(strKey.getBytes());
    }
}

