/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.integration;

import com.huawei.dc.adapter.swimap.mdi.DCExtendedWindow;
import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.dcmodule.DataCenterModuleManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.MenuUtil;
import com.huawei.dc.toolkit.client.base.util.TKLogManager;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1InternalFrame;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1Res;
import java.awt.Container;
import java.awt.Rectangle;

public class ToolkitTL1InterFrame
extends DCExtendedWindow {
    private TKTL1Res res = TKTL1Res.instance();
    private TKTL1InternalFrame toolkitframe = null;
    private DataCenterModuleManager m_oDCModuleMgr;

    public ToolkitTL1InterFrame(DataCenterModuleManager dcModuleMgr) {
        this.m_oDCModuleMgr = dcModuleMgr;
    }

    private void init() {
        Container con = this.toolkitframe.getContentPane();
        this.add(con);
        this.setTitle(this.res.getString("TL1CommandCLient"));
        this.setVisible(true);
        TKLogManager.writeToDebug("ON T2000:initial GI OK " + this.getTitle());
    }

    public boolean initPanel() {
        this.toolkitframe = new TKTL1InternalFrame();
        try {
            this.init();
            try {
                DCHelpManager.getInstance().enableF1HelpKey(this.toolkitframe.getContentPane(), "HELP_TOPIC_TL1_COMMANDLINE_TERMINAL");
                TKLogManager.writeToDebug("ON T2000:Set Help entrance OK " + this.getTitle());
            }
            catch (Exception ex) {
                TKLogManager.writeToDebug("ON T2000:Set Help entrance faild " + this.getTitle() + " " + ex);
                return false;
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
            return false;
        }
        return true;
    }

    public void windowActivated() {
        super.windowActivated();
        if (DCFrameWorkUtil.getIsSingleClient()) {
            MenuUtil.enableMenuItem(DCFrameWorkUtil.getDCMenuManager().getMenuItem("boardSWMenu", "boardSoftManage", "showTL1Frame"), false);
        } else {
            MenuUtil.enableMenuItem(this.m_oDCModuleMgr.getDataCenterMenu(), "showTL1Frame", false);
        }
    }

    public void windowDeactivated() {
        super.windowDeactivated();
        if (DCFrameWorkUtil.getIsSingleClient()) {
            MenuUtil.enableMenuItem(DCFrameWorkUtil.getDCMenuManager().getMenuItem("boardSWMenu", "boardSoftManage", "showTL1Frame"), true);
        } else {
            MenuUtil.enableMenuItem(this.m_oDCModuleMgr.getDataCenterMenu(), "showTL1Frame", true);
        }
    }

    public void windowClosed() {
        this.dispose();
        this.m_oDCModuleMgr.closePanel("TL1CommandPanel");
    }

    public void windowOpened() {
        this.m_oDCModuleMgr.openPanel("TL1CommandPanel");
    }

    public void dispose() {
        if (this.toolkitframe != null) {
            this.toolkitframe.dispose();
            this.toolkitframe = null;
        } else {
            TKLogManager.writeToDebug("Null frame " + this.getTitle());
        }
    }

    public Rectangle getWindowBounds() {
        return new Rectangle(0, 0, DCConstants.DC_WINDOW_WIDTH, DCConstants.DC_WINDOW_HEIGHT);
    }
}

