/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.integration;

import com.huawei.dc.adapter.swimap.iview.framework.modulemanagement.DCBaseModule;
import com.huawei.dc.adapter.swimap.iview.framework.modulemanagement.DCModuleManager;
import com.huawei.dc.common.components.dialog.SimpleProgressDlg;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.toolkit.client.base.communicate.TKCmdMSG;
import com.huawei.dc.toolkit.client.base.communicate.TKCommUtility;
import com.huawei.dc.toolkit.client.base.communicate.TKNoticeReceiver;
import com.huawei.dc.toolkit.client.base.util.TKDebug;
import com.huawei.dc.toolkit.client.base.util.TKLogManager;
import com.huawei.dc.toolkit.client.base.util.TKProfileFactory;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.te.toolkit.TKMainFrame;
import com.huawei.dc.toolkit.control.LogWriterAdapter;
import com.huawei.dc.toolkit.control.TEToolkitDataAdapter;
import com.huawei.dc.toolkit.control.Toolkit4T2kInterface;
import com.huawei.dc.toolkit.control.Toolkit4T2kInterfaceMgr;
import com.huawei.dc.toolkit.integration.action.DoLicenseAction;
import com.huawei.dc.toolkit.integration.action.DoPatchLoadAction;
import com.huawei.dc.toolkit.integration.action.DoSLUAction;
import com.huawei.dc.toolkit.integration.action.DoSMSWPLoadAction;
import com.huawei.imap12.utility.operResult.InmOperResultStruct;
import com.huawei.imap12.utility.operResult.InmOperResultVector;
import com.huawei.te.toolkit.AsnToolkitLogSaveReq;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import java.awt.Component;
import java.io.File;
import javax.swing.SwingUtilities;
import net.commustru.fstru.FStruct;

public class TEToolkitModule
extends DCBaseModule {
    private static LogReceiver logReceiver = new LogReceiver();
    private TKRes res = TKRes.instance();
    public static final int MODULE_ID = 3900;
    public static final String TOOLKIT_MODULE = "toolkitModule";
    public static final int OPER_TYPE = 10;
    private TEToolkitDataAdapter adapter = new TEToolkitDataAdapter();
    private static SimpleProgressDlg m_oProgressDlg = null;
    public static final String TOOLKIT_RES_FILE = "toolkit" + File.separator + "stringresource.ini";

    public TEToolkitModule(DCModuleManager mgr) {
        super((ModuleManager)mgr);
        Toolkit4T2kInterfaceMgr.setInstance(this.adapter);
    }

    public void initialize() {
        boolean isClassMgrExist = false;
        TKLogManager.writeToFile("initializeApp->begin to load toolkitmodule... ...");
        try {
            Class.forName("com.huawei.te.base.data.configuration.TEConfigurationNoticeMgr");
            isClassMgrExist = true;
            throw new Exception("TEConfigurationNoticeMgr exsit");
        }
        catch (Exception ex) {
            TKLogManager.writeToFile("initializeApp->get TEConfigurationNoticeMgr exception ... ...");
            TKLogManager.writeToDebug("TEConfigurationNoticeMgr isClassExist:" + isClassMgrExist);
            TKLogManager.writeToFile("TEConfigurationNoticeMgr isClassExist:" + isClassMgrExist);
            if (isClassMgrExist) {
                boolean isClassLisExist = false;
                try {
                    Class.forName("com.huawei.te.common.data.event.TENEGatewaySwitchLisener");
                    isClassLisExist = true;
                    throw new Exception("TENEGatewaySwitchLisener exsit");
                }
                catch (Exception ex2) {
                    DCDebugTracer.trace(ex2);
                    TKLogManager.writeToDebug("TENEGatewaySwitchLisener isClassExist:" + isClassLisExist);
                    TKLogManager.writeToFile("TENEGatewaySwitchLisener isClassExist:" + isClassLisExist);
                }
            }
            TKCommUtility.addCommunicationNotifier(this.adapter);
            String lp = TKProfileFactory.getCfgString("comm", "lastpath");
            if (lp != null && lp.trim().length() > 1) {
                TKMainFrame.lastpath = lp;
            }
            if (TEToolkitModule.initComm()) {
                TEToolkitModule.listenedComm();
            }
            return;
        }
    }

    public void stop() {
        this.closeAllInterFrame();
        Toolkit4T2kInterfaceMgr.setInstance(null);
        TKCommUtility.dispose();
        TKDebug.exInfoBackup();
        if (TKMainFrame.lastpath != null && TKMainFrame.lastpath.trim().length() > 1) {
            TKProfileFactory.writeBackCommonStringProperty("sysconfig.ini", "comm", "lastpath", "value", TKMainFrame.lastpath);
        }
    }

    void closeAllInterFrame() {
    }

    public static void showBdSoftFrame() {
        DoSMSWPLoadAction.showSPFrame();
    }

    public static void showPatchSoftFrame() {
        DoPatchLoadAction.showPatchFrame();
    }

    public static void showLicenseFrame() {
        DoLicenseAction.showLicenseFrame();
    }

    public static void showBackupLogFrame() {
        DoSLUAction.showSLUFrame();
    }

    public static synchronized boolean initComm() {
        boolean isConnected = TKCommUtility.isConnected();
        TKLogManager.writeToDebug("T2K cnt count :" + TKCommUtility.refCount);
        if (!isConnected) {
            TEToolkitModule.openConnProgressDialog();
            if (TKCommUtility.comm == null) {
                TKLogManager.writeToDebug("TKCommUtility.init.first");
                TKCommUtility.init();
            } else {
                TKLogManager.writeToDebug("TKCommUtility.init.rec");
                TKCommUtility.comm = null;
                TKCommUtility.init();
            }
        }
        String serverName = "";
        Toolkit4T2kInterface inf = Toolkit4T2kInterfaceMgr.getInstance();
        if (inf != null) {
            serverName = inf.getServerIP();
        }
        InmOperResultVector resultV = new InmOperResultVector();
        if (serverName.equals("")) {
            serverName = TKRes.instance().getString("T2000Server");
        }
        String progressName = TKRes.instance().getString("ToolkitServerCourse");
        String sOperFailedInfo = "";
        String operReason = "";
        boolean isConnected2 = TKCommUtility.isConnected();
        if (m_oProgressDlg != null) {
            m_oProgressDlg.setVisible(false);
            m_oProgressDlg.dispose();
            m_oProgressDlg = null;
        }
        if (!isConnected2) {
            sOperFailedInfo = TKRes.instance().getString("InT2000ConnectFail");
            operReason = TKRes.instance().getString("ExceptionReason");
            InmOperResultStruct struct = new InmOperResultStruct(serverName, progressName, operReason);
            resultV.add((Object)struct);
            if (Toolkit4T2kInterfaceMgr.getInstance().getSSLMode() == 1) {
                DCOptionPane.showMessageDialog((Component)TKResourceManager.getMainFrame(), TKRes.instance().getString("ShakeFailBySSL"));
            } else {
                DCOptionPane.showErrorDialog((Component)TKResourceManager.getMainFrame(), sOperFailedInfo + "\n" + operReason);
            }
        }
        int cmdCode = 2109697;
        boolean isSCROperationApp = true;
        TKLogManager.writeToDebug("get from T2000 : CID ->" + cmdCode);
        TKLogManager.writeToDebug("get from T2000 : isSCROperation()->" + isSCROperationApp);
        TKLogManager.writeToDebug("get from Toolkit : isConnected2 -> : " + isConnected2);
        TKLogManager.writeToDebug("user.dir:  " + System.getProperty("user.dir"));
        TKLogManager.writeToDebug("get from Toolkit TWICS : isConnected2 -> :" + isConnected2);
        return isConnected2;
    }

    private static void openConnProgressDialog() {
        m_oProgressDlg = new SimpleProgressDlg(TKRes.instance().getString("InitConnect"), true, TKRes.instance().getString("InitConnectNeedWait")){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancelRollBtnActionPerformed() {
                if (null == m_oProgressDlg) {
                    return;
                }
                m_oProgressDlg.dispose();
                m_oProgressDlg = null;
                this.doCleanUp();
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != m_oProgressDlg) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e) {
                        DCDebugTracer.trace(e);
                    }
                    if (null != m_oProgressDlg) {
                        m_oProgressDlg.setVisible(true);
                    }
                }
            }
        });
    }

    public static void listenedComm() {
    }

    public static synchronized void disposeComm() {
        TKCommUtility.dispose();
        TKLogManager.writeToDebug("T2K cnt count--:" + TKCommUtility.refCount);
        if (!TKCommUtility.isConnected()) {
            TKLogManager.writeToDebug("T2K cnt clsd.");
        }
    }

    static class LogReceiver
    implements TKNoticeReceiver {
        LogReceiver() {
        }

        @Override
        public byte handleNotice(char cmdCode, TKCmdMSG data) {
            if (cmdCode == '\u1307') {
                TKLogManager.writeToDebug("begin to write backup log");
                AsnToolkitLogSaveReq logEvt = new AsnToolkitLogSaveReq();
                boolean result = TKCommUtility.getASNData(data, (FStruct)logEvt);
                if (result) {
                    String neName = new String(logEvt.neName);
                    String operName = new String(logEvt.operateName);
                    String operDetail = new String(logEvt.result);
                    String recordtext = neName + " " + operName + " " + operDetail;
                    TKLogManager.writeToDebug("#####neName :" + neName);
                    TKLogManager.writeToDebug("#####operName :" + operName);
                    TKLogManager.writeToDebug("#####operDetail :" + operDetail);
                    TKLogManager.writeToDebug("#####recordtext :" + recordtext);
                    if (operDetail.indexOf("execute") != -1 || operDetail.indexOf("success") != -1 || operDetail.indexOf("Successfully") != -1) {
                        LogWriterAdapter.writeLogToServer(10, neName, operDetail, 0);
                        TKLogManager.writeToDebug("End to write backup log");
                    } else {
                        LogWriterAdapter.writeLogToServer(10, neName, operDetail, 74040);
                        TKLogManager.writeToDebug("End to write backup log");
                    }
                } else {
                    TKDebug.inmAssert(false, "DecodeFail");
                }
            }
            return 1;
        }
    }
}

