/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.control;

import com.huawei.dc.common.dcmodule.DataCenterModuleForAppModule;
import com.huawei.dc.common.dcmodule.DataCenterModuleManager;
import com.huawei.dc.common.dcmodule.MenuControl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.MenuUtil;
import com.huawei.dc.standalone.StandAloneDomainInfo;
import com.huawei.dc.toolkit.control.TEToolkitDataAdapter;
import com.huawei.dc.toolkit.control.Toolkit4T2kInterfaceMgr;
import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commandmng.ICommandProcessor;
import com.swimap.iview.commstyle.commini.Menu;
import com.swimap.iview.framework.menumanagement.MenuManager;
import java.awt.Component;
import javax.swing.JMenu;

public class TKMenuController {
    private static final String STYLE_CONF_DC_DIR = "conf/dc/";
    private MenuManager m_oMenuManager = null;
    private DataCenterModuleManager m_oDCModuleManager = null;
    private Component m_oLoadBoardSWMenuItem = null;
    private Component m_oLoadBoardPatchMenuItem = null;
    private Component m_oTL1CommandMenuItem = null;
    private Component m_oLicenseMenu = null;
    private Component m_oLogMenu = null;

    public void initTkMenu(MenuManager oMenuManager, DataCenterModuleManager oDCModuleManager, MenuControl oMenuControl) {
        if (null == Toolkit4T2kInterfaceMgr.getInstance()) {
            Toolkit4T2kInterfaceMgr.setInstance(new TEToolkitDataAdapter());
        }
        this.m_oMenuManager = oMenuManager;
        this.m_oDCModuleManager = oDCModuleManager;
        boolean bContainsT2000Device = true;
        if (DCFrameWorkUtil.getIsSingleClient()) {
            if (4 != StandAloneDomainInfo.getInstance().getSelectedDomain()) {
                return;
            }
            this.initTKMenuForStandalone();
        } else {
            this.initTkMenuForU2000();
        }
        this.enableLoadBoadSwMenu(bContainsT2000Device, oMenuControl.isHasLoadBoardSWPrivilege());
        this.enableLoadBoardPatch(bContainsT2000Device, oMenuControl.isHasLoadBoardPatchPrivilege());
        this.enableLicenseMenu(bContainsT2000Device, oMenuControl.isHasTKLicensePrivilege());
        this.enableLogMenu(bContainsT2000Device, oMenuControl.isHasTKLogPrivilege());
        this.enableTL1CommandMenu(bContainsT2000Device, oMenuControl.isHasTL1CommandPrivilege());
    }

    private void initTkBoardMenu() {
        if (!DataCenterModuleForAppModule.getInstance().isAppStyle()) {
            this.m_oMenuManager.loadDynamicMenus("conf/dc/N2000Menu", "boardSWMenu");
        }
        this.m_oMenuManager.addMenu("boardSWMenu", "boardSoftManage");
        Menu m_oBoardManageMenu = this.m_oMenuManager.getMenu("boardSWMenu", "boardSoftManage");
        CommandManager.getInstance().addJMenu((JMenu)m_oBoardManageMenu, (ICommandProcessor)this.m_oDCModuleManager);
        this.m_oLoadBoardSWMenuItem = this.m_oMenuManager.getMenuItem("boardSWMenu", "boardSoftManage", "loadBoardSoft");
        this.m_oLoadBoardPatchMenuItem = this.m_oMenuManager.getMenuItem("boardSWMenu", "boardSoftManage", "loadBoardPatch");
        this.m_oTL1CommandMenuItem = this.m_oMenuManager.getMenuItem("boardSWMenu", "boardSoftManage", "showTL1Frame");
    }

    private void initTkLicenseMenu() {
        if (!DataCenterModuleForAppModule.getInstance().isAppStyle()) {
            this.m_oMenuManager.loadDynamicMenus("conf/dc/N2000Menu", "tkLicenseMenu");
        }
        this.m_oMenuManager.addMenu("tkLicenseMenu", "tkLicenseManage");
        Menu m_oBoardManageMenu = this.m_oMenuManager.getMenu("tkLicenseMenu", "tkLicenseManage");
        CommandManager.getInstance().addJMenu((JMenu)m_oBoardManageMenu, (ICommandProcessor)this.m_oDCModuleManager);
        this.m_oLicenseMenu = this.m_oMenuManager.getMenuItem("tkLicenseMenu", "tkLicenseManage", "tkLicense");
    }

    private void initTkLogMenu() {
        if (!DataCenterModuleForAppModule.getInstance().isAppStyle()) {
            this.m_oMenuManager.loadDynamicMenus("conf/dc/N2000Menu", "tkLogMenu");
        }
        this.m_oMenuManager.addMenu("tkLogMenu", "tkLogManage");
        Menu m_oLodManageMenu = this.m_oMenuManager.getMenu("tkLogMenu", "tkLogManage");
        CommandManager.getInstance().addJMenu((JMenu)m_oLodManageMenu, (ICommandProcessor)this.m_oDCModuleManager);
        this.m_oLogMenu = this.m_oMenuManager.getMenuItem("tkLogMenu", "tkLogManage", "tkBacupLog");
    }

    private void initTkMenuForU2000() {
        Menu oDatacenterMenu = this.m_oDCModuleManager.getDataCenterMenu();
        this.m_oLoadBoardSWMenuItem = oDatacenterMenu.getMenuItem("loadBoardSoft");
        this.m_oLoadBoardPatchMenuItem = oDatacenterMenu.getMenuItem("loadBoardPatch");
        this.m_oTL1CommandMenuItem = oDatacenterMenu.getMenuItem("showTL1Frame");
        this.m_oLicenseMenu = oDatacenterMenu.getMenuItem("tkLicense");
        this.m_oLogMenu = oDatacenterMenu.getMenuItem("tkBacupLog");
    }

    private void initTKMenuForStandalone() {
        this.initTkBoardMenu();
        this.initTkLicenseMenu();
        this.initTkLogMenu();
    }

    public void enableLoadBoadSwMenu(boolean bContainsT2000Device, boolean hasUserOperationPrivilege) {
        MenuUtil.enableMenuItem(this.m_oLoadBoardSWMenuItem, bContainsT2000Device && hasUserOperationPrivilege, 44019);
    }

    public void enableLoadBoardPatch(boolean bContainsT2000Device, boolean hasUserOperationPrivilege) {
        MenuUtil.enableMenuItem(this.m_oLoadBoardPatchMenuItem, bContainsT2000Device && hasUserOperationPrivilege, 44020);
    }

    public void enableTL1CommandMenu(boolean bContainsT2000Device, boolean hasUserOperationPrivilege) {
        MenuUtil.enableMenuItem(this.m_oTL1CommandMenuItem, bContainsT2000Device && hasUserOperationPrivilege, 44045);
    }

    public void enableLicenseMenu(boolean bContainsT2000Device, boolean hasUserOperationPrivilege) {
        MenuUtil.enableMenuItem(this.m_oLicenseMenu, bContainsT2000Device && hasUserOperationPrivilege, 44021);
    }

    public void enableLogMenu(boolean bContainsT2000Device, boolean hasUserOperationPrivilege) {
        MenuUtil.enableMenuItem(this.m_oLogMenu, bContainsT2000Device && hasUserOperationPrivilege, 44022);
    }
}

