/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.control;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnSystemSettingInfoRsp;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.dcmodule.DataCenterModuleManager;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.system.SystemSettingUtil;
import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.configuration.system.FTSInfo;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;
import com.huawei.dc.standalone.controller.StandAloneSyncCtrller;
import com.huawei.dc.standalone.model.T2000DevInfo;
import com.huawei.dc.toolkit.client.base.communicate.TKCommUtility;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKDeviceFactory;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKNodeStruct;
import com.huawei.dc.toolkit.control.Toolkit4T2kInterface;
import com.huawei.dc.toolkit.control.Toolkit4T2kInterfaceMgr;
import com.huawei.dc.toolkit.integration.TEToolkitModule;
import com.huawei.dc.toolkit.model.TKNEProperty;
import com.huawei.dc.toolkit.model.TKSubnetProperty;
import com.swimap.external.sm.adapter.message.LoginMode;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import gnu.trove.TIntObjectHashMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.swing.JFrame;

public class TEToolkitDataAdapter
implements Toolkit4T2kInterface {
    private static final int notsupport = 0;
    private static final int usessl = 1;
    private static final int notusessl = 2;
    private TIntHashSet m_oDevIDLst = null;
    private ArrayList subnetList = null;
    public static HashMap subnetID_HashMap = new HashMap();
    public static int replaceID = 0;
    public static String strTKServerIP = "";
    private TIntObjectHashMap<TKNEProperty> m_oNEHash = new TIntObjectHashMap();
    private TIntHashSet m_setOfDevices;

    @Override
    public Locale getLanguageConfig() {
        return ConfigurationInfo.getInstance().getLocale();
    }

    @Override
    public JFrame getMainFrame() {
        return DCFrameWorkUtil.getMainFrame();
    }

    public ArrayList<TKNEProperty> getNelist(int iProtocolType) {
        ArrayList<TKNEProperty> oTKNEPropertyLst = new ArrayList<TKNEProperty>();
        ArrayList<Integer> oDevIDLst = new ArrayList<Integer>();
        DeviceInfo[] oDeviceInfos = DeviceInfoManagerImpl.getInstance().getDevices();
        if (null == oDeviceInfos || oDeviceInfos.length < 1) {
            return null;
        }
        DeviceInfo oDeviceInfo = null;
        DeviceTypeInfo oDevTypeInfo = null;
        int iDevID = -1;
        for (int i = 0; i < oDeviceInfos.length; ++i) {
            oDeviceInfo = oDeviceInfos[i];
            if (null == oDeviceInfo || !(oDevTypeInfo = oDeviceInfo.getDeviceTypeInfo()).isT2000Domain()) continue;
            oDevIDLst.add(iDevID);
        }
        try {
            List<T2000DevInfo> oT2000DevInfoLst = StandAloneSyncCtrller.getInstance().getT2000Devices(oDevIDLst, 44105, true);
            if (null == oT2000DevInfoLst || oT2000DevInfoLst.size() < 1) {
                return null;
            }
            TKNEProperty oTKNEProperty = null;
            this.m_oNEHash.clear();
            for (T2000DevInfo oT2000DevInfo : oT2000DevInfoLst) {
                if (null == oT2000DevInfo || oT2000DevInfo.getProtocolType() != iProtocolType) continue;
                oTKNEProperty = this.transe2TKNEProperty(oT2000DevInfo);
                oTKNEPropertyLst.add(oTKNEProperty);
                this.m_oNEHash.put(oTKNEProperty.getDevID(), (Object)oTKNEProperty);
            }
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
            DCDebugTracer.trace("failed to get ne list from server");
        }
        return oTKNEPropertyLst;
    }

    @Override
    public int getSSLMode() {
        try {
            if (DCFrameWorkUtil.getIsSingleClient()) {
                return 2;
            }
            LoginMode mode = DCFrameWorkUtil.getSecurityInterface().getloginMode();
            if (null != mode && mode.mode == 1) {
                return 1;
            }
            return 2;
        }
        catch (Exception ex) {
            DCDebugTracer.trace("TEToolkitDataAdapter.getSSLMode() failed to get ssl mode");
            DCDebugTracer.trace(ex);
            return 0;
        }
    }

    @Override
    public String getServerIP() {
        return strTKServerIP;
    }

    @Override
    public ArrayList<String> getTKServerNamelst() {
        DataCenterModuleManager daModuleManager;
        ArrayList<String> serverIPLst = new ArrayList<String>();
        if (DCFrameWorkUtil.getIsSingleClient()) {
            serverIPLst.add("127.0.0.1");
            return serverIPLst;
        }
        SystemManager sysManager = new SystemManager();
        SystemSettingUtil oSystemSettingUtil = new SystemSettingUtil();
        FTSInfo ftpInfo = null;
        try {
            AsnSystemSettingInfoRsp oAsnSystemSettingInfoRsp = sysManager.getSystemSettingInfo();
            ftpInfo = oSystemSettingUtil.getProtocolConfiguration(oAsnSystemSettingInfoRsp.oFTSInfo);
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
        }
        String sServerIP = "";
        if (null != ftpInfo) {
            sServerIP = ftpInfo.getServerIP();
        }
        if (null != sServerIP && sServerIP.length() > 0) {
            serverIPLst.add(ftpInfo.getServerIP());
        }
        if (null != (daModuleManager = DCFrameWorkUtil.getDCModuleManager())) {
            serverIPLst.add(daModuleManager.getServerIP());
        }
        return serverIPLst;
    }

    @Override
    public void helpComponent(Component comp, String strHelpId) {
        if ("HELP_TOPIC_LOAD_BOARD_SOFTWARE".equals(strHelpId)) {
            DCHelpManager.getInstance().enableF1HelpKey(comp, "HELP_TOPIC_LOAD_BOARD_SOFTWARE");
        } else if ("HELP_TOPIC_LOAD_BOARD_PATCH".equals(strHelpId)) {
            DCHelpManager.getInstance().enableF1HelpKey(comp, "HELP_TOPIC_LOAD_BOARD_PATCH");
        } else if ("HELP_TOPIC_TK_MANAGE_LICENSE".equals(strHelpId)) {
            DCHelpManager.getInstance().enableF1HelpKey(comp, "HELP_TOPIC_TK_MANAGE_LICENSE");
        } else if ("HELP_TOPIC_TK_BACKUP_NE_LOG".equals(strHelpId)) {
            DCHelpManager.getInstance().enableF1HelpKey(comp, "HELP_TOPIC_TK_BACKUP_NE_LOG");
        } else if ("HELP_TOPIC_TL1_COMMANDLINE_TERMINAL".equals(strHelpId)) {
            DCHelpManager.getInstance().enableF1HelpKey(comp, "HELP_TOPIC_TL1_COMMANDLINE_TERMINAL");
        } else if ("HELP_TOPIC_SETTING_BOARD_SOFTWARE".equals(strHelpId)) {
            DCHelpManager.getInstance().enableF1HelpKey(comp, "HELP_TOPIC_SETTING_BOARD_SOFTWARE");
        } else if ("HELP_TOPIC_CHOOSE_FILE".equals(strHelpId)) {
            DCHelpManager.getInstance().enableF1HelpKey(comp, "HELP_TOPIC_CHOOSE_FILE");
        } else {
            DCDebugTracer.trace("Toolkit#helpId=" + strHelpId);
        }
    }

    @Override
    public boolean isConn() {
        return true;
    }

    private TKNEProperty transe2TKNEProperty(T2000DevInfo oT2000DevInfo) {
        if (null == oT2000DevInfo) {
            return null;
        }
        TKNEProperty oTkneProperty = new TKNEProperty();
        boolean bTL1NE = oT2000DevInfo.getProtocolType() == 4;
        oTkneProperty.setTL1NE(bTL1NE);
        if (bTL1NE) {
            oTkneProperty.setNeID(DeviceInfoUtil.parseNEIDStr(oT2000DevInfo.getTL1ProtocolDevPhyId()));
        } else if (2 == oT2000DevInfo.getProtocolType()) {
            oTkneProperty.setNeID(oT2000DevInfo.getMMLProtocolPhyDevIdDeviceId());
        }
        oTkneProperty.setNeName(oT2000DevInfo.getDeviceName());
        int iDevID = oT2000DevInfo.getDeviceID();
        oTkneProperty.setDevID(iDevID);
        String sDeTypeName = "";
        DeviceInfo oDevInfo = DeviceInfoManagerImpl.getInstance().getDevice(iDevID);
        if (null != oDevInfo) {
            sDeTypeName = oDevInfo.getDeviceTypeInfo().getDevTypeName();
            oTkneProperty.setGateway(oDevInfo.getRoleType() == 1);
        }
        oTkneProperty.setNeType(sDeTypeName);
        int iGateWayType = oT2000DevInfo.getGateWayType();
        oTkneProperty.setGatewayType(iGateWayType);
        if (1 == iGateWayType) {
            oTkneProperty.setGatewayIP(oT2000DevInfo.getGatewayAddress());
            oTkneProperty.setIpPort(oT2000DevInfo.getPort());
        } else {
            oTkneProperty.setTp4Address(oT2000DevInfo.getGatewayAddress());
            oTkneProperty.setTp4Port(oT2000DevInfo.getPort() + "");
        }
        oTkneProperty.setComPort(-1);
        oTkneProperty.setBandRate(-1);
        oTkneProperty.setUserName(oT2000DevInfo.getUserName());
        oTkneProperty.setPassword(oT2000DevInfo.getPass());
        oTkneProperty.setISUseSSH(oT2000DevInfo.isUseSSH());
        oTkneProperty.setSSHLoginKey(oT2000DevInfo.getSSHLoginKey());
        oTkneProperty.setSSHLoginMode(oT2000DevInfo.getSSHLoginMode());
        oTkneProperty.setSSHPassPhrase(oT2000DevInfo.getSSHPassPhrase());
        return oTkneProperty;
    }

    @Override
    public boolean isSameVersion() {
        String result = TKCommUtility.getServerVersion();
        if (!"".equals(result)) {
            String serverName = "";
            Toolkit4T2kInterface inf = Toolkit4T2kInterfaceMgr.getInstance();
            if (inf != null) {
                serverName = inf.getServerIP();
            }
            if (serverName.equals("")) {
                serverName = TKRes.instance().getString("T2000Server");
            }
            String progressName = TKRes.instance().getString("ToolkitServerCourse");
            String operReason = "";
            operReason = result;
            DCOptionPane.showConfirmDialog(TKResourceManager.getMainFrame(), progressName + "\n" + operReason);
            TEToolkitModule.disposeComm();
            return false;
        }
        return true;
    }

    @Override
    public void notifyCommunication(boolean isConnected) {
    }

    @Override
    public List<TKNodeStruct> getNelist() {
        ArrayList<TKNodeStruct> oTKNodeStructLst = new ArrayList<TKNodeStruct>(0);
        ArrayList<Integer> oDevIDLst = new ArrayList<Integer>(0);
        List<Object> oT2000DevLst = new ArrayList(0);
        try {
            List<T2000DevInfo> oT2000DevLstAll = StandAloneSyncCtrller.getInstance().getT2000Devices(oDevIDLst, 44105, true);
            if (!DCFrameWorkUtil.getIsSingleClient()) {
                DCFrameWorkUtil.getSecurityManager().getDevAccessList();
                this.m_setOfDevices = DCFrameWorkUtil.getSecurityManager().getSetOfDevices();
                if (null != this.m_setOfDevices && this.m_setOfDevices.size() > 0) {
                    for (int index = 0; index < oT2000DevLstAll.size(); ++index) {
                        T2000DevInfo t2000DevInfo = oT2000DevLstAll.get(index);
                        int devID = t2000DevInfo.getDeviceID();
                        if (!this.m_setOfDevices.contains(devID)) continue;
                        oT2000DevLst.add(oT2000DevLst.size(), t2000DevInfo);
                    }
                }
            } else {
                oT2000DevLst = oT2000DevLstAll;
            }
        }
        catch (DCException e) {
            DCDebugTracer.trace("TEToolkitDataAdapter.getNelist() error : faild to get ne list from sever.");
            DCDebugTracer.trace(e);
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
            return oTKNodeStructLst;
        }
        DCDebugTracer.trace("TEToolkitDataAdapter.getNelist() get T2k DevLst size=" + oT2000DevLst.size());
        TKNEProperty oTKNEProperty = null;
        this.m_oDevIDLst = new TIntHashSet();
        this.m_oNEHash.clear();
        replaceID = 0;
        subnetID_HashMap.clear();
        for (T2000DevInfo t2000DevInfo : oT2000DevLst) {
            oTKNEProperty = this.transe2TKNEProperty(t2000DevInfo);
            if (null == oTKNEProperty) continue;
            oTKNodeStructLst.add(this.transeProperty2TKNodeStract(oTKNEProperty));
            this.m_oNEHash.put(oTKNEProperty.getDevID(), (Object)oTKNEProperty);
            this.m_oDevIDLst.add(oTKNEProperty.getDevID());
        }
        this.subnetList = null;
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            this.subnetList = this.getSubnetList(this.m_oDevIDLst);
        }
        try {
            if (this.subnetList == null) {
                this.subnetList = new ArrayList();
            }
            for (int i = 0; i < this.subnetList.size(); ++i) {
                TKNodeStruct tKNodeStruct = new TKNodeStruct();
                TKSubnetProperty subnetNode = (TKSubnetProperty)this.subnetList.get(i);
                TEToolkitDataAdapter.fillSubnetDataR50rR4C02(tKNodeStruct, subnetNode);
                oTKNodeStructLst.add(tKNodeStruct);
                TEToolkitDataAdapter.getAllSubNodes(subnetNode, oTKNodeStructLst);
            }
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
        TKDeviceFactory.setDeviceList(oTKNodeStructLst);
        return oTKNodeStructLst;
    }

    private TKNodeStruct transeProperty2TKNodeStract(TKNEProperty prop) {
        TKNodeStruct nodeData = new TKNodeStruct();
        nodeData.nodeType = 1;
        nodeData.fatherID = 0;
        nodeData.nodeID = prop.getNeID();
        if (prop.gatewayType == 1) {
            nodeData.gatewayAddress = prop.getGatewayIP();
            nodeData.gatewayPort = prop.getIpPort() + "";
        } else {
            nodeData.gatewayAddress = prop.getTp4Address();
            nodeData.gatewayPort = prop.getTp4Port();
        }
        nodeData.gatewayType = prop.getGatewayType();
        nodeData.isGateway = prop.isGateway();
        nodeData.isTL1NE = prop.isTL1NE();
        nodeData.nePass = prop.getPassword();
        nodeData.neType = prop.getNeType();
        nodeData.neUserName = prop.getUserName();
        nodeData.nodeName = prop.getNeName();
        nodeData.setISUseSSH(prop.isUseSSH());
        nodeData.setSSHLoginMode(prop.getSSHLoginMode());
        nodeData.setSSHLoginKey(prop.getSSHLoginKey());
        nodeData.setSSHPassPhrase(prop.getSSHPassPhrase());
        return nodeData;
    }

    public ArrayList getSubnetList(TIntHashSet oDevIDLst) {
        if (null != this.subnetList) {
            return this.subnetList;
        }
        SubMapInfo oAllSubmap = DeviceInfoManagerImpl.getInstance().getSubMapInfo();
        if (null == oAllSubmap) {
            return null;
        }
        SubMapInfo oFilterSubmap = oAllSubmap.getSubmapInfo(oDevIDLst);
        TKSubnetProperty oRootPro = this.transe2SubnetProperty(oFilterSubmap, oDevIDLst);
        return oRootPro.getSubnetList();
    }

    private TKSubnetProperty transe2SubnetProperty(SubMapInfo oSubmap, TIntHashSet oDevIDLst) {
        TKSubnetProperty rootSNProperty = new TKSubnetProperty();
        rootSNProperty.setIconName(null);
        rootSNProperty.setSubnetName(oSubmap.m_strSubMapName);
        rootSNProperty.setRemark(oSubmap.m_strSubMapName);
        rootSNProperty.setSubnetID(oSubmap.m_strSubMapID);
        if (oSubmap.m_strParentSubMapID.equals("")) {
            rootSNProperty.setParentSubmapID(null);
        } else {
            rootSNProperty.setParentSubmapID(oSubmap.m_strParentSubMapID);
        }
        LinkedList<SubMapInfo> oChildSubmap = oSubmap.m_SubMapList;
        for (SubMapInfo oSub : oChildSubmap) {
            rootSNProperty.addSubnet(this.transe2SubnetProperty(oSub, oDevIDLst));
        }
        TIntHashSet oSubmapDevIDLst = oSubmap.m_oSubMapDevIDLst;
        TKNEProperty tk = null;
        ArrayList<TKNEProperty> oNELst = new ArrayList<TKNEProperty>();
        TIntIterator oDevIDItor = oSubmapDevIDLst.iterator();
        int iDevID = -1;
        while (oDevIDItor.hasNext()) {
            iDevID = oDevIDItor.next();
            if (!oDevIDLst.contains(iDevID)) continue;
            tk = (TKNEProperty)this.m_oNEHash.get(iDevID);
            tk.setSubnet(rootSNProperty);
            oNELst.add(tk);
        }
        if (oNELst.size() > 0) {
            rootSNProperty.setNeList(oNELst);
        }
        return rootSNProperty;
    }

    private static void fillSubnetDataR50rR4C02(TKNodeStruct nodeData, TKSubnetProperty prop) {
        nodeData.nodeType = 5;
        nodeData.fatherID = 0;
        try {
            nodeData.fatherID = TEToolkitDataAdapter.replaceSubnet(prop.getParentSubmapID());
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
        try {
            nodeData.nodeID = TEToolkitDataAdapter.replaceSubnet(prop.getSubnetID());
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
        nodeData.nodeName = prop.getSubnetName();
        nodeData.nodeRemark = prop.getRemark();
    }

    public static int replaceSubnet(String subnetID) {
        if ("HWMAP_PHY_SUBMAP".equals(subnetID) || "S102".equals(subnetID.toUpperCase())) {
            return 0;
        }
        if (subnetID_HashMap.size() == 0 || !subnetID_HashMap.containsKey(subnetID)) {
            subnetID_HashMap.put(subnetID, new Integer(++replaceID));
            return replaceID;
        }
        Integer temp = (Integer)subnetID_HashMap.get(subnetID);
        return temp;
    }

    private static void getAllSubNodes(TKSubnetProperty node, ArrayList sublist) {
        TKNodeStruct nodeStruct;
        int i;
        ArrayList neList = node.getNeList();
        ArrayList subnetList = node.getSubnetList();
        if (neList != null) {
            for (i = 0; i < neList.size(); ++i) {
                nodeStruct = new TKNodeStruct();
                TEToolkitDataAdapter.fillNeDataR50rR4C02(nodeStruct, (TKNEProperty)neList.get(i));
                sublist.add(nodeStruct);
            }
        }
        if (subnetList != null) {
            for (i = 0; i < subnetList.size(); ++i) {
                nodeStruct = new TKNodeStruct();
                TKSubnetProperty subnetNode = (TKSubnetProperty)subnetList.get(i);
                TEToolkitDataAdapter.fillSubnetDataR50rR4C02(nodeStruct, subnetNode);
                sublist.add(nodeStruct);
                TEToolkitDataAdapter.getAllSubNodes(subnetNode, sublist);
            }
        }
    }

    private static void fillNeDataR50rR4C02(TKNodeStruct nodeData, TKNEProperty prop) {
        nodeData.nodeType = 1;
        nodeData.fatherID = 0;
        try {
            nodeData.fatherID = TEToolkitDataAdapter.replaceSubnet(prop.getSubnet().getSubnetID());
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
        nodeData.nodeID = prop.getNeID();
        if (prop.gatewayType == 1) {
            nodeData.gatewayAddress = prop.getGatewayIP();
            nodeData.gatewayPort = prop.getIpPort() + "";
        } else {
            nodeData.gatewayAddress = prop.getTp4Address();
            nodeData.gatewayPort = prop.getTp4Port();
        }
        nodeData.gatewayPort = prop.getIpPort() + "";
        nodeData.gatewayType = prop.getGatewayType();
        nodeData.isGateway = prop.isGateway();
        nodeData.isTL1NE = prop.isTL1NE();
        nodeData.nePass = prop.getPassword();
        nodeData.neType = prop.getNeType();
        nodeData.neUserName = prop.getUserName();
        nodeData.nodeName = prop.getNeName();
    }

    @Override
    public void setServerIP(String strIP) {
        strTKServerIP = strIP;
    }
}

