/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.util;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.event.MouseInputAdapter;

public class TKTableRowResizer
extends MouseInputAdapter {
    public static final Cursor RESIZE_CURSOR = Cursor.getPredefinedCursor(8);
    private int mouseYOffset;
    private Cursor normalCursor;
    private int resizingRow;
    private String resizingRows = "**";
    private JTable table;

    public TKTableRowResizer(JTable table) {
        this.table = table;
        table.addMouseListener(this);
        table.addMouseMotionListener(this);
        this.normalCursor = table.getCursor();
    }

    public void addResizableRow(int row) {
        this.resizingRows = this.resizingRows + "**" + row + "**";
    }

    private int getResizingRow(Point point) {
        return this.getResizingRow(point, this.table.rowAtPoint(point));
    }

    private int getResizingRow(Point point, int row) {
        if (row == -1) {
            return -1;
        }
        int col = this.table.columnAtPoint(point);
        if (col == -1) {
            return -1;
        }
        Rectangle r = this.table.getCellRect(row, col, true);
        r.grow(0, -3);
        if (r.contains(point)) {
            return -1;
        }
        int midPoint = r.y + r.height / 2;
        int rowIndex = point.y < midPoint ? row - 1 : row;
        return rowIndex;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int newHeight;
        int mouseY = e.getY();
        if (this.table.getCursor().getType() == RESIZE_CURSOR.getType() && (newHeight = mouseY - this.mouseYOffset) > 22) {
            this.table.setRowHeight(this.resizingRow, newHeight);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.resizingRow = this.getResizingRow(e.getPoint());
        this.swapCursor();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point p = e.getPoint();
        int rowMouse = this.table.rowAtPoint(p);
        if (this.resizingRows.indexOf("**" + rowMouse + "**") < 0) {
            return;
        }
        this.resizingRow = this.getResizingRow(p);
        this.mouseYOffset = p.y - this.table.getRowHeight(this.resizingRow);
        if (this.table.getCursor().getType() == RESIZE_CURSOR.getType() && null != this.table.getCellEditor()) {
            this.table.getCellEditor().stopCellEditing();
        }
    }

    private void swapCursor() {
        String resizedRowId = "*" + this.resizingRow + "*";
        if (this.resizingRows.indexOf(resizedRowId) > -1) {
            DCFrameWorkUtil.setCursor(this.table, RESIZE_CURSOR);
        } else {
            DCFrameWorkUtil.setCursor(this.table, this.normalCursor);
        }
    }
}

