/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.util;

import com.huawei.dc.toolkit.client.te.toolkit.util.TKProgressMonitor;
import java.awt.Component;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class TKProgressMonitorInputStream
extends FilterInputStream {
    private TKProgressMonitor oProgressMonitor;
    private int iRead = 0;
    private int iSize = 0;

    public TKProgressMonitorInputStream(Component parentComponent, Object message, InputStream in, String title) {
        super(in);
        try {
            this.iSize = in.available();
        }
        catch (IOException ioe) {
            this.iSize = 0;
        }
        this.oProgressMonitor = new TKProgressMonitor(title, parentComponent, message, null, 0, this.iSize){

            @Override
            public void dispose() {
                try {
                    TKProgressMonitorInputStream.this.close();
                }
                catch (IOException ex) {
                    ex.toString();
                }
            }
        };
    }

    public TKProgressMonitorInputStream(Component parentComponent, Object message, InputStream in) {
        this(parentComponent, message, in, null);
    }

    public TKProgressMonitor getProgressMonitor() {
        return this.oProgressMonitor;
    }

    @Override
    public int read() throws IOException {
        int iReadLine = this.in.read();
        if (iReadLine >= 0) {
            this.oProgressMonitor.setProgress(++this.iRead);
        }
        if (this.oProgressMonitor.isCanceled()) {
            InterruptedIOException exc = new InterruptedIOException("progress");
            exc.bytesTransferred = this.iRead;
            throw exc;
        }
        return iReadLine;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int iReadLine = this.in.read(b);
        if (iReadLine > 0) {
            this.oProgressMonitor.setProgress(this.iRead += iReadLine);
        }
        if (this.oProgressMonitor.isCanceled()) {
            InterruptedIOException exc = new InterruptedIOException("progress");
            exc.bytesTransferred = this.iRead;
            throw exc;
        }
        return iReadLine;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int nr = this.in.read(b, off, len);
        if (nr > 0) {
            this.oProgressMonitor.setProgress(this.iRead += nr);
        }
        if (this.oProgressMonitor.isCanceled()) {
            InterruptedIOException exc = new InterruptedIOException("progress");
            exc.bytesTransferred = this.iRead;
            throw exc;
        }
        return nr;
    }

    @Override
    public long skip(long n) throws IOException {
        long nr = this.in.skip(n);
        if (nr > 0L) {
            this.iRead = (int)((long)this.iRead + nr);
            this.oProgressMonitor.setProgress(this.iRead);
        }
        return nr;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.oProgressMonitor.close();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.iRead = this.iSize - this.in.available();
        this.oProgressMonitor.setProgress(this.iRead);
    }
}

