/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.UIManager;

public class TKProgressMonitor {
    private Object[] cancelOption = null;
    private JDialog dcDialog;
    private int dcLastDisp;
    private int dcMax;
    private Object strMsg;
    private int dcMillisToDecideToPopup = 1;
    private int dcMillisToPopup = 1;
    private int iMin;
    private JProgressBar jBar;
    private String strNote;
    private JLabel noteLabel;
    private JOptionPane pane;
    private Component parentComponent;
    private int reportDelta;
    private TKProgressMonitor oRoot;
    private long dcTZero;
    private String strTitle;
    private String totalSize;

    public TKProgressMonitor(Component parentComponent, Object msg, String note, int iMin, int iMax) {
        this(parentComponent, msg, note, iMin, iMax, null);
    }

    private TKProgressMonitor(Component parentComponent, Object message, String note, int min, int max, TKProgressMonitor group) {
        this.iMin = min;
        this.dcMax = max;
        this.parentComponent = parentComponent;
        this.cancelOption = new Object[1];
        this.cancelOption[0] = UIManager.getString("OptionPane.cancelButtonText");
        this.reportDelta = 1;
        this.strMsg = message;
        this.strNote = note;
        if (group != null) {
            this.oRoot = group.oRoot != null ? group.oRoot : group;
            this.dcTZero = this.oRoot.dcTZero;
            this.dcDialog = this.oRoot.dcDialog;
        } else {
            this.dcTZero = System.currentTimeMillis();
        }
    }

    public TKProgressMonitor(String title, Component parentComponent, Object message, String note, int min, int max) {
        this(parentComponent, message, note, min, max);
        this.strTitle = title;
        this.totalSize = TKProgressMonitor.fileSize(max);
    }

    public void close() {
        if (this.dcDialog != null) {
            this.dcDialog.dispose();
            this.dcDialog = null;
            this.pane = null;
            this.jBar = null;
        }
    }

    public void dispose() {
    }

    private static String fileSize(long s) {
        int intCycle;
        double dblSize = s;
        for (intCycle = 0; dblSize >= 1000.0 && intCycle < 4; dblSize /= 1024.0, ++intCycle) {
        }
        String strSuffixUnit = "";
        switch (intCycle) {
            case 0: {
                strSuffixUnit = "B";
                break;
            }
            case 1: {
                strSuffixUnit = "K";
                break;
            }
            case 2: {
                strSuffixUnit = "M";
                break;
            }
            case 3: {
                strSuffixUnit = "G";
                break;
            }
            case 4: {
                strSuffixUnit = "T";
                break;
            }
        }
        return String.format("%.2f", dblSize) + strSuffixUnit;
    }

    public boolean isCanceled() {
        if (this.pane == null) {
            return false;
        }
        Object v = this.pane.getValue();
        return v != null && this.cancelOption.length == 1 && v.equals(this.cancelOption[0]);
    }

    public void setProgress(int nv) {
        if (nv >= this.dcMax) {
            this.close();
        } else if (nv >= this.dcLastDisp + this.reportDelta) {
            this.dcLastDisp = nv;
            if (this.jBar != null) {
                this.jBar.setValue(nv);
                this.jBar.setString(TKProgressMonitor.fileSize(nv) + "/" + this.totalSize);
            } else {
                int predictedCompletionTime;
                long T = System.currentTimeMillis();
                long dT = (int)(T - this.dcTZero);
                if (dT >= (long)this.dcMillisToDecideToPopup && (predictedCompletionTime = nv > this.iMin ? (int)(dT * (long)(this.dcMax - this.iMin) / (long)(nv - this.iMin)) : this.dcMillisToPopup) >= this.dcMillisToPopup) {
                    this.initProgressOptionPane(nv);
                    if (this.strTitle == null) {
                        this.strTitle = UIManager.getString("ProgressMonitor.progressText");
                    }
                    this.dcDialog = this.pane.createDialog(this.parentComponent, this.strTitle);
                    this.dcDialog.setVisible(true);
                }
            }
        }
    }

    private void initProgressOptionPane(int nv) {
        this.jBar = new JProgressBar();
        this.jBar.setStringPainted(true);
        this.jBar.setMaximum(this.dcMax);
        this.jBar.setMinimum(this.iMin);
        this.jBar.setValue(nv);
        if (this.strNote != null) {
            this.noteLabel = new JLabel(this.strNote);
        }
        this.pane = new ProgressOperationPane(new Object[]{this.strMsg, this.noteLabel, this.jBar});
    }

    public int getiMax() {
        return this.dcMax;
    }

    public void setiMax(int iMax) {
        this.dcMax = iMax;
    }

    public int getMillisToDecideToPopup() {
        return this.dcMillisToDecideToPopup;
    }

    public void setMillisToDecideToPopup(int millisToDecideToPopup) {
        this.dcMillisToDecideToPopup = millisToDecideToPopup;
    }

    public int getMillisToPopup() {
        return this.dcMillisToPopup;
    }

    public void setMillisToPopup(int millisToPopup) {
        this.dcMillisToPopup = millisToPopup;
    }

    public int getiMin() {
        return this.iMin;
    }

    public void setiMin(int iMin) {
        this.iMin = iMin;
    }

    public String getStrNote() {
        return this.strNote;
    }

    public void setNote(String strNote) {
        this.strNote = strNote;
        if (this.noteLabel != null) {
            this.noteLabel.setText(strNote);
        }
    }

    public String getTitle() {
        return this.strTitle;
    }

    public void setTitle(String title) {
        this.strTitle = title;
        if (this.dcDialog != null) {
            this.dcDialog.setTitle(title);
        }
    }

    private class ProgressOperationPane
    extends JOptionPane {
        private static final long serialVersionUID = -783138406346017084L;
        private static final int MAX_CHARACTERS_PER_LINE_COUNT = 60;

        ProgressOperationPane(Object oMessageList) {
            super(oMessageList, -1, -1, null, TKProgressMonitor.this.cancelOption, null);
        }

        @Override
        public JDialog createDialog(Component prtObj, String name) {
            Frame f = JOptionPane.getFrameForComponent(prtObj);
            final JDialog dg = new JDialog(f, name, false);
            Container cp = dg.getContentPane();
            cp.setLayout(new BorderLayout());
            cp.add((Component)this, "Center");
            dg.pack();
            dg.setLocationRelativeTo(prtObj);
            dg.addWindowListener(new WindowAdapter(){
                boolean isFocus = false;

                @Override
                public void windowClosed(WindowEvent e) {
                    TKProgressMonitor.this.dispose();
                }

                @Override
                public void windowActivated(WindowEvent we) {
                    if (!this.isFocus) {
                        ProgressOperationPane.this.selectInitialValue();
                        this.isFocus = true;
                    }
                }

                @Override
                public void windowClosing(WindowEvent we) {
                    ProgressOperationPane.this.setValue(null);
                }
            });
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent pce) {
                    if (dg.isVisible() && pce.getSource() == ProgressOperationPane.this && (pce.getPropertyName().equals("value") || pce.getPropertyName().equals("inputValue"))) {
                        dg.setVisible(false);
                        dg.dispose();
                    }
                }
            });
            return dg;
        }

        @Override
        public int getMaxCharactersPerLineCount() {
            return 60;
        }
    }
}

