/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.util;

import com.huawei.dc.common.components.u2kcbb.DCPasswordFiled;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.security.DCEncryptServiceUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.configuration.system.FTSInfo;
import com.huawei.dc.toolkit.client.base.communicate.TKCmdMSG;
import com.huawei.dc.toolkit.client.base.communicate.TKCommUtility;
import com.huawei.dc.toolkit.client.base.communicate.TKCommandResult;
import com.huawei.dc.toolkit.client.base.communicate.TKNoticeReceiver;
import com.huawei.dc.toolkit.client.base.util.TKFile;
import com.huawei.dc.toolkit.client.base.util.TKFtpStruct;
import com.huawei.dc.toolkit.client.base.util.TKLogManager;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.component.TKButton;
import com.huawei.dc.toolkit.client.base.util.component.TKComponentToolkit;
import com.huawei.dc.toolkit.client.base.util.component.TKIntegerTextField;
import com.huawei.dc.toolkit.client.base.util.component.TKNameTextField;
import com.huawei.dc.toolkit.client.base.util.component.TKOptionPane;
import com.huawei.dc.toolkit.client.base.util.component.TKTextField;
import com.huawei.dc.toolkit.client.base.util.filechooser.TKFileChooser;
import com.huawei.dc.toolkit.client.base.util.help.TKHelpMgr;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultStruct;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultVector;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperationShowMgr;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKConfirmOperationDlg;
import com.huawei.dc.toolkit.control.Toolkit4T2kInterface;
import com.huawei.dc.toolkit.control.Toolkit4T2kInterfaceMgr;
import com.huawei.te.toolkit.AsnSingleReturn;
import com.huawei.te.toolkit.AsnToolkitFtpServerInfo;
import com.huawei.te.toolkit.AsnToolkitGetFtpServerInfoRsp;
import com.huawei.te.toolkit.AsnToolkitSetFtpServerInfoReq;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.math.BigInteger;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.commustru.fstru.FStruct;

public class TKFtpPropertySetDlg
extends JDialog
implements TKNoticeReceiver {
    private static final long serialVersionUID = 277667121858032412L;
    private TKRes res = TKRes.instance();
    private static final Icon ICON_FTPOK = TKResourceManager.getIcon("ftpok.gif");
    private static final Icon ICON_FTPSTOP = TKResourceManager.getIcon("ftpstop.gif");
    String ftpIP = "";
    int ftpPort = 21;
    String userName = "";
    String pass = "";
    String rootDir = "";
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel4 = new JLabel();
    JLabel jLabel5 = new JLabel();
    private JLabel ftpStateLabel = new JLabel();
    private JLabel hintLabel = new JLabel();
    private JLabel hintLabel2 = new JLabel();
    private static final int FTP_SERV_RUNNING = 0;
    TKIntegerTextField jPortText = new TKIntegerTextField(1, 65535);
    TKTextField jUserText = new TKNameTextField();
    DCPasswordFiled jPasswordText = null;
    TKTextField jFileText = new TKTextField();
    TKButton jBrowseBtn = new TKButton();
    TKButton jOKBtn = new TKButton();
    TKButton jCancelBtn = new TKButton();
    TKButton jStopBtn = new TKButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    boolean isStart = false;
    static final String CHAR_COLON = ":";
    static final String CHAR_AT = "@";

    public TKFtpPropertySetDlg(Frame pFrame) {
        super(pFrame, true);
        Toolkit4T2kInterface inf = Toolkit4T2kInterfaceMgr.getInstance();
        if (inf != null) {
            TKCommUtility.comm.registerListener('\u1605', this);
            TKCommUtility.comm.registerListener('\u1604', this);
        }
        try {
            this.initDlg();
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), "HELP_TOPIC_SYSTEM_SETTTING_FTP_TOOLKIT");
    }

    private void initDlg() {
        Toolkit4T2kInterface inf = Toolkit4T2kInterfaceMgr.getInstance();
        if (inf == null) {
            TKHelpMgr.instance().helpRootPane(this.getRootPane());
            TKHelpMgr.instance().helpComponent(this, "ftpset");
        }
        this.ftpStateLabel.setForeground(Color.black);
        this.ftpStateLabel.setText(this.res.getString("FTPStateStop"));
        this.ftpStateLabel.setIcon(ICON_FTPSTOP);
        this.hintLabel.setText(this.res.getString("TEXT_hintLabel"));
        String TEXT_hintLabel2 = this.res.getString("TEXT_hintLabel2");
        TKLogManager.writeToDebug("TEXT_hintLabel2 :" + TEXT_hintLabel2);
        if (TEXT_hintLabel2.equals("TEXT_hintLabel2")) {
            this.hintLabel2.setText("");
        } else {
            this.hintLabel2.setText(TEXT_hintLabel2);
        }
        this.initComponent();
        this.jBrowseBtn.setMargin(new Insets(0, 10, 0, 10));
        this.jOKBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TKFtpPropertySetDlg.this.okBtn_actionPerformed();
                    }
                });
            }
        });
        this.jCancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKFtpPropertySetDlg.this.cancelBtn_actionPerformed();
            }
        });
        this.jBrowseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKFtpPropertySetDlg.this.browseBtn_actionPerformed();
            }
        });
        this.jStopBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKFtpPropertySetDlg.this.stopFTPServer();
            }
        });
        KeyAdapter escKa = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    TKFtpPropertySetDlg.this.cancelBtn_actionPerformed();
                }
            }
        };
        KeyAdapter enterKa = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    TKFtpPropertySetDlg.this.okBtn_actionPerformed();
                }
            }
        };
        TKComponentToolkit.addAllKeyListener(this, "javax.swing.text.JTextComponent", enterKa);
        TKComponentToolkit.addAllKeyListener(this, "javax.swing.JComponent", escKa);
        this.setTitle(this.res.getString("FTPpropertySet"));
        TKComponentToolkit.addAllButtonEnterKeyAdp(this);
        this.setDefaultCloseOperation(2);
    }

    private void initComponent() {
        this.jPasswordText = new DCPasswordFiled(40);
        this.setDefaultCloseOperation(2);
        this.jPanel1.setLayout(this.gridBagLayout3);
        this.jPanel2.setLayout(this.gridBagLayout2);
        this.jPanel3.setLayout(this.gridBagLayout1);
        this.jLabel1.setText(this.res.getString("FTP_Server_IP") + CHAR_COLON);
        this.jLabel2.setText(this.res.getString("Port") + CHAR_COLON);
        this.jLabel3.setText(this.res.getString("User") + CHAR_COLON);
        this.jLabel4.setText(this.res.getString("Password") + CHAR_COLON);
        this.jLabel5.setText(this.res.getString("Home_Directory") + CHAR_COLON);
        this.jBrowseBtn.setText(this.res.getString("Browse"));
        this.jOKBtn.setText(this.res.getString("button_START"));
        this.jCancelBtn.setText(this.res.getString("button_CANCEL"));
        this.jStopBtn.setText(this.res.getString("button_STOP"));
        this.jBrowseBtn.setName("_Button_Browse");
        this.jOKBtn.setName("_Button_Start");
        this.jCancelBtn.setName("_Button_Cancel");
        this.jStopBtn.setName("_Button_Stop");
        this.jPortText.setName("_TextField_Port");
        this.jUserText.setName("_TextField_User");
        this.jPasswordText.setName("_TextField_Password");
        this.jFileText.setName("_TextField_Path");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 1, 0, 2), 1, -12));
        this.jPanel2.add((Component)this.jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(19, 51, 0, 42), 0, 0));
        this.jPanel2.add((Component)this.jLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 51, 0, 15), 0, 0));
        this.jPanel2.add((Component)this.jLabel5, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(19, 51, 20, 49), 0, 0));
        this.jPanel2.add((Component)this.hintLabel, new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 51, 0, 35), 0, 0));
        this.jPanel2.add((Component)this.hintLabel2, new GridBagConstraints(0, 6, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 51, 20, 49), 0, 0));
        Toolkit4T2kInterface inf = Toolkit4T2kInterfaceMgr.getInstance();
        if (inf != null) {
            this.jPanel2.add((Component)this.ftpStateLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(36, 51, 0, 0), 0, 0));
        }
        this.jPanel2.add((Component)this.jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 51, 0, 46), 0, 0));
        this.jPanel2.add((Component)((Object)this.jPasswordText), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(17, 0, 0, 29), 136, 0));
        this.jPanel2.add((Component)this.jFileText, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(16, 0, 20, 0), 165, 0));
        this.jPanel2.add((Component)this.jPortText, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(17, 0, 0, 30), 135, 0));
        this.jPanel2.add((Component)this.jUserText, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(16, 0, 0, 30), 135, 0));
        this.jPanel2.add((Component)this.jBrowseBtn, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(14, 9, 20, 19), 4, 0));
        this.jPanel1.add((Component)this.jPanel3, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(8, 1, 11, 2), 0, 0));
        this.jPanel3.add((Component)this.jOKBtn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 20, 14, 0), 0, 0));
        this.jPanel3.add((Component)this.jStopBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 15, 14, 0), 0, 0));
        this.jPanel3.add((Component)this.jCancelBtn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 15, 14, 0), 0, 0));
        this.jPortText.setText(String.valueOf(this.ftpPort));
        this.jUserText.setText(this.userName);
        this.jPasswordText.setText(this.pass);
        if (this.rootDir.trim().length() > 1) {
            this.jFileText.setText(this.rootDir);
        }
    }

    void okBtn_actionPerformed() {
        int willContinue;
        int port = this.jPortText.getValue();
        String portStr = this.jPortText.getText();
        String user = this.jUserText.getText().trim();
        String pwd = String.valueOf(DCEncryptServiceUtil.encrypt(this.jPasswordText.getPassword()));
        String file = this.jFileText.getText().trim();
        if (file.length() > 1 && (file.endsWith("/") || file.endsWith("\\"))) {
            file = file.substring(0, file.length() - 1);
        }
        if (portStr.equals("")) {
            this.jPortText.requestFocus();
            TKOperationShowMgr.showPromptDialog(this, this.res.getString("PortInfoFail"), false);
            return;
        }
        if (user.trim().equals("")) {
            this.jUserText.requestFocus();
            TKOperationShowMgr.showPromptDialog(this, this.res.getString("UserInfoFail"), false);
            return;
        }
        if (pwd.equals("")) {
            this.jPasswordText.requestFocus();
            TKOperationShowMgr.showPromptDialog(this, this.res.getString("PwdInfoFail"), false);
            return;
        }
        if (file.equals("")) {
            this.jFileText.requestFocus();
            TKOperationShowMgr.showPromptDialog(this, this.res.getString("DirInfoFail"), false);
            return;
        }
        if (StringUtils.isContainsWhitespace(file)) {
            this.jFileText.requestFocus();
            TKOperationShowMgr.showPromptDialog(this, DCFrameWorkUtil.getLocalizedString("SYSTEM_INFO_TFTP_ROOT_DIRECTORY_BLANK_SPACE"), false);
            return;
        }
        if (StringUtils.isContainsSpecialChar(file)) {
            this.jFileText.requestFocus();
            TKOperationShowMgr.showPromptDialog(this, DCFrameWorkUtil.getLocalizedString("ROOT_CANNOT_HAVE_SPECIAL_CHARACTERS"), false);
            return;
        }
        if (user.indexOf(CHAR_AT) >= 0) {
            this.jUserText.requestFocus();
            TKOperationShowMgr.showPromptDialog(this, this.res.getString("CheckFTPUserAndPassword"), false);
            return;
        }
        if (pwd.indexOf(CHAR_AT) >= 0) {
            this.jPasswordText.requestFocus();
            TKOperationShowMgr.showPromptDialog(this, this.res.getString("CheckFTPUserAndPassword"), false);
            return;
        }
        if (this.isStart && this.ftpPort == port && this.userName.equals(user) && this.pass.equals(pwd) && this.rootDir.equals(file)) {
            this.dispose();
            return;
        }
        if (this.isStart && (willContinue = this.initConfirmDialog()) == 1) {
            return;
        }
        AsnToolkitSetFtpServerInfoReq req = new AsnToolkitSetFtpServerInfoReq();
        AsnToolkitFtpServerInfo ftpInfo = new AsnToolkitFtpServerInfo();
        ftpInfo.ftpIP = "".getBytes();
        ftpInfo.ftpPort = BigInteger.valueOf(port);
        ftpInfo.userName = user.getBytes();
        ftpInfo.userPwd = pwd.getBytes();
        ftpInfo.rootDir = file.getBytes();
        req.ftpServerInfo = ftpInfo;
        AsnSingleReturn rsp = new AsnSingleReturn();
        char cmdCode = '\u1602';
        byte receiveModule = 22;
        TKScreenToolKit.setComponentCursorBusy(this, true);
        TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, receiveModule, 120);
        TKScreenToolKit.setComponentCursorBusy(this, false);
        if (!ret.isSuccess) {
            TKOperationShowMgr.showOperationDlg((Component)this.getParent(), ret.resultInfo, true);
            return;
        }
        TKOperResultVector resultV = new TKOperResultVector();
        String logStr = "";
        if (rsp.isSuccess) {
            this.handleSuccessResult(port, user, pwd, file);
        } else {
            logStr = this.handleFailureResult(rsp, resultV);
        }
        if (logStr.trim().length() > 1) {
            TKLogManager.recordLog2Server(this.res.getString("FTPServer"), this.res.getString("SetFTP"), logStr);
        }
        if (resultV.size() > 0) {
            TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), this.res.getString("OperResult"), resultV);
        }
    }

    private String handleFailureResult(AsnSingleReturn rsp, TKOperResultVector resultV) {
        String operResult = this.res.getString("SetFTPFail");
        String operReason = TKRes.getErrorInfo(rsp);
        TKOperResultStruct struct = new TKOperResultStruct(this.res.getString("FTPServer"), operResult, operReason);
        resultV.addElement(struct);
        String logStr = this.res.getString("SetFTPFail") + " " + operReason;
        return logStr;
    }

    private void handleSuccessResult(int port, String user, String pwd, String file) {
        this.setFTPState(true);
        TKOptionPane.showMessageDialog(TKResourceManager.getMainFrame(), (Object)this.res.getString("FTPStateStart"), this.res.getString("Hint"), 1);
        this.dispose();
        FTSInfo oFtsInfo = new FTSInfo();
        oFtsInfo.setFTPPortNumber(port);
        oFtsInfo.setFTPUserName(user);
        oFtsInfo.setFTPPassword(pwd.toCharArray());
        oFtsInfo.setRootDirectory(file);
        this.updateDCServerFtpInfo(oFtsInfo);
    }

    private int initConfirmDialog() {
        String dlgDesc = this.res.getString("Toolkit_will_restart");
        String oper = this.res.getString("RestartOper");
        TKOperResultVector breakResultV = new TKOperResultVector();
        String operObj = this.res.getString("FTPServer");
        String breakDesc = this.res.getString("Toolkit_restart_result");
        TKOperResultStruct stuct = new TKOperResultStruct(operObj, oper, breakDesc);
        breakResultV.addElement(stuct);
        TKConfirmOperationDlg confDlg = new TKConfirmOperationDlg(TKResourceManager.getMainFrame(), this.res.getString("Warning"), dlgDesc, breakResultV, true);
        TKScreenToolKit.centerLocateToScreen(confDlg);
        int willContinue = confDlg.showDialog();
        return willContinue;
    }

    void cancelBtn_actionPerformed() {
        this.dispose();
    }

    void browseBtn_actionPerformed() {
        int result;
        TKFileChooser fc = new TKFileChooser();
        fc.setDialogTitle(this.res.getString("BrowseDirectory"));
        fc.setMultiSelectionEnabled(false);
        fc.setFileSelectionMode(1);
        fc.setBrowseType(101);
        fc.setShowFtpEnable(false);
        fc.setShowToolkitEnable(false);
        String lp = this.jFileText.getText();
        if (lp != null && lp.trim().length() > 1) {
            TKFile ff = new TKFile(lp, 1);
            fc.setCurrentDirectory(ff);
        }
        if ((result = fc.showFileDialog()) == 0) {
            TKFile selectedFile = fc.getSelectedFile();
            String path = selectedFile.getPath();
            path = path.replace(File.separatorChar, '/');
            this.jFileText.setText(path);
        }
    }

    public void queryFTPState() {
        TKLogManager.writeToFile(this.getClass().getName() + ":Query FTP Server state.");
        boolean ftpState = false;
        AsnToolkitSetFtpServerInfoReq req = new AsnToolkitSetFtpServerInfoReq();
        AsnToolkitFtpServerInfo ftpServerInfo = new AsnToolkitFtpServerInfo();
        ftpServerInfo.ftpIP = "".getBytes();
        ftpServerInfo.ftpPort = BigInteger.valueOf(0L);
        ftpServerInfo.userName = "".getBytes();
        ftpServerInfo.userPwd = "".getBytes();
        ftpServerInfo.rootDir = "".getBytes();
        req.ftpServerInfo = ftpServerInfo;
        AsnToolkitGetFtpServerInfoRsp rsp = new AsnToolkitGetFtpServerInfoRsp();
        char cmdCode = '\u1601';
        byte receiveModule = 22;
        TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, receiveModule, 120);
        if (!ret.isSuccess) {
            this.setFTPState(false);
            return;
        }
        ftpState = rsp.tkFtpServState.intValue() == 0;
        TKLogManager.writeToFile(this.getClass().getName() + ":Is FTP Server running:" + ftpState);
        this.setFTPState(ftpState);
    }

    public void setFTPState(boolean isStart) {
        this.isStart = isStart;
        if (isStart) {
            this.ftpStateLabel.setText(this.res.getString("FTPStateStart"));
            this.ftpStateLabel.setIcon(ICON_FTPOK);
        } else {
            this.ftpStateLabel.setText(this.res.getString("FTPStateStop"));
            this.ftpStateLabel.setIcon(ICON_FTPSTOP);
        }
        this.jStopBtn.setEnabled(isStart);
    }

    @Override
    public byte handleNotice(char cmdCode, TKCmdMSG data) {
        if (cmdCode == '\u1605') {
            TKLogManager.writeToFile(this.getClass().getName() + ": FTP Server stop.");
            this.setFTPState(false);
        }
        if (cmdCode == '\u1604') {
            TKLogManager.writeToFile(this.getClass().getName() + ":FTP Server started.");
            this.setFTPState(true);
        }
        return 1;
    }

    @Override
    public void dispose() {
        Toolkit4T2kInterface inf = Toolkit4T2kInterfaceMgr.getInstance();
        if (inf != null && TKCommUtility.comm != null) {
            TKCommUtility.comm.unregisterListener('\u1605', this);
            TKCommUtility.comm.unregisterListener('\u1604', this);
        }
        super.dispose();
    }

    void stopFTPServer() {
        String oper = this.res.getString("FTPStop");
        TKOperResultVector breakResultV = new TKOperResultVector();
        String operObj = this.res.getString("FTPServer");
        String breakDesc = this.res.getString("FTPStopResult");
        TKOperResultStruct stuct = new TKOperResultStruct(operObj, oper, breakDesc);
        breakResultV.addElement(stuct);
        AsnSingleReturn rsp = new AsnSingleReturn();
        char cmdCode = '\u1606';
        byte receiveModule = 22;
        TKScreenToolKit.setComponentCursorBusy(this, true);
        TKCommandResult ret = TKCommUtility.sendCommand(null, (FStruct)rsp, cmdCode, receiveModule, 120);
        TKScreenToolKit.setComponentCursorBusy(this, false);
        if (!ret.isSuccess) {
            TKOperationShowMgr.showOperationDlg((Component)this.getParent(), ret.resultInfo, false);
            return;
        }
        if (rsp.isSuccess) {
            this.setFTPState(false);
            TKOptionPane.showMessageDialog(TKResourceManager.getMainFrame(), (Object)this.res.getString("FTPStateStop"), this.res.getString("Hint"), 1);
        } else {
            TKOptionPane.showMessageDialog(TKResourceManager.getMainFrame(), (Object)this.res.getString("StopFTPServerFail"), this.res.getString("Hint"), 1);
        }
    }

    public void updateFTPInfo() {
        AsnToolkitSetFtpServerInfoReq req = new AsnToolkitSetFtpServerInfoReq();
        AsnToolkitFtpServerInfo ftpServerInfo = new AsnToolkitFtpServerInfo();
        ftpServerInfo.ftpIP = "".getBytes();
        ftpServerInfo.ftpPort = BigInteger.valueOf(0L);
        ftpServerInfo.userName = "".getBytes();
        ftpServerInfo.userPwd = "".getBytes();
        ftpServerInfo.rootDir = "".getBytes();
        req.ftpServerInfo = ftpServerInfo;
        TKFtpStruct data = new TKFtpStruct("");
        AsnToolkitGetFtpServerInfoRsp rsp = new AsnToolkitGetFtpServerInfoRsp();
        char cmdCode = '\u1601';
        byte receiveModule = 22;
        TKScreenToolKit.setComponentCursorBusy(this, true);
        TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, receiveModule, 120);
        TKScreenToolKit.setComponentCursorBusy(this, false);
        TKOperResultVector resultV = new TKOperResultVector();
        if (!ret.isSuccess) {
            return;
        }
        String logStr = "";
        if (rsp != null) {
            AsnToolkitFtpServerInfo asnFSInfo = rsp.ftpServerInfo;
            if (rsp.ret.isSuccess) {
                data = new TKFtpStruct(new String(asnFSInfo.rootDir));
                data.ftpIP = "";
                data.ftpPort = asnFSInfo.ftpPort.intValue();
                data.ftpPass = new String(asnFSInfo.userPwd);
                data.ftpUser = new String(asnFSInfo.userName);
            } else {
                String operResult = this.res.getString("QueryFTPFail");
                String operReason = TKRes.getErrorInfo(rsp.ret);
                TKOperResultStruct struct = new TKOperResultStruct(this.res.getString("FTPServer"), operResult, operReason);
                resultV.addElement(struct);
                logStr = this.res.getString("QueryFTPFail") + " " + operReason;
            }
            if (logStr.trim().length() > 1) {
                TKLogManager.recordLog2Server(this.res.getString("FTPServer"), this.res.getString("QueryFTP"), logStr);
            }
        }
        if (resultV.size() > 0) {
            TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), this.res.getString("OperResult"), resultV);
        }
        this.updateFTPServerInfo(data);
    }

    public void updateFTPServerInfo(TKFtpStruct data) {
        this.ftpIP = data.ftpIP;
        this.ftpPort = data.ftpPort;
        this.userName = data.ftpUser;
        this.pass = data.ftpPass;
        this.rootDir = data.getPath();
        this.jPortText.setText(String.valueOf(this.ftpPort));
        this.jUserText.setText(this.userName);
        this.jPasswordText.setText(this.pass);
        if (this.rootDir.trim().length() > 1) {
            this.jFileText.setText(this.rootDir);
        }
    }

    public boolean getFTPServerState() {
        return this.isStart;
    }

    private void updateDCServerFtpInfo(FTSInfo oFtsInfo) {
        SystemManager oSysMgr = new SystemManager();
        int iErrorCode = oSysMgr.setFTSInfo(oFtsInfo);
        DCDebugTracer.trace("toolkit ftp set ftp info " + iErrorCode);
    }
}

