/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.util;

import com.huawei.dc.toolkit.client.base.util.TKNameValuePair;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.component.TKButton;
import com.huawei.dc.toolkit.client.base.util.component.TKIntegerTextField;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOptionDialog;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKConfirmOperationDlg;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class TKFontChooser {
    private static TKRes res = TKRes.instance();
    TKIntegerTextField tfSize = new TKIntegerTextField();
    JLabel lbSize = new JLabel();
    JLabel lbFont = new JLabel();
    JLabel lbStyle = new JLabel();
    JPanel panel = new JPanel();
    JComboBox fontList = new JComboBox();
    JButton btnSetDefault = new TKButton();
    JComboBox styleList;
    private Font defaultFont;
    private Font originFont = new Font("DialogInput", 0, 13);
    private static int SAMPLE_FONT_SIZE = 12;
    TKNameValuePair styleNVPlain = new TKNameValuePair(0, res.getString("Plain"));
    TKNameValuePair styleNVPBold = new TKNameValuePair(1, res.getString("Plain"));
    TKNameValuePair StyleNVPItalic = new TKNameValuePair(2, res.getString("Plain"));
    Frame frame = null;
    TKOptionDialog fontDialog;
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public TKFontChooser(Frame frame, Font font) {
        this.defaultFont = font == null ? TKFontChooser.getDefaultFont() : font;
        this.frame = frame;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.toString();
        }
    }

    public TKFontChooser() {
        this(null, null);
    }

    public TKFontChooser(Frame frame, Font font, Font initFont) {
        this(frame, font);
        this.originFont = initFont;
    }

    public Font show() {
        this.fontDialog = new TKOptionDialog(this.frame, res.getString("SetFont"));
        this.fontDialog.setMessageComponent(this.panel);
        this.fontDialog.addButton(this.btnSetDefault);
        this.fontDialog.setSize(330, 120);
        int result = this.fontDialog.showDialog();
        if (result == 0) {
            int fontStyle;
            Font sFont;
            String fontName = this.defaultFont.getName();
            if (this.fontList.getSelectedIndex() >= 0) {
                fontName = this.fontList.getSelectedItem().toString();
            }
            if (!(sFont = new Font(fontName, fontStyle = this.defaultFont.getStyle(), this.tfSize.getValue())).canDisplay('A')) {
                TKConfirmOperationDlg confDlg = new TKConfirmOperationDlg(TKResourceManager.getMainFrame(), res.getString("Hint"), res.getString("ConfirmFont"), null, true);
                TKScreenToolKit.centerLocateToScreen(confDlg);
                int willContinue = confDlg.showDialog();
                if (willContinue == 1) {
                    return this.defaultFont;
                }
            }
            this.defaultFont = sFont;
        }
        return this.defaultFont;
    }

    private void jbInit() throws Exception {
        this.panel.setLayout(this.gridBagLayout1);
        this.lbSize.setText(res.getString("Size") + ":");
        this.lbFont.setText(res.getString("Font") + ":");
        this.lbStyle.setText(res.getString("Style") + ":");
        this.btnSetDefault.setText(res.getString("button_INIT"));
        this.styleList = new JComboBox();
        this.styleList.addItem(this.styleNVPlain);
        this.styleList.addItem(this.styleNVPBold);
        this.styleList.addItem(this.StyleNVPItalic);
        this.styleList.setSelectedIndex(this.defaultFont.getStyle());
        this.tfSize.setText(String.valueOf(this.defaultFont.getSize()));
        this.tfSize.setRange(1, 72);
        this.initFontList(this.defaultFont);
        this.tfSize.setPreferredSize(new Dimension(7, 22));
        this.tfSize.setMaximumSize(new Dimension(7, 22));
        this.tfSize.setMinimumSize(new Dimension(7, 22));
        this.fontList.setPreferredSize(new Dimension(27, 22));
        this.fontList.setMaximumSize(new Dimension(27, 22));
        this.fontList.setMinimumSize(new Dimension(27, 22));
        this.btnSetDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKFontChooser.this.fontList.setSelectedItem(TKFontChooser.this.originFont.getName());
                TKFontChooser.this.tfSize.setText(String.valueOf(TKFontChooser.this.originFont.getSize()));
            }
        });
        this.lbFont.setRequestFocusEnabled(true);
        this.panel.add((Component)this.fontList, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 0, 9, 0), 124, 0));
        this.panel.add((Component)this.tfSize, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 0, 9, 3), 58, 0));
        this.panel.add((Component)this.lbSize, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 22, 9, 0), 4, 0));
        this.panel.add((Component)this.lbFont, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, -1, 8, 13), 0, 0));
        this.tfSize.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                this.approve(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.approve(e);
            }

            private void approve(KeyEvent e) {
                if (TKFontChooser.this.fontDialog != null && e.getKeyCode() == 10) {
                    TKFontChooser.this.fontDialog.approveAction();
                }
            }
        });
    }

    private void initFontList(Font selectedFont) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        this.fontList.removeAllItems();
        boolean hasFont = false;
        Object[] supportFonts = new String[]{"\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd_GB2312", "\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd", "\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00c4\u00b2\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd", "\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ce\u00ba", "\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00cf\u00b8\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd", "\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00d0\u00bf\u00ef\u00bf\u00bd", "\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd", "\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd-\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00d6\u00b7\u00ef\u00bf\u00bd", "\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00d4\u00b2", "\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd", "\u00ef\u00bf\u00bd\u00c2\u00bc\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdw", "\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00d2\u00a6\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd", "\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd", "\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd_GB2312", "\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdw", "e\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd", "\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd"};
        Arrays.sort(supportFonts);
        for (int i = 0; i < fontNames.length; ++i) {
            String fontName = fontNames[i];
            if (fontName.trim().length() == 0) continue;
            if (this.containChineseCheck(fontName)) {
                if (Arrays.binarySearch(supportFonts, fontName) > -1) {
                    this.fontList.addItem(fontName);
                }
            } else {
                this.fontList.addItem(fontName);
            }
            if (!fontName.trim().equals(selectedFont.getName().trim())) continue;
            hasFont = true;
        }
        if (hasFont) {
            this.fontList.setSelectedItem(selectedFont.getName().trim());
        }
    }

    public static Font getDefaultFont() {
        UIDefaults uidefs = UIManager.getLookAndFeelDefaults();
        String[] keys = uidefs.keySet().toArray(new String[0]);
        Font font = null;
        for (int i = 0; i < keys.length; ++i) {
            Object v = uidefs.get(keys[i]);
            if (!(v instanceof Font)) continue;
            font = uidefs.getFont(keys[i]);
            break;
        }
        return font;
    }

    private boolean containChineseCheck(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char singleChar = str.charAt(i);
            if (singleChar <= '\u007f') continue;
            return true;
        }
        return false;
    }
}

