/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.util;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.component.TKComponentToolkit;
import com.huawei.dc.toolkit.client.base.util.component.TKTable;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultStruct;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TKConfirmOperationDlg
extends JDialog {
    private CustomTableCellRender cellRender = new CustomTableCellRender();
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    private int YES_OR_NO = 1;
    private static TKRes res = TKRes.instance();
    static String resourceFile = "operres.ini";
    private JPanel parentPnl = new JPanel();
    private JPanel tablePnl = new JPanel();
    private JScrollPane operScrollPane = new JScrollPane();
    private JPanel topPnl = new JPanel();
    private JPanel btnPnl = new JPanel();
    private JPanel infoPnl = new JPanel();
    private JLabel iconLbl = new JLabel();
    private JScrollPane infoScrllPn = new JScrollPane();
    private JTextArea infoTextArea = new JTextArea();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JButton detailBtn = new JButton();
    private JButton noBtn = new JButton();
    private JButton okBtn = new JButton();
    private JButton noDetailBtn = new JButton();
    private JScrollPane operScrollPane2 = new JScrollPane();
    private JTable table2 = new TKTable();
    private DefaultTableModel tableModel2 = null;
    private JTable table = new TKTable();
    private Vector vcColumn = null;
    private Vector vcData = null;
    private DefaultTableModel tableModel = null;
    private final String colOperObj = TKResourceManager.getString(resourceFile, "OPER_OBJ");
    private final String colOperResult = TKResourceManager.getString(resourceFile, "OPERATION");
    private final String colConfMsg = TKResourceManager.getString(resourceFile, "DESC");
    private static final int WindowWidth = 450;
    private static final int WindowHeightCollapse = 180;
    private static final int WindowHeightExtend = 360;
    private static final String iconFile = "inform.gif";
    private String infoStr = null;
    private boolean oneColumn_ = false;
    KeyAdapter escKa = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                TKConfirmOperationDlg.this.noBtn_actionPerformed(null);
            }
        }
    };

    public TKConfirmOperationDlg(Frame parentFrame, String title, String infoStr, TKOperResultVector vcrData, boolean isModal) {
        this(parentFrame, title, infoStr, vcrData, isModal, false);
    }

    public TKConfirmOperationDlg(Frame parentFrame, String title, String infoStr, TKOperResultVector vcrData, boolean isModal, boolean oneColumn) {
        super(parentFrame, title, isModal);
        this.infoStr = infoStr;
        this.vcData = TKConfirmOperationDlg.operResultVectorToCommonVector(vcrData);
        this.oneColumn_ = oneColumn;
        try {
            this.jbInit();
            this.extraInit();
            this.setDefaultCloseOperation(2);
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
    }

    private void jbInit() throws Exception {
        this.detailBtn.setText(TKResourceManager.getString(resourceFile, "DETAIL_1"));
        this.noBtn.setText(res.getString("button_NO"));
        this.noDetailBtn.setText(TKResourceManager.getString(resourceFile, "DETAIL_2"));
        this.okBtn.setText(res.getString("button_YES"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.detailBtn);
        group.add(this.noBtn);
        group.add(this.noDetailBtn);
        group.add(this.okBtn);
        this.iconLbl.setIcon(TKResourceManager.getIcon(iconFile));
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table2.getTableHeader().setReorderingAllowed(false);
        this.infoTextArea.setWrapStyleWord(true);
        this.infoTextArea.setLineWrap(true);
        this.infoTextArea.setBorder(BorderFactory.createEmptyBorder());
        this.infoTextArea.setEditable(false);
        this.infoTextArea.setBackground(UIManager.getColor("Label.background"));
        this.infoTextArea.setRequestFocusEnabled(false);
        this.infoScrllPn.setBorder(null);
        this.infoScrllPn.setPreferredSize(new Dimension(300, 80));
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.getContentPane().add(this.parentPnl);
        this.parentPnl.setLayout(new BorderLayout(20, 20));
        this.parentPnl.add((Component)this.topPnl, "North");
        this.parentPnl.add((Component)this.tablePnl, "Center");
        this.topPnl.setLayout(this.gridBagLayout1);
        this.topPnl.add((Component)this.iconLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 5, 5), 0, 0));
        this.topPnl.add((Component)this.infoScrllPn, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(20, 10, 5, 5), 0, 0));
        this.topPnl.add((Component)this.btnPnl, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.infoScrllPn.getViewport().add(this.infoTextArea);
        this.btnPnl.setLayout(new FlowLayout(2, 8, 0));
        this.btnPnl.add(this.detailBtn);
        this.btnPnl.add(this.noDetailBtn);
        this.btnPnl.add(this.okBtn);
        this.btnPnl.add(this.noBtn);
        TKComponentToolkit.instance().addButtonsFocusAdapter(new JButton[]{this.detailBtn, this.noDetailBtn, this.okBtn, this.noBtn}, 0);
        this.tablePnl.setLayout(new BorderLayout());
        if (this.oneColumn_) {
            this.tablePnl.add((Component)this.operScrollPane2, "Center");
        } else {
            this.tablePnl.add((Component)this.operScrollPane, "Center");
        }
        this.operScrollPane.getViewport().add(this.table);
        this.operScrollPane2.getViewport().add(this.table2);
        this.table.setFocusable(false);
        this.table2.setFocusable(false);
        this.detailBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKConfirmOperationDlg.this.detailBtn_actionPerformed(e);
            }
        });
        this.noDetailBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKConfirmOperationDlg.this.noDetailBtn_actionPerformed(e);
            }
        });
        this.noBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKConfirmOperationDlg.this.noBtn_actionPerformed(e);
            }
        });
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKConfirmOperationDlg.this.okBtn_actionPerformed(e);
            }
        });
        this.tablePnl.setVisible(false);
        this.noDetailBtn.setVisible(false);
        this.operScrollPane2.setVisible(false);
        this.setSize(450, 180);
        TKScreenToolKit.centerLocateToScreen(this);
        TKComponentToolkit.addAllKeyListener(this, "javax.swing.JComponent", this.escKa);
        TKComponentToolkit.addAllButtonEnterKeyAdp(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                TKConfirmOperationDlg.this.noBtn.requestFocusInWindow();
            }
        });
        this.detailBtn.setVisible(this.vcData.size() > 0);
    }

    private void extraInit() {
        if (this.infoStr == null) {
            this.infoTextArea.setText(TKResourceManager.getString(resourceFile, "OPER_OVER"));
        } else {
            this.infoTextArea.setText(this.infoStr);
        }
        this.infoTextArea.setCaretPosition(0);
        if (null == this.vcData || this.vcData.size() == 0) {
            return;
        }
        try {
            this.vcColumn = new Vector();
            this.vcColumn.addElement(this.colOperObj);
            this.vcColumn.addElement(this.colOperResult);
            this.vcColumn.addElement(this.colConfMsg);
            this.tableModel = new DefaultTableModel(this.vcData, this.vcColumn){

                @Override
                public boolean isCellEditable(int row, int col) {
                    return false;
                }
            };
            this.table.setModel(this.tableModel);
            this.table.addMouseMotionListener(this.getMouseMotionAdapterForTable());
            TableColumn objTC = this.table.getColumn(this.colOperObj);
            TableColumn resultTC = this.table.getColumn(this.colOperResult);
            TableColumn reasonTC = this.table.getColumn(this.colConfMsg);
            objTC.setMaxWidth(1000);
            objTC.setMinWidth(60);
            objTC.setPreferredWidth(110);
            objTC.setCellRenderer(this.cellRender);
            resultTC.setMaxWidth(1000);
            resultTC.setMinWidth(50);
            resultTC.setPreferredWidth(120);
            resultTC.setCellRenderer(this.cellRender);
            reasonTC.setMaxWidth(1500);
            reasonTC.setMinWidth(100);
            reasonTC.setPreferredWidth(220);
            reasonTC.setCellRenderer(this.cellRender);
            this.setRowHeight();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TKConfirmOperationDlg.this.table.repaint();
                    TKConfirmOperationDlg.this.detailBtn.setEnabled(TKConfirmOperationDlg.this.tableModel.getRowCount() > 0);
                }
            });
        }
        catch (Exception ex) {
            ex.toString();
        }
        if (!this.oneColumn_) {
            return;
        }
        try {
            Vector<String> vcColumn2 = new Vector<String>();
            vcColumn2.addElement(this.colConfMsg);
            this.tableModel2 = new DefaultTableModel(this.vcData, vcColumn2){

                @Override
                public boolean isCellEditable(int row, int col) {
                    return false;
                }
            };
            this.table2.setModel(this.tableModel2);
            this.table2.addMouseMotionListener(this.getMouseMotionAdapterForTable2());
            TableColumn reasonTC2 = this.table2.getColumn(this.colConfMsg);
            reasonTC2.setMaxWidth(1600);
            reasonTC2.setMinWidth(100);
            reasonTC2.setPreferredWidth(450);
            reasonTC2.setCellRenderer(this.cellRender);
            this.setRowHeight();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TKConfirmOperationDlg.this.table2.repaint();
                    TKConfirmOperationDlg.this.detailBtn.setEnabled(TKConfirmOperationDlg.this.tableModel.getRowCount() > 0);
                }
            });
        }
        catch (Exception ex) {
            ex.toString();
        }
    }

    private MouseMotionAdapter getMouseMotionAdapterForTable() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent oEvent) {
                TKConfirmOperationDlg.this.setToolTipForTable(oEvent);
            }
        };
    }

    private void setToolTipForTable(MouseEvent oEvent) {
        Point oPoint = oEvent.getPoint();
        String strToolTipText = this.table.getValueAt(this.table.rowAtPoint(oPoint), this.table.columnAtPoint(oPoint)).toString();
        this.table.setToolTipText(strToolTipText);
    }

    private MouseMotionAdapter getMouseMotionAdapterForTable2() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent oEvent) {
                TKConfirmOperationDlg.this.setToolTipForTable2(oEvent);
            }
        };
    }

    private void setToolTipForTable2(MouseEvent oEvent) {
        Point oPoint = oEvent.getPoint();
        String strToolTipText = this.table2.getValueAt(this.table2.rowAtPoint(oPoint), this.table2.columnAtPoint(oPoint)).toString();
        this.table2.setToolTipText(strToolTipText);
    }

    private void noBtn_actionPerformed(ActionEvent e) {
        this.YES_OR_NO = 1;
        this.dispose();
    }

    @Override
    public void dispose() {
        if (this.vcData != null) {
            this.vcData.clear();
        }
        super.dispose();
    }

    private void detailBtn_actionPerformed(ActionEvent e) {
        this.setSize(450, 360);
        this.tablePnl.setVisible(true);
        this.noDetailBtn.setVisible(true);
        this.detailBtn.setVisible(false);
        this.validate();
        this.repaint();
    }

    private void noDetailBtn_actionPerformed(ActionEvent e) {
        this.setSize(450, 180);
        this.tablePnl.setVisible(false);
        this.noDetailBtn.setVisible(false);
        this.detailBtn.setVisible(true);
        this.validate();
        this.repaint();
    }

    private void okBtn_actionPerformed(ActionEvent e) {
        this.YES_OR_NO = 0;
        this.dispose();
    }

    public void setRowHeight() {
        JTable tempTable = new TKTable();
        tempTable = this.oneColumn_ ? this.table2 : this.table;
        int row = tempTable.getRowCount();
        int columnCount = tempTable.getColumnCount();
        if (this.oneColumn_) {
            columnCount = 1;
        }
        JTextArea textArea = new JTextArea();
        Font font = textArea.getFont();
        if (row < 0) {
            return;
        }
        for (int i = 0; i < row; ++i) {
            int maxRowHeight;
            int tempRowHeight = maxRowHeight = 20;
            for (int j = 0; j < columnCount; ++j) {
                int cellWidth;
                int height = 20;
                Object tem = tempTable.getValueAt(i, j);
                String temp = tem.toString();
                Rectangle2D r2d = font.getStringBounds(temp, new FontRenderContext(new AffineTransform(), true, true));
                int width = (int)r2d.getWidth();
                double rowNum = Math.ceil((double)width / (double)(cellWidth = tempTable.getColumnModel().getColumn(j).getPreferredWidth()));
                tempRowHeight = height * (int)rowNum;
                if (tempRowHeight <= maxRowHeight) continue;
                maxRowHeight = tempRowHeight;
            }
            tempTable.setRowHeight(i, maxRowHeight);
        }
    }

    public int showDialog() {
        TKScreenToolKit.centerLocateToScreen(this);
        this.show();
        return this.YES_OR_NO;
    }

    public void setAlterStyle() {
        Font font = this.infoTextArea.getFont();
        this.infoTextArea.setFont(new Font(font.getFontName(), 1, font.getSize()));
    }

    public void hideDetailColumn() {
        boolean show = false;
        this.operScrollPane.setVisible(show);
        this.operScrollPane2.setVisible(!show);
        this.detailBtn_actionPerformed(null);
    }

    public void showDetail() {
        this.detailBtn_actionPerformed(null);
    }

    public static Vector operResultVectorToCommonVector(TKOperResultVector data) {
        Vector vc = new Vector();
        if (data != null) {
            for (int i = 0; i < data.size(); ++i) {
                Object obj = data.elementAt(i);
                Vector<String> rowData = new Vector<String>();
                if (obj instanceof TKOperResultStruct) {
                    TKOperResultStruct objStruct = (TKOperResultStruct)data.elementAt(i);
                    if (objStruct.operObj != null) {
                        rowData.addElement(objStruct.operObj);
                    } else {
                        rowData.addElement("");
                    }
                    if (objStruct.operResult != null) {
                        rowData.addElement(objStruct.operResult);
                    } else {
                        rowData.addElement("");
                    }
                    if (objStruct.operReason != null) {
                        rowData.addElement(objStruct.operReason);
                    } else {
                        rowData.addElement("");
                    }
                } else {
                    rowData.add((String)obj);
                }
                vc.addElement(rowData);
            }
        }
        return vc;
    }

    public static Vector operResultVectorToStringList(TKOperResultVector data) {
        Vector<String> vc = new Vector<String>();
        if (data != null) {
            for (int i = 0; i < data.size(); ++i) {
                Object obj = data.elementAt(i);
                String rowData = "";
                if (obj instanceof TKOperResultStruct) {
                    TKOperResultStruct objStruct = (TKOperResultStruct)data.elementAt(i);
                    if (objStruct.operObj != null) {
                        rowData = rowData + "(" + objStruct.operObj + ")";
                    }
                    if (objStruct.operResult != null) {
                        rowData = rowData + objStruct.operResult + "-";
                    }
                    if (objStruct.operReason != null) {
                        rowData = rowData + objStruct.operReason;
                    }
                } else {
                    rowData = obj.toString();
                }
                vc.addElement(rowData);
            }
        }
        return vc;
    }

    class CustomTableCellRender
    extends JTextArea
    implements TableCellRenderer {
        public CustomTableCellRender() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

