/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.util;

import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.component.TKButton;
import com.huawei.dc.toolkit.client.base.util.component.TKTextField;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKButtonEditorInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;

public class TKButtonEditor
extends AbstractCellEditor
implements TableCellEditor {
    JPanel panel = new JPanel();
    TKTextField textfield = new TKTextField();
    TKButton button = new TKButton();
    private TKButtonEditorInterface editorInterface = null;
    private static final int inTableCell = 0;
    private static final int inTable = 1;
    int selectedRow = -1;
    boolean isSelected = false;
    int selectedColumn = -1;

    public TKButtonEditor(TKButtonEditorInterface tablepanel, String buttonText, String actionCommand) {
        this(tablepanel, buttonText, actionCommand, null);
    }

    public TKButtonEditor(TKButtonEditorInterface tablepanel, String buttonText) {
        this(tablepanel, buttonText, "default", null);
    }

    public TKButtonEditor(TKButtonEditorInterface tablepanel, String actionCommand, Icon icon) {
        this(tablepanel, "...", actionCommand, icon);
    }

    public TKButtonEditor(TKButtonEditorInterface tablepanel, Icon icon) {
        this(tablepanel, "", "default", icon);
    }

    public TKButtonEditor(TKButtonEditorInterface tablepanel) {
        this(tablepanel, "...", "default", null);
    }

    public TKButtonEditor(TKButtonEditorInterface tablepanel, String buttonText, String actionCommand, Icon icon) {
        this.button.setText(buttonText);
        if (icon != null) {
            this.button.setHorizontalTextPosition(2);
            this.button.setIcon(icon);
        }
        this.button.setMargin(new Insets(0, 0, 0, 0));
        this.button.setActionCommand(actionCommand);
        this.editorInterface = tablepanel;
        this.textfield.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.textfield.setEditable(false);
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.textfield, "Center");
        this.panel.add((Component)this.button, "East");
        ActionListener[] als = this.button.getActionListeners();
        for (int i = 0; i < als.length; ++i) {
            this.button.removeActionListener(als[i]);
        }
        AbstractAction enterAction = new AbstractAction("VK_ENTER "){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        this.button.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "VK_ENTER");
        this.button.getActionMap().put("VK_ENTER", enterAction);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKButtonEditor.this.editorInterface.actionPerformedByEditor(e);
            }
        });
        this.textfield.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TKButtonEditor.this.showPopupMenu(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TKButtonEditor.this.showPopupMenu(e);
                }
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value != null) {
            this.textfield.setText(value.toString());
        }
        this.selectedColumn = column;
        this.selectedRow = row;
        this.textfield.repaint();
        return this.panel;
    }

    @Override
    public Object getCellEditorValue() {
        return this.textfield.getText();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.textfield.repaint();
        return super.stopCellEditing();
    }

    public Component getTableCellEditorComponent() {
        return this.textfield;
    }

    private void showPopupMenu(MouseEvent e) {
        JPopupMenu popupMenu = this.editorInterface.getPopupMenu(this.selectedRow, this.selectedColumn);
        if (popupMenu == null) {
            return;
        }
        Point point = TKScreenToolKit.getPopupMenuShowupPosition(this.textfield, popupMenu, e.getX(), e.getY());
        popupMenu.show(this.textfield, point.x, point.y);
    }
}

