/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.util;

import com.huawei.dc.toolkit.client.base.util.TKFile;
import com.huawei.dc.toolkit.client.base.util.TKFtpStruct;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.te.toolkit.AsnSingleReturn;
import com.huawei.te.toolkit.AsnTkPkgSoftLoadInfo;
import com.huawei.te.toolkit.AsnTkSoftInfo;
import com.huawei.te.toolkit.AsnToolkitError;
import com.huawei.te.toolkit.AsnToolkitLoadFileInfo;
import java.math.BigInteger;
import java.util.Vector;

public class TKASNTool {
    public static final TKASNTool instance = new TKASNTool();
    public static final String Head_of_FTP = "ftp://";
    public static final String Head_of_SFTP = "sftp://";

    private TKASNTool() {
    }

    public static AsnToolkitLoadFileInfo[] toAsn1LoadFiles(TKFile[] fs) {
        if (fs == null) {
            return null;
        }
        Vector<AsnToolkitLoadFileInfo> retVe = new Vector<AsnToolkitLoadFileInfo>();
        for (int i = 0; i < fs.length; ++i) {
            if (fs[i] == null) continue;
            AsnToolkitLoadFileInfo asn = new AsnToolkitLoadFileInfo();
            asn.fileName = fs[i].getAbsolutePath().getBytes();
            asn.softVersion = fs[i].softVersion.getBytes();
            asn.softType = new BigInteger(fs[i].softType + "");
            asn.resetType = new BigInteger(fs[i].resetType + "");
            retVe.add(asn);
        }
        Object[] asns = new AsnToolkitLoadFileInfo[retVe.size()];
        retVe.copyInto(asns);
        return asns;
    }

    public static AsnTkPkgSoftLoadInfo[] toAsn1PkgSoftInfos(TKFtpStruct[] fs) {
        if (fs == null) {
            return null;
        }
        Vector<AsnTkPkgSoftLoadInfo> fsV = new Vector<AsnTkPkgSoftLoadInfo>();
        for (int i = 0; i < fs.length; ++i) {
            AsnTkPkgSoftLoadInfo asn = new AsnTkPkgSoftLoadInfo();
            if (null != asn) {
                asn.softInfo = TKASNTool.toAsn1SoftInfo(fs[i]);
            }
            if (asn == null) continue;
            asn.softType = BigInteger.valueOf(fs[i].softType);
            fsV.add(asn);
        }
        if (fsV.size() == 0) {
            return null;
        }
        Object[] asns = new AsnTkPkgSoftLoadInfo[fsV.size()];
        fsV.copyInto(asns);
        return asns;
    }

    public static AsnTkPkgSoftLoadInfo toAsn1PkgSoftInfo(TKFtpStruct ftpStruct) {
        if (ftpStruct == null) {
            return null;
        }
        AsnTkPkgSoftLoadInfo asn = new AsnTkPkgSoftLoadInfo();
        asn.softInfo = TKASNTool.toAsn1SoftInfo(ftpStruct);
        if (asn.softInfo == null) {
            return null;
        }
        asn.softType = BigInteger.valueOf(ftpStruct.softType);
        return asn;
    }

    public static AsnTkSoftInfo[] toAsn1SoftInfos(TKFtpStruct[] fs) {
        if (fs == null) {
            return null;
        }
        Vector<AsnTkSoftInfo> fsV = new Vector<AsnTkSoftInfo>();
        for (int i = 0; i < fs.length; ++i) {
            AsnTkSoftInfo asnFile = TKASNTool.toAsn1SoftInfo(fs[i]);
            if (asnFile == null) continue;
            fsV.add(asnFile);
        }
        if (fsV.size() == 0) {
            return null;
        }
        Object[] asns = new AsnTkSoftInfo[fsV.size()];
        fsV.copyInto(asns);
        return asns;
    }

    public static AsnTkSoftInfo toAsn1SoftInfo(TKFtpStruct ftpStruct) {
        if (ftpStruct == null) {
            return null;
        }
        if (ftpStruct.getAbsolutePath().trim().equals("")) {
            return null;
        }
        AsnTkSoftInfo asn = new AsnTkSoftInfo();
        asn.softName = ftpStruct.getPath().getBytes();
        asn.softVer = ftpStruct.softVersion.getBytes();
        asn.ifFtp = ftpStruct.isFtp;
        asn.userPwd = ftpStruct.ftpPass.getBytes();
        asn.ftpPort = BigInteger.valueOf(ftpStruct.ftpPort);
        asn.ftpServer = ftpStruct.ftpIP.getBytes();
        asn.userName = ftpStruct.ftpUser.getBytes();
        return asn;
    }

    public static TKFtpStruct[] softInfosToTKFiles(Object[] objs) {
        if (objs == null) {
            return null;
        }
        Vector<TKFtpStruct> fsV = new Vector<TKFtpStruct>();
        for (int i = 0; i < objs.length; ++i) {
            AsnTkSoftInfo asnObj;
            TKFtpStruct file;
            if (!(objs[i] instanceof AsnTkSoftInfo) || (file = TKASNTool.softInfoToTKFile(asnObj = (AsnTkSoftInfo)objs[i])) == null) continue;
            fsV.add(file);
        }
        Object[] fs = new TKFtpStruct[objs.length];
        fsV.copyInto(fs);
        fsV.removeAllElements();
        return fs;
    }

    public static TKFtpStruct[] bytesListToTKFiles(Object[] objs) {
        if (objs == null) {
            return null;
        }
        Vector<TKFtpStruct> fsV = new Vector<TKFtpStruct>();
        for (int i = 0; i < objs.length; ++i) {
            byte[] asnObj;
            if (!(objs[i] instanceof byte[]) || (asnObj = (byte[])objs[i]) == null || asnObj.length == 0) continue;
            TKFtpStruct file = new TKFtpStruct(new String(asnObj));
            file.isFtp = false;
            fsV.add(file);
        }
        Object[] fs = new TKFtpStruct[fsV.size()];
        fsV.copyInto(fs);
        fsV.removeAllElements();
        return fs;
    }

    public static TKFtpStruct[] pkgSoftLoadInfosToTKFiles(Object[] objs) {
        if (objs == null) {
            return null;
        }
        Vector<TKFtpStruct> fsV = new Vector<TKFtpStruct>();
        for (int i = 0; i < objs.length; ++i) {
            AsnTkPkgSoftLoadInfo asnObj;
            TKFtpStruct file;
            if (!(objs[i] instanceof AsnTkPkgSoftLoadInfo) || (file = TKASNTool.pkgSoftLoadInfoToTKFile(asnObj = (AsnTkPkgSoftLoadInfo)objs[i])) == null) continue;
            fsV.add(file);
        }
        if (fsV.size() == 0) {
            return null;
        }
        Object[] fs = new TKFtpStruct[fsV.size()];
        fsV.copyInto(fs);
        fsV.removeAllElements();
        return fs;
    }

    public static TKFtpStruct softInfoToTKFile(AsnTkSoftInfo softInfo) {
        String fileName = new String(softInfo.softName);
        if (fileName.trim().equals("")) {
            return null;
        }
        TKFtpStruct file = new TKFtpStruct(new String(softInfo.softName));
        file.softVersion = new String(softInfo.softVer);
        file.ftpIP = new String(softInfo.ftpServer);
        file.ftpPort = softInfo.ftpPort.intValue();
        file.ftpPass = new String(softInfo.userPwd);
        file.ftpUser = new String(softInfo.userName);
        file.isFtp = softInfo.ifFtp;
        return file;
    }

    public static TKFtpStruct pkgSoftLoadInfoToTKFile(AsnTkPkgSoftLoadInfo softInfo) {
        TKFtpStruct file = TKASNTool.softInfoToTKFile(softInfo.softInfo);
        if (file != null) {
            file.softType = softInfo.softType.intValue();
        }
        return file;
    }

    public static TKFtpStruct[] loadFileInfosToTKFiles(Object[] objs) {
        if (objs == null) {
            return null;
        }
        Vector<TKFtpStruct> fsV = new Vector<TKFtpStruct>();
        AsnToolkitLoadFileInfo fileInfo = null;
        for (int i = 0; i < objs.length; ++i) {
            if (!(objs[i] instanceof AsnToolkitLoadFileInfo)) continue;
            fileInfo = (AsnToolkitLoadFileInfo)objs[i];
            String fileName = new String(fileInfo.fileName);
            if (fileName.trim().equals("")) continue;
            TKFtpStruct file = new TKFtpStruct(fileName);
            file.softVersion = new String(fileInfo.softVersion);
            file.isFtp = fileName.startsWith(Head_of_FTP) || fileName.startsWith(Head_of_SFTP);
            file.softType = fileInfo.softType.intValue();
            file.resetType = fileInfo.resetType.intValue();
            fsV.add(file);
        }
        if (fsV.size() == 0) {
            return null;
        }
        Object[] fs = new TKFtpStruct[fsV.size()];
        fsV.copyInto(fs);
        fsV.removeAllElements();
        return fs;
    }

    public static TKFtpStruct[] loadFileInfosToTKFiles(Object[] objs, String parentPath) {
        if (objs == null) {
            return null;
        }
        Vector<TKFtpStruct> fsV = new Vector<TKFtpStruct>();
        AsnToolkitLoadFileInfo fileInfo = null;
        for (int i = 0; i < objs.length; ++i) {
            if (!(objs[i] instanceof AsnToolkitLoadFileInfo)) continue;
            fileInfo = (AsnToolkitLoadFileInfo)objs[i];
            String fileName = new String(fileInfo.fileName);
            if (fileName.trim().equals("")) continue;
            TKFtpStruct file = new TKFtpStruct(parentPath + fileName);
            file.softVersion = new String(fileInfo.softVersion);
            file.isFtp = file.getPath().startsWith(Head_of_FTP) || file.getPath().startsWith(Head_of_SFTP);
            file.softType = fileInfo.softType.intValue();
            file.resetType = fileInfo.resetType.intValue();
            fsV.add(file);
        }
        if (fsV.size() == 0) {
            return null;
        }
        Object[] fs = new TKFtpStruct[fsV.size()];
        fsV.copyInto(fs);
        fsV.removeAllElements();
        return fs;
    }

    public static String getErrorInfo(AsnSingleReturn asr) {
        TKRes.instance();
        return TKRes.getErrorInfo(asr, 0);
    }

    public static String getErrorInfo(AsnSingleReturn asr, int msgType) {
        TKRes.instance();
        return TKRes.getErrorInfo(asr, msgType);
    }

    public static String getErrorInfo(AsnToolkitError error) {
        TKRes.instance();
        return TKRes.getErrorInfo(error, 0);
    }

    public static String getErrorInfo(AsnToolkitError error, int msgType) {
        TKRes.instance();
        return TKRes.getErrorInfo(error, msgType);
    }
}

