/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.tl1;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.component.TKPopMenuItem;
import com.huawei.dc.toolkit.client.base.util.component.TKTextField;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1FindDialog;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

public class TKTL1TextPane
extends JTextPane
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 5545262148466739627L;

    public TKTL1TextPane() {
        this.addMouseListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    TKTL1TextPane.this.getHighlighter().removeAllHighlights();
                    int selectionStart = TKTL1TextPane.this.getSelectionStart();
                    int selectionEnd = TKTL1TextPane.this.getSelectionEnd();
                    Highlighter highLighter = TKTL1TextPane.this.getHighlighter();
                    try {
                        Object obj = TKTL1TextPane.this.getHighlighter().addHighlight(TKTL1TextPane.this.getSelectionStart(), TKTL1TextPane.this.getSelectionEnd(), DefaultHighlighter.DefaultPainter);
                        highLighter.changeHighlight(obj, selectionStart, selectionEnd);
                    }
                    catch (Exception ex) {
                        DCDebugTracer.trace(ex);
                    }
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                TKTL1FindDialog.instance(TKTL1TextPane.this);
                TKTL1TextPane.this.getCaret().setVisible(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                TKTL1TextPane.this.getCaret().setVisible(false);
            }
        });
        this.getActionMap().put("find", new AbstractAction("find"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TKTL1TextPane.this.find();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("control F"), "find");
        Font font = new Font(this.getFont().getFamily(), this.getFont().getStyle(), 13);
        this.setFont(font);
    }

    protected TKPopMenuItem getMenuItem(String itemInfo, String cmdText) {
        TKPopMenuItem menuItem = new TKPopMenuItem();
        menuItem.setText(itemInfo);
        menuItem.setActionCommand(cmdText);
        menuItem.addActionListener(this);
        return menuItem;
    }

    public void find() {
        try {
            TKTL1FindDialog findDlg = TKTL1FindDialog.instance(this);
            findDlg.show();
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveFile(String fileName) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(fileName));
            out.write(this.getText());
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            DCDebugTracer.trace(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
        }
    }

    public static void formatTextField(TKTextField textField) {
        AbstractAction pasteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String pastedText;
                int startIndex;
                TKTextField jTextField = (TKTextField)e.getSource();
                jTextField.paste();
                String oldCopiedText = jTextField.getText();
                if (oldCopiedText == null) {
                    return;
                }
                int rIndexOld = oldCopiedText.indexOf("\r");
                int nIndexOld = oldCopiedText.indexOf("\n");
                if (rIndexOld < 0 && nIndexOld < 0) {
                    return;
                }
                String newCopiedText = oldCopiedText.trim();
                int indexOfNew = oldCopiedText.indexOf(newCopiedText);
                String rigthText = newCopiedText;
                String leftText = "";
                int rIndex = newCopiedText.indexOf("\r");
                int nIndex = newCopiedText.indexOf("\n");
                if (rIndex > 0 || nIndex > 0) {
                    startIndex = Math.min(rIndex, nIndex);
                    if (startIndex <= 0) {
                        startIndex = Math.max(rIndex, nIndex);
                    }
                    rigthText = newCopiedText.substring(0, startIndex);
                } else {
                    rIndex = oldCopiedText.indexOf("\r", indexOfNew);
                    nIndex = oldCopiedText.indexOf("\n", indexOfNew);
                    if (rIndex > 0 || nIndex > 0) {
                        startIndex = Math.min(rIndex, nIndex);
                        if (startIndex <= 0) {
                            startIndex = Math.max(rIndex, nIndex);
                        }
                        rigthText = oldCopiedText.substring(indexOfNew, startIndex);
                    }
                }
                String leftTextOld = oldCopiedText.substring(0, indexOfNew);
                rIndex = leftTextOld.lastIndexOf("\r");
                nIndex = leftTextOld.lastIndexOf("\n");
                if (rIndex >= 0 || nIndex >= 0) {
                    int startIndex2 = Math.max(rIndex, nIndex) + 1;
                    leftText = leftTextOld.substring(startIndex2);
                }
                if (!oldCopiedText.equals(pastedText = leftText + rigthText)) {
                    jTextField.setText(pastedText);
                }
            }
        };
        textField.getInputMap(0).put(KeyStroke.getKeyStroke(86, 2), "Ctl+V");
        textField.getActionMap().put("Ctl+V", pasteAction);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }
}

