/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.tl1;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.component.TKSplitPane;
import com.huawei.dc.toolkit.client.base.util.resource.TKErrorCodeRes;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKNeStruct;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1CmdText;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1MsgString;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1MsgText;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1Res;
import java.awt.BorderLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class TKTL1TabPage
extends JPanel {
    private TKErrorCodeRes errorRes = TKErrorCodeRes.instance();
    private TKTL1Res res = TKTL1Res.instance();
    TKTL1MsgText msgTextPane = null;
    TKTL1CmdText cmdTextPane = null;
    JSplitPane spltPane = new JSplitPane();
    private LinkedList messageQueue = new LinkedList();
    TKNeStruct ne = null;
    boolean openning = true;
    JScrollPane msgScrPane;
    Thread readMsg;
    TKTL1MsgString messageString;
    Document msgDoc;
    StyleContext sc = StyleContext.getDefaultStyleContext();
    static Object lockWriteLog = new Object();

    public TKTL1TabPage(TKNeStruct ne) {
        this.ne = ne;
        this.init();
        this.msgDoc = this.msgTextPane.getDocument();
    }

    public TKNeStruct getNE() {
        return this.ne;
    }

    private void init() {
        this.msgTextPane = new TKTL1MsgText();
        this.msgTextPane.setNEName(this.ne.neName);
        this.cmdTextPane = new TKTL1CmdText(this.ne, this.msgTextPane);
        AbstractAction ctlEnterAction = new AbstractAction("CtlEnter"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTextComponent c = (JTextComponent)evt.getSource();
                try {
                    c.getDocument().insertString(c.getCaretPosition(), "\n", null);
                }
                catch (BadLocationException e) {
                    DCDebugTracer.trace(e);
                }
            }
        };
        AbstractAction enterAction = new AbstractAction("Enter"){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selCmdText = TKTL1TabPage.this.cmdTextPane.getSelectLine();
                TKTL1TabPage.this.cmdTextPane.sendScript(selCmdText, 1);
                try {
                    JTextComponent c = (JTextComponent)e.getSource();
                    int len = c.getDocument().getLength();
                    String docStr = c.getDocument().getText(0, len);
                    int carPosition = c.getCaretPosition();
                    if ((selCmdText == null || selCmdText.equals("")) && carPosition == len) {
                        c.getDocument().insertString(len, "\n", null);
                    } else if (selCmdText != null) {
                        int lastSegBegin = docStr.lastIndexOf("\n");
                        if (lastSegBegin == -1) {
                            lastSegBegin = 0;
                        }
                        if (carPosition > lastSegBegin) {
                            c.setCaretPosition(len);
                            c.getDocument().insertString(len, "\n", null);
                        }
                    }
                }
                catch (Exception ex) {
                    DCDebugTracer.trace(ex);
                }
            }
        };
        this.cmdTextPane.getInputMap(0).put(KeyStroke.getKeyStroke(10, 2), "CtlEnter");
        this.cmdTextPane.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "Enter");
        this.cmdTextPane.getActionMap().put("CtlEnter", ctlEnterAction);
        this.cmdTextPane.getActionMap().put("Enter", enterAction);
        this.cmdTextPane.setAutoscrolls(true);
        this.msgScrPane = new JScrollPane(this.msgTextPane);
        this.spltPane = new TKSplitPane(0, this.msgScrPane, new JScrollPane(this.cmdTextPane));
        this.spltPane.setDividerSize(5);
        this.spltPane.setDividerLocation(300);
        this.setLayout(new BorderLayout());
        this.add(this.spltPane);
        this.readMsg = new Thread("read-message"){

            @Override
            public void run() {
                while (TKTL1TabPage.this.openning) {
                    try {
                        Thread.sleep(10L);
                        TKTL1TabPage.this.readMsg();
                    }
                    catch (InterruptedException ex) {
                        DCDebugTracer.trace(ex);
                    }
                }
            }
        };
        this.readMsg.setPriority(3);
        this.readMsg.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMsg(TKTL1MsgString msgString) {
        LinkedList linkedList = this.messageQueue;
        synchronized (linkedList) {
            this.messageQueue.addLast(msgString);
        }
    }

    private void readMsg() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LinkedList linkedList = TKTL1TabPage.this.messageQueue;
                synchronized (linkedList) {
                    if (TKTL1TabPage.this.messageQueue.isEmpty()) {
                        return;
                    }
                    while (!TKTL1TabPage.this.messageQueue.isEmpty()) {
                        TKTL1MsgString msgString = null;
                        try {
                            msgString = (TKTL1MsgString)TKTL1TabPage.this.messageQueue.removeFirst();
                        }
                        catch (NoSuchElementException nse) {
                            break;
                        }
                        if (msgString == null) continue;
                        try {
                            TKTL1TabPage.this.msgTextPane.setSelectionEnd(TKTL1TabPage.this.msgTextPane.getSelectionStart());
                        }
                        catch (Exception ex) {
                            TKTL1TabPage.this.msgTextPane.setSelectionEnd(0);
                            TKTL1TabPage.this.msgTextPane.setSelectionStart(0);
                        }
                        try {
                            AttributeSet aset = TKTL1TabPage.this.sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, msgString.getColor());
                            TKTL1TabPage.this.msgDoc.insertString(TKTL1TabPage.this.msgDoc.getLength(), msgString.toString(), aset);
                            aset = null;
                            if (TKTL1TabPage.this.msgDoc.getLength() > TKTL1TabPage.this.msgTextPane.MAX_LENGTH) {
                                String save = TKTL1TabPage.this.msgDoc.getText(0, TKTL1TabPage.this.msgTextPane.DELETE_POSITION);
                                new Thread((Runnable)new LogWritor(save), "Log-Writor").start();
                                TKTL1TabPage.this.msgDoc.remove(0, TKTL1TabPage.this.msgTextPane.DELETE_POSITION);
                            }
                        }
                        catch (Exception ex) {
                            DCDebugTracer.trace(ex);
                        }
                        int maxValue = TKTL1TabPage.this.msgScrPane.getVerticalScrollBar().getMaximum();
                        TKTL1TabPage.this.msgScrPane.getVerticalScrollBar().setValue(maxValue);
                        Rectangle rect = TKTL1TabPage.this.msgScrPane.getVisibleRect();
                        rect.setLocation(0, maxValue);
                        TKTL1TabPage.this.msgTextPane.scrollRectToVisible(rect);
                        rect = null;
                        Object var2_2 = null;
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(String neName, String record) {
        Object object = lockWriteLog;
        synchronized (object) {
            boolean makePath;
            String logPath = TKResourceManager.getPath() + File.separator + "client" + File.separator + "tklog";
            String filename = logPath + File.separator + "tktl1_" + neName + "_" + Calendar.getInstance().get(1) + "_" + (Calendar.getInstance().get(2) + 1) + "_" + Calendar.getInstance().get(5) + ".log";
            File path = new File(logPath);
            if (!(path.exists() && path.isDirectory() || (makePath = path.mkdir()))) {
                DCDebugTracer.trace("DC::TKTL1TabPage#writeToFile#makePath is " + makePath);
                return;
            }
            File f = new File(filename);
            FileOutputStream fOut = null;
            FilterOutputStream stream = null;
            if (!f.exists()) {
                try {
                    fOut = new FileOutputStream(filename);
                    stream = new DataOutputStream(fOut);
                    stream.write((Calendar.getInstance().getTime() + "\r\n").getBytes());
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
                finally {
                    if (null != stream) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            DCDebugTracer.trace(e);
                        }
                    }
                    if (null != fOut) {
                        try {
                            fOut.close();
                        }
                        catch (IOException e) {
                            DCDebugTracer.trace(e);
                        }
                    }
                }
            }
            RandomAccessFile file = null;
            try {
                file = new RandomAccessFile(filename, "rw");
                long len = file.length();
                file.seek(len);
                new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
                file.write(record.getBytes());
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
            }
            finally {
                if (null != file) {
                    try {
                        file.close();
                    }
                    catch (IOException e) {
                        DCDebugTracer.trace(e);
                    }
                }
            }
        }
    }

    public void dispose() {
        TKTL1TabPage.writeToFile(this.getNE().neName, this.msgTextPane.getText());
        this.msgTextPane.setText("");
        this.openning = false;
    }

    @Override
    public String toString() {
        return this.ne.toString();
    }

    class LogWritor
    implements Runnable {
        String logText = "";

        public LogWritor(String log) {
            this.logText = log;
        }

        @Override
        public void run() {
            TKTL1TabPage.writeToFile(TKTL1TabPage.this.getNE().neName, this.logText);
        }
    }
}

