/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.tl1;

import com.huawei.dc.toolkit.client.base.util.TKProfileFactory;
import com.huawei.dc.toolkit.client.base.util.resource.TKAreaDescObject;
import com.huawei.dc.toolkit.client.base.util.resource.TKFileDescObject;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;

public class TKTL1StyleMgr {
    Font fontCmd;
    Font defaultFontCmd;
    Font fontMsg;
    Font defaultFontMsg;
    HashMap colors = new HashMap();
    private static TKTL1StyleMgr styleAdp = null;
    public static final String cfgFileName = "tkconfig.ini";
    public static final String defFileName = "tl1cfg.ini";
    public static final String fontObjArea = "tl1font";
    public static final String defFontObjArea = "option";
    public static final String colorObjArea = "tl1colors";

    public static TKTL1StyleMgr instance() {
        if (styleAdp == null) {
            styleAdp = new TKTL1StyleMgr();
        }
        return styleAdp;
    }

    public static Color getColor(int rgb) {
        return new Color(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    private TKTL1StyleMgr() {
        TKFileDescObject cfile = TKProfileFactory.getCommonFileDescObject(cfgFileName);
        TKAreaDescObject areaObject = cfile.getAreaDescObject(colorObjArea);
        String colorInfo = "";
        int colorRgb = 0;
        for (int i = 0; i < areaObject.getDescObjectCount(); ++i) {
            colorInfo = areaObject.getDescObject(i).getObjectName();
            try {
                colorRgb = Integer.parseInt(areaObject.getDescObject(i).getStringPropertyValue("colorRGB"));
            }
            catch (Exception ex) {
                ex.toString();
            }
            this.setColor(colorInfo, TKTL1StyleMgr.getColor(colorRgb));
        }
        String defFontFamilyCmd = TKProfileFactory.getCfgString(defFileName, defFontObjArea, "DefaultFontFamilyCmd");
        int defFontSizeCmd = 13;
        try {
            defFontSizeCmd = Integer.parseInt(TKProfileFactory.getCfgString(defFileName, defFontObjArea, "DefaultFontSizeCmd"));
        }
        catch (Exception ex) {
            ex.toString();
        }
        String fontFamilyCmd = TKProfileFactory.getCfgString(cfgFileName, fontObjArea, "FontFamilyCmd");
        int fontSizeCmd = 13;
        try {
            fontSizeCmd = Integer.parseInt(TKProfileFactory.getCfgString(cfgFileName, fontObjArea, "FontSizeCmd"));
        }
        catch (Exception ex) {
            ex.toString();
        }
        String defFontFamilyMsg = TKProfileFactory.getCfgString(defFileName, defFontObjArea, "DefaultFontFamilyMsg");
        int defFontSizeMsg = 13;
        try {
            defFontSizeMsg = Integer.parseInt(TKProfileFactory.getCfgString(defFileName, defFontObjArea, "DefaultFontSizeMsg"));
        }
        catch (Exception ex) {
            ex.toString();
        }
        String fontFamilyMsg = TKProfileFactory.getCfgString(cfgFileName, fontObjArea, "FontFamilyMsg");
        int fontSizeMsg = 13;
        try {
            fontSizeMsg = Integer.parseInt(TKProfileFactory.getCfgString(cfgFileName, fontObjArea, "FontSizeMsg"));
        }
        catch (Exception ex) {
            ex.toString();
        }
        this.defaultFontCmd = new Font(defFontFamilyCmd, 0, defFontSizeCmd);
        this.fontCmd = new Font(fontFamilyCmd, 0, fontSizeCmd);
        this.defaultFontMsg = new Font(defFontFamilyMsg, 0, defFontSizeMsg);
        this.fontMsg = new Font(fontFamilyMsg, 0, fontSizeMsg);
    }

    public void setColor(String colorInfo, Color color) {
        this.colors.put(colorInfo, color);
    }

    public Color getColor(String colorInfo) {
        if (this.colors.get(colorInfo) == null) {
            return Color.red;
        }
        return (Color)this.colors.get(colorInfo);
    }

    public HashMap getColorSet() {
        return this.colors;
    }

    public Font getDefaultCmdFont() {
        return this.defaultFontCmd;
    }

    public void setCmdFont(Font f) {
        this.fontCmd = f;
    }

    public Font getCmdFont() {
        return this.fontCmd;
    }

    public Font getDefaultMsgFont() {
        return this.defaultFontMsg;
    }

    public void setMsgFont(Font f) {
        this.fontMsg = f;
    }

    public Font getMsgFont() {
        return this.fontMsg;
    }

    public void saveCmdFont() {
        TKProfileFactory.saveCommonStringProperty(cfgFileName, fontObjArea, "FontFamilyCmd", "value", this.fontCmd.getFamily());
        TKProfileFactory.saveCommonStringProperty(cfgFileName, fontObjArea, "FontSizeCmd", "value", String.valueOf(this.fontCmd.getSize()));
        TKProfileFactory.saveCommonStringProperty(cfgFileName, fontObjArea, "FontStyleCmd", "value", String.valueOf(this.fontCmd.getStyle()));
    }

    public void saveMsgFont() {
        TKProfileFactory.saveCommonStringProperty(cfgFileName, fontObjArea, "FontFamilyMsg", "value", this.fontMsg.getFamily());
        TKProfileFactory.saveCommonStringProperty(cfgFileName, fontObjArea, "FontSizeMsg", "value", String.valueOf(this.fontMsg.getSize()));
        TKProfileFactory.saveCommonStringProperty(cfgFileName, fontObjArea, "FontStyleMsg", "value", String.valueOf(this.fontMsg.getStyle()));
    }
}

