/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.tl1;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.TKFile;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.component.TKPopMenuItem;
import com.huawei.dc.toolkit.client.base.util.filechooser.TKFileChooser;
import com.huawei.dc.toolkit.client.te.toolkit.TKMainFrame;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1ColorDialog;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1Res;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1StyleMgr;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1TabPage;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1TextPane;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKFileFilterMananger;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKFontChooser;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class TKTL1MsgText
extends TKTL1TextPane
implements PopupMenuListener {
    TKTL1Res res = TKTL1Res.instance();
    public final int DELETE_POSITION = 100000;
    public final int MAX_LENGTH = 200000;
    private JPopupMenu popMenu = new JPopupMenu();
    private TKPopMenuItem saveasMenuItem;
    private TKPopMenuItem copyMenuItem;
    private TKPopMenuItem clearMenuItem;
    private TKPopMenuItem findMenuItem;
    private TKPopMenuItem colorMenuItem;
    private TKPopMenuItem fontMenuItem;
    int deletePos = 0;
    boolean setDeletePos = false;
    boolean ifShowPopMenu = false;
    String neName = "";

    public TKTL1MsgText() {
        this.setEditable(false);
        this.setBackground(Color.white);
        DCFrameWorkUtil.setCursor(this, new Cursor(2));
        this.createCmdPopupMenu();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TKTL1MsgText.this.setFont(TKTL1StyleMgr.instance().getMsgFont());
            }
        });
    }

    private void createCmdPopupMenu() {
        this.saveasMenuItem = this.getMenuItem(this.res.getString("Saveas"), "saveas");
        this.copyMenuItem = this.getMenuItem(this.res.getString("Copy"), "copy");
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.clearMenuItem = this.getMenuItem(this.res.getString("Clear"), "clear");
        this.findMenuItem = this.getMenuItem(this.res.getString("Find"), "find");
        this.findMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.colorMenuItem = this.getMenuItem(this.res.getString("SetColor"), "color");
        this.fontMenuItem = this.getMenuItem(this.res.getString("SetFont"), "font");
        this.popMenu.add(this.saveasMenuItem);
        this.popMenu.addSeparator();
        this.popMenu.add(this.copyMenuItem);
        this.popMenu.add(this.clearMenuItem);
        this.popMenu.addSeparator();
        this.popMenu.add(this.findMenuItem);
        this.popMenu.addSeparator();
        this.popMenu.add(this.colorMenuItem);
        this.popMenu.add(this.fontMenuItem);
        this.popMenu.addPopupMenuListener(this);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.checkMouseEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.checkMouseEvent(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.checkMouseEvent(e);
    }

    private void checkMouseEvent(MouseEvent e) {
        this.grabFocus();
        if (e.getModifiers() == 0 || e.getModifiers() == 8 || e.getModifiers() == 10) {
            return;
        }
        if (e.isPopupTrigger()) {
            Point point = TKScreenToolKit.getPopupMenuShowupPosition(this, this.popMenu, e.getX(), e.getY());
            this.ifShowPopMenu = true;
            this.popMenu.show(this, point.x, point.y);
        }
    }

    public void insert(String msg, Color color) {
        try {
            this.getHighlighter().removeAllHighlights();
            Document doc = this.getDocument();
            SimpleAttributeSet sas = new SimpleAttributeSet();
            StyleConstants.setForeground(sas, color);
            doc.insertString(doc.getLength(), msg, sas);
            if (!this.setDeletePos && doc.getLength() > 100000) {
                this.deletePos = doc.getLength();
                this.setDeletePos = true;
            }
            if (doc.getLength() > 200000 && this.setDeletePos) {
                doc.remove(0, this.deletePos);
                this.deletePos = 0;
                this.setDeletePos = false;
            }
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actCmd = e.getActionCommand();
        if (actCmd.equalsIgnoreCase("color")) {
            TKTL1ColorDialog colorDialog = TKTL1ColorDialog.instance();
            colorDialog.show();
            return;
        }
        if (actCmd.equalsIgnoreCase("copy")) {
            this.copy();
            return;
        }
        if (actCmd.equalsIgnoreCase("clear")) {
            try {
                String save = this.getDocument().getText(0, this.getDocument().getLength());
                TKTL1TabPage.writeToFile(this.neName, save);
                this.getDocument().remove(0, this.getDocument().getLength());
            }
            catch (Exception ex) {
                DCDebugTracer.trace(ex);
            }
            return;
        }
        if (actCmd.equalsIgnoreCase("Find")) {
            this.find();
            return;
        }
        if (actCmd.equalsIgnoreCase("Font")) {
            Font oldFont;
            TKFontChooser fontCh = new TKFontChooser(TKResourceManager.getMainFrame(), this.getFont(), TKTL1StyleMgr.instance().getDefaultMsgFont());
            Font font = fontCh.show();
            if (!font.equals(oldFont = this.getFont())) {
                TKTL1StyleMgr.instance().setMsgFont(font);
                TKTL1StyleMgr.instance().saveMsgFont();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TKTL1MsgText.this.setFont(TKTL1StyleMgr.instance().getMsgFont());
                    }
                });
            }
            return;
        }
        if (actCmd.equalsIgnoreCase("saveas")) {
            String saveFileName;
            int result;
            TKFile ff;
            TKFileChooser fileChooser = new TKFileChooser();
            fileChooser.setDialogTitle(this.res.getString("SaveFile"));
            fileChooser.setBrowseType(102);
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.addFileFilter(TKFileFilterMananger.txtFilter);
            fileChooser.setFileSelectionMode(0);
            String lp = TKMainFrame.lastpath;
            if (lp != null && lp.trim().length() > 1 && (ff = new TKFile(lp)) != null) {
                fileChooser.setCurrentDirectory(ff);
            }
            if ((result = fileChooser.showSaveFileDialog()) != 0) {
                return;
            }
            if (fileChooser.getSelectedFile() == null) {
                return;
            }
            File saveFile = new File(fileChooser.getSelectedFile().getAbsolutePath());
            TKMainFrame.lastpath = saveFileName = saveFile.getAbsolutePath();
            this.saveFile(saveFileName);
            return;
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.saveasMenuItem.setEnabled(this.getText().length() > 0);
        this.copyMenuItem.setEnabled(this.getSelectionEnd() != this.getSelectionStart());
        this.clearMenuItem.setEnabled(this.saveasMenuItem.isEnabled());
        this.findMenuItem.setEnabled(this.clearMenuItem.isEnabled());
    }

    @Override
    public void copy() {
        JTextPane tempText = new JTextPane();
        tempText.setText(this.getSelectedText());
        tempText.setSelectionStart(0);
        tempText.setSelectionEnd(tempText.getText().length());
        tempText.copy();
    }

    public void setNEName(String nename) {
        this.neName = nename;
    }
}

