/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.tl1;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.communicate.TKCmdMSG;
import com.huawei.dc.toolkit.client.base.communicate.TKCommUtility;
import com.huawei.dc.toolkit.client.base.communicate.TKCommandResult;
import com.huawei.dc.toolkit.client.base.communicate.TKNoticeReceiver;
import com.huawei.dc.toolkit.client.base.util.TKDebug;
import com.huawei.dc.toolkit.client.base.util.TKLogManager;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.help.TKHelpMgr;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultStruct;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultVector;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperationShowMgr;
import com.huawei.dc.toolkit.client.base.util.resource.TKErrorCodeRes;
import com.huawei.dc.toolkit.client.te.toolkit.TKMainFrame;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKInternalFrame;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKNeStruct;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKTreeNodeProp;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKTreePanel;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1FindDialog;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1FuncPane;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1MsgString;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1MsgText;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1Res;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1SetValueDialog;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1StyleMgr;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1TabPage;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKConfirmOperationDlg;
import com.huawei.dc.toolkit.control.Toolkit4T2kInterface;
import com.huawei.dc.toolkit.control.Toolkit4T2kInterfaceMgr;
import com.huawei.te.toolkit.AsnBulkReturn;
import com.huawei.te.toolkit.AsnOneReturn;
import com.huawei.te.toolkit.AsnToolkitDelNEReq;
import com.huawei.te.toolkit.AsnToolkitTL1LogReq;
import com.huawei.te.toolkit.AsnToolkitTL1LogRpt;
import com.huawei.te.toolkit.AsnToolkitTL1MsgRpt;
import com.huawei.te.toolkit.AsnToolkitTL1NETabOperationReq;
import com.huawei.te.toolkit.AsnToolkitTL1SetVarAck;
import com.huawei.te.toolkit.AsnToolkitTL1SetVarRpt;
import com.huawei.te.toolkit.AsnToolkitTclStateRpt;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import net.commustru.fstru.FStruct;

public class TKTL1InternalFrame
extends TKInternalFrame
implements TKNoticeReceiver {
    public static HashMap neState = new HashMap();
    private TKMainFrame parent = null;
    private JSplitPane jSplitPane1;
    private TKTL1FuncPane oTL1FuncPane = new TKTL1FuncPane();
    public TKTreePanel objectTreePanel = null;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    TKTL1Res res = TKTL1Res.instance();
    private TKErrorCodeRes errorRes = TKErrorCodeRes.instance();
    BigInteger setValueNeId;
    String setValueVariable;
    String setValueDesc;
    double modulusX = 0.3;
    double modulusY = 0.3;
    double oldArea = -1.0;
    double newArea = 1.0;

    public TKTL1InternalFrame() {
        this((TKMainFrame)null);
    }

    public TKTL1InternalFrame(TKMainFrame parent) {
        this.parent = parent;
        try {
            this.jdInit();
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    private void jdInit() throws Exception {
        this.setTitle(this.res.getString("TL1CommandCLient"));
        TKHelpMgr.instance().helpRootPane(this.getRootPane());
        TKHelpMgr.instance().helpComponent(this, "tl1frame");
        Toolkit4T2kInterface inf = Toolkit4T2kInterfaceMgr.getInstance();
        this.setFrameIcon(TKResourceManager.getMainIcon());
        this.getContentPane().setLayout(this.gridBagLayout1);
        if (inf != null) {
            Runnable logRun = new Runnable(){

                @Override
                public void run() {
                    AsnToolkitTL1LogReq logReq = new AsnToolkitTL1LogReq();
                    logReq.rspTL1Log = true;
                    char cmdCode = '\u0f0a';
                    byte recvModule = 15;
                    TKCommUtility.sendRequest((FStruct)logReq, cmdCode, recvModule, null, 120);
                }
            };
            new Thread(logRun).start();
        }
        this.objectTreePanel = new TKTreePanel(this, 11, 15);
        JScrollPane scrolPanel = new JScrollPane();
        scrolPanel.setVerticalScrollBarPolicy(21);
        scrolPanel.getViewport().add(this.objectTreePanel);
        this.jSplitPane1 = new JSplitPane(1, scrolPanel, this.oTL1FuncPane);
        this.jSplitPane1.setDividerSize(7);
        this.jSplitPane1.setDividerLocation(220);
        this.getContentPane().add((Component)this.jSplitPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                TKTL1InternalFrame.this.newArea = TKTL1InternalFrame.this.getWidth() * TKTL1InternalFrame.this.getHeight();
                if (TKTL1InternalFrame.this.oldArea == -1.0) {
                    TKTL1InternalFrame.this.oldArea = TKTL1InternalFrame.this.newArea;
                }
                if (TKTL1InternalFrame.this.oldArea >= TKTL1InternalFrame.this.newArea) {
                    TKTL1InternalFrame.this.jSplitPane1.setDividerLocation((int)((double)TKTL1InternalFrame.this.getSize().width * TKTL1InternalFrame.this.modulusX));
                    if (null != TKTL1InternalFrame.this.oTL1FuncPane.getSelectedTL1Page()) {
                        try {
                            ((TKTL1InternalFrame)TKTL1InternalFrame.this).oTL1FuncPane.getSelectedTL1Page().spltPane.setDividerLocation((int)((double)TKTL1InternalFrame.this.getSize().height * TKTL1InternalFrame.this.modulusY));
                        }
                        catch (Exception ex1) {
                            ex1.toString();
                        }
                    }
                } else {
                    TKTL1InternalFrame.this.jSplitPane1.setDividerLocation((int)((double)TKTL1InternalFrame.this.getSize().width * 0.3));
                    if (null != TKTL1InternalFrame.this.oTL1FuncPane.getSelectedTL1Page()) {
                        try {
                            ((TKTL1InternalFrame)TKTL1InternalFrame.this).oTL1FuncPane.getSelectedTL1Page().spltPane.setDividerLocation((int)((double)TKTL1InternalFrame.this.getSize().height * 0.5));
                        }
                        catch (Exception ex1) {
                            ex1.toString();
                        }
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TKTL1InternalFrame.this.modulusX = (float)TKTL1InternalFrame.this.jSplitPane1.getDividerLocation() / (float)TKTL1InternalFrame.this.getWidth();
                if (null != TKTL1InternalFrame.this.oTL1FuncPane.getSelectedTL1Page()) {
                    try {
                        TKTL1InternalFrame.this.modulusY = (float)((TKTL1InternalFrame)TKTL1InternalFrame.this).oTL1FuncPane.getSelectedTL1Page().spltPane.getDividerLocation() / (float)TKTL1InternalFrame.this.getHeight();
                    }
                    catch (Exception ex) {
                        ex.toString();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte handleNotice(char cmdCode, TKCmdMSG data) {
        boolean result;
        if (cmdCode == '\u0f41') {
            AsnToolkitTL1MsgRpt msgRpt = new AsnToolkitTL1MsgRpt();
            boolean result2 = TKCommUtility.getASNData(data, (FStruct)msgRpt, false);
            if (!result2) {
                TKDebug.inmAssert(false, this.res.getString("DecodeFail"));
                return 0;
            }
            this.processMsgType(msgRpt);
            return 1;
        }
        if (cmdCode == '\u0f43') {
            AsnToolkitTclStateRpt stateRpt = new AsnToolkitTclStateRpt();
            boolean result3 = TKCommUtility.getASNData(data, (FStruct)stateRpt);
            if (!result3) {
                TKDebug.inmAssert(false, this.res.getString("DecodeFail"));
                return 0;
            }
            BigInteger neId = stateRpt.neID;
            TKTL1TabPage tabPage = this.oTL1FuncPane.getTL1Page(neId.toString());
            if (tabPage == null) {
                neState.put(neId.toString(), stateRpt.tclExeState);
                return 1;
            }
            tabPage.cmdTextPane.setScriptState(stateRpt.tclExeState.intValue());
            return 1;
        }
        if (cmdCode == '\u0f44') {
            AsnToolkitDelNEReq clearRpt = new AsnToolkitDelNEReq();
            result = TKCommUtility.getASNData(data, (FStruct)clearRpt);
            if (!result) {
                TKDebug.inmAssert(false, this.res.getString("DecodeFail"));
                return 0;
            }
            BigInteger neId = clearRpt.neID;
            TKTL1TabPage tabPage = this.oTL1FuncPane.getTL1Page(neId.toString());
            if (null != tabPage) {
                TKTL1MsgText tKTL1MsgText = tabPage.msgTextPane;
                synchronized (tKTL1MsgText) {
                    TKTL1TabPage.writeToFile(tabPage.getNE().neName, tabPage.msgTextPane.getText());
                    tabPage.msgTextPane.setText("");
                    tabPage.msgTextPane.setSelectionStart(0);
                    tabPage.msgTextPane.setSelectionEnd(0);
                }
            }
        }
        if (cmdCode == '\u0f02') {
            AsnToolkitTL1SetVarRpt setVarRpt = new AsnToolkitTL1SetVarRpt();
            result = TKCommUtility.getASNData(data, (FStruct)setVarRpt);
            if (!result) {
                TKDebug.inmAssert(false, this.res.getString("DecodeFail"));
                return 0;
            }
            this.setValueNeId = setVarRpt.neID;
            this.setValueVariable = new String(setVarRpt.varName);
            this.setValueDesc = new String(setVarRpt.varDiscription);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TKTL1InternalFrame.this.showValueDlg(TKTL1InternalFrame.this.setValueNeId, TKTL1InternalFrame.this.setValueVariable, TKTL1InternalFrame.this.setValueDesc);
                }
            });
            return 1;
        }
        if (cmdCode == '\u0f42') {
            AsnToolkitTL1LogRpt logRpt = new AsnToolkitTL1LogRpt();
            result = TKCommUtility.getASNData(data, (FStruct)logRpt);
            if (!result) {
                TKDebug.inmAssert(false, this.res.getString("DecodeFail"));
                return 0;
            }
            String object = new String(logRpt.neName);
            String sDetail = new String(logRpt.opratnResult);
            String sTime = "";
            TKLogManager.writeT2kLog(object, sDetail, sTime, 0);
        }
        return 0;
    }

    private void processMsgType(AsnToolkitTL1MsgRpt msgRpt) {
        int msgType = msgRpt.msgType.intValue();
        if (msgType == 2) {
            msgType = 3;
        }
        if (msgType == -1) {
            msgType = 5;
        }
        BigInteger neId = msgRpt.neID;
        String msgCont = new String(msgRpt.msgCont);
        TKTL1TabPage tabPage = this.oTL1FuncPane.getTL1Page(neId.toString());
        if (null != tabPage) {
            tabPage.addMsg(new TKTL1MsgString(msgCont, TKTL1StyleMgr.instance().getColor(String.valueOf(msgType))));
        }
    }

    @Override
    public void refreshTableData(ArrayList selectNeList) {
        int i;
        HashMap<String, String> neMap = new HashMap<String, String>();
        if (selectNeList != null && selectNeList.size() > 0) {
            for (int i2 = 0; i2 < selectNeList.size(); ++i2) {
                neMap.put(String.valueOf(((TKNeStruct)selectNeList.get((int)i2)).neID), "exist");
            }
        } else {
            this.updateTableData(null);
            return;
        }
        ArrayList<String> tl1TabNeList = new ArrayList<String>();
        for (i = 0; i < this.oTL1FuncPane.getTL1PageCount(); ++i) {
            tl1TabNeList.add(String.valueOf(this.oTL1FuncPane.getTL1Page((int)i).getNE().neID));
        }
        for (i = 0; i < tl1TabNeList.size(); ++i) {
            String neId = tl1TabNeList.get(i).toString();
            if (neMap.get(neId) != null) continue;
            this.oTL1FuncPane.shutPage(this.oTL1FuncPane.getTL1Page(neId));
        }
    }

    public void updateTableData(ArrayList loadInfoList) {
        int i;
        ArrayList<String> tl1TabNeList = new ArrayList<String>();
        for (i = 0; i < this.oTL1FuncPane.getTL1PageCount(); ++i) {
            tl1TabNeList.add(String.valueOf(this.oTL1FuncPane.getTL1Page((int)i).getNE().neID));
        }
        for (i = 0; i < tl1TabNeList.size(); ++i) {
            this.oTL1FuncPane.shutPage(this.oTL1FuncPane.getTL1Page(tl1TabNeList.get(i).toString()));
        }
    }

    @Override
    public void deleteRowbyId(int neId, int slot) {
        if (this.oTL1FuncPane.getTL1Page(String.valueOf(neId)) == null) {
            return;
        }
        this.oTL1FuncPane.shutPage(this.oTL1FuncPane.getTL1Page(String.valueOf(neId)));
    }

    @Override
    public void doLoadInfoQuery(ArrayList selectNeList) {
        int i;
        AsnToolkitTL1NETabOperationReq shutReq = new AsnToolkitTL1NETabOperationReq();
        HashMap<String, String> neMap = new HashMap<String, String>();
        if (selectNeList != null) {
            for (i = 0; i < selectNeList.size(); ++i) {
                neMap.put(String.valueOf(((TKTreeNodeProp)selectNeList.get((int)i)).nedata.neID), "willbeopened");
            }
        }
        for (i = 0; i < this.oTL1FuncPane.getTL1PageCount(); ++i) {
            if (neMap.get(String.valueOf(this.oTL1FuncPane.getTL1Page((int)i).getNE().neID)) != null) continue;
            shutReq.neIDList.add((Object)BigInteger.valueOf(this.oTL1FuncPane.getTL1Page((int)i).getNE().neID));
        }
        this.oTL1FuncPane.shutPages(shutReq);
        HashMap<String, TKNeStruct> openNeList = new HashMap<String, TKNeStruct>();
        AsnToolkitTL1NETabOperationReq openReq = new AsnToolkitTL1NETabOperationReq();
        AsnBulkReturn openRtn = new AsnBulkReturn();
        if (selectNeList != null) {
            for (int i2 = 0; i2 < selectNeList.size(); ++i2) {
                TKTreeNodeProp ne = (TKTreeNodeProp)selectNeList.get(i2);
                if (this.oTL1FuncPane.getTL1Page(String.valueOf(ne.nedata.neID)) != null) continue;
                openReq.neIDList.add((Object)BigInteger.valueOf(ne.nedata.neID));
                openNeList.put(String.valueOf(ne.nedata.neID), ne.nedata);
            }
        }
        if (openReq.neIDList.size() == 0) {
            return;
        }
        char cmdCode = '\u0f07';
        byte recvModule = 15;
        TKScreenToolKit.setComponentCursorBusy(this, true);
        TKCommandResult openRet = TKCommUtility.sendCommand((FStruct)openReq, (FStruct)openRtn, cmdCode, recvModule, 120);
        TKScreenToolKit.setComponentCursorBusy(this, false);
        if (!openRet.isSuccess) {
            TKOperationShowMgr.showOperationDlg((Component)this.getParent(), openRet.resultInfo, true);
            return;
        }
        TKOperResultVector resultV = new TKOperResultVector();
        for (int i3 = 0; i3 < openRtn.size(); ++i3) {
            AsnOneReturn asnRtn = (AsnOneReturn)openRtn.elementAt(i3);
            if (this.oTL1FuncPane.getTL1Page(String.valueOf(asnRtn.id)) != null) continue;
            TKNeStruct ne = (TKNeStruct)openNeList.get(String.valueOf(asnRtn.id));
            TKTL1InternalFrame tKTL1InternalFrame = this;
            if (this.oTL1FuncPane.getTL1PageCount() >= tKTL1InternalFrame.oTL1FuncPane.getMaxNumOfPages()) {
                TKOperResultStruct struct = new TKOperResultStruct(ne.neName, this.res.getString("OpenTL1PageFail"), this.res.getString("TouchLimit"));
                TKLogManager.recordLog2Server(ne.neName, this.res.getString("OpenTL1PageFail"), this.res.getString("TouchLimit"));
                resultV.addElement(struct);
                continue;
            }
            if (asnRtn.ret.isSuccess) {
                this.oTL1FuncPane.addTL1Page(ne);
                continue;
            }
            String reason = TKRes.getErrorInfo(asnRtn.ret);
            TKOperResultStruct struct = new TKOperResultStruct(ne.neName, this.res.getString("OpenTL1PageFail"), reason);
            TKLogManager.recordLog2Server(ne.neName, this.res.getString("OpenTL1PageFail"), reason);
            resultV.addElement(struct);
        }
        openReq = null;
        openRtn = null;
        if (resultV.size() > 0) {
            TKOperationShowMgr.showOperationDlg((Component)this.getParent(), this.res.getString("OperResult"), resultV);
        }
    }

    @Override
    public void dispose() {
        TKTL1FindDialog.instance().dispose();
        this.oTL1FuncPane.dispose();
        if (TKCommUtility.comm != null) {
            TKCommUtility.comm.unregisterListener('\u0f41', this);
            TKCommUtility.comm.unregisterListener('\u0f02', this);
            TKCommUtility.comm.unregisterListener('\u0f42', this);
            TKCommUtility.comm.unregisterListener('\u0f43', this);
            TKCommUtility.comm.unregisterListener('\u0f44', this);
        }
        this.objectTreePanel.dispose();
        super.dispose();
    }

    private void showValueDlg(BigInteger neId, String variable, String varDesc) {
        TKTL1SetValueDialog setValueDlg = new TKTL1SetValueDialog(this, this.oTL1FuncPane.getTL1Page(neId.toString()).getNE(), variable, varDesc);
        AsnToolkitTL1SetVarAck setVarAck = new AsnToolkitTL1SetVarAck();
        setVarAck.varName = variable.getBytes();
        setVarAck.neID = neId;
        char cmdCode = '\u0f02';
        byte recvModule = 15;
        TKCommUtility.sendRequest((FStruct)setVarAck, cmdCode, recvModule, null, 120);
        setValueDlg.show();
    }

    @Override
    public TKTreePanel getObjectTreePanel() {
        return this.objectTreePanel;
    }

    @Override
    public void doDefaultCloseAction() {
        TKOperResultVector resultVct = new TKOperResultVector();
        if (!this.isBusinessOver(resultVct)) {
            TKConfirmOperationDlg confDlg = new TKConfirmOperationDlg(TKResourceManager.getMainFrame(), this.res.getString("Hint"), this.res.getString("ConfirmDisposeWorking"), resultVct, true);
            TKScreenToolKit.centerLocateToScreen(confDlg);
            int willContinue = confDlg.showDialog();
            if (willContinue == 1) {
                return;
            }
        }
        this.dispose();
    }

    private boolean isBusinessOver(TKOperResultVector resultVct) {
        int task = 0;
        resultVct.clear();
        int totalRow = this.oTL1FuncPane.getTL1PageCount();
        for (int row = 0; row < totalRow; ++row) {
            TKTL1TabPage tapPage = this.oTL1FuncPane.getTL1Page(row);
            int scriptState = tapPage.cmdTextPane.getScriptState();
            if (scriptState != 2) {
                if (scriptState != 1) continue;
            }
            ++task;
            TKNeStruct ne = tapPage.getNE();
            String operObj = ne.neName;
            TKOperResultStruct struct = new TKOperResultStruct(operObj, this.res.getString("Close_Window"), this.res.getString("Scripting"));
            resultVct.add(struct);
        }
        return task == 0;
    }

    @Override
    public void updateTableNEData(TKTreeNodeProp neNode) {
        int neID = neNode.nedata.neID;
        TKTL1TabPage tabPage = this.oTL1FuncPane.getTL1Page(String.valueOf(neID));
        if (tabPage != null) {
            tabPage.ne = neNode.nedata;
            String neName = neNode.nedata.neName;
            String ipGate = neNode.nedata.gatewayType == 1 ? neNode.nedata.gatewayIP + ":" + neNode.nedata.ipPort : neNode.nedata.tp4Address + ":" + neNode.nedata.tp4Port;
            int tabs = this.oTL1FuncPane.getTL1PageCount();
            int selectTabId = this.oTL1FuncPane.getSelectedTL1Page().getNE().neID;
            if (neID == selectTabId) {
                this.oTL1FuncPane.setWestText(neName);
                this.oTL1FuncPane.setEastText(ipGate);
            }
            for (int i = 0; i < tabs; ++i) {
                TKTL1TabPage tab = this.oTL1FuncPane.getTL1Page(i);
                int tabID = tab.getNE().neID;
                if (tabID != neID) continue;
                this.oTL1FuncPane.mainTabPane.setTitleAt(i, neName);
                break;
            }
        }
    }

    @Override
    public boolean isNeedRevertLayout() {
        try {
            int dividerLocation2 = this.oTL1FuncPane.getSelectedTL1Page().spltPane.getDividerLocation();
            int heigthFrame = this.getHeight();
            if (heigthFrame - dividerLocation2 < 50 || dividerLocation2 < 5) {
                return true;
            }
        }
        catch (Exception ex) {
            ex.toString();
        }
        return false;
    }

    @Override
    public void revertLayout() {
        this.jSplitPane1.setDividerLocation(220);
        try {
            this.oTL1FuncPane.getSelectedTL1Page().spltPane.setDividerLocation(300);
        }
        catch (Exception e) {
            e.toString();
        }
    }

    @Override
    public void registerCmd() {
        try {
            TKLogManager.writeToFile("RegisterListener CommandCode on " + this.getTitle());
            TKCommUtility.comm.registerListener('\u0f41', this);
            TKCommUtility.comm.registerListener('\u0f02', this);
            TKCommUtility.comm.registerListener('\u0f42', this);
            TKCommUtility.comm.registerListener('\u0f43', this);
            TKCommUtility.comm.registerListener('\u0f44', this);
            TKLogManager.writeToFile("RegisterListener CommandCode on " + this.getTitle() + " Successfully.");
        }
        catch (Exception e) {
            e.toString();
        }
    }
}

