/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.tl1;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.communicate.TKCmdMSG;
import com.huawei.dc.toolkit.client.base.communicate.TKCommUtility;
import com.huawei.dc.toolkit.client.base.communicate.TKCommandResult;
import com.huawei.dc.toolkit.client.base.util.TKLogManager;
import com.huawei.dc.toolkit.client.base.util.TKProfileFactory;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultStruct;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultVector;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperationShowMgr;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKNeStruct;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1FindDialog;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1Res;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1StyleMgr;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1TabPage;
import com.huawei.te.toolkit.AsnBulkReturn;
import com.huawei.te.toolkit.AsnOneReturn;
import com.huawei.te.toolkit.AsnToolkitTL1NETabOperationReq;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.commustru.fstru.FStruct;

public class TKTL1FuncPane
extends JPanel
implements ChangeListener {
    TKTL1Res res = TKTL1Res.instance();
    JTabbedPane mainTabPane = new JTabbedPane(){

        @Override
        public void remove(Component component) {
            super.remove(component);
            TKTL1FuncPane.this.mainTabPane.setVisible(TKTL1FuncPane.this.mainTabPane.getTabCount() > 0);
        }
    };
    JPanel bottomPanel = new JPanel();
    JLabel westInfoLabel = new JLabel();
    JLabel eastInfoLabel = new JLabel();
    ArrayList points = new ArrayList();
    HashMap page4point = new HashMap();
    HashMap pages = new HashMap();

    public TKTL1FuncPane() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
    }

    void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.westInfoLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.westInfoLabel.setRequestFocusEnabled(true);
        this.westInfoLabel.setText("  ");
        this.eastInfoLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.eastInfoLabel.setVerticalAlignment(0);
        this.bottomPanel.setLayout(new GridLayout());
        this.bottomPanel.setBorder(null);
        this.add((Component)this.mainTabPane, "Center");
        this.add((Component)this.bottomPanel, "South");
        this.bottomPanel.add((Component)this.westInfoLabel, null);
        this.bottomPanel.add((Component)this.eastInfoLabel, null);
        this.mainTabPane.getActionMap().put("toRight", new AbstractAction("toRight"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int selectIndex = TKTL1FuncPane.this.mainTabPane.getSelectedIndex();
                selectIndex = ++selectIndex >= TKTL1FuncPane.this.mainTabPane.getTabCount() ? 0 : selectIndex;
                TKTL1FuncPane.this.mainTabPane.setSelectedIndex(selectIndex);
            }
        });
        this.mainTabPane.getInputMap().put(KeyStroke.getKeyStroke(39, 0), "toRight");
        this.mainTabPane.getActionMap().put("toLeft", new AbstractAction("toLeft"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int selectIndex = TKTL1FuncPane.this.mainTabPane.getSelectedIndex();
                selectIndex = --selectIndex < 0 ? TKTL1FuncPane.this.mainTabPane.getTabCount() - 1 : selectIndex;
                TKTL1FuncPane.this.mainTabPane.setSelectedIndex(selectIndex);
            }
        });
        this.mainTabPane.getInputMap().put(KeyStroke.getKeyStroke(37, 0), "toLeft");
        this.mainTabPane.addChangeListener(this);
        this.mainTabPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point mousePoint = e.getPoint();
                TKTL1TabPage selectTab = TKTL1FuncPane.this.getSelectedTL1Page();
                if (selectTab == null) {
                    return;
                }
                String selectNeId = String.valueOf(selectTab.getNE().neID);
                Point iconPoint = (Point)TKTL1FuncPane.this.page4point.get(selectNeId);
                if (iconPoint == null) {
                    return;
                }
                double gapX = mousePoint.getX() - iconPoint.getX();
                double gapY = mousePoint.getY() - iconPoint.getY();
                if (gapX >= 0.0 && gapX <= 15.0 && gapY >= 0.0 && gapY <= 15.0) {
                    TKTL1FuncPane.this.setCloseIcon(TKTL1FuncPane.this.mainTabPane.getSelectedIndex(), TKTL1Icon.PRESS);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TKTL1FuncPane.this.setCloseIcon(TKTL1FuncPane.this.mainTabPane.getSelectedIndex(), TKTL1Icon.DEFAULT);
                Point mousePoint = e.getPoint();
                TKTL1TabPage selectTab = TKTL1FuncPane.this.getSelectedTL1Page();
                if (selectTab == null) {
                    return;
                }
                String selectNeId = String.valueOf(selectTab.getNE().neID);
                Point iconPoint = (Point)TKTL1FuncPane.this.page4point.get(selectNeId);
                if (iconPoint == null) {
                    return;
                }
                double gapX = mousePoint.getX() - iconPoint.getX();
                double gapY = mousePoint.getY() - iconPoint.getY();
                if (gapX >= 0.0 && gapX <= 15.0 && gapY >= 0.0 && gapY <= 15.0) {
                    TKTL1FuncPane.this.removeSelectTL1Page();
                }
            }
        });
        this.mainTabPane.setVisible(false);
    }

    private void setCloseIcon(int tabIndex, int iconType) {
        if (tabIndex < 0) {
            return;
        }
        TKTL1Icon closeIcon = new TKTL1Icon(String.valueOf(this.getTL1Page((int)tabIndex).getNE().neID), iconType){

            @Override
            public void actionOnPoint(int x, int y) {
                Point point = new Point(x, y);
                TKTL1FuncPane.this.page4point.put(this.neId_icon, point);
            }
        };
        this.mainTabPane.setIconAt(tabIndex, closeIcon);
    }

    public void dispose() {
        for (int i = 0; i < this.getTL1PageCount(); ++i) {
            TKTL1TabPage tapPage = this.getTL1Page(i);
            tapPage.dispose();
        }
    }

    public boolean checkData(TKCmdMSG inData, TKCmdMSG outData) {
        return false;
    }

    public static final int getMaxNumOfPages() {
        try {
            int maxNum = Integer.parseInt(TKProfileFactory.getCfgString("tl1cfg.ini", "option", "maxNumber"));
            if (maxNum <= 0 || maxNum > 50) {
                maxNum = 10;
            }
            return maxNum;
        }
        catch (Exception ex) {
            return 10;
        }
    }

    public int getTL1PageCount() {
        return this.mainTabPane.getTabCount();
    }

    public boolean addTL1Page(TKNeStruct ne) {
        TKTL1TabPage TL1Page = new TKTL1TabPage(ne);
        return this.addTL1Page(TL1Page);
    }

    public boolean addTL1Page(TKTL1TabPage TL1Page) {
        if (this.mainTabPane.getTabCount() >= TKTL1FuncPane.getMaxNumOfPages()) {
            return false;
        }
        if (this.pages.get(String.valueOf(TL1Page.getNE().neID)) != null) {
            return false;
        }
        this.points.clear();
        TKTL1Icon closeIcon = new TKTL1Icon(String.valueOf(TL1Page.ne.neID), TKTL1Icon.DEFAULT){

            @Override
            public void actionOnPoint(int x, int y) {
                Point point = new Point(x, y);
                TKTL1FuncPane.this.page4point.put(this.neId_icon, point);
            }
        };
        this.mainTabPane.addTab(TL1Page.getNE().neName, closeIcon, TL1Page);
        this.mainTabPane.setVisible(true);
        this.pages.put(String.valueOf(TL1Page.getNE().neID), TL1Page);
        TKLogManager.writeLog("Add TL1 Tab Success:" + TL1Page.getNE().neID + "\t" + TL1Page.getNE().neName);
        return true;
    }

    public TKTL1TabPage getSelectedTL1Page() {
        return (TKTL1TabPage)this.mainTabPane.getSelectedComponent();
    }

    public TKTL1TabPage getTL1Page(String neId) {
        return (TKTL1TabPage)this.pages.get(neId);
    }

    public TKTL1TabPage getTL1Page(int index) {
        return (TKTL1TabPage)this.mainTabPane.getComponent(index);
    }

    public void removeSelectTL1Page() {
        this.removeTL1Page((TKTL1TabPage)this.mainTabPane.getSelectedComponent());
    }

    public void removeTL1Page(String neId) {
        this.removeTL1Page((TKTL1TabPage)this.pages.get(neId));
    }

    public void shutPage(TKTL1TabPage TL1Page) {
        this.points.clear();
        TL1Page.dispose();
        this.mainTabPane.remove(TL1Page);
        this.pages.remove(String.valueOf(TL1Page.getNE().neID));
        TKTL1TabPage selectTab = this.getSelectedTL1Page();
        if (selectTab == null) {
            this.setNeInfo(null);
        } else {
            this.setNeInfo(selectTab.getNE());
        }
    }

    public void setNeInfo(TKNeStruct ne) {
        if (ne == null) {
            this.setWestText("  ");
            this.setEastText("  ");
        } else {
            String neName = ne.isTL1NE ? ne.TID : ne.neName;
            String ipGate = ne.gatewayType == 1 ? ne.gatewayIP + ":" + ne.ipPort : ne.tp4Address + ":" + ne.tp4Port;
            this.setWestText(neName);
            this.setEastText(ipGate);
        }
    }

    public void removeTL1Page(TKTL1TabPage TL1Page) {
        if (TL1Page == null) {
            return;
        }
        AsnToolkitTL1NETabOperationReq shutReq = new AsnToolkitTL1NETabOperationReq();
        shutReq.neIDList.add((Object)BigInteger.valueOf(TL1Page.getNE().neID));
        int retShuts = this.shutPages(shutReq);
        if (retShuts > 0) {
            this.shutPage(TL1Page);
        }
    }

    public int shutPages(AsnToolkitTL1NETabOperationReq req) {
        AsnOneReturn asnRtn;
        if (req.neIDList.size() == 0) {
            return 0;
        }
        AsnBulkReturn shutRtn = new AsnBulkReturn();
        char cmdCode = '\u0f08';
        byte recvModule = 15;
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), true);
        TKCommandResult shutRet = TKCommUtility.sendCommand((FStruct)req, (FStruct)shutRtn, cmdCode, recvModule, 120);
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), false);
        if (!shutRet.isSuccess) {
            TKOperationShowMgr.showOperationDlg((Component)this.getParent(), shutRet.resultInfo, true);
            return 0;
        }
        int shutCount = 0;
        TKOperResultVector resultV = new TKOperResultVector();
        for (int i = 0; i < shutRtn.size(); ++i) {
            asnRtn = (AsnOneReturn)shutRtn.elementAt(i);
            if (asnRtn.ret.isSuccess) {
                this.shutPage(this.getTL1Page(String.valueOf(asnRtn.id)));
                ++shutCount;
                continue;
            }
            String neName = this.getTL1Page((String)asnRtn.id.toString()).getNE().neName;
            String operReason = TKRes.getErrorInfo(asnRtn.ret);
            TKOperResultStruct struct = new TKOperResultStruct(neName, this.res.getString("CloseTL1PageFail"), operReason);
            TKLogManager.recordLog2Server(neName, this.res.getString("OpenTL1PageFail"), operReason);
            resultV.addElement(struct);
        }
        asnRtn = null;
        shutRtn = null;
        if (resultV.size() > 0) {
            TKOperationShowMgr.showOperationDlg((Component)this.getParent(), this.res.getString("OperResult"), resultV);
        }
        return shutCount;
    }

    public void setWestText(String info) {
        this.westInfoLabel.setText(info);
    }

    public void setEastText(String info) {
        this.eastInfoLabel.setText(info);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        TKTL1TabPage TL1Page = this.getSelectedTL1Page();
        if (this.getTL1PageCount() == 1) {
            TL1Page = (TKTL1TabPage)this.mainTabPane.getComponent(0);
        }
        if (this.getTL1PageCount() == 0) {
            this.setNeInfo(null);
            if (TKTL1FindDialog.instance().isShowing()) {
                TKTL1FindDialog.instance().dispose();
            }
        } else {
            TL1Page.cmdTextPane.setFont(TKTL1StyleMgr.instance().getCmdFont());
            TL1Page.msgTextPane.setFont(TKTL1StyleMgr.instance().getMsgFont());
            this.setNeInfo(TL1Page.getNE());
        }
    }

    public static class TKTL1Icon
    implements Icon {
        protected String neId_icon = "";
        protected static int PRESS = 0;
        protected static int DEFAULT = 1;
        private int iconType = DEFAULT;
        public static final int Height = 15;
        public static final int Width = 15;

        public TKTL1Icon(String neId, int type) {
            this.neId_icon = neId;
            this.iconType = type;
        }

        public TKTL1Icon() {
        }

        @Override
        public int getIconHeight() {
            return 15;
        }

        @Override
        public int getIconWidth() {
            return 15;
        }

        public void actionOnPoint(int x, int y) {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.actionOnPoint(x, y);
            int iconWidth = this.getIconWidth();
            int iconHeight = this.getIconHeight();
            if (this.iconType == DEFAULT) {
                g.setColor(Color.white);
            } else {
                g.setColor(Color.gray);
            }
            g.translate(x, y);
            g.drawLine(0, 0, 0, iconHeight);
            g.drawLine(0, 0, iconWidth, 0);
            if (this.iconType == DEFAULT) {
                g.setColor(Color.gray);
            } else {
                g.setColor(Color.white);
            }
            g.drawLine(0, iconHeight, iconWidth, iconHeight);
            g.drawLine(iconWidth, 0, iconWidth, iconHeight);
            int arg1 = 4;
            int arg2 = 5;
            if (this.iconType == PRESS) {
                --iconWidth;
                --iconHeight;
            }
            g.setColor(Color.black);
            g.drawLine(arg1, arg2, iconWidth - arg2, iconHeight - arg1);
            g.drawLine(arg1, arg1, iconWidth - arg1, iconHeight - arg1);
            g.drawLine(arg2, arg1, iconWidth - arg1, iconHeight - arg2);
            g.drawLine(iconWidth - arg1, arg1, arg1, iconHeight - arg1);
            g.drawLine(iconWidth - arg1, arg2, arg2, iconHeight - arg1);
            g.drawLine(iconWidth - arg2, arg1, arg1, iconHeight - arg2);
            g.translate(-x, -y);
        }
    }
}

