/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.tl1;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.component.TKComponentToolkit;
import com.huawei.dc.toolkit.client.base.util.component.TKTextField;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperationShowMgr;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1Res;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1TextPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;

public class TKTL1FindDialog
extends JDialog
implements ActionListener {
    TKTL1Res res = TKTL1Res.instance();
    JTextComponent textPane = null;
    String strFind = "";
    private static TKTL1FindDialog findDlg = null;
    JPanel mainPanel = new JPanel();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    TKTextField fndText = new TKTextField();
    JLabel kwLab = new JLabel();
    JCheckBox caseCkBox = new JCheckBox();
    JCheckBox wordCkBox = new JCheckBox();
    JButton fndButton = new JButton();
    JButton cancButton = new JButton();
    JLabel spaceLab = new JLabel();

    private TKTL1FindDialog() {
        super(TKResourceManager.getMainFrame());
        try {
            this.jbInit();
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    private void jbInit() throws Exception {
        this.fndText.setColumns(1);
        this.fndText.setText("");
        this.kwLab.setText(this.res.getString("FindWhat") + ": ");
        this.caseCkBox.setText(this.res.getString("MatchCase"));
        this.wordCkBox.setText(this.res.getString("MatchWord"));
        this.fndButton.setText(this.res.getString("FindButton"));
        this.cancButton.setText(this.res.getString("button_CANCEL"));
        this.spaceLab.setText("  ");
        this.kwLab.setForeground(this.fndButton.getForeground());
        int width = 125;
        int higth = 27;
        this.fndButton.setMaximumSize(new Dimension(width, higth));
        this.fndButton.setMinimumSize(new Dimension(width, higth));
        this.fndButton.setPreferredSize(new Dimension(width, higth));
        this.cancButton.setMaximumSize(new Dimension(width, higth));
        this.cancButton.setMinimumSize(new Dimension(width, higth));
        this.cancButton.setPreferredSize(new Dimension(width, higth));
        this.jPanel1.setLayout(this.borderLayout1);
        this.jPanel2.setLayout(this.borderLayout2);
        this.jPanel3.setLayout(this.borderLayout3);
        this.jPanel1.add((Component)this.kwLab, "West");
        this.jPanel1.add((Component)this.fndText, "Center");
        this.jPanel2.add((Component)this.wordCkBox, "West");
        this.jPanel2.add((Component)this.caseCkBox, "North");
        this.jPanel3.add((Component)this.fndButton, "North");
        this.jPanel3.add((Component)this.cancButton, "South");
        this.jPanel3.add((Component)this.spaceLab, "Center");
        this.mainPanel.setLayout(this.gridBagLayout1);
        this.mainPanel.add((Component)this.jPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 15, 2, new Insets(10, 7, 2, 7), 155, 4));
        this.mainPanel.add((Component)this.jPanel3, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 17, 0, new Insets(3, 3, 9, 7), 2, 0));
        this.mainPanel.add((Component)this.jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(3, 9, 7, 7), 94, -2));
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.setTitle(this.res.getString("Find"));
        this.setSize(395, 128);
        this.setResizable(false);
        this.setLocation((int)Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 2 - this.getWidth() / 2, (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 2 - this.getHeight() / 2);
        KeyAdapter escKa = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                int keyCode = evt.getKeyCode();
                if (keyCode == 27) {
                    TKTL1FindDialog.this.dispose();
                }
            }
        };
        TKComponentToolkit.addAllKeyListener(this, "javax.swing.JComponent", escKa);
        KeyAdapter okKa = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    TKTL1FindDialog.this.find();
                }
            }
        };
        this.fndText.addKeyListener(okKa);
        TKComponentToolkit.addAllButtonEnterKeyAdp(this);
        TKTL1TextPane.formatTextField(this.fndText);
        this.fndButton.addActionListener(this);
        this.cancButton.addActionListener(this);
        this.fndText.requestFocus();
    }

    public static synchronized TKTL1FindDialog instance(JTextComponent textComponent) {
        if (findDlg == null) {
            findDlg = new TKTL1FindDialog();
        }
        findDlg.setTextComponent(textComponent);
        return findDlg;
    }

    public static synchronized TKTL1FindDialog instance() {
        if (findDlg == null) {
            findDlg = new TKTL1FindDialog();
        }
        return findDlg;
    }

    public void setTextComponent(JTextComponent textComponent) {
        this.textPane = textComponent;
        this.strFind = "";
    }

    @Override
    public void show() {
        this.fndText.requestFocus();
        this.fndText.requestFocus();
        super.show();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e != null && (JButton)e.getSource() == this.cancButton) {
            this.dispose();
            return;
        }
        this.textPane.getHighlighter().removeAllHighlights();
        this.find();
    }

    private void find() {
        int lenTal = this.textPane.getText().length();
        if (lenTal == 0) {
            TKOperationShowMgr.showMessageDialog(this, this.res.getString("NoFindText"), this.res.getString("Hint"), 1);
            this.fndText.grabFocus();
            return;
        }
        this.strFind = this.fndText.getText();
        int lenFndStr = this.strFind.length();
        if (lenFndStr == 0) {
            TKOperationShowMgr.showMessageDialog(this, this.res.getString("NoFoundText"), this.res.getString("Hint"), 1);
            this.fndText.requestFocus();
            return;
        }
        int realIndex = this.textPane.getText().toLowerCase().indexOf(this.strFind.toLowerCase());
        if (this.caseCkBox.isSelected()) {
            realIndex = this.textPane.getText().indexOf(this.strFind);
        }
        if (realIndex < 0) {
            TKOperationShowMgr.showMessageDialog(this, this.res.getString("FindOver"), this.res.getString("Hint"), 1);
            this.fndText.grabFocus();
            return;
        }
        this.textPane.getHighlighter().removeAllHighlights();
        int origSelectStart = this.textPane.getSelectionStart();
        int origSelectEnd = this.textPane.getSelectionEnd();
        boolean findOut = false;
        findOut = origSelectStart == origSelectEnd && origSelectStart == 0 ? this.findStr(0, this.strFind) : this.findStr(origSelectStart + 1, this.strFind);
        if (!findOut) {
            this.textPane.setSelectionEnd(0);
            this.textPane.setSelectionStart(0);
            findOut = this.findStr(0, this.strFind);
        }
        if (!findOut) {
            this.textPane.setSelectionEnd(origSelectEnd);
            this.textPane.setSelectionStart(origSelectStart);
            TKOperationShowMgr.showMessageDialog(this, this.res.getString("FindOver"), this.res.getString("Hint"), 1);
        } else {
            try {
                this.textPane.getHighlighter().addHighlight(this.textPane.getSelectionStart(), this.textPane.getSelectionEnd(), DefaultHighlighter.DefaultPainter);
            }
            catch (Exception ex) {
                DCDebugTracer.trace(ex);
            }
        }
    }

    private boolean findStr(int findStart, String fdStr) {
        int fndLen = fdStr.length();
        String findCont = this.textPane.getText();
        boolean findout = false;
        while (!findout && findStart + fndLen <= findCont.length()) {
            block5: {
                try {
                    String findText = this.textPane.getText(findStart, fndLen);
                    if (!this.compare(fdStr, findText)) break block5;
                    if (this.wordCkBox.isSelected()) {
                        if (!this.isNumberOrLetter(findStart - 1) && !this.isNumberOrLetter(findStart + fndLen)) {
                            this.textPane.setSelectionStart(findStart);
                            this.textPane.setSelectionEnd(findStart + fndLen);
                            findout = true;
                            break;
                        }
                        break block5;
                    }
                    this.textPane.setSelectionStart(findStart);
                    this.textPane.setSelectionEnd(findStart + fndLen);
                    findout = true;
                }
                catch (BadLocationException ex) {}
                break;
            }
            ++findStart;
        }
        return findout;
    }

    private boolean isNumberOrLetter(int start) {
        boolean isNumberOrLetter = false;
        if (start < 0) {
            return isNumberOrLetter;
        }
        try {
            String s = this.textPane.getText(start, 1);
            char c = s.toCharArray()[0];
            if (c == '_') {
                return true;
            }
            int cType = Character.getType(c);
            if (cType == 9 || cType == 2 || cType == 1) {
                return true;
            }
        }
        catch (BadLocationException ble) {
            ble.toString();
        }
        return isNumberOrLetter;
    }

    private boolean compare(String a, String b) {
        if (a == null || b == null) {
            return false;
        }
        if (!this.caseCkBox.isSelected()) {
            return a.equalsIgnoreCase(b);
        }
        return a.equals(b);
    }

    @Override
    public void dispose() {
        DCDebugTracer.trace("TKTL1FindDialog dispose");
        super.dispose();
    }
}

