/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.tl1;

import com.huawei.dc.toolkit.client.base.util.TKProfileFactory;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.component.TKComponentToolkit;
import com.huawei.dc.toolkit.client.base.util.resource.TKAreaDescObject;
import com.huawei.dc.toolkit.client.base.util.resource.TKFileDescObject;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1Res;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1StyleMgr;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TKTL1ColorDialog
extends JDialog
implements ActionListener {
    TKTL1Res res = TKTL1Res.instance();
    TKTL1StyleMgr colorMgr = TKTL1StyleMgr.instance();
    JButton okButton = new JButton(this.res.getString("button_OK"));
    JButton cancButton = new JButton(this.res.getString("button_CANCEL"));
    JButton initButton = new JButton(this.res.getString("button_INIT"));
    HashMap tmpColors = new HashMap();
    HashMap tmpButton = new HashMap();
    private static TKTL1ColorDialog cologDlg = null;
    KeyAdapter escKa = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                TKTL1ColorDialog.this.dispose();
            }
        }
    };

    public static synchronized TKTL1ColorDialog instance() {
        if (null == cologDlg) {
            cologDlg = new TKTL1ColorDialog();
        }
        return cologDlg;
    }

    private TKTL1ColorDialog() {
        super((Frame)TKResourceManager.getMainFrame(), true);
        JPanel mPane = new JPanel();
        mPane.setSize(170, 80);
        HashMap colors = this.colorMgr.getColorSet();
        mPane.setLayout(new GridLayout(colors.size(), 2));
        Iterator iter = colors.keySet().iterator();
        while (iter.hasNext()) {
            String colorInfo = iter.next().toString();
            String colorDesc = TKProfileFactory.getCommonFileDescObject("tkconfig.ini").getAreaDescObject("tl1colors").getDescObject(colorInfo).getStringPropertyValue("desc");
            this.tmpColors.put(colorInfo, (Color)colors.get(colorInfo));
            JLabel jLabel2 = new JLabel(this.res.getString(colorDesc) + ":");
            jLabel2.setFont(TKTL1Res.DEFAULT_FONT);
            JPanel jPanel = new JPanel();
            jPanel.add((Component)jLabel2, "East");
            mPane.add(jPanel);
            mPane.add(this.createButton(colorInfo));
            if (colorInfo != null) continue;
            break;
        }
        this.getContentPane().add((Component)new JPanel(), "North");
        this.getContentPane().add((Component)mPane, "Center");
        JPanel sPanel = new JPanel();
        sPanel.add(this.initButton);
        sPanel.add(this.okButton);
        sPanel.add(this.cancButton);
        this.initButton.setFont(TKTL1Res.DEFAULT_FONT);
        this.okButton.setFont(TKTL1Res.DEFAULT_FONT);
        this.cancButton.setFont(TKTL1Res.DEFAULT_FONT);
        this.initButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancButton.addActionListener(this);
        this.getContentPane().add((Component)sPanel, "South");
        this.setSize(250, 80 + colors.size() * 20);
        this.setLocation((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() - 250.0) / 2, (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() - 160.0) / 2);
        this.setResizable(false);
        this.setTitle(this.res.getString("SetColor"));
        TKComponentToolkit.addAllKeyListener(this, "javax.swing.JComponent", this.escKa);
        TKComponentToolkit.addAllButtonEnterKeyAdp(this);
        this.setDefaultCloseOperation(2);
    }

    private JButton createButton(String colorInfo) {
        JButton button = new JButton();
        button.setActionCommand(colorInfo);
        button.setBackground(this.colorMgr.getColor(colorInfo));
        button.addActionListener(this);
        button.setSize(90, button.getHeight());
        this.tmpButton.put(colorInfo, button);
        return button;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ((JButton)e.getSource() == this.okButton) {
            Iterator iter = this.tmpButton.keySet().iterator();
            while (iter.hasNext()) {
                String curColorInfo = iter.next().toString();
                JButton jbtn = (JButton)this.tmpButton.get(curColorInfo);
                if (curColorInfo == null) break;
                this.colorMgr.setColor(curColorInfo, jbtn.getBackground());
                TKProfileFactory.saveCommonStringProperty("tkconfig.ini", "tl1colors", curColorInfo, "colorRGB", String.valueOf(jbtn.getBackground().getRGB()));
            }
            this.dispose();
            return;
        }
        if ((JButton)e.getSource() == this.cancButton) {
            Iterator iter = this.tmpButton.keySet().iterator();
            while (iter.hasNext()) {
                String colorInfo = iter.next().toString();
                JButton button = (JButton)this.tmpButton.get(colorInfo);
                button.setBackground(this.colorMgr.getColor(colorInfo));
            }
            this.dispose();
            return;
        }
        if ((JButton)e.getSource() == this.initButton) {
            this.initBtn_actionPerformed();
            return;
        }
        String colorInfo = e.getActionCommand();
        String colorDesc = TKProfileFactory.getCommonFileDescObject("tkconfig.ini").getAreaDescObject("tl1colors").getDescObject(colorInfo).getStringPropertyValue("desc");
        JButton colorBt = (JButton)e.getSource();
        Color color = JColorChooser.showDialog(this, this.res.getString(colorDesc), colorBt.getBackground());
        if (color != null) {
            this.tmpColors.put(colorInfo, color);
            ((JButton)e.getSource()).setBackground(color);
        }
    }

    public void initBtn_actionPerformed() {
        TKTL1StyleMgr initcolorMgr = TKTL1StyleMgr.instance();
        TKFileDescObject cfile = TKProfileFactory.getCommonFileDescObject("tl1cfg.ini");
        TKAreaDescObject areaObject = cfile.getAreaDescObject("initcolors");
        String colorInfo = "";
        int colorRgb = 0;
        HashMap<String, Color> tmpInitColors = new HashMap<String, Color>();
        for (int i = 0; i < areaObject.getDescObjectCount(); ++i) {
            colorInfo = areaObject.getDescObject(i).getObjectName();
            try {
                colorRgb = Integer.parseInt(areaObject.getDescObject(i).getStringPropertyValue("colorRGB"));
            }
            catch (Exception ex) {
                ex.toString();
            }
            tmpInitColors.put(colorInfo, TKTL1StyleMgr.getColor(colorRgb));
        }
        HashMap initcolors = initcolorMgr.getColorSet();
        Iterator iter = initcolors.keySet().iterator();
        while (iter.hasNext()) {
            colorInfo = iter.next().toString();
            JButton button = (JButton)this.tmpButton.get(colorInfo);
            button.setBackground((Color)tmpInitColors.get(colorInfo));
        }
    }
}

