/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.tl1;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.communicate.TKCommUtility;
import com.huawei.dc.toolkit.client.base.communicate.TKCommandResult;
import com.huawei.dc.toolkit.client.base.util.TKFile;
import com.huawei.dc.toolkit.client.base.util.TKLogManager;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.component.TKOptionPane;
import com.huawei.dc.toolkit.client.base.util.component.TKPopMenuItem;
import com.huawei.dc.toolkit.client.base.util.filechooser.TKFileChooser;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperationShowMgr;
import com.huawei.dc.toolkit.client.base.util.resource.TKErrorCodeRes;
import com.huawei.dc.toolkit.client.base.util.text.TKCodeContent;
import com.huawei.dc.toolkit.client.te.toolkit.TKMainFrame;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKNeStruct;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1InternalFrame;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1MsgText;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1Res;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1StyleMgr;
import com.huawei.dc.toolkit.client.te.toolkit.tl1.TKTL1TextPane;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKConfirmOperationDlg;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKFileFilterMananger;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKFontChooser;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKProgressMonitorInputStream;
import com.huawei.te.toolkit.AsnToolkitParameter;
import com.huawei.te.toolkit.AsnToolkitTL1CmdSendReq;
import com.huawei.te.toolkit.AsnToolkitTL1CmdSendRsp;
import com.huawei.te.toolkit.AsnToolkitTL1NoCmdReq;
import com.huawei.te.toolkit.AsnToolkitTL1NoCmdRsp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.StyleContext;
import javax.swing.text.Utilities;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import net.commustru.fstru.FStruct;

public class TKTL1CmdText
extends TKTL1TextPane
implements PopupMenuListener {
    TKTL1Res res = TKTL1Res.instance();
    private TKErrorCodeRes errorRes = TKErrorCodeRes.instance();
    private JPopupMenu cmdPopMenu = new JPopupMenu();
    boolean ifShowPopMenu = false;
    private TKNeStruct ne = null;
    private TKTL1MsgText msgTextPane = null;
    String curSaveFile = "";
    long fileLength;
    private int scriptState = -99;
    UndoManager undoMgr = new UndoManager();
    private TKPopMenuItem openMenuItem;
    private TKPopMenuItem saveMenuItem;
    private TKPopMenuItem saveAsMenuItem;
    private TKPopMenuItem undoMenuItem;
    private TKPopMenuItem redoMenuItem;
    private TKPopMenuItem cutMenuItem;
    private TKPopMenuItem copyMenuItem;
    private TKPopMenuItem pasteMenuItem;
    private TKPopMenuItem findMenuItem;
    private TKPopMenuItem runSeMenuItem;
    private TKPopMenuItem pauseMenuItem;
    private TKPopMenuItem runMenuItem;
    private TKPopMenuItem stopMenuItem;
    private TKPopMenuItem fontMenuItem;
    static final int CMD_OPEN = 0;
    static final int CMD_SAVE = 1;
    static final int CMD_SAVEAS = 2;
    static final int CMD_UNDO = 3;
    static final int CMD_REDO = 4;
    static final int CMD_CUT = 5;
    static final int CMD_COPY = 6;
    static final int CMD_PASTE = 7;
    static final int CMD_FIND = 8;
    static final int CMD_FUN = 9;
    static final int CMD_PAUSE = 10;
    static final int CMD_RUN = 11;
    static final int CMD_STOP = 12;
    static final int CMD_RSS = 13;
    static final int CMD_FONT = 14;
    private static final int OPEN_FOR_RUN = 0;
    private static final int OPEN_FOR_OPEN = 1;
    private static final int MAX_FILE_LENGTH = 0x100000;
    private static final int OPEN_FILE_LENGTH = 51200;
    TKCodeContent codeContent = new TKCodeContent();
    private boolean reading = false;

    public TKTL1CmdText(TKNeStruct ne, TKTL1MsgText msgTextPane) {
        this.setDocument(new DefaultStyledDocument((AbstractDocument.Content)this.codeContent, new StyleContext()));
        this.ne = ne;
        this.msgTextPane = msgTextPane;
        this.setDoubleBuffered(true);
        this.createPopMenu();
        this.cmdPopMenu.addNotify();
        this.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                TKTL1CmdText.this.undoMgr.addEdit(evt.getEdit());
            }
        });
        this.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (TKTL1CmdText.this.undoMgr.canUndo()) {
                        TKTL1CmdText.this.undoMgr.undo();
                    }
                }
                catch (CannotUndoException e) {
                    e.toString();
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        this.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (TKTL1CmdText.this.undoMgr.canRedo()) {
                        TKTL1CmdText.this.undoMgr.redo();
                    }
                }
                catch (CannotRedoException e) {
                    e.toString();
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
        this.getActionMap().put("Save", new AbstractAction("Save"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if ("".equals(TKTL1CmdText.this.curSaveFile)) {
                    TKTL1CmdText.this.saveAs();
                } else {
                    TKTL1CmdText.this.saveFile(TKTL1CmdText.this.curSaveFile);
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("control S"), "Save");
        this.getActionMap().put("Open", new AbstractAction("Open"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TKTL1CmdText.this.openFile();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("control O"), "Open");
        if (TKTL1InternalFrame.neState.get(String.valueOf(ne.neID)) != null) {
            this.scriptState = ((BigInteger)TKTL1InternalFrame.neState.get(String.valueOf(ne.neID))).intValue();
            this.setScriptState(this.scriptState);
        }
        this.setFont(TKTL1StyleMgr.instance().getCmdFont());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openFile() {
        this.reading = false;
        File scriptFile = this.getScriptFile(1);
        if (scriptFile == null) {
            return;
        }
        this.fileLength = scriptFile.length();
        if (this.fileLength > 0x100000L) {
            TKOperationShowMgr.showMessageDialog(TKResourceManager.getMainFrame(), this.res.getString("FileTooBig_E"), this.res.getString("Hint"), 0);
            this.resetSaveFile();
            return;
        }
        if (this.fileLength > 51200L) {
            String dlgDesc = this.res.getString("FileTooBig");
            TKConfirmOperationDlg cfDlg = new TKConfirmOperationDlg(TKResourceManager.getMainFrame(), this.res.getString("Hint"), dlgDesc, null, true);
            int go = cfDlg.showDialog();
            if (go == 1) {
                return;
            }
        }
        FileInputStream fileIn = null;
        try {
            fileIn = new FileInputStream(scriptFile);
            TKProgressMonitorInputStream proIn = new TKProgressMonitorInputStream(TKResourceManager.getMainFrame(), this.res.getString("LoadingFromFile"), fileIn, this.ne.neName + ":" + this.res.getString("ReadingFile"));
            InputStreamReader inReader = new InputStreamReader(proIn);
            BufferedReader in = new BufferedReader(inReader);
            proIn.getProgressMonitor().setNote(scriptFile.getAbsolutePath());
            FileLoader loader = new FileLoader(in, this.getDocument());
            this.setText("");
            loader.start();
        }
        catch (IOException e) {
            this.curSaveFile = "";
        }
        finally {
            if (null != fileIn) {
                try {
                    fileIn.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
        }
    }

    private void createPopMenu() {
        this.cmdPopMenu = new JPopupMenu();
        this.openMenuItem = this.getMenuItem(this.res.getString("Open"), String.valueOf(0));
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.saveMenuItem = this.getMenuItem(this.res.getString("Save"), String.valueOf(1));
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveAsMenuItem = this.getMenuItem(this.res.getString("Saveas"), String.valueOf(2));
        this.undoMenuItem = this.getMenuItem(this.res.getString("Undo"), String.valueOf(3));
        this.undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.redoMenuItem = this.getMenuItem(this.res.getString("Redo"), String.valueOf(4));
        this.redoMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.cutMenuItem = this.getMenuItem(this.res.getString("Cut"), String.valueOf(5));
        this.cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.copyMenuItem = this.getMenuItem(this.res.getString("Copy"), String.valueOf(6));
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.pasteMenuItem = this.getMenuItem(this.res.getString("Paste"), String.valueOf(7));
        this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.findMenuItem = this.getMenuItem(this.res.getString("Find"), String.valueOf(8));
        this.findMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.runSeMenuItem = this.getMenuItem(this.res.getString("RunSelectScript"), String.valueOf(13));
        this.runMenuItem = this.getMenuItem(this.res.getString("Run"), String.valueOf(11));
        this.pauseMenuItem = this.getMenuItem(this.res.getString("Pause"), String.valueOf(10));
        this.stopMenuItem = this.getMenuItem(this.res.getString("Stop"), String.valueOf(12));
        this.fontMenuItem = this.getMenuItem(this.res.getString("SetFont"), String.valueOf(14));
        this.cmdPopMenu.add(this.openMenuItem);
        this.cmdPopMenu.add(this.saveMenuItem);
        this.cmdPopMenu.add(this.saveAsMenuItem);
        this.cmdPopMenu.addSeparator();
        this.cmdPopMenu.add(this.undoMenuItem);
        this.cmdPopMenu.add(this.redoMenuItem);
        this.cmdPopMenu.addSeparator();
        this.cmdPopMenu.add(this.cutMenuItem);
        this.cmdPopMenu.add(this.copyMenuItem);
        this.cmdPopMenu.add(this.pasteMenuItem);
        this.cmdPopMenu.addSeparator();
        this.cmdPopMenu.add(this.findMenuItem);
        this.cmdPopMenu.addSeparator();
        this.cmdPopMenu.add(this.fontMenuItem);
        this.cmdPopMenu.addSeparator();
        this.cmdPopMenu.add(this.runSeMenuItem);
        this.cmdPopMenu.add(this.runMenuItem);
        this.cmdPopMenu.add(this.pauseMenuItem);
        this.cmdPopMenu.add(this.stopMenuItem);
        this.cmdPopMenu.addPopupMenuListener(this);
    }

    private void checkMouse(MouseEvent e) {
        this.grabFocus();
        if (e.getModifiers() == 0 || e.getModifiers() == 8 || e.getModifiers() == 10) {
            return;
        }
        if (e.isPopupTrigger()) {
            int x = e.getX();
            int y = e.getY();
            Point point = TKScreenToolKit.getPopupMenuShowupPosition(this, this.cmdPopMenu, x, y);
            this.ifShowPopMenu = true;
            this.cmdPopMenu.show(this, (int)point.getX(), (int)point.getY());
        }
    }

    public String getSelectLine() {
        int caretOpt = this.getCaretPosition();
        String row = "";
        try {
            String charSta;
            String charEnd;
            Document doc = this.getDocument();
            int rowEnd = Utilities.getRowEnd(this, caretOpt);
            int rowSta = Utilities.getRowStart(this, caretOpt);
            row = doc.getText(rowSta, rowEnd - rowSta + 1);
            if (rowEnd < doc.getLength() && !(charEnd = doc.getText(rowEnd, 1)).equals("\n") && !charEnd.equals("\r")) {
                row = row + this.getTailInLine(rowEnd + 1);
            }
            if (rowSta > 0 && !(charSta = doc.getText(rowSta - 1, 1)).equals("\n") && !charSta.equals("\r")) {
                row = this.getHeadInLine(rowSta) + row;
            }
        }
        catch (BadLocationException ble) {
            DCDebugTracer.trace("TKTL1CmdText:getSelectLine Exception:" + ble.toString());
            ble.toString();
        }
        return row;
    }

    private String getHeadInLine(int curCaretPsn) {
        String headContent = "";
        Document doc = this.getDocument();
        if (curCaretPsn == 0) {
            return headContent;
        }
        for (int i = curCaretPsn - 1; i >= 0; --i) {
            try {
                String ch = doc.getText(i, 1);
                if (ch.toCharArray()[0] == '\n' || ch.toCharArray()[0] == '\r') {
                    String temp;
                    if (ch.toCharArray()[0] == '\r' && i + 1 < doc.getLength() && (temp = doc.getText(i + 1, 1)).equals("\n")) continue;
                    headContent = doc.getText(i + 1, curCaretPsn - i - 1);
                    break;
                }
                if (i != 0) continue;
                headContent = doc.getText(0, curCaretPsn - i);
                continue;
            }
            catch (BadLocationException ble) {
                ble.toString();
            }
        }
        return headContent;
    }

    private String getTailInLine(int curCaretPsn) {
        String tailContent = "";
        Document doc = this.getDocument();
        if (curCaretPsn == doc.getLength()) {
            return tailContent;
        }
        for (int i = curCaretPsn; i < doc.getLength(); ++i) {
            try {
                String ch = doc.getText(i, 1);
                if (ch.toCharArray()[0] == '\n' || ch.toCharArray()[0] == '\r') {
                    tailContent = doc.getText(curCaretPsn, i - curCaretPsn + 1);
                    break;
                }
                if (i != doc.getLength() - 1) continue;
                tailContent = doc.getText(curCaretPsn, doc.getLength() - curCaretPsn);
                continue;
            }
            catch (BadLocationException ble) {
                ble.toString();
            }
        }
        return tailContent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int actCmd = 0;
        try {
            actCmd = Integer.parseInt(e.getActionCommand());
        }
        catch (Exception ex) {
            ex.toString();
        }
        switch (actCmd) {
            case 8: {
                this.find();
                break;
            }
            case 13: {
                String selCmd = this.getSelectedText();
                this.sendScript(selCmd, 3);
                break;
            }
            case 11: {
                try {
                    Document doc = this.getDocument();
                    String cmd = doc.getText(0, doc.getLength());
                    this.sendScript(cmd, 2);
                }
                catch (Exception ex) {
                    DCDebugTracer.trace(ex);
                }
                break;
            }
            case 10: {
                this.pause();
                break;
            }
            case 12: {
                this.stop();
                break;
            }
            case 5: {
                this.cut();
                break;
            }
            case 6: {
                this.copy();
                break;
            }
            case 7: {
                try {
                    this.paste();
                }
                catch (Exception or) {
                    DCDebugTracer.trace(or);
                }
                break;
            }
            case 2: {
                this.saveAs();
                break;
            }
            case 1: {
                if ("".equals(this.curSaveFile)) {
                    this.saveAs();
                    break;
                }
                this.saveFile(this.curSaveFile);
                break;
            }
            case 0: {
                this.openFile();
                break;
            }
            case 3: {
                try {
                    if (!this.undoMgr.canUndo()) break;
                    this.undoMgr.undo();
                }
                catch (CannotUndoException ex) {
                    ex.toString();
                }
                break;
            }
            case 4: {
                try {
                    if (!this.undoMgr.canRedo()) break;
                    this.undoMgr.redo();
                }
                catch (CannotRedoException ex) {
                    ex.toString();
                }
                break;
            }
            case 14: {
                TKFontChooser fontCh = new TKFontChooser(TKResourceManager.getMainFrame(), this.getFont(), TKTL1StyleMgr.instance().getDefaultCmdFont());
                Font font = fontCh.show();
                Font oldFont = this.getFont();
                if (font.equals(oldFont)) break;
                TKTL1StyleMgr.instance().setCmdFont(font);
                TKTL1StyleMgr.instance().saveCmdFont();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TKTL1CmdText.this.setFont(TKTL1StyleMgr.instance().getCmdFont());
                    }
                });
                break;
            }
        }
    }

    private void saveAs() {
        int result;
        TKFile ff;
        TKFileChooser fileChooser = new TKFileChooser();
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setBrowseType(102);
        fileChooser.setDialogTitle(this.res.getString("SaveFile"));
        fileChooser.setFileSelectionMode(0);
        fileChooser.addFileFilter(TKFileFilterMananger.txtFilter);
        fileChooser.addFileFilter(TKFileFilterMananger.tclFilter);
        String lp = TKMainFrame.lastpath;
        if (lp != null && lp.trim().length() > 1 && (ff = new TKFile(lp)) != null) {
            fileChooser.setCurrentDirectory(ff);
        }
        if ((result = fileChooser.showSaveFileDialog()) != 0) {
            return;
        }
        if (fileChooser.getSelectedFile() == null) {
            return;
        }
        File saveFile = new File(fileChooser.getSelectedFile().getAbsolutePath());
        TKMainFrame.lastpath = this.curSaveFile = saveFile.getAbsolutePath();
        this.saveFile(this.curSaveFile);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.getCaret().setVisible(true);
        this.checkMouse(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.checkMouse(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.checkMouse(e);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.cutMenuItem.setEnabled(this.getSelectedText() != null);
        this.copyMenuItem.setEnabled(this.cutMenuItem.isEnabled());
        this.redoMenuItem.setEnabled(this.undoMgr.canRedo());
        this.undoMenuItem.setEnabled(this.undoMgr.canUndo());
        try {
            int txtlen = this.getDocument().getLength();
            String cmdtxt = this.getDocument().getText(0, txtlen).trim();
            if (cmdtxt.length() > 0 && !this.reading) {
                this.runMenuItem.setEnabled(true);
            } else {
                this.runMenuItem.setEnabled(false);
            }
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
        String textSelect = this.getSelectedText();
        this.runSeMenuItem.setEnabled(textSelect != null);
        if (textSelect != null) {
            int len = textSelect.trim().length();
            this.runSeMenuItem.setEnabled(len > 0);
        }
        this.enableWithScriptState();
    }

    public void sendScript(String cmd, int howSend) {
        if (howSend == 2 && this.getScriptState() == 2) {
            SwingUtilities.invokeLater(new ChangeSSRunnable('\u0f05'));
            return;
        }
        if (null == cmd || cmd.length() == 0) {
            return;
        }
        String sndCmd = cmd;
        int howSnd = howSend;
        if (cmd.trim().equalsIgnoreCase("runfile")) {
            howSnd = 0;
            sndCmd = this.getScriptFromFile();
            if (null == sndCmd || sndCmd.length() == 0) {
                return;
            }
            if (TKOptionPane.showConfirmDialog((Component)TKResourceManager.getMainFrame(), (Object)this.res.getString("ConfRunFileScript"), this.res.getString("Run"), 0) != 0) {
                return;
            }
        }
        if (null == sndCmd || sndCmd.length() == 0) {
            return;
        }
        AsnToolkitTL1CmdSendReq cmdSndReq = new AsnToolkitTL1CmdSendReq();
        cmdSndReq.cmdContentString = sndCmd.getBytes();
        cmdSndReq.tclFlg = BigInteger.valueOf(howSnd);
        cmdSndReq.neID = BigInteger.valueOf(this.ne.neID);
        char cmdCode = '\u0f01';
        byte recvModule = 15;
        AsnToolkitTL1CmdSendRsp cmdSndRsp = new AsnToolkitTL1CmdSendRsp();
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), true);
        TKCommandResult result = TKCommUtility.sendCommand((FStruct)cmdSndReq, (FStruct)cmdSndRsp, cmdCode, recvModule, 120);
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), false);
        if (!result.isSuccess) {
            this.msgTextPane.insert(this.res.getString("Warning") + " " + this.res.getString("FailSendTL1") + ":" + result.resultInfo + "\n", Color.red);
            TKLogManager.writeToFile("Failed to send TCL:" + sndCmd);
            return;
        }
        if (null != cmdSndRsp.ret && !cmdSndRsp.ret.isSuccess) {
            int errcode = cmdSndRsp.ret.retCode.intValue();
            String errorReason = this.res.getString("Warning") + " " + TKErrorCodeRes.parseCode(errcode) + ":";
            errorReason = cmdSndRsp.ret.reason != null && cmdSndRsp.ret.reason.length > 0 ? errorReason + new String(cmdSndRsp.ret.reason) : errorReason + this.errorRes.getErrString(String.valueOf(errcode));
            if (cmdSndRsp.ret.parameters != null) {
                for (int i = 0; i < cmdSndRsp.ret.parameters.size(); ++i) {
                    AsnToolkitParameter atp = (AsnToolkitParameter)cmdSndRsp.ret.parameters.get(i);
                    errorReason = errorReason.replaceAll(new String(atp.name), new String(atp.value));
                }
            }
            this.msgTextPane.insert(errorReason + "\n", Color.red);
            TKLogManager.writeToFile("Failed to send TCL:" + errorReason);
        }
    }

    public void pause() {
        SwingUtilities.invokeLater(new ChangeSSRunnable('\u0f04'));
    }

    public void stop() {
        SwingUtilities.invokeLater(new ChangeSSRunnable('\u0f06'));
    }

    public void enableWithScriptState() {
        int scrptState = this.getScriptState();
        this.pauseMenuItem.setEnabled(scrptState == 1);
        this.stopMenuItem.setEnabled(scrptState == 2 || scrptState == 1);
        if (scrptState == 2) {
            this.runMenuItem.setText(this.res.getString("Continue"));
            this.runMenuItem.setEnabled(true);
            this.runSeMenuItem.setEnabled(false);
        } else {
            this.runMenuItem.setText(this.res.getString("Run"));
        }
    }

    public void setScriptState(int state) {
        this.scriptState = state;
        this.enableWithScriptState();
    }

    public int getScriptState() {
        return this.scriptState;
    }

    private void changeScriptState(char cmdCode) {
        AsnToolkitTL1NoCmdReq req = new AsnToolkitTL1NoCmdReq();
        req.neID = BigInteger.valueOf(this.ne.neID);
        AsnToolkitTL1NoCmdRsp rsp = new AsnToolkitTL1NoCmdRsp();
        byte recvModule = 15;
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), true);
        TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, recvModule, 120);
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), false);
        if (!ret.isSuccess) {
            this.msgTextPane.insert(this.res.getString("Warning") + ":" + ret.resultInfo, Color.red);
            return;
        }
        if (null != rsp.ret && !rsp.ret.isSuccess) {
            String eString = this.res.getString("Warning") + " " + TKErrorCodeRes.parseCode(rsp.ret.retCode.intValue()) + ":" + this.errorRes.getErrString(String.valueOf(rsp.ret.retCode.intValue()));
            TKLogManager.writeToDebug(eString);
            TKOperationShowMgr.showOperationDlg((Component)this, eString, false);
        }
    }

    private File getScriptFile(int opeType) {
        TKFile ff;
        TKFileChooser fileChooser = new TKFileChooser();
        fileChooser.setBrowseType(102);
        fileChooser.addFileFilter(TKFileFilterMananger.tl1Filter);
        String lp = TKMainFrame.lastpath;
        if (lp != null && lp.trim().length() > 1 && (ff = new TKFile(lp)) != null) {
            fileChooser.setCurrentDirectory(ff);
        }
        int result = fileChooser.showFileDialog();
        if (fileChooser.getSelectedFile() == null) {
            return null;
        }
        File scrptFile = new File(fileChooser.getSelectedFile().getPath());
        if (scrptFile == null || result == 1 || result == -1) {
            return null;
        }
        if (!scrptFile.exists()) {
            TKOperationShowMgr.showMessageDialog(TKResourceManager.getMainFrame(), this.res.getString("FileNotExist"), this.res.getString("OperResult"), 0);
            return null;
        }
        TKMainFrame.lastpath = scrptFile.getAbsolutePath();
        if (opeType == 1) {
            this.curSaveFile = scrptFile.getAbsolutePath();
        }
        return scrptFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getScriptFromFile() {
        File scriptFile = this.getScriptFile(0);
        if (scriptFile == null) {
            return null;
        }
        this.fileLength = scriptFile.length();
        if (this.fileLength > 0x100000L) {
            TKOperationShowMgr.showMessageDialog(TKResourceManager.getMainFrame(), this.res.getString("FileTooBig_E"), this.res.getString("Hint"), 0);
            this.resetSaveFile();
            return null;
        }
        StringBuffer scripts = new StringBuffer();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(scriptFile));
            String str = reader.readLine();
            while (str != null) {
                String strstr = str + "\n";
                scripts.append(strstr);
                str = reader.readLine();
            }
        }
        catch (IOException ioe) {
            DCDebugTracer.trace(ioe);
            String string = null;
            return string;
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
        }
        return scripts.toString().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveFile(String fileName) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(fileName));
            out.write(this.getText());
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            DCDebugTracer.trace(e);
            if (!new File(fileName).exists()) {
                int willContinue = TKOptionPane.showConfirmDialog(TKResourceManager.getMainFrame(), (Object)TKRes.instance().getString("File_Inexistence"), TKRes.instance().getString("Hint"), 0, 0);
                if (willContinue == 1 || willContinue == -1) {
                    boolean bl = false;
                    return bl;
                }
                this.saveAs();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
        }
    }

    private void resetSaveFile() {
        this.curSaveFile = "";
    }

    @Override
    public void copy() {
        try {
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            int p0 = this.getSelectionStart();
            int p1 = this.getSelectionEnd();
            int len = p1 - p0;
            String strData = this.codeContent.getText(p0, len);
            StringSelection contents = new StringSelection(strData);
            clipboard.setContents(contents, null);
        }
        catch (Exception e) {
            e.toString();
        }
    }

    private boolean isReading() {
        return this.reading;
    }

    class ChangeSSRunnable
    implements Runnable {
        char cmd_;

        public ChangeSSRunnable(char cmd) {
            this.cmd_ = cmd;
        }

        @Override
        public void run() {
            TKTL1CmdText.this.changeScriptState(this.cmd_);
        }
    }

    class FileLoader
    extends Thread {
        Document doc;
        BufferedReader bfIn;

        FileLoader(BufferedReader bfIn, Document doc) {
            this.setPriority(3);
            this.doc = doc;
            this.bfIn = bfIn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TKTL1CmdText.this.reading = true;
            TKTL1CmdText.this.setEditable(false);
            TKTL1CmdText.this.codeContent.setEnabled(false);
            try {
                char[] buff = new char[8172];
                int nch = -2;
                nch = this.bfIn.read(buff, 0, buff.length);
                while (TKTL1CmdText.this.isReading() && nch != -1) {
                    String str = new String(buff, 0, nch);
                    this.doc.insertString(this.doc.getLength(), str, null);
                    nch = this.bfIn.read(buff, 0, buff.length);
                }
                if (nch > 0) {
                    TKTL1CmdText.this.resetSaveFile();
                }
            }
            catch (IOException e) {
                TKTL1CmdText.this.resetSaveFile();
            }
            catch (BadLocationException e) {
                e.toString();
            }
            finally {
                TKTL1CmdText.this.codeContent.setEnabled(true);
                TKTL1CmdText.this.setEditable(true);
                TKTL1CmdText.this.reading = false;
                if (null != this.bfIn) {
                    try {
                        this.bfIn.close();
                    }
                    catch (IOException e) {
                        DCDebugTracer.trace(e);
                    }
                }
            }
        }
    }
}

