/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.swpload;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.communicate.TKCommUtility;
import com.huawei.dc.toolkit.client.base.communicate.TKCommandResult;
import com.huawei.dc.toolkit.client.base.util.TKDebug;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.component.TKButton;
import com.huawei.dc.toolkit.client.base.util.component.TKComponentToolkit;
import com.huawei.dc.toolkit.client.base.util.component.TKDialog;
import com.huawei.dc.toolkit.client.base.util.filtertable.TKFilterTable;
import com.huawei.dc.toolkit.client.base.util.filtertable.TKFilterTableModel;
import com.huawei.dc.toolkit.client.base.util.help.TKHelpMgr;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultStruct;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultVector;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperationShowMgr;
import com.huawei.dc.toolkit.client.base.util.treetable.TKDefaultTreeRow;
import com.huawei.dc.toolkit.client.base.util.treetable.TKTreeTableUI;
import com.huawei.dc.toolkit.client.te.toolkit.swpload.TKSWPLoadTablePanel;
import com.huawei.dc.toolkit.client.te.toolkit.swpload.TKSWPNEDataStruct;
import com.huawei.dc.toolkit.client.te.toolkit.swpload.TKSWPRes;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKASNTool;
import com.huawei.dc.toolkit.control.Toolkit4T2kInterface;
import com.huawei.dc.toolkit.control.Toolkit4T2kInterfaceMgr;
import com.huawei.te.toolkit.AsnTkPkgBdVerInfo;
import com.huawei.te.toolkit.AsnTkPkgNeVerChkReq;
import com.huawei.te.toolkit.AsnTkPkgNeVerChkRsp;
import com.huawei.te.toolkit.AsnTkSoftVerInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import net.commustru.fstru.FStruct;

public class TKSWPVersionDialog
extends TKDialog {
    private int BoardObjectType = 1;
    private int BoardVersionType = 2;
    private int SoftVersionType = 3;
    private ColorCellRenderer colorRenderer = new ColorCellRenderer();
    private Icon boardIcon = TKResourceManager.getIcon("board.gif");
    private TKSWPRes res = TKSWPRes.instance();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel2 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel3 = new JPanel();
    TKButton btnOk = new TKButton();
    BorderLayout borderLayout4 = new BorderLayout();
    JPanel jPanel4 = new JPanel();
    BorderLayout borderLayout5 = new BorderLayout();
    JPanel jPanel8 = new JPanel();
    TKButton btnRefresh = new TKButton();
    TKSWPNEDataStruct neData = null;
    Border border1;
    TitledBorder titledBorder1;
    JPanel jPanel6 = new JPanel();
    JLabel tfInfoOper = new JLabel();
    JPanel jPanel5 = new JPanel();
    JLabel tfNeInfo = new JLabel();
    BorderLayout borderLayout6 = new BorderLayout();
    JPanel jPanel7 = new JPanel();
    BorderLayout borderLayout7 = new BorderLayout();
    private static final int COL_BOARD = 0;
    private static final int COL_SOFTTYPE = 1;
    private static final int COL_RUNVER = 2;
    private static final int COL_PKGVER = 3;
    private String[] talbeColumn = new String[]{this.res.getString("BoardType"), this.res.getString("SoftType"), this.res.getString("TableTitleRunVer"), this.res.getString("TableTitleUpgradeVer")};
    private TKFilterTableModel bdTableModel = new TKFilterTableModel(this.talbeColumn);
    private TKFilterTable bdTable = new TKFilterTable(this.bdTableModel){

        @Override
        public String toTooltip(int row, int column) {
            TKDefaultTreeRow rowData = (TKDefaultTreeRow)TKSWPVersionDialog.this.bdTable.getRow(row);
            if (rowData.getObjectType() == TKSWPVersionDialog.this.BoardVersionType) {
                return TKComponentToolkit.formatToolTip(((CmBoardVerData)rowData).detailVer);
            }
            return null;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            TKDefaultTreeRow rowData = (TKDefaultTreeRow)TKSWPVersionDialog.this.bdTable.getRow(row);
            if (rowData.getObjectType() == TKSWPVersionDialog.this.SoftVersionType) {
                return TKSWPVersionDialog.this.colorRenderer;
            }
            return super.getCellRenderer(row, column);
        }

        @Override
        public Icon getIcon(int row) {
            TKDefaultTreeRow rowData = (TKDefaultTreeRow)this.getRow(row);
            if (rowData.getObjectType() == TKSWPVersionDialog.this.BoardObjectType) {
                return TKSWPVersionDialog.this.boardIcon;
            }
            return super.getIcon(row);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    };
    String title = this.res.getString("DlgTitleUpgradeVer");
    KeyAdapter escKa = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 27 || e.getKeyCode() == 10) {
                TKSWPVersionDialog.this.dispose();
            }
        }
    };

    public TKSWPVersionDialog(TKSWPNEDataStruct neData) {
        super(TKResourceManager.getMainFrame());
        this.setModal(true);
        this.neData = neData;
        this.setTitle(this.title);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        KeyAdapter escKa = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    TKSWPVersionDialog.this.dispose();
                }
            }
        };
        TKComponentToolkit.addAllKeyListener(this, "javax.swing.JComponent", escKa);
    }

    @Override
    public Component getMostRecentFocusOwner() {
        this.btnOk.requestFocus();
        return this.btnOk;
    }

    private void jbInit() throws Exception {
        Toolkit4T2kInterface inf = Toolkit4T2kInterfaceMgr.getInstance();
        if (inf != null) {
            try {
                inf.helpComponent(this.getContentPane(), "SWPVersion");
            }
            catch (Exception ex) {
                DCDebugTracer.trace(ex);
            }
        } else {
            TKHelpMgr.instance().helpRootPane(this.getRootPane());
            TKHelpMgr.instance().helpComponent(this, "SWPVersion");
        }
        this.bdTable.setExpandedIcon(this.boardIcon);
        this.bdTable.setCollapsedIcon(this.boardIcon);
        this.bdTable.setLeafIcon(TKTreeTableUI.blank_icon);
        this.bdTable.registerTooltipColumn(1);
        this.bdTable.registerTooltipColumn(2);
        this.bdTable.registerTooltipColumn(3);
        this.border1 = BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151));
        this.titledBorder1 = new TitledBorder(this.border1, "TitleUpgradeVersion");
        this.getContentPane().setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel2.setLayout(this.borderLayout3);
        this.btnOk.setText(this.res.getString("button_OK"));
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.tfInfoOper.setBorder(BorderFactory.createEmptyBorder());
        this.tfInfoOper.setText("");
        this.tfInfoOper.setBackground(this.jPanel1.getBackground());
        this.tfNeInfo.setBorder(BorderFactory.createEmptyBorder());
        this.tfNeInfo.setText("");
        this.tfNeInfo.setBackground(this.jPanel1.getBackground());
        this.jPanel3.setLayout(this.borderLayout4);
        this.jPanel4.setLayout(this.borderLayout5);
        this.jPanel5.setLayout(this.borderLayout6);
        this.jPanel7.setLayout(this.borderLayout7);
        this.btnRefresh.setText(this.res.getString("Refresh"));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.jPanel4, "South");
        this.jPanel4.add((Component)this.jPanel3, "East");
        this.jPanel3.add((Component)this.jPanel8, "East");
        this.jPanel8.add((Component)this.btnRefresh, null);
        this.jPanel8.add((Component)this.btnOk, null);
        this.jPanel4.add((Component)this.jPanel6, "West");
        this.jPanel6.add((Component)this.tfInfoOper, null);
        this.jPanel2.add((Component)this.jPanel5, "North");
        this.jPanel5.add((Component)this.tfNeInfo, "Center");
        this.jPanel2.add((Component)this.jPanel7, "Center");
        this.jPanel7.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.bdTable, null);
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 0, 5, 0));
        this.jPanel5.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.setSize(550, 400);
        TKScreenToolKit.centerLocateToScreen(this);
        this.queryVersionInfo();
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKSWPVersionDialog.this.queryVersionInfo();
            }
        });
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKSWPVersionDialog.this.dispose();
            }
        });
        TKComponentToolkit.addAllKeyListener(this, "javax.swing.JComponent", this.escKa);
    }

    private void queryVersionInfo() {
        if (this.neData == null) {
            return;
        }
        String neInfo = this.res.getString("NeName") + " : " + this.neData.nedata.neName + "    " + this.neData.nedata.neType + "    " + this.neData.runVer;
        this.tfNeInfo.setText(neInfo);
        if (this.neData.loadPkg == null || this.neData.loadPkg.getAbsolutePath().trim().equals("")) {
            TKOperationShowMgr.showOperationDlg((Component)this, this.res.getString("NtcNotSetPkg"), false);
            return;
        }
        new Thread(){

            @Override
            public void run() {
                TKSWPVersionDialog.this.setTitle(TKSWPVersionDialog.this.title + " - " + TKSWPVersionDialog.this.res.getString("WaitQueryVer") + "...");
                AsnTkPkgNeVerChkReq req = new AsnTkPkgNeVerChkReq();
                req.neID = BigInteger.valueOf(TKSWPVersionDialog.this.neData.nedata.neID);
                req.pkgFile = TKASNTool.toAsn1SoftInfo(TKSWPVersionDialog.this.neData.loadPkg);
                AsnTkPkgNeVerChkRsp rsp = new AsnTkPkgNeVerChkRsp();
                char cmdCode = '\u1e0e';
                byte receiveModule = 30;
                TKScreenToolKit.setComponentCursorBusy(TKSWPVersionDialog.this, true);
                TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, receiveModule, 240);
                TKScreenToolKit.setComponentCursorBusy(TKSWPVersionDialog.this, false);
                TKSWPVersionDialog.this.setTitle(TKSWPVersionDialog.this.title);
                if (!ret.isSuccess) {
                    TKOperationShowMgr.showOperationDlg((Component)TKSWPVersionDialog.this, ret.resultInfo, true);
                    return;
                }
                if (!rsp.ret.isSuccess) {
                    TKOperationShowMgr.showOperationDlg((Component)TKSWPVersionDialog.this, TKASNTool.getErrorInfo(rsp.ret), true);
                    return;
                }
                Iterator retItr = rsp.bdVerInfoList.iterator();
                if (null == retItr) {
                    TKDebug.inmAssert(false, TKSWPVersionDialog.this.res.getString("ReturnDataNull"));
                    return;
                }
                TKOperResultVector resultV = new TKOperResultVector();
                while (TKSWPVersionDialog.this.bdTableModel.getRowCount() > 0) {
                    TKDefaultTreeRow rowData = (TKDefaultTreeRow)TKSWPVersionDialog.this.bdTableModel.getRow(0);
                    TKSWPVersionDialog.this.bdTableModel.removeRow(rowData);
                }
                TKSWPVersionDialog.this.bdTable.repaint();
                while (retItr.hasNext()) {
                    AsnTkPkgBdVerInfo asnRtn = (AsnTkPkgBdVerInfo)retItr.next();
                    if (!asnRtn.ret.isSuccess) {
                        String operObj = TKSWPVersionDialog.this.neData.nedata.neName + "-" + asnRtn.slotID + "-" + new String(asnRtn.boardName);
                        String operResult = TKSWPVersionDialog.this.res.getString("VerCheckFail");
                        String operReason = TKASNTool.getErrorInfo(asnRtn.ret);
                        TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                        resultV.addElement(struct);
                        continue;
                    }
                    TKSWPVersionDialog.this.addBoardRows(asnRtn);
                }
                TKSWPVersionDialog.this.bdTable.repaint();
                if (resultV.size() > 0) {
                    TKOperationShowMgr.showOperationDlg((Component)TKSWPVersionDialog.this, TKSWPVersionDialog.this.res.getString("OperResult"), resultV);
                }
            }
        }.start();
    }

    private void addBoardRows(AsnTkPkgBdVerInfo bdVerInfo) {
        CmBoardData board = new CmBoardData();
        board.boardName = new String(bdVerInfo.boardName);
        board.slotID = bdVerInfo.slotID.intValue();
        this.bdTableModel.addRow(board);
        CmBoardVerData boardVer = new CmBoardVerData();
        board.insertChild(boardVer);
        if (bdVerInfo.ret.isSuccess) {
            boardVer.detailVer = new String(bdVerInfo.detailVer);
            this.addVersionRows((Vector)bdVerInfo.softVerList, board);
        } else {
            boardVer.detailVer = this.res.getString("ErrInfo") + " : " + TKRes.getErrorInfo(bdVerInfo.ret);
        }
    }

    private void addVersionRows(Vector verList, CmBoardData board) {
        Iterator retItr = verList.iterator();
        if (null == retItr) {
            TKDebug.inmAssert(false, this.res.getString("ReturnDataNull"));
            return;
        }
        while (retItr.hasNext()) {
            AsnTkSoftVerInfo asnRtn = (AsnTkSoftVerInfo)retItr.next();
            CmVerData verNode = new CmVerData();
            verNode.isSame = asnRtn.isSame;
            verNode.pkgVer = new String(asnRtn.loadVer);
            verNode.runVer = new String(asnRtn.runVer);
            verNode.softType = new String(asnRtn.softType);
            board.insertChild(verNode);
        }
    }

    class ColorCellRenderer
    extends DefaultTableCellRenderer {
        ColorCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TKDefaultTreeRow rowData = (TKDefaultTreeRow)TKSWPVersionDialog.this.bdTable.getRow(row);
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setForeground(table.getForeground());
            }
            if (rowData.getObjectType() == TKSWPVersionDialog.this.SoftVersionType && !((CmVerData)rowData).isSame) {
                this.setForeground(TKSWPLoadTablePanel.alterColorHigh);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    class CmVerData
    extends TKDefaultTreeRow {
        public String softType = "";
        public String runVer = "";
        public String pkgVer = "";
        public boolean isSame = true;

        CmVerData() {
        }

        @Override
        public boolean paintIcon() {
            return false;
        }

        @Override
        public int getObjectType() {
            return TKSWPVersionDialog.this.SoftVersionType;
        }

        @Override
        public Object getValueAt(int column) {
            String retValue = "";
            switch (column) {
                case 1: {
                    retValue = this.softType;
                    break;
                }
                case 3: {
                    retValue = this.pkgVer;
                    break;
                }
                case 2: {
                    retValue = this.runVer;
                    break;
                }
            }
            return retValue;
        }
    }

    class CmBoardVerData
    extends TKDefaultTreeRow {
        public String detailVer = "";

        CmBoardVerData() {
        }

        @Override
        public int getObjectType() {
            return TKSWPVersionDialog.this.BoardVersionType;
        }

        @Override
        public int minMixColumn() {
            return 1;
        }

        @Override
        public Object getValueAt(int column) {
            if (column == this.minMixColumn()) {
                String retValue = this.detailVer;
                return retValue;
            }
            return "";
        }

        @Override
        public boolean paintIcon() {
            return false;
        }

        @Override
        public boolean mixColumns() {
            return true;
        }
    }

    class CmBoardData
    extends TKDefaultTreeRow {
        public int slotID = 0;
        public String boardName = "";

        CmBoardData() {
        }

        @Override
        public Object getValueAt(int column) {
            String retValue = this.slotID + "-" + this.boardName;
            return retValue;
        }

        @Override
        public int getObjectType() {
            return TKSWPVersionDialog.this.BoardObjectType;
        }

        @Override
        public boolean mixColumns() {
            return true;
        }
    }
}

