/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.swpload;

import com.huawei.dc.toolkit.client.base.communicate.TKCommUtility;
import com.huawei.dc.toolkit.client.base.communicate.TKCommandResult;
import com.huawei.dc.toolkit.client.base.util.TKFile;
import com.huawei.dc.toolkit.client.base.util.TKFileUtilities;
import com.huawei.dc.toolkit.client.base.util.TKFtpStruct;
import com.huawei.dc.toolkit.client.base.util.TKNameValuePair;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.component.TKButton;
import com.huawei.dc.toolkit.client.base.util.component.TKComboxRenderer;
import com.huawei.dc.toolkit.client.base.util.component.TKComponentToolkit;
import com.huawei.dc.toolkit.client.base.util.component.TKDialog;
import com.huawei.dc.toolkit.client.base.util.filechooser.TKFileChooser;
import com.huawei.dc.toolkit.client.base.util.filechooser.TKFileFilter;
import com.huawei.dc.toolkit.client.base.util.help.TKHelpMgr;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultStruct;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultVector;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperationShowMgr;
import com.huawei.dc.toolkit.client.base.util.sorttable.TKSortTable;
import com.huawei.dc.toolkit.client.base.util.sorttable.TKSortTableModel;
import com.huawei.dc.toolkit.client.base.util.text.TKCodeContent;
import com.huawei.dc.toolkit.client.te.toolkit.swpload.TKSWPBoardDataStruct;
import com.huawei.dc.toolkit.client.te.toolkit.swpload.TKSWPBoardFilesDialog;
import com.huawei.dc.toolkit.client.te.toolkit.swpload.TKSWPRes;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKASNTool;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKConfirmOperationDlg;
import com.huawei.dc.toolkit.control.Toolkit4T2kInterface;
import com.huawei.dc.toolkit.control.Toolkit4T2kInterfaceMgr;
import com.huawei.te.toolkit.AsnToolkitGetFileVerReq;
import com.huawei.te.toolkit.AsnToolkitGetFileVerRet;
import com.huawei.te.toolkit.AsnToolkitGetFileVerRsp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.commustru.fstru.FStruct;

public class TKSWPRollbackBoardFileDialog
extends TKDialog {
    private static String UNKNOWN_VERSION = "unknown";
    private TKSWPRes res = TKSWPRes.instance();
    private Vector filesVector = new Vector();
    String[] tableColName = new String[]{this.res.getString("FileName"), this.res.getString("TableTilteFileVer"), this.res.getString("SoftType")};
    private static final int COL_FILE_NAME = 0;
    private static final int COL_FILE_VER = 1;
    private static final int COL_SOFT_TYPE = 2;
    private static final int COL_IS_LOAD = 3;
    private boolean is4SccBoard = false;
    private String mainVer = "";
    TKSortTableModel tableModel = new TKSortTableModel(this.tableColName, 0){

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (column == 2) {
                TKFtpStruct file = (TKFtpStruct)this.getValueAt(row, 0);
                TKNameValuePair softType = TKSWPRollbackBoardFileDialog.this.getSofttype(file);
                TKNameValuePair oldSoftType = (TKNameValuePair)this.getValueAt(row, 2);
                if (softType.value == -1) {
                    super.setValueAt(aValue, row, column);
                    return;
                }
                TKNameValuePair nvp = (TKNameValuePair)aValue;
                if (nvp.value == 0) {
                    super.setValueAt(aValue, row, column);
                    return;
                }
                if (!TKSWPRollbackBoardFileDialog.this.checkSoftType(file, nvp.value)) {
                    TKOperationShowMgr.showOperationDlg((Component)TKSWPRollbackBoardFileDialog.this, TKSWPRollbackBoardFileDialog.this.res.getString("SWPIncorrectSoftType"), false);
                    if (oldSoftType.value != softType.value && oldSoftType.value != 0) {
                        super.setValueAt(softType, row, column);
                    }
                } else {
                    super.setValueAt(aValue, row, column);
                }
            } else {
                super.setValueAt(aValue, row, column);
            }
        }
    };
    TKSortTable fileTable = new TKSortTable(this.tableModel){

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            if (column == 2) {
                return new TKComboxRenderer();
            }
            return new FileNameCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            if (column == 2) {
                return new DefaultCellEditor(TKSWPRollbackBoardFileDialog.this.getSoftTypeComboBox());
            }
            return super.getCellEditor();
        }

        @Override
        public String toTooltip(int row, int column) {
            String tooltip = TKComponentToolkit.formatToolTip(this.getValueAt(row, column).toString());
            return tooltip;
        }
    };
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    JLabel jLabel1 = new JLabel();
    JPanel jPanel4 = new JPanel();
    BorderLayout borderLayout4 = new BorderLayout();
    JPanel jPanel5 = new JPanel();
    JPanel jPanel6 = new JPanel();
    TKButton btnRemove = new TKButton();
    TKButton btnAdd = new TKButton();
    TKButton btnOK = new TKButton();
    TKButton btnCancel = new TKButton();
    FlowLayout flowLayout2 = new FlowLayout(0);
    FlowLayout flowLayout3 = new FlowLayout(2);
    BorderLayout borderLayout5 = new BorderLayout();
    Insets marg = new Insets(1, 10, 1, 10);
    private TKNameValuePair bdAutoTypeNVP = new TKNameValuePair(0, this.res.getString("Auto"));
    private TKNameValuePair bdSoftType1NVP = new TKNameValuePair(5, this.res.getString("RollbackBdSoftType1"));
    private TKNameValuePair bdSoftType2NVP = new TKNameValuePair(6, this.res.getString("RollbackBdSoftType2"));
    private static final int NESoftType1 = 1;
    private static final int NESoftType2 = 2;
    private static final int NESoftType3 = 3;
    private static final int NESoftType4 = 4;
    private static final int AutoSoftType = 0;
    private TKNameValuePair neAutoTypeNVP = new TKNameValuePair(0, this.res.getString("Auto"));
    private TKNameValuePair neSoftType1 = new TKNameValuePair(1, this.res.getString("RollbackNESoftType1"));
    private TKNameValuePair neSoftType2 = new TKNameValuePair(2, this.res.getString("RollbackNESoftType2"));
    private TKNameValuePair neSoftType3 = new TKNameValuePair(3, this.res.getString("RollbackNESoftType3"));
    private TKNameValuePair neSoftType4 = new TKNameValuePair(4, this.res.getString("RollbackNESoftType4"));
    private TKNameValuePair defaultTypeNVP = new TKNameValuePair(-1, this.res.getString("Default"));
    JComboBox softTypeComBox = new JComboBox();
    private int operationResult = 1;
    private TKSWPBoardDataStruct[] setDatas = null;
    private boolean isSupportAuto = true;
    private String title = this.res.getString("DlgTitleRollbackBoardFileSetting");
    ActionListener removeAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selectRows = TKSWPRollbackBoardFileDialog.this.fileTable.getSelectedRows();
            if (selectRows == null || selectRows.length == 0) {
                return;
            }
            Arrays.sort(selectRows);
            for (int i = selectRows.length - 1; i >= 0; --i) {
                TKSWPRollbackBoardFileDialog.this.filesVector.remove(TKSWPRollbackBoardFileDialog.this.tableModel.getValueAt(selectRows[i], 0));
                TKSWPRollbackBoardFileDialog.this.tableModel.removeRow(selectRows[i]);
            }
        }
    };
    ActionListener addAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int result;
            TKFileChooser fc = new TKFileChooser();
            fc.setMultiSelectionEnabled(true);
            int rowCount = TKSWPRollbackBoardFileDialog.this.fileTable.getRowCount();
            if (rowCount > 0) {
                TKFtpStruct file = (TKFtpStruct)TKSWPRollbackBoardFileDialog.this.fileTable.getValueAt(rowCount - 1, 0);
                if (file.isFtp) {
                    if (file.getPath().startsWith("ftp") || file.getPath().startsWith("sftp")) {
                        file = TKFileUtilities.parseFTPPath(file.getPath());
                    }
                    fc.initFtp(file.ftpIP, file.ftpPort, file.ftpUser, file.ftpPass);
                    fc.setBrowseType(100);
                }
                fc.setCurrentDirectory(TKFileUtilities.getParent(file));
            }
            if ((result = fc.showFileDialog()) != 0) {
                return;
            }
            TKSWPRollbackBoardFileDialog.this.addNewLoadFiles(fc.getSelectedFiles());
        }
    };

    public TKSWPRollbackBoardFileDialog(TKSWPBoardDataStruct[] setDatas) {
        super(TKResourceManager.getMainFrame());
        this.setTitle(this.title);
        this.setModal(true);
        this.setDatas = setDatas;
        this.checkBoard();
        this.initSoftType();
        this.jbInit();
        KeyAdapter escKa = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    TKSWPRollbackBoardFileDialog.this.dispose();
                }
            }
        };
        TKComponentToolkit.addAllKeyListener(this, "javax.swing.JComponent", escKa);
        TKScreenToolKit.centerLocateToScreen(this);
    }

    @Override
    public Component getMostRecentFocusOwner() {
        if (this.btnAdd.isEnabled()) {
            this.btnAdd.requestFocus();
            return this.btnAdd;
        }
        this.btnCancel.requestFocus();
        return this.btnCancel;
    }

    private void jbInit() {
        this.setSize(500, 400);
        Toolkit4T2kInterface inf = Toolkit4T2kInterfaceMgr.getInstance();
        if (inf != null) {
            inf.helpComponent(this.getContentPane(), "SWPRollbackBoardSet");
        } else {
            TKHelpMgr.instance().helpRootPane(this.getRootPane());
            TKHelpMgr.instance().helpComponent(this, "SWPRollbackBoardSet");
        }
        this.fileTable.addColumnSortAction(2);
        this.fileTable.addColumnSortAction(1);
        this.fileTable.registerTooltipColumn(0);
        this.getContentPane().setLayout(this.borderLayout1);
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 12));
        this.jPanel1.setLayout(this.borderLayout3);
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 12, 5, 12));
        this.jPanel2.setLayout(this.borderLayout4);
        this.jPanel3.setLayout(this.borderLayout2);
        this.jLabel1.setText(this.res.getString("DescBoardFileSetting"));
        this.jLabel1.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.btnRemove.setText(this.res.getString("ButtonRemoveSelectFile"));
        this.btnAdd.setText(this.res.getString("ButtonAdd") + "...");
        this.btnOK.setText(this.res.getString("Ok"));
        this.btnCancel.setText(this.res.getString("Cancel"));
        this.btnAdd.setMargin(this.marg);
        this.btnRemove.setMargin(this.marg);
        this.btnOK.setMargin(this.marg);
        this.btnCancel.setMargin(this.marg);
        this.jPanel4.setLayout(this.borderLayout5);
        this.jPanel5.setLayout(this.flowLayout3);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jPanel3, "Center");
        this.jPanel3.add((Component)new JScrollPane(this.fileTable), "Center");
        this.jPanel3.add((Component)this.jLabel1, "North");
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.jPanel4, "Center");
        this.jPanel4.add((Component)this.jPanel6, "West");
        this.jPanel6.setLayout(this.flowLayout2);
        this.jPanel6.add((Component)this.btnRemove, null);
        this.jPanel6.add((Component)this.btnAdd, null);
        this.jPanel4.add((Component)this.jPanel5, "East");
        this.jPanel5.add((Component)this.btnOK, null);
        this.jPanel5.add((Component)this.btnCancel, null);
        this.btnAdd.setName("_Button_Add");
        this.btnRemove.setName("_Button_Remove");
        this.btnOK.setName("_Button_OK");
        this.btnCancel.setName("_Button_Cancel");
        this.fileTable.setName("_Table_FileList");
        this.btnRemove.setEnabled(false);
        this.initAction();
        this.initData();
    }

    private void initAction() {
        this.btnRemove.addActionListener(this.removeAction);
        this.btnAdd.addActionListener(this.addAction);
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKSWPRollbackBoardFileDialog.this.setData();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKSWPRollbackBoardFileDialog.this.operationResult = -1;
                TKSWPRollbackBoardFileDialog.this.dispose();
            }
        });
        this.fileTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TKSWPRollbackBoardFileDialog.this.btnRemove.setEnabled(TKSWPRollbackBoardFileDialog.this.fileTable.getSelectedRowCount() > 0);
            }
        });
    }

    private void initData() {
        if (this.setDatas == null || this.setDatas.length == 0 || this.setDatas.length > 1) {
            return;
        }
        if (this.setDatas[0] != null) {
            this.mainVer = this.setDatas[0].rollbackPkgVer;
            this.addLoadFiles(this.setDatas[0].rbackFileList);
        }
    }

    private boolean checkSoftType(TKFile file, int softType) {
        TKFileFilter fileFilter = TKSWPBoardFilesDialog.getFileFilter(this.is4SccBoard, softType);
        if (!this.is4SccBoard) {
            if (softType == this.bdSoftType1NVP.value) {
                fileFilter = TKSWPBoardFilesDialog.getFileFilter(this.is4SccBoard, TKSWPBoardFilesDialog.bdSoftType1NVP.value);
            } else if (softType == this.bdSoftType2NVP.value) {
                fileFilter = TKSWPBoardFilesDialog.getFileFilter(this.is4SccBoard, TKSWPBoardFilesDialog.bdSoftType2NVP.value);
            }
        }
        if (fileFilter != null) {
            return fileFilter.accept(file);
        }
        return true;
    }

    private TKNameValuePair getSofttype(TKFile file) {
        if (file == null) {
            return this.defaultTypeNVP;
        }
        int autoSoftType_ = 0;
        int fileSoftType = file.softType;
        autoSoftType_ = this.is4SccBoard ? TKSWPBoardFilesDialog.neAutoTypeNVP.value : TKSWPBoardFilesDialog.bdAutoTypeNVP.value;
        TKFileFilter autoFileFilter = TKSWPBoardFilesDialog.getFileFilter(this.is4SccBoard, autoSoftType_);
        if (autoFileFilter.accept(file)) {
            if (this.is4SccBoard) {
                if (fileSoftType > 0) {
                    switch (fileSoftType) {
                        case 1: {
                            return this.neSoftType1;
                        }
                        case 2: {
                            return this.neSoftType2;
                        }
                        case 3: {
                            return this.neSoftType3;
                        }
                        case 4: {
                            return this.neSoftType4;
                        }
                    }
                }
                if (TKSWPBoardFilesDialog.getFileFilter(this.is4SccBoard, 2).accept(file)) {
                    return this.neSoftType2;
                }
                if (TKSWPBoardFilesDialog.getFileFilter(this.is4SccBoard, 1).accept(file)) {
                    return this.neSoftType1;
                }
                if (TKSWPBoardFilesDialog.getFileFilter(this.is4SccBoard, 3).accept(file)) {
                    return this.neSoftType3;
                }
                if (TKSWPBoardFilesDialog.getFileFilter(this.is4SccBoard, 4).accept(file)) {
                    return this.neSoftType4;
                }
            } else {
                if (TKSWPBoardFilesDialog.getFileFilter(this.is4SccBoard, TKSWPBoardFilesDialog.bdSoftType1NVP.value).accept(file)) {
                    return this.bdSoftType1NVP;
                }
                if (TKSWPBoardFilesDialog.getFileFilter(this.is4SccBoard, TKSWPBoardFilesDialog.bdSoftType2NVP.value).accept(file)) {
                    return this.bdSoftType2NVP;
                }
            }
        }
        return this.defaultTypeNVP;
    }

    private void setData() {
        if (this.fileTable.getRowCount() == 0) {
            TKConfirmOperationDlg confDlg = new TKConfirmOperationDlg(TKResourceManager.getMainFrame(), this.res.getString("Hint"), this.res.getString("NoticNotSelectBoardSoft"), null, true, false);
            confDlg.setDefaultCloseOperation(2);
            int willContinue = confDlg.showDialog();
            if (willContinue == 1) {
                return;
            }
            for (int i = 0; i < this.setDatas.length; ++i) {
                if (this.setDatas[i] == null) continue;
                this.setDatas[i].rbackFileList = null;
                this.setDatas[i].rollbackPkgVer = "";
            }
            this.operationResult = 0;
            this.dispose();
            return;
        }
        int rowCount = this.fileTable.getRowCount();
        TKFile[] loadFileList = new TKFtpStruct[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            TKFtpStruct file = (TKFtpStruct)this.fileTable.getValueAt(i, 0);
            TKNameValuePair softType = (TKNameValuePair)this.fileTable.getValueAt(i, 2);
            file.softType = softType.value;
            if (null == loadFileList) continue;
            loadFileList[i] = file;
        }
        TKConfirmOperationDlg confDlg = new TKConfirmOperationDlg(TKResourceManager.getMainFrame(), this.res.getString("Hint"), this.res.getString("ConfirmFileType"), null, true, false);
        confDlg.setDefaultCloseOperation(2);
        int willContinue = confDlg.showDialog();
        if (willContinue == 1) {
            return;
        }
        if (null != loadFileList && loadFileList.length > 0 && !this.queryLoadFileVersion(loadFileList)) {
            return;
        }
        if (this.setDatas != null) {
            for (int i = 0; i < this.setDatas.length; ++i) {
                if (this.setDatas[i] == null) continue;
                this.setDatas[i].rbackFileList = loadFileList;
                this.setDatas[i].rollbackPkgVer = this.mainVer;
            }
        }
        this.operationResult = 0;
        this.dispose();
    }

    private void initSoftType() {
        if (!this.is4SccBoard) {
            if (this.isSupportAuto) {
                this.softTypeComBox.addItem(this.bdAutoTypeNVP);
            }
            this.softTypeComBox.addItem(this.bdSoftType1NVP);
            this.softTypeComBox.addItem(this.bdSoftType2NVP);
        } else {
            if (this.isSupportAuto) {
                this.softTypeComBox.addItem(this.neAutoTypeNVP);
            }
            this.softTypeComBox.addItem(this.neSoftType1);
            this.softTypeComBox.addItem(this.neSoftType2);
            this.softTypeComBox.addItem(this.neSoftType3);
            this.softTypeComBox.addItem(this.neSoftType4);
        }
    }

    private JComboBox getSoftTypeComboBox() {
        return this.softTypeComBox;
    }

    private void addNewLoadFiles(final TKFile[] loadFileList) {
        new Thread(){

            @Override
            public void run() {
                TKSWPRollbackBoardFileDialog.this.queryLoadFileVersion(loadFileList);
                TKSWPRollbackBoardFileDialog.this.addLoadFiles(loadFileList);
            }
        }.start();
    }

    public void addLoadFiles(TKFile[] files) {
        if (files == null || files.length == 0) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            TKFile file = files[i];
            if (file == null || this.filesVector.contains(file)) continue;
            this.filesVector.add(file);
            Vector<Object> rowData = new Vector<Object>();
            rowData.add(file);
            rowData.add(file.softVersion);
            if (!this.isSupportAuto) {
                TKNameValuePair nvp = this.getSofttype(file);
                if (nvp.value == -1) {
                    rowData.add(this.softTypeComBox.getItemAt(0));
                } else {
                    rowData.add(nvp);
                }
            } else {
                rowData.add(this.getSoftTypeObject(file.softType));
            }
            this.tableModel.addRow(rowData);
        }
        this.fileTable.repaint();
    }

    public int getResultOption() {
        return this.operationResult;
    }

    private Object getSoftTypeObject(int softType) {
        int itemCount = this.softTypeComBox.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            TKNameValuePair nvp = (TKNameValuePair)this.softTypeComBox.getItemAt(i);
            if (nvp.value != softType) continue;
            return nvp;
        }
        return this.softTypeComBox.getItemAt(0);
    }

    private void checkBoard() {
        if (this.setDatas == null) {
            return;
        }
        for (int i = 0; i < this.setDatas.length; ++i) {
            if (this.setDatas[i] == null) continue;
            int boardKind = this.setDatas[i].board.boardKind;
            if (boardKind == 1 || boardKind == 2) {
                this.is4SccBoard = true;
            }
            if (this.setDatas[i].isSupportAuto) continue;
            this.isSupportAuto = false;
        }
    }

    private boolean queryLoadFileVersion(TKFile[] files) {
        this.setTitle(this.title + " - " + this.res.getString("WaitQueryDbSoft"));
        AsnToolkitGetFileVerReq req = new AsnToolkitGetFileVerReq();
        for (int i = 0; i < files.length; ++i) {
            req.fileURLs.add((Object)files[i].getAbsolutePath().getBytes());
        }
        AsnToolkitGetFileVerRsp rsp = new AsnToolkitGetFileVerRsp();
        char cmdCode = '\u1705';
        byte receiveModule = 23;
        TKScreenToolKit.setComponentCursorBusy(this, true);
        TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, receiveModule, 120);
        if (!ret.isSuccess) {
            this.setTitle(this.title);
            TKScreenToolKit.setComponentCursorBusy(this, false);
            TKOperationShowMgr.showOperationDlg((Component)this.getParent(), ret.resultInfo, false);
            return false;
        }
        TKOperResultVector resultV = new TKOperResultVector();
        for (AsnToolkitGetFileVerRet retfile : rsp.fileVers) {
            String absolutePath = new String(retfile.fileName);
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getAbsolutePath().equals(absolutePath)) continue;
                files[i].softVersion = new String(retfile.fileVer);
            }
            if (retfile.ret.isSuccess) continue;
            String operObj = TKCodeContent.formatFtpPath(absolutePath);
            String operResult = this.res.getString("QueryVersionFail");
            String operReason = TKASNTool.getErrorInfo(retfile.ret);
            TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
            resultV.addElement(struct);
        }
        if (rsp.mainFileVer != null && rsp.mainFileVer.length > 0) {
            this.mainVer = new String(rsp.mainFileVer);
        }
        this.setTitle(this.title);
        if (resultV.size() > 0) {
            TKScreenToolKit.setComponentCursorBusy(this, false);
            TKOperationShowMgr.showOperationDlg((Component)this.getParent(), this.res.getString("OperResult"), resultV);
            return false;
        }
        TKScreenToolKit.setComponentCursorBusy(this, false);
        return true;
    }

    public static void main(String[] ars) {
        TKSWPRollbackBoardFileDialog dlg = new TKSWPRollbackBoardFileDialog(null);
        dlg.setDefaultCloseOperation(2);
        dlg.setVisible(true);
    }

    private class FileNameCellRenderer
    extends DefaultTableCellRenderer {
        JLabel label = new JLabel();

        private FileNameCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String showText = value.toString();
            if (value.getClass().getName().indexOf("TKFtpStruct") >= 0) {
                showText = ((TKFile)value).getName();
            }
            if (isSelected) {
                this.label.setOpaque(true);
                this.label.setBackground(table.getSelectionBackground());
                this.label.setForeground(table.getSelectionForeground());
            } else {
                this.label.setOpaque(true);
                this.label.setBackground(table.getBackground());
                this.label.setForeground(table.getForeground());
            }
            this.label.setText(showText);
            return this.label;
        }
    }
}

