/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.swpload;

import com.huawei.dc.toolkit.client.base.util.TKCommonUtil;
import com.huawei.dc.toolkit.client.base.util.TKDebug;
import com.huawei.dc.toolkit.client.base.util.TKFile;
import com.huawei.dc.toolkit.client.base.util.TKLoadFileStruct;
import com.huawei.dc.toolkit.client.base.util.TKLogManager;
import com.huawei.dc.toolkit.client.base.util.TKNameValuePair;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.component.TKBlankRenderer;
import com.huawei.dc.toolkit.client.base.util.component.TKComponentToolkit;
import com.huawei.dc.toolkit.client.base.util.component.TKFileListEditor;
import com.huawei.dc.toolkit.client.base.util.component.TKFileListRenderer;
import com.huawei.dc.toolkit.client.base.util.component.TKGuageRenderer;
import com.huawei.dc.toolkit.client.base.util.component.TKInfoEditor;
import com.huawei.dc.toolkit.client.base.util.component.TKInfoRenderer;
import com.huawei.dc.toolkit.client.base.util.component.TKPopMenuItem;
import com.huawei.dc.toolkit.client.base.util.component.TKTooltipTable;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultVector;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperationShowMgr;
import com.huawei.dc.toolkit.client.te.toolkit.swpload.TKSWPBoardDataStruct;
import com.huawei.dc.toolkit.client.te.toolkit.swpload.TKSWPDataStruct;
import com.huawei.dc.toolkit.client.te.toolkit.swpload.TKSWPLoadTablePanel;
import com.huawei.dc.toolkit.client.te.toolkit.swpload.TKSWPRes;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKTableRowResizer;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TKSWPInfoTablePanel
extends JPanel {
    private int neID = -1;
    private int slotID = -1;
    TKSWPDataStruct data = null;
    private static TKSWPRes res = TKSWPRes.instance();
    JPopupMenu clearMenu = new JPopupMenu();
    boolean ifShowPopMenu = false;
    private TKPopMenuItem clearMenuItem = new TKPopMenuItem();
    TKSWPLoadTablePanel loadTablePanel;
    JScrollPane jScrollPane1 = new JScrollPane();
    String neObject = res.getString("NeName");
    String bdObject = res.getString("Board");
    String sccObject = res.getString("SccBoard");
    String[] colNames = new String[]{res.getString("Name"), res.getString("Value")};
    private static final int ROW_NENAME = 0;
    private static final int ROW_RUNVER = 1;
    private static final int ROW_GUAGE = 2;
    private static final int ROW_WAITLOADVER = 3;
    private static final int ROW_STARTTIME = 4;
    private static final int ROW_RESULTINFO = 5;
    Object[][] tableData2 = new Object[][]{{res.getString("NeName"), ""}, {res.getString("RunVerDetail"), ""}, {res.getString("Guage"), ""}, {res.getString("WaitLoadVer"), new TKLoadFileStruct()}, {res.getString("Start-EndTime"), ""}, {res.getString("OperResult"), ""}};
    DefaultTableModel infoTableModel = new DefaultTableModel(this.tableData2, this.colNames);
    TKGuageRenderer guageRender = new TKGuageRenderer(0, 100);
    TKInfoRenderer textrender = new TKInfoRenderer();
    TKInfoEditor texteditor = new TKInfoEditor();
    TKFileListEditor fileEditor = new TKFileListEditor();
    TKFileListRenderer fileRender = new TKFileListRenderer();
    TKTooltipTable infoTable = new TKTooltipTable(this.infoTableModel){

        @Override
        public boolean isCellEditable(int row, int column) {
            return row == 5 && column == 1 || row == 3 && column == 1;
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            if (row == 5 && column == 1) {
                return TKSWPInfoTablePanel.this.texteditor;
            }
            if (row == 3 && column == 1) {
                return TKSWPInfoTablePanel.this.fileEditor;
            }
            return super.getCellEditor(row, column);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            if (column == 1 && row == 2) {
                return TKSWPInfoTablePanel.this.guageRender;
            }
            if (column == 1 && row == 5) {
                return TKSWPInfoTablePanel.this.textrender;
            }
            if (row == 3 && column == 1) {
                return TKSWPInfoTablePanel.this.fileRender;
            }
            return new TKBlankRenderer();
        }

        @Override
        public String toTooltip(int row, int column) {
            if (row == 3 && column == 1) {
                TKLoadFileStruct waitLoadFile;
                if (null != TKSWPInfoTablePanel.this.infoTable.getCellEditor()) {
                    TKSWPInfoTablePanel.this.infoTable.getCellEditor().stopCellEditing();
                }
                if ((waitLoadFile = (TKLoadFileStruct)TKSWPInfoTablePanel.this.infoTableModel.getValueAt(3, 1)) == null || waitLoadFile.fileList().length == 0) {
                    return null;
                }
                TKFile[] files = waitLoadFile.fileList();
                if (files == null) {
                    return null;
                }
                StringBuffer tooltip = new StringBuffer("<html><body><table>");
                for (int j = 0; j < files.length; ++j) {
                    String softTip;
                    if (files[j] == null || files[j].toString().equals("") || tooltip.indexOf(softTip = "<tr><td>" + files[j].toString() + "</td><td color=red>" + files[j].softVersion + "</td></tr>") >= 0) continue;
                    tooltip.append(softTip);
                }
                tooltip.append("</table></body><html>");
                return tooltip.toString();
            }
            if (row == 1 && column == 1) {
                return TKComponentToolkit.formatToolTip(this.getValueAt(row, column).toString());
            }
            return "";
        }
    };
    TKTableRowResizer rowResize = new TKTableRowResizer(this.infoTable);
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JComboBox softTypeComBox = new JComboBox();
    private JComboBox loadAreaComBox = new JComboBox();
    private JComboBox statusComBox = new JComboBox();

    public TKSWPInfoTablePanel() {
        this.jbInit();
    }

    private void jbInit() {
        this.loadAreaComBox.addItem(new TKNameValuePair(1, "NeSoft1"));
        this.loadAreaComBox.addItem(new TKNameValuePair(2, "NeSoft2"));
        this.loadAreaComBox.setSelectedIndex(0);
        this.statusComBox.addItem(new TKNameValuePair(1, res.getString("NormState")));
        this.statusComBox.addItem(new TKNameValuePair(2, res.getString("ExcepState")));
        this.statusComBox.addItem(new TKNameValuePair(3, res.getString("CopyState")));
        this.statusComBox.addItem(new TKNameValuePair(4, res.getString("ActiveState")));
        this.statusComBox.addItem(new TKNameValuePair(5, res.getString("WaitActiveState")));
        this.statusComBox.addItem(new TKNameValuePair(6, res.getString("SwitchState")));
        this.statusComBox.addItem(new TKNameValuePair(7, res.getString("SynState")));
        this.statusComBox.setSelectedIndex(0);
        this.softTypeComBox.addItem(new TKNameValuePair(1, res.getString("NESoftType1")));
        this.softTypeComBox.addItem(new TKNameValuePair(2, res.getString("NESoftType2")));
        this.softTypeComBox.addItem(new TKNameValuePair(3, res.getString("NESoftType3")));
        this.softTypeComBox.addItem(new TKNameValuePair(4, res.getString("NESoftType4")));
        this.softTypeComBox.addItem(new TKNameValuePair(5, res.getString("Auto")));
        this.softTypeComBox.setSelectedIndex(0);
        this.guageRender.setValue(0);
        this.rowResize.addResizableRow(5);
        this.infoTable.registerTooltipRowAndColumn(3, 1);
        this.infoTable.registerTooltipRowAndColumn(1, 1);
        this.infoTable.setName("_Table_Detail");
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this.jScrollPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.infoTable, null);
        this.infoTable.getTableHeader().setReorderingAllowed(false);
        this.infoTable.setRowHeight(22);
        this.infoTable.setRowHeight(5, 209);
        this.infoTable.getColumnModel().getColumn(0).setMaxWidth(170);
        this.infoTable.getColumnModel().getColumn(0).setPreferredWidth(120);
        this.texteditor.getTextArea().add(this.createPopMenu());
        this.infoTable.add(this.createPopMenu());
        this.infoTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TKDebug.trace("1mousePressed");
                Point p = e.getPoint();
                int row = TKSWPInfoTablePanel.this.infoTable.rowAtPoint(p);
                if (row == 5) {
                    TKSWPInfoTablePanel.this.checkMouse(e, TKSWPInfoTablePanel.this.infoTable);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TKDebug.trace("1mouseReleased");
                Point p = e.getPoint();
                int row = TKSWPInfoTablePanel.this.infoTable.rowAtPoint(p);
                if (row == 5) {
                    TKSWPInfoTablePanel.this.checkMouse(e, TKSWPInfoTablePanel.this.infoTable);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                TKLogManager.writeToDebug("1mouseClicked");
                Point p = e.getPoint();
                int row = TKSWPInfoTablePanel.this.infoTable.rowAtPoint(p);
                if (row == 5) {
                    TKSWPInfoTablePanel.this.checkMouse(e, TKSWPInfoTablePanel.this.infoTable);
                }
            }
        });
        this.texteditor.getTextArea().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TKDebug.trace("mousePressed");
                TKSWPInfoTablePanel.this.checkMouse(e, TKSWPInfoTablePanel.this.texteditor.getTextArea());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TKDebug.trace("mouseReleased");
                TKSWPInfoTablePanel.this.checkMouse(e, TKSWPInfoTablePanel.this.texteditor.getTextArea());
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                TKDebug.trace("mouseClicked");
                TKSWPInfoTablePanel.this.checkMouse(e, TKSWPInfoTablePanel.this.texteditor.getTextArea());
            }
        });
    }

    public synchronized void updateTableData(TKSWPDataStruct data) {
        this.data = data;
        this.repaintTable();
    }

    public synchronized void repaintTable() {
        this.updateData();
    }

    private void updateData() {
        if (this.infoTable.getCellEditor() != null) {
            this.infoTable.getCellEditor().stopCellEditing();
        }
        if (this.data == null) {
            this.infoTable.setValueAt("", 0, 1);
            this.infoTable.setValueAt("", 1, 1);
            this.infoTable.setValueAt(new TKLoadFileStruct(), 3, 1);
            TKGuageRenderer guageRen = (TKGuageRenderer)this.infoTable.getCellRenderer(2, 1);
            guageRen.setValue(0);
            this.infoTable.setValueAt("", 4, 1);
            this.infoTable.setValueAt("", 5, 1);
        } else {
            this.setBasicInfo();
            TKLoadFileStruct loadFile = new TKLoadFileStruct();
            if (this.data.isSimulatePackageLoad()) {
                loadFile.update(this.data.loadedFileList);
            } else {
                loadFile.update(this.data.loadFileList);
            }
            if (this.data.getObjectType() == 1) {
                TKSWPBoardDataStruct bdData = (TKSWPBoardDataStruct)this.data;
                loadFile.setCurrentFile(bdData.currentLoadFile);
            }
            this.infoTableModel.setValueAt(loadFile, 3, 1);
            this.infoTableModel.setValueAt(this.data.resultInfo, 5, 1);
        }
    }

    private JPopupMenu createPopMenu() {
        this.clearMenu = new JPopupMenu();
        this.clearMenuItem.setText(res.getString("Clear"));
        this.clearMenu.add(this.clearMenuItem);
        this.clearMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKSWPInfoTablePanel.this.clearResultInfo();
            }
        });
        return this.clearMenu;
    }

    protected void clearResultInfo() {
        this.texteditor.getTextArea().setText("");
        this.data.resultInfo = "";
        this.updateObjectResult(this.data);
    }

    protected synchronized void updateObjectBasicInfo(TKSWPDataStruct data) {
        if (this.data == null || data == null) {
            return;
        }
        if (this.data.equals(data)) {
            this.setBasicInfo();
            this.infoTable.repaintRow(0, 2);
            this.infoTable.repaintRow(4);
        }
    }

    private void setBasicInfo() {
        if (this.data.getObjectType() == 1) {
            if (((TKSWPBoardDataStruct)this.data).isSCCBoard()) {
                this.infoTable.setValueAt(this.sccObject, 0, 0);
            } else {
                this.infoTable.setValueAt(this.bdObject, 0, 0);
            }
            TKSWPBoardDataStruct bdData = (TKSWPBoardDataStruct)this.data;
            String bdName = bdData.nedata.getNeName() + "-" + TKCommonUtil.getBoardName(bdData.board.slotID) + "-" + bdData.board.boardType;
            if (bdData.isSCCBoard()) {
                if (bdData.board.slotID <= 0) {
                    bdName = bdData.nedata.getNeName() + "-" + bdData.board.boardType;
                }
                if (!bdData.runArea.equals("NSF3")) {
                    bdName = bdName + "  " + bdData.runArea;
                }
            }
            this.infoTableModel.setValueAt(bdName, 0, 1);
        } else {
            this.infoTable.setValueAt(this.neObject, 0, 0);
            String neName = this.data.nedata.getNeName();
            this.infoTableModel.setValueAt(neName, 0, 1);
        }
        this.infoTable.setValueAt(this.data.runVerDetail, 1, 1);
        TKGuageRenderer guageRen = (TKGuageRenderer)this.infoTable.getCellRenderer(2, 1);
        if (this.data.guage <= 100 && this.data.guage >= 0) {
            guageRen.setValue(this.data.guage);
        } else {
            guageRen.setValue(0);
        }
        if (this.data.startTime.equals("")) {
            this.infoTableModel.setValueAt(this.data.startTime, 4, 1);
        }
        if (!this.data.startTime.equals("")) {
            this.infoTableModel.setValueAt(res.getString("StartTime:") + this.data.startTime + " ", 4, 1);
            if (!this.data.endTime.equals("")) {
                this.infoTableModel.setValueAt(res.getString("StartTime:") + this.data.startTime + " " + "   " + res.getString("EndTime:") + this.data.endTime + " ", 4, 1);
            }
        }
    }

    protected synchronized void updateObjectResult(TKSWPDataStruct data) {
        if (this.data == null || data == null) {
            return;
        }
        if (this.data.equals(data)) {
            if (this.infoTable.getEditingRow() == 5 && this.infoTable.getCellEditor() != null) {
                this.infoTable.getCellEditor().stopCellEditing();
            }
            this.infoTableModel.setValueAt(data.resultInfo, 5, 1);
            if (SwingUtilities.isEventDispatchThread()) {
                this.infoTable.repaint();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TKSWPInfoTablePanel.this.infoTable.repaint();
                    }
                });
            }
        }
    }

    protected synchronized void updateObjectResultAndPopupDlg(final TKSWPDataStruct data, final Container oTkInternalFrame, final String titleConcent, final TKOperResultVector resultV, final String sDialogFlag, final boolean bUpdateFileList) {
        if (this.data == null || data == null) {
            return;
        }
        if (this.data.equals(data)) {
            if (this.infoTable.getEditingRow() == 5 && this.infoTable.getCellEditor() != null) {
                this.infoTable.getCellEditor().stopCellEditing();
            }
            this.infoTableModel.setValueAt(data.resultInfo, 5, 1);
            if (SwingUtilities.isEventDispatchThread()) {
                this.infoTable.repaint();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TKSWPInfoTablePanel.this.infoTable.repaint();
                        if (bUpdateFileList) {
                            TKSWPInfoTablePanel.this.updateObjectFileList(data);
                        }
                        if (resultV.size() > 0) {
                            TKOperationShowMgr.showMutexOperationDlg((Component)oTkInternalFrame, titleConcent, resultV, sDialogFlag);
                        }
                    }
                });
            }
        }
    }

    protected synchronized void updateObjectFileList(TKSWPDataStruct data) {
        if (this.data == null || data == null) {
            return;
        }
        if (this.data.equals(data)) {
            TKLoadFileStruct loadFile = new TKLoadFileStruct();
            if (data.isSimulatePackageLoad()) {
                loadFile.update(data.loadedFileList);
            } else {
                loadFile.update(data.loadFileList);
            }
            if (data.getObjectType() == 1) {
                TKSWPBoardDataStruct bdData = (TKSWPBoardDataStruct)data;
                loadFile.setCurrentFile(bdData.currentLoadFile);
            }
            if (this.infoTable.getEditingRow() == 3 && this.infoTable.getCellEditor() != null) {
                this.infoTable.getCellEditor().stopCellEditing();
            }
            this.infoTableModel.setValueAt(loadFile, 3, 1);
            this.infoTable.repaintRow(3);
        }
    }

    public void setLoadTablePanel(TKSWPLoadTablePanel loadTablePanel) {
        this.loadTablePanel = loadTablePanel;
    }

    private void checkMouse(MouseEvent e, Container con) {
        if (e.isPopupTrigger()) {
            int x = e.getX();
            int y = e.getY();
            Point point = TKScreenToolKit.getPopupMenuShowupPosition(con, this.clearMenu, x, y);
            this.ifShowPopMenu = true;
            this.clearMenu.show(con, (int)point.getX(), (int)point.getY());
            if (this.data == null) {
                this.clearMenuItem.setEnabled(false);
                return;
            }
            this.texteditor.getTextArea().updateUI();
            if (this.data.resultInfo.trim().equals("")) {
                this.clearMenuItem.setEnabled(false);
            } else {
                this.clearMenuItem.setEnabled(true);
            }
        }
    }
}

