/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.sp;

import com.huawei.dc.toolkit.client.base.util.TKLogManager;
import com.huawei.dc.toolkit.client.base.util.TKNameValuePair;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultStruct;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultVector;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperationShowMgr;
import com.huawei.dc.toolkit.client.base.util.text.TKCodeContent;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKNeStruct;
import com.huawei.dc.toolkit.client.te.toolkit.sp.TKSPLoadDataStruct;
import com.huawei.dc.toolkit.client.te.toolkit.sp.TKSPLoadTablePaneDefInterface;
import com.huawei.te.toolkit.AsnOneReturn;
import com.huawei.te.toolkit.AsnTkMessageRpt;
import com.huawei.te.toolkit.AsnToolkitError;
import com.huawei.te.toolkit.AsnToolkitOneFileCopyResult;
import com.huawei.te.toolkit.AsnToolkitStateGuageRpt;
import java.awt.Component;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class TKSPLoadTablePaneDef
extends TKSPLoadTablePaneDefInterface {
    public synchronized TKSPLoadDataStruct getTableDatabyID(int neID) {
        int totalRow = this.tableModel.getRowCount();
        for (int row = 0; row < totalRow; ++row) {
            TKSPLoadDataStruct data = (TKSPLoadDataStruct)this.tableModel.getRow(row);
            if (data.nedata.neID != neID) continue;
            return data;
        }
        return null;
    }

    public synchronized void updateStatusGuageMsg(AsnToolkitStateGuageRpt info) {
        int neId = info.neID.intValue();
        int row = this.getTableRowbyID(neId);
        TKSPLoadDataStruct data = this.getTableDatabyID(neId);
        if (null == data) {
            TKLogManager.writeToDebug("updateStatusGuageMsg(" + neId + ") of TKSPLoadTablePane get data is null!");
            return;
        }
        int guageInt = info.guage.intValue();
        int stateInt = info.loadState.intValue();
        int oldstate = data.status;
        if (oldstate != 3 && oldstate != 4 && oldstate != 7 && oldstate != 6 && oldstate != 9) {
            if (oldstate != 911 && oldstate != 13 && oldstate != 14) {
                if (oldstate != 2) {
                    return;
                }
            }
        }
        int oldguage = data.guage;
        if (guageInt > 0 && guageInt < oldguage) {
            return;
        }
        data.guage = guageInt;
        data.status = stateInt;
        if (data.guage > 100 || data.guage < -1) {
            data.guage = 0;
        }
        if (row >= 0) {
            this.loadTable.repaintRow(row);
        }
        this.tkframe.infoTablePanel.updateObjectBasicInfo(data);
        if (stateInt != oldstate) {
            this.sp_processOperatorState();
        }
    }

    public synchronized int getTableRowbyID(int neID) {
        int totalRow = this.tableModel.getRowCount();
        int row = -1;
        for (int r = 0; r < totalRow; ++r) {
            TKSPLoadDataStruct data = (TKSPLoadDataStruct)this.tableModel.getRow(r);
            if (data.nedata.neID != neID) continue;
            row = r;
            break;
        }
        return row;
    }

    public void processFileReport(AsnToolkitOneFileCopyResult asnRtn, String dateInfo) {
        int neId = asnRtn.neID.intValue();
        int row = this.getTableRowbyID(neId);
        TKSPLoadDataStruct loadData = this.getTableDatabyID(neId);
        if (null == loadData || row < 0) {
            return;
        }
        loadData.currentfile = new String(asnRtn.fileNext);
        if (loadData.resultInfo.trim().length() > 1) {
            String tmp = loadData.resultInfo.endsWith("\n") ? "" : "\n";
            loadData.resultInfo = loadData.resultInfo + tmp;
        }
        loadData.resultInfo = loadData.resultInfo + dateInfo;
        if (asnRtn.ret.isSuccess) {
            String operResult = this.res.getString("CopyFileFinish");
            loadData.resultInfo = loadData.resultInfo + TKCodeContent.formatFtpPath(new String(asnRtn.fileName)) + "    " + operResult;
        } else {
            String operReason = TKRes.getErrorInfo(asnRtn.ret);
            loadData.resultInfo = loadData.resultInfo + TKCodeContent.formatFtpPath(new String(asnRtn.fileName)) + "    " + this.res.getString("CopyFileFail") + "    " + operReason;
        }
        this.loadTable.repaintRow(row);
        this.tkframe.infoTablePanel.updateObjectResult(loadData);
    }

    public Object[] processErrorMsg(AsnTkMessageRpt evtRpt, String dateInfo) {
        int neId = evtRpt.neID.intValue();
        int row = this.getTableRowbyID(neId);
        TKSPLoadDataStruct data = this.getTableDatabyID(neId);
        if (data == null || row < 0) {
            return null;
        }
        Iterator errorItr = evtRpt.msgList.iterator();
        TKOperResultVector resultV = new TKOperResultVector();
        while (errorItr.hasNext()) {
            AsnToolkitError error = (AsnToolkitError)errorItr.next();
            String operObj = data.nedata.neName;
            if (error.errCode.intValue() == 0x10001D) {
                String operRes = this.res.getString("SwitchGateway");
                TKOperationShowMgr.showOperationDlg((Component)this, operRes, false);
                return null;
            }
            String operResult = TKRes.getResultInfo(evtRpt);
            String operReason = TKRes.getErrorInfo(error, evtRpt.msgType.intValue());
            TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
            resultV.addElement(struct);
            if (data.resultInfo.trim().length() > 1) {
                String tmp = data.resultInfo.endsWith("\n") ? "" : "\n";
                data.resultInfo = data.resultInfo + tmp + dateInfo + operReason;
            } else {
                data.resultInfo = dateInfo + operReason;
            }
            this.tkframe.infoTablePanel.updateObjectResult(data);
        }
        if (resultV.size() > 0) {
            return resultV.toArray();
        }
        return null;
    }

    public synchronized void updateTableData(ArrayList dataList, boolean addNotExist) {
        if (dataList == null || dataList.size() == 0) {
            return;
        }
        for (int i = 0; i < dataList.size(); ++i) {
            TKSPLoadDataStruct data = (TKSPLoadDataStruct)dataList.get(i);
            if (data == null) continue;
            if (this.hasLoadData(data)) {
                this.replaceNeData(data);
                continue;
            }
            if (!addNotExist) continue;
            this.tableModel.addRow(data);
        }
        this.repaintTableAllRows();
    }

    public void deleteRowbyId(int neId) {
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().stopCellEditing();
        }
        this.loadTable.clearSelection();
        TKSPLoadDataStruct delData = this.getTableDatabyID(neId);
        if (delData != null) {
            this.tableModel.removeRow(delData);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TKSPLoadTablePaneDef.this.loadTable.repaint();
            }
        });
    }

    public boolean hasLoadData(TKSPLoadDataStruct data) {
        return this.tableModel.getDatas().contains(data);
    }

    private void replaceNeData(TKSPLoadDataStruct neData) {
        if (neData == null) {
            return;
        }
        int neId = neData.nedata.neID;
        TKSPLoadDataStruct replaceData = this.getTableDatabyID(neId);
        if (replaceData == null) {
            return;
        }
        replaceData.endTime = neData.endTime;
        replaceData.guage = neData.guage;
        replaceData.healthState = neData.healthState;
        replaceData.nedata = neData.nedata;
        replaceData.status = neData.status;
        replaceData.difGroup = neData.difGroup;
        replaceData.isFirstNode = neData.isFirstNode;
        replaceData.isSupDiffuse = neData.isSupDiffuse;
        if (neData.difGroup == 0) {
            replaceData.isFirstNode = false;
        }
        replaceData.runVer = neData.runVer;
        replaceData.startTime = neData.startTime;
        boolean isUpdateStatus = this.isUpdateWithServer(replaceData.status);
        if (isUpdateStatus) {
            replaceData.selectedProtocolType = neData.selectedProtocolType;
            if (replaceData.selectedProtocolType == 1) {
                replaceData.FTP_LoadFile = neData.FTP_LoadFile;
                replaceData.loadVer = neData.FTP_LoadFile.softVersion;
            } else if (replaceData.selectedProtocolType == 2) {
                replaceData.NORMAL_LoadFile = neData.NORMAL_LoadFile;
                replaceData.loadVer = neData.NORMAL_LoadFile.softVersion;
            } else {
                int n = replaceData.selectedProtocolType;
                this.getClass();
                if (n == 3) {
                    replaceData.group_LoadFile = neData.group_LoadFile;
                    replaceData.loadVer = neData.group_LoadFile.softVersion;
                }
            }
            replaceData.protocolType = neData.protocolType;
        }
    }

    public void updateNEInfo(TKNeStruct data) {
        int row = this.getTableRowbyID(data.neID);
        TKSPLoadDataStruct loadData = this.getTableDatabyID(data.neID);
        if (loadData == null) {
            TKLogManager.writeToDebug("updateNEInfo of TKSPLoadTablePane get loadData is null!");
            return;
        }
        loadData.nedata = data;
        this.updateTableObject(loadData, false);
        this.loadTable.repaintRow(row);
        this.tkframe.infoTablePanel.updateObjectBasicInfo(loadData);
    }

    public boolean hasWorkingObjects(TKOperResultVector resultVct, ArrayList groupDiffuse) {
        boolean working = false;
        int totalRow = this.tableModel.getRowCount();
        TKSPLoadDataStruct data = null;
        for (int row = 0; row < totalRow; ++row) {
            TKOperResultStruct oper;
            String operObj;
            data = (TKSPLoadDataStruct)this.tableModel.getRow(row);
            if (data.status != 1) {
                if (data.status != 912) {
                    if (data.status != 913) {
                        operObj = data.nedata.neName;
                        oper = new TKOperResultStruct(operObj, this.res.getString("Working"), data.getValueAt(3).toString());
                        resultVct.addElement(oper);
                        working = true;
                    }
                }
            }
            if (data.status != 1) {
                if (data.status != 912) {
                    if (data.status != 913) continue;
                }
            }
            if (data.difGroup == 0) continue;
            operObj = data.nedata.neName;
            oper = new TKOperResultStruct(operObj, this.res.getString("CreatedDiffuseGroup"), data.getValueAt(3).toString());
            resultVct.addElement(oper);
            working = true;
            if (groupDiffuse != null && groupDiffuse.size() != 0) {
                for (int i = 0; i < groupDiffuse.size(); ++i) {
                    if (BigInteger.valueOf(data.difGroup) == (BigInteger)groupDiffuse.get(i)) continue;
                    groupDiffuse.add(BigInteger.valueOf(data.difGroup));
                }
                continue;
            }
            if (groupDiffuse == null) continue;
            groupDiffuse.add(BigInteger.valueOf(data.difGroup));
        }
        return working;
    }

    public int getActNENumber(int[] rows) {
        Vector<String> vc1 = new Vector<String>();
        for (int i = 0; i < rows.length; ++i) {
            TKNameValuePair buttStateData = (TKNameValuePair)((Object)this.tableModel.getRow(rows[i]));
            int statusValue = buttStateData.value;
            TKSPLoadDataStruct data = (TKSPLoadDataStruct)this.tableModel.getRow(rows[i]);
            String neKey = String.valueOf(data.nedata.neID);
            if (vc1.contains(neKey) || statusValue != 5) continue;
            vc1.add(neKey);
        }
        return vc1.size();
    }

    public void clearNEResultInfo(int neID) {
        int row = this.getTableRowbyID(neID);
        TKSPLoadDataStruct loadData = this.getTableDatabyID(neID);
        if (row < 0 || loadData == null) {
            return;
        }
        loadData.resultInfo = "";
        if (loadData.status == 1) {
            loadData.startTime = "";
            loadData.endTime = "";
        }
        this.loadTable.repaintRow(row);
        this.tkframe.infoTablePanel.updateObjectBasicInfo(loadData);
        this.tkframe.infoTablePanel.updateObjectResult(loadData);
    }

    protected void updateTableObject(TKSPLoadDataStruct dataStruct, boolean updateMenu) {
        int[] selectedRows;
        if (dataStruct == null) {
            return;
        }
        int row = this.getTableRowbyID(dataStruct.nedata.neID);
        if (row < 0) {
            this.loadTable.repaint();
            return;
        }
        if (updateMenu && (selectedRows = this.loadTable.getSelectedRows()) != null && selectedRows.length > 0) {
            for (int i = 0; i < selectedRows.length; ++i) {
                if (selectedRows[i] != row) continue;
                this.sp_processOperatorState();
                break;
            }
        }
        this.loadTable.repaintRow(row);
    }

    protected void processFailureResult(TKOperResultVector resultV, ArrayList nedataList, String dateInfo, AsnOneReturn asnRtn) {
        if (asnRtn.id.intValue() == 0) {
            for (int i = 0; i < nedataList.size(); ++i) {
                TKSPLoadDataStruct data = (TKSPLoadDataStruct)nedataList.get(i);
                String operResult = this.res.getString("CreateGroupFail");
                String operReason = TKRes.getErrorInfo(asnRtn.ret);
                TKOperResultStruct struct = new TKOperResultStruct(data.nedata.neName, operResult, operReason);
                resultV.addElement(struct);
                if (data.resultInfo.trim().length() > 1) {
                    String tmp = data.resultInfo.endsWith("\n") ? "" : "\n";
                    data.resultInfo = data.resultInfo + tmp + dateInfo + operResult + "    " + operReason;
                } else {
                    data.resultInfo = data.resultInfo + dateInfo + operResult + "    " + operReason;
                }
                this.tkframe.infoTablePanel.updateObjectBasicInfo(data);
                this.tkframe.infoTablePanel.updateObjectResult(data);
            }
        } else {
            TKSPLoadDataStruct HideData = this.getTableDatabyID(asnRtn.id.intValue());
            if (!asnRtn.ret.isSuccess) {
                String operResult = this.res.getString("CreateGroupFail");
                String operReason = TKRes.getErrorInfo(asnRtn.ret);
                TKOperResultStruct struct = new TKOperResultStruct(HideData.nedata.neName, operResult, operReason);
                resultV.addElement(struct);
                if (HideData.resultInfo.trim().length() > 1) {
                    String tmp = HideData.resultInfo.endsWith("\n") ? "" : "\n";
                    HideData.resultInfo = HideData.resultInfo + tmp + dateInfo + operResult + "    " + operReason;
                } else {
                    HideData.resultInfo = HideData.resultInfo + dateInfo + operResult + "    " + operReason;
                }
                this.tkframe.infoTablePanel.updateObjectBasicInfo(HideData);
                this.tkframe.infoTablePanel.updateObjectResult(HideData);
            }
        }
    }

    protected void sp_cancelGroup() {
    }

    public TKSPLoadDataStruct queryDelState(int neID) {
        return null;
    }

    protected void cancelGroupONTableFailed(int groupID, String dateInfo, String operReason) {
        ArrayList groupDataList = this.getcurrentTableData();
        if (groupDataList == null) {
            return;
        }
        String operResult = this.res.getString("CancelGroupFail");
        for (int j = 0; j < groupDataList.size(); ++j) {
            TKSPLoadDataStruct data = (TKSPLoadDataStruct)groupDataList.get(j);
            if (data.difGroup != groupID) continue;
            if (data.resultInfo.trim().length() > 1) {
                String tmp = data.resultInfo.endsWith("\n") ? "" : "\n";
                data.resultInfo = data.resultInfo + tmp + dateInfo + operResult + "    " + operReason;
            } else {
                data.resultInfo = data.resultInfo + dateInfo + operResult + "    " + operReason;
            }
            this.tkframe.infoTablePanel.updateObjectResult(data);
        }
    }

    protected void cancelGroupONTable(int[] groupList, String dateInfo) {
        if (groupList == null || groupList.length == 0) {
            return;
        }
        ArrayList groupDataList = this.getcurrentTableData();
        if (groupDataList == null) {
            return;
        }
        for (int i = 0; i < groupList.length; ++i) {
            if (groupList[i] == 0) continue;
            for (int j = 0; j < groupDataList.size(); ++j) {
                TKSPLoadDataStruct data = (TKSPLoadDataStruct)groupDataList.get(j);
                if (data.difGroup != groupList[i]) continue;
                String operResult = this.res.getString("CancelOperResult");
                data.difGroup = 0;
                data.isFirstNode = false;
                if (data.resultInfo.trim().length() > 1) {
                    String tmp = data.resultInfo.endsWith("\n") ? "" : "\n";
                    data.resultInfo = data.resultInfo + tmp + dateInfo + operResult;
                } else {
                    data.resultInfo = data.resultInfo + dateInfo + operResult;
                }
                this.tkframe.infoTablePanel.updateObjectBasicInfo(data);
                this.tkframe.infoTablePanel.updateObjectResult(data);
            }
        }
    }

    public void updateNeLoginStatus(int neID, boolean isLogin) {
        int row = this.getTableRowbyID(neID);
        TKSPLoadDataStruct loadData = (TKSPLoadDataStruct)this.tableModel.getRow(row);
        String objectName = "(" + neID + ")";
        if (loadData == null) {
            TKLogManager.writeToDebug("updateNEInfo of TKSPLoadTablePane get loadData is null!");
            return;
        }
        objectName = "(" + neID + ")" + loadData.nedata.neName;
        loadData.nedata.isLogin = isLogin;
        this.updateTableObject(loadData, false);
        this.loadTable.repaintRow(row);
        this.tkframe.infoTablePanel.updateObjectBasicInfo(loadData);
        TKLogManager.writeToDebug(objectName + ".isLogin: " + isLogin);
    }
}

