/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.nemgr;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.TKCommonUtil;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKBoardStruct;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKNeStruct;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKNodeStruct;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKSubnetStruct;
import java.util.ArrayList;

public class TKTreeNodeProp
implements Comparable {
    public int fatherID = -1;
    public int nodeID = -1;
    public String nodeName = "";
    public int nodeType = -1;
    public String remark = "";
    public int selectState = 1;
    public boolean showState = true;
    public boolean labelFlag = false;
    public TKSubnetStruct subnetData = new TKSubnetStruct();
    public TKNeStruct nedata = new TKNeStruct();
    public TKBoardStruct board = new TKBoardStruct();
    public String nodeVersion = "";
    public boolean isExpanded = false;
    public boolean isSupport = true;

    public TKTreeNodeProp(TKNeStruct neData, TKBoardStruct board) {
        this.nedata = neData;
        this.board = board;
        this.nodeName = board.boardType.trim().equals("") ? String.valueOf(board.slotID) : board.slotID + "-" + board.boardType;
        this.fatherID = neData.neID;
        this.nodeID = board.slotID;
        this.nodeType = 2;
    }

    public TKTreeNodeProp(TKNeStruct neData) {
        this.nedata = neData;
        this.nodeName = neData.neName.trim().equals("") ? String.valueOf(neData.neID) : neData.neName;
        this.fatherID = neData.fatherID;
        this.nodeID = neData.neID;
        this.nodeType = 1;
        if (!"".equals(neData.actionVersion)) {
            this.nodeVersion = neData.actionVersion;
        }
    }

    public TKTreeNodeProp(TKSubnetStruct subnetData) {
        this.subnetData = subnetData;
        this.nodeName = subnetData.subnetName;
        this.fatherID = subnetData.fatherID;
        this.nodeID = subnetData.subnetID;
        this.nodeType = 5;
        this.remark = subnetData.subnetRemark;
    }

    public TKTreeNodeProp(String nodeName) {
        this.nodeName = nodeName;
    }

    public TKNodeStruct getNodeStruct() {
        TKNodeStruct nodeStruct = new TKNodeStruct();
        nodeStruct.boardKind = this.board.boardKind;
        nodeStruct.boardList = this.nedata.boardList;
        nodeStruct.fatherID = this.fatherID;
        nodeStruct.gatewayAddress = this.nedata.gatewayIP;
        nodeStruct.gatewayPort = this.nedata.ipPort + "";
        nodeStruct.gatewayType = this.nedata.gatewayType;
        nodeStruct.isGateway = this.nedata.isGateway;
        nodeStruct.isLogin = this.nedata.isLogin;
        nodeStruct.isSupport = this.nedata.isSupport;
        nodeStruct.isTL1NE = this.nedata.isTL1NE;
        nodeStruct.nePass = this.nedata.nePass;
        nodeStruct.neType = this.nedata.neType;
        nodeStruct.neUserName = this.nedata.neUserName;
        nodeStruct.nodeID = this.nodeID;
        nodeStruct.nodeName = this.nodeName;
        nodeStruct.nodeRemark = this.getRemark();
        nodeStruct.nodeType = this.nodeType;
        nodeStruct.nodeVersion = this.nodeVersion;
        nodeStruct.supportFuncIDList.addAll(this.nedata.supportList);
        return nodeStruct;
    }

    public void updateInfo(TKNodeStruct nodeStruct) {
        if (this.getNodeType() == 2) {
            this.board.boardKind = nodeStruct.boardKind;
        }
        if (this.getNodeType() == 1) {
            this.nedata.gatewayIP = nodeStruct.gatewayAddress;
            try {
                this.nedata.ipPort = Integer.parseInt(nodeStruct.gatewayPort);
            }
            catch (NumberFormatException e) {
                DCDebugTracer.trace(e);
            }
            this.nedata.gatewayType = nodeStruct.gatewayType;
            this.nedata.isGateway = nodeStruct.isGateway;
            this.nedata.isLogin = nodeStruct.isLogin;
            this.nedata.isSupport = nodeStruct.isSupport;
            this.nedata.isTL1NE = nodeStruct.isTL1NE;
            this.nedata.nePass = nodeStruct.nePass;
            this.nedata.neType = nodeStruct.neType;
            this.nedata.neUserName = nodeStruct.neUserName;
            ArrayList supportListTemp = new ArrayList(nodeStruct.supportFuncIDList);
            this.nedata.supportList.clear();
            this.nedata.supportList.addAll(supportListTemp);
        }
        this.setFatherID(nodeStruct.fatherID);
        this.setNodeName(nodeStruct.nodeName);
        this.setNodeType(nodeStruct.nodeType);
        this.setRemark(nodeStruct.nodeRemark);
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(int nodeType) {
        this.nodeType = nodeType;
    }

    public int getFatherID() {
        return this.fatherID;
    }

    public void setFatherID(int id) {
        this.fatherID = id;
        if (this.nodeType == 1) {
            this.nedata.fatherID = id;
        } else if (this.nodeType == 5) {
            this.subnetData.fatherID = id;
        }
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(int id) {
        this.nodeID = id;
        if (this.nodeType == 1) {
            this.nedata.neID = id;
        } else if (this.nodeType == 5) {
            this.subnetData.subnetID = id;
        } else if (this.nodeType == 2) {
            this.board.slotID = id;
        }
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
        if (this.nodeType == 1) {
            this.nedata.neName = nodeName;
        } else if (this.nodeType == 5) {
            this.subnetData.subnetName = nodeName;
        } else if (this.nodeType == 2) {
            this.board.boardType = nodeName;
        }
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
        if (this.nodeType == 5) {
            this.subnetData.subnetRemark = remark;
        }
    }

    public void setNodeVersion(String nodeVersion) {
        if (!"".equals(nodeVersion)) {
            this.nodeVersion = nodeVersion;
        }
    }

    public String getNodeVersion() {
        return this.nodeVersion;
    }

    public String toString() {
        if (this.nodeType == 1) {
            this.nodeName = this.nedata.neName.trim().equals("") ? String.valueOf(this.nedata.neID) : this.nedata.neName;
        } else if (this.nodeType == 2) {
            this.nodeName = this.board.boardType.trim().equals("") ? TKCommonUtil.getBoardName(this.board.slotID) : TKCommonUtil.getBoardName(this.board.slotID) + "-" + this.board.boardType;
        } else if (this.nodeType == 5) {
            this.nodeName = this.subnetData.subnetName;
        }
        return this.nodeName;
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof TKTreeNodeProp)) {
            return -1;
        }
        TKTreeNodeProp nodeProp = (TKTreeNodeProp)obj;
        if (nodeProp.nodeType == 2) {
            if (this.nodeType != 2) {
                return -1;
            }
            return this.nodeID - nodeProp.nodeID;
        }
        if (nodeProp.nodeType != this.nodeType) {
            if (nodeProp.nodeType == 1) {
                return -1;
            }
            if (nodeProp.nodeType == 5) {
                return 1;
            }
        } else {
            if (nodeProp.nodeType == 2) {
                return this.board.slotID - nodeProp.board.slotID;
            }
            return this.nodeName.compareTo(nodeProp.nodeName);
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TKTreeNodeProp)) {
            return false;
        }
        TKTreeNodeProp tkTreeNodeProp = (TKTreeNodeProp)obj;
        return this.fatherID == tkTreeNodeProp.getFatherID() && this.nodeID == tkTreeNodeProp.getNodeID() && this.nodeName.equals(tkTreeNodeProp.getNodeName()) && this.nodeType == tkTreeNodeProp.getNodeType() && this.remark.equals(tkTreeNodeProp.getRemark()) && this.selectState == tkTreeNodeProp.selectState && this.showState == tkTreeNodeProp.showState && this.labelFlag == tkTreeNodeProp.labelFlag && this.subnetData.equals(tkTreeNodeProp.subnetData) && this.nedata.equals(tkTreeNodeProp.nedata) && this.board.equals(tkTreeNodeProp.board) && this.nodeVersion.equals(tkTreeNodeProp.nodeVersion);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (null == this.nedata ? 0 : this.nedata.neID);
        return result;
    }
}

