/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.nemgr;

import com.huawei.dc.toolkit.client.base.util.TKLogManager;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.sorttable.TKDataSort;
import com.huawei.dc.toolkit.client.te.toolkit.TKMainRes;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKBoardStruct;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKNeStruct;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKDeviceFactory;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKDeviceInterface;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKFilterCond;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKNodeCellRenderer;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKNodeStruct;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKObjectTreeNode;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKPopupMenuMgr;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKSubnetStruct;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKTreeCellEditor;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKTreeMgrDef;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKTreeNodeProp;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKTreePanel;
import com.huawei.dc.toolkit.integration.TEToolkitModule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TKTreeMgr
extends TKTreeMgrDef
implements TKDeviceInterface {
    public static final int ROOT_NODE_ID = 0;
    private static ArrayList oBoardList = new ArrayList();

    public void dispose() {
        if (null != this.treePanel) {
            this.treePanel = null;
        }
        TKDeviceFactory.instance().removeDeviceInterface(this);
    }

    TKTreeMgr(TKTreePanel treePanel, int operationType) {
        this.jTree.setName("_Tree_Object");
        this.jTree.setModel(this.jTree.getModel());
        this.treePanel = treePanel;
        this.operationType = operationType;
        this.popupMenuMgr = new TKPopupMenuMgr(this, operationType);
        this.jTree.setToolTipText("");
        TKNodeCellRenderer ceRenderer = new TKNodeCellRenderer(this);
        this.jTree.setCellRenderer(ceRenderer);
        TKTreeCellEditor cellEditor = new TKTreeCellEditor(this);
        this.jTree.setCellEditor(cellEditor);
        this.jTree.setEditable(true);
        this.jTree.getSelectionModel().setSelectionMode(1);
        this.jTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                JTree tree = (JTree)e.getSource();
                tree.stopEditing();
                TreePath path = e.getPath();
                TKObjectTreeNode node = (TKObjectTreeNode)path.getLastPathComponent();
                TKTreeNodeProp prop = (TKTreeNodeProp)node.getUserObject();
                prop.labelFlag = true;
            }
        });
        this.jTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int row;
                Point p = e.getPoint();
                Component o = TKTreeMgr.this.jTree.getComponentAt(p);
                if (o instanceof JPanel || o instanceof JTree) {
                    TKTreeMgr.this.showPopupMenu(e);
                }
                if (e.getButton() == 1 && (row = TKTreeMgr.this.jTree.getRowForLocation(p.x, p.y)) >= 0) {
                    TreePath selectPath = TKTreeMgr.this.jTree.getPathForRow(row);
                    TKObjectTreeNode nd = (TKObjectTreeNode)selectPath.getLastPathComponent();
                    TKTreeMgr.this.doTreeSelectAction(nd);
                }
            }
        });
        this.jTree.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                TKTreeMgr.this.treeTooltipText = null;
                int row = TKTreeMgr.this.jTree.getRowForLocation(e.getX(), e.getY());
                if (row < 0) {
                    TKTreeMgr.this.treeTooltipText = TKTreeMgr.this.treeFilterText;
                    return;
                }
                TreePath treePath = TKTreeMgr.this.jTree.getPathForRow(row);
                TKObjectTreeNode tn = (TKObjectTreeNode)treePath.getLastPathComponent();
                TKTreeNodeProp neNode = (TKTreeNodeProp)tn.getUserObject();
                if (neNode.nodeType != 1) {
                    return;
                }
                String TooltipText = "";
                if (neNode.nedata.isLogin) {
                    TooltipText = TKTreeMgr.this.res.getString("alreadyStateText");
                    if (neNode.nedata.supportState(TKTreeMgr.this.treePanel.funcId) == 0) {
                        TooltipText = TKTreeMgr.this.res.getString("unsupportStateText");
                    }
                    if (neNode.nedata.supportState(TKTreeMgr.this.treePanel.funcId) == 2) {
                        TooltipText = TKTreeMgr.this.res.getString("unknownSupportText");
                    }
                } else {
                    TooltipText = TKTreeMgr.this.res.getString("noneStateText");
                }
                TKTreeMgr.this.treeTooltipText = neNode.nedata.neName + " : " + TooltipText;
            }
        });
        this.jTree.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TKTreeMgr.this.lastFocusNode = null;
            }
        });
        TKTreeNodeProp nodeProperty = new TKTreeNodeProp("root");
        nodeProperty.nodeType = 0;
        nodeProperty.setNodeID(0);
        this.root = new TKObjectTreeNode("root");
        this.root.setUserObject(nodeProperty);
        this.treeModel = new DefaultTreeModel(this.root);
        this.jTree.setModel(this.treeModel);
        TKDeviceFactory.instance().addNotifier(this);
    }

    Icon getNodeIcon(TKObjectTreeNode node, boolean expanded) {
        Icon icon = null;
        TKTreeNodeProp nodeProp = (TKTreeNodeProp)node.getUserObject();
        if (nodeProp.nodeType == 5) {
            return TKResourceManager.getIcon("subnet.gif");
        }
        if (nodeProp.nodeType == 1) {
            nodeProp.isSupport = true;
            if (nodeProp.nedata.isLogin) {
                int boardSupport;
                if (this.treePanel.funcId == 30) {
                    icon = TKResourceManager.getIcon("already.gif");
                    if (expanded) {
                        boardSupport = nodeProp.nedata.supportState(12);
                        int neSupport = nodeProp.nedata.supportState(11);
                        nodeProp.isSupport = false;
                        if (boardSupport == 0 || neSupport == 0) {
                            icon = TKResourceManager.getIcon("unsupport.gif");
                        } else if (boardSupport == 2 || neSupport == 2) {
                            icon = TKResourceManager.getIcon("unbeknown.gif");
                        } else {
                            icon = TKResourceManager.getIcon("already.gif");
                            nodeProp.isSupport = true;
                        }
                    }
                } else if (this.treePanel.funcId == 17) {
                    icon = TKResourceManager.getIcon("already.gif");
                    boardSupport = nodeProp.nedata.supportState(17);
                    int sphSupport = nodeProp.nedata.supportState(32);
                    if (boardSupport == 1 || sphSupport == 1) {
                        sphSupport = nodeProp.nedata.supportState(32);
                    } else if (boardSupport == 0 || sphSupport == 0) {
                        icon = TKResourceManager.getIcon("unsupport.gif");
                    } else if (boardSupport == 2 || sphSupport == 2) {
                        icon = TKResourceManager.getIcon("unbeknown.gif");
                    }
                } else if (nodeProp.nedata.supportState(this.treePanel.funcId) == 0) {
                    icon = TKResourceManager.getIcon("unsupport.gif");
                    TKLogManager.writeToDebug(nodeProp.nedata.neID + ".isSupportBdload: " + TKMainRes.toString(nodeProp.nedata.supportList));
                } else {
                    icon = nodeProp.nedata.supportState(this.treePanel.funcId) == 2 ? TKResourceManager.getIcon("unbeknown.gif") : TKResourceManager.getIcon("already.gif");
                }
            } else {
                icon = TKResourceManager.getIcon("none.gif");
            }
            if (nodeProp.nedata.isGateway) {
                Image image = ((ImageIcon)icon).getImage();
                icon = new ImageIcon(image){

                    @Override
                    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
                        super.paintIcon(c, g, x, y);
                        Font font = new Font(null, 1, 12);
                        g.setColor(Color.BLACK);
                        g.setFont(font);
                        g.drawString("G", 0, 10);
                        g.dispose();
                    }
                };
            }
        }
        return icon;
    }

    private void showPopupMenu(MouseEvent e) {
        Point p = e.getPoint();
        Component o = this.jTree.getComponentAt(p);
        if (o instanceof JPanel || o instanceof JTree) {
            TreePath treeP = this.jTree.getPathForLocation(p.x, p.y);
            if (null == treeP) {
                return;
            }
            this.lastNode = (TKObjectTreeNode)treeP.getLastPathComponent();
            TKTreeNodeProp np = (TKTreeNodeProp)this.lastNode.getUserObject();
            this.popupMenuMgr.lastNode = this.lastNode;
            this.popupMenuMgr.processPopMenu(e, np, p, this.jTree);
        }
    }

    public ArrayList getAllNEList() {
        ArrayList allNePropList = this.getAllSubOperationNodes(11, false);
        ArrayList<TKNeStruct> allNeList = new ArrayList<TKNeStruct>();
        for (int i = 0; i < allNePropList.size(); ++i) {
            TKTreeNodeProp prop = (TKTreeNodeProp)allNePropList.get(i);
            allNeList.add(prop.nedata);
        }
        return allNeList;
    }

    public void refresh(boolean bFromFresh) {
        this.treePanel.enableRefreshBtn(false);
        boolean isConnect = TEToolkitModule.initComm();
        if (!isConnect) {
            this.treePanel.enableRefreshBtn(true);
            return;
        }
        this.treePanel.registerCmd();
        ArrayList refreshNodeList = TKDeviceFactory.instance().getDeviceList(this.operationType, this.treePanel.funcId, bFromFresh);
        if (oBoardList.size() > 0 && this.operationType != 11) {
            for (int i = 0; i < oBoardList.size(); ++i) {
                refreshNodeList.add(oBoardList.get(i));
            }
        }
        if (null == refreshNodeList || refreshNodeList.size() == 0) {
            this.treePanel.enableRefreshBtn(true);
            return;
        }
        this.treeFilterText = null;
        this.updateTreeWithInterface(refreshNodeList);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null == TKTreeMgr.this.jTree) {
                    return;
                }
                TreePath rowTreePath = TKTreeMgr.this.jTree.getPathForRow(0);
                if (TKTreeMgr.this.jTree.isCollapsed(rowTreePath)) {
                    TKTreeMgr.this.jTree.expandPath(rowTreePath);
                }
            }
        });
        this.treePanel.enableRefreshBtn(true);
    }

    public JTree getJTree() {
        return this.jTree;
    }

    void doChildNodeSelect(TKObjectTreeNode currentNode) {
        TKObjectTreeNode nd = currentNode;
        TKTreeNodeProp nodeProp = (TKTreeNodeProp)nd.getUserObject();
        ArrayList allChildren = new ArrayList();
        TKTreeMgr.getAllSubNodes(nd, allChildren);
        for (int i = 0; i < allChildren.size(); ++i) {
            TKObjectTreeNode node = (TKObjectTreeNode)allChildren.get(i);
            TKTreeNodeProp np = (TKTreeNodeProp)node.getUserObject();
            np.selectState = nodeProp.selectState;
        }
    }

    void doTreeSelectAction(TKObjectTreeNode nd) {
        if (this.jTree.getEditingPath() != null) {
            this.jTree.stopEditing();
        }
        TKTreeNodeProp neNode = (TKTreeNodeProp)nd.getUserObject();
        neNode.selectState = neNode.selectState == 3 || neNode.selectState == 2 ? 1 : 3;
        if (nd.getParent() != null) {
            this.doParentNodeSelect(nd);
        }
        if (nd.getChildCount() > 0) {
            this.doChildNodeSelect(nd);
        }
        this.jTree.repaint();
        this.buttonColor();
    }

    public ArrayList getAllNodePropList(int nodeType, boolean ifOnlySelected) {
        ArrayList allNodeList = TKTreeMgr.getAllNodeProp(this.root, nodeType, ifOnlySelected);
        return allNodeList;
    }

    public ArrayList getAllVisiableNodePropList(int nodeType, boolean ifOnlySelected) {
        ArrayList allNodeList = TKTreeMgr.getAllVisiableNodeProp(this.root, nodeType, ifOnlySelected);
        return allNodeList;
    }

    public ArrayList getAllSubOperationNodes(int operType, boolean ifOnlySelected) {
        ArrayList allNodeList = new ArrayList();
        this.getAllSubOperationNodes(this.root, operType, allNodeList, ifOnlySelected);
        Iterator iterator = allNodeList.iterator();
        if (ifOnlySelected) {
            while (iterator.hasNext()) {
                TKTreeNodeProp childNodeProp = (TKTreeNodeProp)iterator.next();
                if (childNodeProp.selectState == 3 || childNodeProp.selectState == 2) continue;
                iterator.remove();
            }
        }
        return allNodeList;
    }

    public TKObjectTreeNode getBoardNode(int neID, int slot) {
        TKObjectTreeNode neNode = TKTreeMgr.getNodeByID(this.root, 1, neID);
        if (neNode == null) {
            return null;
        }
        Enumeration<TreeNode> boardEnum = neNode.children();
        while (boardEnum.hasMoreElements()) {
            TKObjectTreeNode board = (TKObjectTreeNode)boardEnum.nextElement();
            TKTreeNodeProp boardProp = (TKTreeNodeProp)board.getUserObject();
            if (boardProp.board.slotID != slot) continue;
            return board;
        }
        return null;
    }

    public void updateObjectNode(TKTreeNodeProp node) {
        int neID = node.nedata.neID;
        int slot = node.board.slotID;
        Enumeration<TreeNode> enumch = this.root.children();
        while (enumch.hasMoreElements()) {
            TKObjectTreeNode nodech = (TKObjectTreeNode)enumch.nextElement();
            TKTreeNodeProp nProp = (TKTreeNodeProp)nodech.getUserObject();
            if (slot >= 0) {
                Enumeration<TreeNode> enumBds = nodech.children();
                while (enumBds.hasMoreElements()) {
                    TKObjectTreeNode board = (TKObjectTreeNode)enumBds.nextElement();
                    TKTreeNodeProp boardProp = (TKTreeNodeProp)board.getUserObject();
                    if (boardProp.nedata.neID != neID || boardProp.board.slotID != slot) continue;
                    boardProp.nedata = node.nedata;
                    boardProp.board = node.board;
                    break;
                }
            }
            if (nProp.nedata.neID != neID || slot > 0) continue;
            nProp.nedata = node.nedata;
            nProp.board = node.board;
            break;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TKTreeMgr.this.jTree.updateUI();
            }
        });
    }

    public void updateTreeWithInterface(ArrayList refreshNodeList) {
        ArrayList treeNodeList = new ArrayList();
        TKTreeMgr.getAllSubNodes(this.root, treeNodeList);
        for (int i = 0; i < treeNodeList.size(); ++i) {
            TKObjectTreeNode childNode = (TKObjectTreeNode)treeNodeList.get(i);
            childNode.setVisible(true);
            childNode.removeAllChildren();
        }
        this.root.removeAllChildren();
        this.updateAllNodes(refreshNodeList, treeNodeList);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TKTreeMgr.this.jTree.updateUI();
            }
        });
    }

    protected static TKObjectTreeNode createNodeFromListById(int nodeId, ArrayList nodeList) {
        TKObjectTreeNode node = null;
        for (int i = 0; i < nodeList.size(); ++i) {
            TKNodeStruct nodeStruct = (TKNodeStruct)nodeList.get(i);
            if (nodeStruct.nodeType == 2 || nodeStruct.nodeID != nodeId) continue;
            node = TKTreeMgr.createTreeNode(nodeStruct);
            break;
        }
        return node;
    }

    public static int getInsertLocation(TKObjectTreeNode fatherNode, TKObjectTreeNode insertNode) {
        if (null != insertNode) {
            TKTreeNodeProp insertNodeProp = (TKTreeNodeProp)insertNode.getUserObject();
            for (int i = 0; i < fatherNode.getChildCount(); ++i) {
                TKObjectTreeNode preNode = (TKObjectTreeNode)fatherNode.getChildAt(i);
                TKTreeNodeProp preNodeProp = (TKTreeNodeProp)preNode.getUserObject();
                if (insertNodeProp.compareTo(preNodeProp) >= 0) {
                    if (i < fatherNode.getChildCount() - 1) {
                        TKObjectTreeNode nextNode = (TKObjectTreeNode)fatherNode.getChildAt(i + 1);
                        TKTreeNodeProp nextNodeProp = (TKTreeNodeProp)nextNode.getUserObject();
                        if (insertNodeProp.compareTo(nextNodeProp) >= 0) continue;
                        return i + 1;
                    }
                    return i + 1;
                }
                return i;
            }
        }
        return 0;
    }

    protected static TKObjectTreeNode createBoardNode(TKNeStruct neData, TKBoardStruct bdData) {
        TKTreeNodeProp nodeProperty = new TKTreeNodeProp(neData, bdData);
        TKObjectTreeNode boardNode = new TKObjectTreeNode(nodeProperty);
        if (!neData.boardList.contains(bdData)) {
            neData.boardList.add(bdData);
        }
        return boardNode;
    }

    protected static TKObjectTreeNode createNeNode(TKNeStruct neData) {
        TKTreeNodeProp nodeProperty = new TKTreeNodeProp(neData);
        nodeProperty.nedata.isServerLogin = nodeProperty.nedata.isLogin;
        TKObjectTreeNode treeNode = new TKObjectTreeNode(nodeProperty);
        if (neData.boardList != null) {
            for (int j = 0; j < neData.boardList.size(); ++j) {
                TKBoardStruct bdData = (TKBoardStruct)neData.boardList.get(j);
                TKObjectTreeNode boardNode = TKTreeMgr.createBoardNode(neData, bdData);
                treeNode.add(boardNode);
            }
        }
        return treeNode;
    }

    protected static TKObjectTreeNode createTreeNode(TKNodeStruct nodeData) {
        TKObjectTreeNode treeNode;
        if (nodeData.nodeType == 5) {
            TKSubnetStruct subnetData = new TKSubnetStruct(nodeData);
            TKTreeNodeProp nodeProperty = new TKTreeNodeProp(subnetData);
            treeNode = new TKObjectTreeNode(nodeProperty);
        } else if (nodeData.nodeType == 1) {
            TKNeStruct neData = new TKNeStruct(nodeData);
            treeNode = TKTreeMgr.createNeNode(neData);
        } else if (nodeData.nodeType == 2) {
            TKNeStruct neData = new TKNeStruct(nodeData);
            TKBoardStruct bdData = new TKBoardStruct(nodeData);
            treeNode = TKTreeMgr.createBoardNode(neData, bdData);
        } else {
            treeNode = new TKObjectTreeNode(nodeData.nodeName);
        }
        return treeNode;
    }

    public static TKObjectTreeNode getNodeByID(TKObjectTreeNode treeNode, int nodeType, int nodeId) {
        TKObjectTreeNode retNode = null;
        ArrayList neChildren = new ArrayList();
        TKTreeMgr.getAllSubNodes(treeNode, nodeType, neChildren);
        for (int i = 0; i < neChildren.size(); ++i) {
            TKObjectTreeNode node = (TKObjectTreeNode)neChildren.get(i);
            if (node == null) continue;
            TKTreeNodeProp nodeProp = (TKTreeNodeProp)node.getUserObject();
            if (nodeProp.nodeID != nodeId) continue;
            retNode = node;
            break;
        }
        return retNode;
    }

    public static TKObjectTreeNode getNodeByID(TKObjectTreeNode treeNode, int nodeId) {
        TKObjectTreeNode retNode = null;
        ArrayList neChildren = new ArrayList();
        TKTreeMgr.getAllSubNodes(treeNode, -1, neChildren);
        for (int i = 0; i < neChildren.size(); ++i) {
            TKObjectTreeNode node = (TKObjectTreeNode)neChildren.get(i);
            if (node == null) continue;
            TKTreeNodeProp nodeProp = (TKTreeNodeProp)node.getUserObject();
            if (nodeProp.nodeType == 2 || nodeProp.nodeID != nodeId) continue;
            retNode = node;
            break;
        }
        return retNode;
    }

    public static TKObjectTreeNode getNodeByIDFromList(ArrayList treeNodeList, int nodeId) {
        TKObjectTreeNode retNode = null;
        for (int i = 0; i < treeNodeList.size(); ++i) {
            TKObjectTreeNode node = (TKObjectTreeNode)treeNodeList.get(i);
            if (node == null) continue;
            TKTreeNodeProp nodeProp = (TKTreeNodeProp)node.getUserObject();
            if (nodeProp.nodeType == 2 || nodeProp.nodeID != nodeId) continue;
            retNode = node;
            break;
        }
        return retNode;
    }

    public TKObjectTreeNode getNodeByID(int nodeID) {
        TKObjectTreeNode root = (TKObjectTreeNode)this.jTree.getModel().getRoot();
        TKObjectTreeNode neNode = TKTreeMgr.getNodeByID(root, nodeID);
        return neNode;
    }

    public void filterTree(TKFilterCond cond) {
        if (cond == null) {
            return;
        }
        this.filterCond = cond;
        this.filterTree();
        this.updateTreeSelection();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TKTreeMgr.this.jTree.updateUI();
            }
        });
    }

    private void filterTree() {
        TKObjectTreeNode selectNode;
        TreePath curPath;
        if (this.filterCond == null) {
            return;
        }
        StringBuffer tooltip = new StringBuffer();
        tooltip.append("<html><body><table>");
        tooltip.append("<tr><td>" + this.res.getString("Filtered") + "</td><td> </td></tr>");
        if (this.filterCond.filterType == 0) {
            if (!this.filterCond.neType.trim().equals("")) {
                tooltip.append("<tr><td>" + this.res.getString("NeType") + ":</td><td>" + this.filterCond.neType + "</td></tr>");
            }
            if (!this.filterCond.neName.trim().equals("")) {
                tooltip.append("<tr><td>" + this.res.getString("NeName") + ":</td><td>" + this.filterCond.neName + "</td></tr>");
            }
        } else if (this.filterCond.filterType == 1 && !this.filterCond.boardType.equals("")) {
            tooltip.append("<tr><td>" + this.res.getString("BoardType") + ":</td><td>" + this.filterCond.boardType + "</td></tr>");
        }
        tooltip.append("</table></body><html>");
        this.treeFilterText = tooltip.toString();
        TKObjectTreeNode curNode = this.root;
        if (this.filterCond.filterFrom != 0 && (curPath = this.jTree.getSelectionPath()) != null && (selectNode = (TKObjectTreeNode)curPath.getLastPathComponent()).getNodeType() == 5) {
            curNode = selectNode;
        }
        ArrayList AllsubNodes = new ArrayList();
        TKTreeMgr.getAllSubNodes(this.root, AllsubNodes);
        for (int i = 0; i < AllsubNodes.size(); ++i) {
            TKObjectTreeNode node = (TKObjectTreeNode)AllsubNodes.get(i);
            node.setVisible(true);
        }
        ArrayList subNodes = new ArrayList();
        TKTreeMgr.getAllSubNodes(curNode, subNodes);
        for (int i = 0; i < subNodes.size(); ++i) {
            TKObjectTreeNode node = (TKObjectTreeNode)subNodes.get(i);
            node.setVisible(true);
            this.filterTreeNode(node, this.filterCond);
        }
    }

    private void filterTreeNode(TKObjectTreeNode node, TKFilterCond cond) {
        TKTreeNodeProp nodeProp = (TKTreeNodeProp)node.getUserObject();
        int nodeType = nodeProp.getNodeType();
        if (cond.filterType == 0 && nodeType == 1) {
            if (!cond.neType.equals("")) {
                if (nodeProp.nedata.neType.equals(cond.neType)) {
                    node.setVisible(true);
                } else {
                    node.setVisible(false);
                }
            }
            if (!cond.neName.equals("") && node.isVisible()) {
                String condNeName;
                String nodePropNeName = nodeProp.nedata.neName.toUpperCase();
                if (nodePropNeName.indexOf(condNeName = cond.neName.toUpperCase()) > -1) {
                    node.setVisible(true);
                } else {
                    node.setVisible(false);
                }
            }
        } else if (cond.filterType == 1) {
            if (nodeType == 1) {
                ArrayList itr = nodeProp.nedata.boardList;
                boolean hasboard = false;
                for (int i = 0; i < itr.size(); ++i) {
                    TKBoardStruct bd = (TKBoardStruct)itr.get(i);
                    if (!bd.boardType.equals(cond.boardType)) continue;
                    hasboard = true;
                    break;
                }
                node.setVisible(hasboard);
            } else if (nodeType == 2 && !cond.boardType.equals("")) {
                if (nodeProp.board.boardType.equals(cond.boardType)) {
                    node.setVisible(true);
                } else {
                    node.setVisible(false);
                }
            }
        }
    }

    private void visibleAllNode() {
        this.treeFilterText = null;
        TKObjectTreeNode curNode = this.root;
        ArrayList subNodes = new ArrayList();
        TKTreeMgr.getAllSubNodes(curNode, subNodes);
        for (int i = 0; i < subNodes.size(); ++i) {
            TKObjectTreeNode node = (TKObjectTreeNode)subNodes.get(i);
            node.setVisible(true);
        }
    }

    public void showAllNode() {
        this.visibleAllNode();
        this.updateTreeSelection();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TKTreeMgr.this.jTree.updateUI();
            }
        });
    }

    public void buttonColor() {
        ArrayList selectNeNodeList = this.getAllVisiableNodePropList(1, true);
        if (0 != selectNeNodeList.size()) {
            this.treePanel.setSelectBtnBackground(TKTreePanel.BUTTON_COLOR);
        } else {
            this.treePanel.setSelectBtnBackground(UIManager.getColor("Button.background"));
        }
    }

    public static void getAllSubNodes(TKObjectTreeNode node, ArrayList sublist) {
        Enumeration<TreeNode> children = node.children();
        if (TKObjectTreeNode.EMPTY_ENUMERATION == children) {
            return;
        }
        while (children.hasMoreElements()) {
            TKObjectTreeNode child = (TKObjectTreeNode)children.nextElement();
            sublist.add(child);
            TKTreeMgr.getAllSubNodes(child, sublist);
        }
    }

    protected ArrayList getBoardTypeList() {
        ArrayList<String> boardTypeList = new ArrayList<String>();
        ArrayList boardList = new ArrayList();
        TKTreeMgr.getAllSubNodes(this.root, 2, boardList);
        for (TKObjectTreeNode childNode : boardList) {
            TKTreeNodeProp childNodeProp = (TKTreeNodeProp)childNode.getUserObject();
            if (boardTypeList.contains(childNodeProp.board.boardType)) continue;
            boardTypeList.add(childNodeProp.board.boardType);
        }
        TKDataSort.sortList(boardTypeList, 1);
        return boardTypeList;
    }

    protected ArrayList getNETypeList() {
        ArrayList<String> neTypeList = new ArrayList<String>();
        ArrayList neList = new ArrayList();
        TKTreeMgr.getAllSubNodes(this.root, 1, neList);
        for (TKObjectTreeNode childNode : neList) {
            TKTreeNodeProp childNodeProp = (TKTreeNodeProp)childNode.getUserObject();
            if (neTypeList.contains(childNodeProp.nedata.neType)) continue;
            neTypeList.add(childNodeProp.nedata.neType);
        }
        TKDataSort.sortList(neTypeList, 1);
        return neTypeList;
    }

    private synchronized ArrayList updateAllNodes(ArrayList newNodeStructList, ArrayList treeNodeList) {
        ArrayList treeNodeFilterList = new ArrayList(treeNodeList);
        HashMap fatherNodeTable = new HashMap();
        ArrayList newNodeList = new ArrayList();
        ArrayList newBoardList = new ArrayList();
        boolean isOnlyNE = this.operationType == 11;
        for (int i = 0; i < newNodeStructList.size(); ++i) {
            Enumeration<TreeNode> children;
            TKNodeStruct nodeStruct = (TKNodeStruct)newNodeStructList.get(i);
            int nodeType = nodeStruct.nodeType;
            if (nodeType == 2 && isOnlyNE) continue;
            Integer fatherID = nodeStruct.fatherID;
            Integer nodeID = nodeStruct.nodeID;
            TKObjectTreeNode fatherNode = null;
            if (nodeStruct.fatherID == 0) {
                fatherNode = this.root;
            } else {
                Object fatherObj = fatherNodeTable.get(fatherID);
                if (fatherObj == null) {
                    fatherNode = this.updateFatherNode(newNodeStructList, treeNodeList, fatherNodeTable, newNodeList, fatherID);
                } else {
                    fatherNode = (TKObjectTreeNode)fatherObj;
                    treeNodeFilterList.remove(fatherNode);
                }
                if (fatherNode == null) continue;
            }
            TKBoardStruct board = new TKBoardStruct(nodeStruct);
            if (nodeType == 2 && null != fatherNode) {
                int sphSupport;
                int index;
                TKTreeNodeProp fatherProp = (TKTreeNodeProp)fatherNode.getUserObject();
                if (!fatherProp.nedata.boardList.contains(board)) {
                    fatherProp.nedata.boardList.add(board);
                }
                if ((index = oBoardList.lastIndexOf(nodeStruct)) == -1 || !this.bContainBoard(oBoardList, nodeStruct)) {
                    oBoardList.add(nodeStruct);
                }
                if (this.treePanel.funcId == 17 && fatherProp.nedata.isLogin && (sphSupport = fatherProp.nedata.supportState(32)) == 1) continue;
            }
            TKObjectTreeNode nodeAsChild = null;
            if (null != fatherNode && TKObjectTreeNode.EMPTY_ENUMERATION != (children = fatherNode.children())) {
                while (children.hasMoreElements()) {
                    TKObjectTreeNode child = (TKObjectTreeNode)children.nextElement();
                    TKTreeNodeProp childNodeProp = (TKTreeNodeProp)child.getUserObject();
                    treeNodeFilterList.remove(child);
                    if (childNodeProp.nodeID != nodeID) continue;
                    nodeAsChild = child;
                    break;
                }
            }
            this.processNodeInfo(treeNodeList, treeNodeFilterList, fatherNodeTable, newNodeList, newBoardList, isOnlyNE, nodeStruct, nodeType, nodeID, fatherNode, board, nodeAsChild);
            if (nodeType != 11) continue;
            this.updateNeLoginState(nodeStruct.nodeID, nodeStruct.isLogin);
        }
        if (newNodeList.size() > 0) {
            this.updateNodesSelection(newNodeList);
        }
        if (newBoardList.size() > 0) {
            this.updateNodesSelection(newBoardList);
        }
        this.updateTreeSelection();
        return treeNodeFilterList;
    }

    private void processNodeInfo(ArrayList treeNodeList, ArrayList treeNodeFilterList, HashMap fatherNodeTable, ArrayList newNodeList, ArrayList newBoardList, boolean isOnlyNE, TKNodeStruct nodeStruct, int nodeType, Integer nodeID, TKObjectTreeNode fatherNode, TKBoardStruct board, TKObjectTreeNode nodeAsChild) {
        if (nodeAsChild == null) {
            TKObjectTreeNode node;
            boolean isExist = false;
            if (nodeType != 2) {
                Object nodeObj = fatherNodeTable.get(nodeID);
                if (nodeObj == null) {
                    node = TKTreeMgr.getNodeByIDFromList(treeNodeList, nodeStruct.nodeID);
                    if (node == null) {
                        node = this.processNodeOperation(newNodeList, isOnlyNE, nodeStruct, nodeType);
                    } else {
                        isExist = true;
                        treeNodeFilterList.remove(node);
                    }
                } else {
                    node = (TKObjectTreeNode)nodeObj;
                }
                fatherNodeTable.put(nodeID, node);
            } else {
                node = this.getBoardNode(nodeStruct.fatherID, nodeStruct.nodeID);
                if (node == null) {
                    node = this.createNodeInfo(newBoardList, fatherNode, board, node);
                } else {
                    isExist = true;
                }
            }
            if (null != node) {
                this.updateNodeInfo(isOnlyNE, nodeStruct, nodeType, node, isExist);
            }
            if (null != fatherNode) {
                fatherNode.add(node);
            }
        } else {
            TKTreeNodeProp prop = (TKTreeNodeProp)nodeAsChild.getUserObject();
            prop.updateInfo(nodeStruct);
            if (nodeType == 2 && !isOnlyNE) {
                this.treePanel.internalFrame.updateTableNEData(prop);
            }
        }
    }

    private TKObjectTreeNode createNodeInfo(ArrayList newBoardList, TKObjectTreeNode fatherNode, TKBoardStruct board, TKObjectTreeNode node) {
        if (null != fatherNode) {
            TKTreeNodeProp prop = (TKTreeNodeProp)fatherNode.getUserObject();
            node = TKTreeMgr.createBoardNode(prop.nedata, board);
            if (!newBoardList.contains(node)) {
                newBoardList.add(node);
            }
        }
        return node;
    }

    private void updateNodeInfo(boolean isOnlyNE, TKNodeStruct nodeStruct, int nodeType, TKObjectTreeNode node, boolean isExist) {
        TKTreeNodeProp prop = (TKTreeNodeProp)node.getUserObject();
        if (isExist) {
            prop.updateInfo(nodeStruct);
        }
        if (nodeType == 2 && !isOnlyNE) {
            this.treePanel.internalFrame.updateTableNEData(prop);
        }
        node.removeFromParent();
    }

    private TKObjectTreeNode updateFatherNode(ArrayList newNodeStructList, ArrayList treeNodeList, HashMap fatherNodeTable, ArrayList newNodeList, Integer fatherID) {
        TKObjectTreeNode fatherNode = TKTreeMgr.getNodeByIDFromList(treeNodeList, fatherID);
        if (fatherNode == null) {
            fatherNode = TKTreeMgr.createNodeFromListById(fatherID, newNodeStructList);
            fatherNodeTable.put(fatherID, fatherNode);
            if (!newNodeList.contains(fatherNode)) {
                newNodeList.add(fatherNode);
            }
        }
        return fatherNode;
    }

    private TKObjectTreeNode processNodeOperation(ArrayList newNodeList, boolean isOnlyNE, TKNodeStruct nodeStruct, int nodeType) {
        TKObjectTreeNode node = TKTreeMgr.createTreeNode(nodeStruct);
        if (isOnlyNE && nodeType == 1 && node.getChildCount() > 0) {
            node.removeAllChildren();
        }
        if (!newNodeList.contains(node)) {
            newNodeList.add(node);
        }
        return node;
    }

    private void updateNodesSelection(ArrayList nodes) {
        if (nodes == null) {
            return;
        }
        for (TKObjectTreeNode node : nodes) {
            if (node == null) {
                return;
            }
            TKObjectTreeNode parentNode = (TKObjectTreeNode)node.getParent();
            if (parentNode == null) continue;
            TKTreeNodeProp np = (TKTreeNodeProp)parentNode.getUserObject();
            if (np.selectState != 3) continue;
            ((TKTreeNodeProp)node.getUserObject()).selectState = 3;
        }
    }

    private void updateTreeSelection() {
        TKObjectTreeNode node;
        int i;
        ArrayList allNodes = new ArrayList();
        TKTreeMgr.getAllSubNodes(this.root, allNodes);
        ArrayList<TKObjectTreeNode> leafNodes = new ArrayList<TKObjectTreeNode>();
        HashMap<TKObjectTreeNode, String> parentMap = new HashMap<TKObjectTreeNode, String>();
        for (i = 0; i < allNodes.size(); ++i) {
            node = (TKObjectTreeNode)allNodes.get(i);
            TKObjectTreeNode parentNode = (TKObjectTreeNode)node.getParent();
            if (parentNode == null || !node.isLeaf() || parentMap.get(parentNode) != null) continue;
            leafNodes.add(node);
            parentMap.put(parentNode, "");
        }
        for (i = 0; i < leafNodes.size(); ++i) {
            node = (TKObjectTreeNode)leafNodes.get(i);
            this.doParentNodeSelect(node);
        }
    }

    @Override
    public synchronized void updateChildrenNodes(int fatherId, ArrayList children) {
        ArrayList treeNodeList = new ArrayList();
        TKTreeMgr.getAllSubNodes(this.root, treeNodeList);
        this.updateAllNodes(children, treeNodeList);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TKTreeMgr.this.jTree.updateUI();
            }
        });
    }

    @Override
    public synchronized void updateNodeInfo(TKNodeStruct nodeInfo) {
        if (nodeInfo == null) {
            return;
        }
        TKObjectTreeNode treeNode = TKTreeMgr.getNodeByID(this.root, nodeInfo.nodeID);
        if (treeNode == null) {
            return;
        }
        TKTreeNodeProp nodeProp = (TKTreeNodeProp)treeNode.getUserObject();
        nodeProp.updateInfo(nodeInfo);
        this.treePanel.updateTableNEData(nodeProp);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TKTreeMgr.this.jTree.updateUI();
            }
        });
    }

    @Override
    public synchronized void removeNodes(ArrayList nodeStructList) {
        if (null != this.jTree && null != this.jTree.getCellEditor()) {
            this.jTree.getCellEditor().stopCellEditing();
        }
        for (int i = 0; i < nodeStructList.size(); ++i) {
            TKNodeStruct nodeStruct = (TKNodeStruct)nodeStructList.get(i);
            TKObjectTreeNode node = null;
            node = nodeStruct.nodeType == 2 ? this.getBoardNode(nodeStruct.fatherID, nodeStruct.nodeID) : TKTreeMgr.getNodeByID(this.root, nodeStruct.nodeType, nodeStruct.nodeID);
            if (nodeStruct.nodeType == 1 && this.getObjectMgrInterface() != null) {
                this.getObjectMgrInterface().noticeNELoginState(nodeStruct.nodeID, false);
            }
            if (node == null) continue;
            if (nodeStruct.nodeType == 2) {
                TKTreeNodeProp nodeProp = (TKTreeNodeProp)node.getUserObject();
                nodeProp.nedata.boardList.remove(nodeProp.board);
            }
            node.removeAllChildren();
            if (null == this.treeModel) continue;
            this.treeModel.removeNodeFromParent(node);
        }
        this.updateTreeSelection();
        this.buttonColor();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TKTreeMgr.this.jTree.updateUI();
            }
        });
    }

    @Override
    public synchronized void updateNeInfo(TKNeStruct neInfo) {
        if (neInfo == null) {
            return;
        }
        TKObjectTreeNode neNode = TKTreeMgr.getNodeByID(this.root, 1, neInfo.neID);
        if (neNode == null) {
            return;
        }
        TKTreeNodeProp prop = (TKTreeNodeProp)neNode.getUserObject();
        prop.nedata.updateWithData(neInfo);
        if (!"".equals(neInfo.actionVersion)) {
            prop.setNodeVersion(neInfo.actionVersion);
        }
        if (this.treePanel.funcId == 17 && prop.nedata.isLogin) {
            int sphSupport = prop.nedata.supportState(32);
            if (sphSupport == 1) {
                neNode.removeAllChildren();
                if (prop.selectState == 2) {
                    prop.selectState = 3;
                }
            } else if (prop.nedata.boardList != null) {
                for (int j = 0; j < prop.nedata.boardList.size(); ++j) {
                    TKBoardStruct bdData = (TKBoardStruct)prop.nedata.boardList.get(j);
                    boolean hasChild = false;
                    Enumeration<TreeNode> children = neNode.children();
                    if (TKObjectTreeNode.EMPTY_ENUMERATION != children) {
                        while (children.hasMoreElements()) {
                            TKObjectTreeNode child = (TKObjectTreeNode)children.nextElement();
                            TKTreeNodeProp childNodeProp = (TKTreeNodeProp)child.getUserObject();
                            if (childNodeProp.nodeID != bdData.slotID) continue;
                            hasChild = true;
                            break;
                        }
                    }
                    if (hasChild) continue;
                    TKObjectTreeNode boardNode = TKTreeMgr.createBoardNode(prop.nedata, bdData);
                    neNode.add(boardNode);
                }
            }
        }
        this.treePanel.updateTableNEData(prop);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TKTreeMgr.this.jTree.updateUI();
            }
        });
    }

    @Override
    public synchronized void updateNeLoginState(int neID, boolean isLogin) {
        TKObjectTreeNode neNode = TKTreeMgr.getNodeByID(this.root, 1, neID);
        if (neNode == null) {
            return;
        }
        TKTreeNodeProp prop = (TKTreeNodeProp)neNode.getUserObject();
        prop.nedata.isLogin = isLogin;
        if (this.getObjectMgrInterface() != null) {
            this.getObjectMgrInterface().noticeNELoginState(neID, isLogin);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TKTreeMgr.this.jTree.updateUI();
            }
        });
    }

    private boolean bContainBoard(ArrayList oBoardList, TKNodeStruct nodeStruct) {
        for (int i = oBoardList.size() - 1; i >= 0; --i) {
            TKNodeStruct oTKNodeStruct = (TKNodeStruct)oBoardList.get(i);
            if (oTKNodeStruct.fatherID != nodeStruct.fatherID || !oTKNodeStruct.nodeName.equals(nodeStruct.nodeName) || oTKNodeStruct.nodeID != nodeStruct.nodeID) continue;
            return true;
        }
        return false;
    }
}

