/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.nemgr;

import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.component.TKTridStateIcon;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKObjectTreeNode;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKTreeMgr;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKTreeNodeProp;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;

public class TKNodeCellRenderer
extends DefaultTreeCellRenderer {
    private final TKTreeMgr tkTreeMgr;
    private JCheckBox checkBox = new JCheckBox();
    private JLabel label = new JLabel();
    private JPanel panel = new JPanel();
    private JLabel iconLabel = new JLabel();
    private TKTridStateIcon tkTridStateIcon;
    private int selectState;

    public TKNodeCellRenderer(TKTreeMgr tkTreeMgr) {
        this.tkTreeMgr = tkTreeMgr;
        this.checkBox.setOpaque(false);
        this.selectState = 1;
        this.tkTridStateIcon = new TKTridStateIcon(this.selectState);
        this.checkBox.setIcon(this.tkTridStateIcon);
        this.label.setOpaque(false);
        this.panel.setOpaque(false);
        this.iconLabel.setIcon(TKResourceManager.getIcon("none.gif"));
        this.panel.setLayout(new FlowLayout(1, 0, 0));
        this.panel.add(this.checkBox);
        this.panel.add(this.iconLabel);
        this.panel.add(this.label);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (hasFocus) {
            TKObjectTreeNode focusNode = null;
            if (!(value instanceof TKObjectTreeNode)) {
                return super.getTreeCellRendererComponent(tree, value, this.selected, expanded, leaf, row, hasFocus);
            }
            focusNode = (TKObjectTreeNode)value;
            TKTreeNodeProp focusNodeProp = (TKTreeNodeProp)focusNode.getUserObject();
            if (null == focusNodeProp) {
                return super.getTreeCellRendererComponent(tree, value, this.selected, expanded, leaf, row, hasFocus);
            }
            this.tkTreeMgr.lastFocusNode = focusNodeProp.nodeType != 1 || focusNodeProp.nodeType != 2 ? focusNode : null;
        }
        TKObjectTreeNode node = null;
        if (!(value instanceof TKObjectTreeNode)) {
            return super.getTreeCellRendererComponent(tree, value, this.selected, expanded, leaf, row, hasFocus);
        }
        node = (TKObjectTreeNode)value;
        Object userObject = node.getUserObject();
        if (null == userObject) {
            return super.getTreeCellRendererComponent(tree, value, this.selected, expanded, leaf, row, hasFocus);
        }
        TKTreeNodeProp np = (TKTreeNodeProp)userObject;
        if (np.nodeType == 0 || np.nodeType == 2) {
            this.iconLabel.setVisible(false);
        } else {
            this.iconLabel.setIcon(this.tkTreeMgr.getNodeIcon(node, expanded));
            this.iconLabel.setVisible(true);
        }
        if (np.selectState == 3) {
            this.tkTridStateIcon.setState(3);
        } else if (np.selectState == 2) {
            this.tkTridStateIcon.setState(2);
        } else {
            this.tkTridStateIcon.setState(1);
        }
        this.label.setVisible(true);
        this.label.setText(userObject.toString());
        if (np.labelFlag && hasFocus) {
            this.label.setOpaque(true);
            this.label.setForeground(UIManager.getColor("Tree.selectionForeground"));
            this.label.setBackground(UIManager.getColor("Tree.selectionBackground"));
            np.labelFlag = false;
        } else {
            this.label.setOpaque(false);
            this.label.setForeground(UIManager.getColor("Tree.foreground"));
            this.label.setBackground(UIManager.getColor("Tree.background"));
        }
        if (sel) {
            this.label.setOpaque(true);
            this.label.setForeground(UIManager.getColor("Tree.selectionForeground"));
            this.label.setBackground(UIManager.getColor("Tree.selectionBackground"));
            np.labelFlag = false;
        }
        return this.panel;
    }
}

