/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.nemgr;

import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.communicate.TKCmdMSG;
import com.huawei.dc.toolkit.client.base.communicate.TKCommUtility;
import com.huawei.dc.toolkit.client.base.communicate.TKCommandResult;
import com.huawei.dc.toolkit.client.base.communicate.TKNoticeReceiver;
import com.huawei.dc.toolkit.client.base.util.TKDebug;
import com.huawei.dc.toolkit.client.base.util.TKLogManager;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperationShowMgr;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKBoardStruct;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKNeStruct;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKSupport;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKDeviceInterface;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKNodeStruct;
import com.huawei.dc.toolkit.control.TKCommNotifier;
import com.huawei.dc.toolkit.control.Toolkit4T2kInterface;
import com.huawei.dc.toolkit.control.Toolkit4T2kInterfaceMgr;
import com.huawei.te.toolkit.AsnSingleReturn;
import com.huawei.te.toolkit.AsnTkSwitchGatewayReq;
import com.huawei.te.toolkit.AsnTkSwitchGatewayRsp;
import com.huawei.te.toolkit.AsnToolkitFuncIDAndSupport;
import com.huawei.te.toolkit.AsnToolkitGetNEPropertyReq;
import com.huawei.te.toolkit.AsnToolkitGetNEPropertyRsp;
import com.huawei.te.toolkit.AsnToolkitGetTreeReq;
import com.huawei.te.toolkit.AsnToolkitGetTreeRsp;
import com.huawei.te.toolkit.AsnToolkitNeLoginStateRpt;
import com.huawei.te.toolkit.AsnToolkitNodeChangedInfo;
import com.huawei.te.toolkit.AsnToolkitSetNEListInfoReq;
import com.huawei.te.toolkit.AsnToolkitTreeChangedRpt;
import java.awt.Component;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import net.commustru.fstru.FStruct;

public class TKDeviceFactory
implements TKNoticeReceiver,
TKCommNotifier {
    private ArrayList notifierList = new ArrayList();
    public static final int ADD_OPERATE = 1;
    public static final int EDIT_OPERATE = 2;
    public static final int DEL_OPERATE = 3;
    public static final int QUERY_OPERATE = 4;
    private static TKDeviceFactory instance = null;
    private static int TIMEOUT = 1200;

    public static synchronized TKDeviceFactory instance() {
        if (instance == null) {
            instance = new TKDeviceFactory();
        }
        return instance;
    }

    private TKDeviceFactory() {
        TKCommUtility.addCommunicationNotifier(this);
        if (TKCommUtility.comm != null) {
            TKCommUtility.comm.registerListener('\u010b', this);
            TKCommUtility.comm.registerListener('\u0116', this);
        }
    }

    @Override
    public void notifyCommunication(boolean isConnected) {
        if (isConnected) {
            TKCommUtility.comm.unregisterListener('\u010b', this);
            TKCommUtility.comm.unregisterListener('\u0116', this);
            TKCommUtility.comm.registerListener('\u010b', this);
            TKCommUtility.comm.registerListener('\u0116', this);
        }
    }

    public ArrayList getDeviceListFromLocal(int operType, int funcId) {
        return this.getDeviceListFromLocal(operType, funcId, true);
    }

    public ArrayList getDeviceListFromLocal(int operType, int funcId, boolean catchError) {
        ArrayList nodeList = new ArrayList();
        AsnToolkitGetTreeReq req = new AsnToolkitGetTreeReq();
        req.funcID = BigInteger.valueOf(funcId);
        req.isNeedBDList = operType != 11;
        AsnToolkitGetTreeRsp rsp = new AsnToolkitGetTreeRsp();
        char cmdCode = '\u0101';
        byte recvModule = 1;
        if (catchError) {
            TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), true);
        }
        TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, recvModule, TIMEOUT);
        if (catchError) {
            TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), false);
        }
        if (!ret.isSuccess && catchError) {
            TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), ret.resultInfo, false);
            return null;
        }
        Iterator nodeInfoItr = rsp.treeNodeInfoList.iterator();
        nodeList = this.getNodeStructList(nodeInfoItr, funcId, false);
        return nodeList;
    }

    public ArrayList getDeviceList(int operType, int funcId, boolean bFreshBtn) {
        List<TKNodeStruct> Lst;
        Toolkit4T2kInterface inf = Toolkit4T2kInterfaceMgr.getInstance();
        if (inf != null && (Lst = inf.getNelist()).size() == 0) {
            DCDebugTracer.trace("TKDeviceFactory#getDeviceList Toolkit4T2kInterfaceMgr.getInstance() get device is null!");
            return null;
        }
        ArrayList nodeList = new ArrayList();
        AsnToolkitGetTreeReq req = new AsnToolkitGetTreeReq();
        req.funcID = BigInteger.valueOf(funcId);
        req.isNeedBDList = operType != 11 && bFreshBtn;
        AsnToolkitGetTreeRsp rsp = new AsnToolkitGetTreeRsp();
        char cmdCode = '\u0101';
        byte recvModule = 1;
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), true);
        TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, recvModule, TIMEOUT);
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), false);
        if (!ret.isSuccess) {
            TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), ret.resultInfo, false);
            return null;
        }
        Iterator nodeInfoItr = rsp.treeNodeInfoList.iterator();
        nodeList = this.getNodeStructList(nodeInfoItr, funcId, false);
        return nodeList;
    }

    protected ArrayList getNodeStructList(Iterator nodeInfoItr, int funcId, boolean bdInNE) {
        ArrayList<TKNodeStruct> nodeList = new ArrayList<TKNodeStruct>();
        if (null != nodeInfoItr) {
            while (nodeInfoItr.hasNext()) {
                TKNodeStruct node;
                TKSupport support;
                AsnToolkitNodeChangedInfo asnNodeInfo = (AsnToolkitNodeChangedInfo)nodeInfoItr.next();
                if (asnNodeInfo.nodeType.intValue() != 2 || !bdInNE) {
                    TKNodeStruct nodeData = new TKNodeStruct();
                    nodeData.fatherID = asnNodeInfo.fatherID.intValue();
                    nodeData.nodeID = asnNodeInfo.nodeID.intValue();
                    nodeData.nodeName = new String(asnNodeInfo.nodeName);
                    nodeData.nodeType = asnNodeInfo.nodeType.intValue();
                    nodeData.nodeRemark = new String(asnNodeInfo.nodeRemark);
                    nodeData.boardKind = asnNodeInfo.boardKind.intValue();
                    String nodeVer = new String(asnNodeInfo.nodeVersion);
                    if (!"".equals(nodeVer)) {
                        nodeData.nodeVersion = nodeVer;
                    }
                    nodeData.neType = new String(asnNodeInfo.neType);
                    nodeData.neUserName = new String(asnNodeInfo.userName);
                    nodeData.nePass = DCCommonUtil.convertByteArrayToChar(asnNodeInfo.userPwd);
                    nodeData.isLogin = asnNodeInfo.isLogin;
                    nodeData.isTL1NE = asnNodeInfo.isTL1NE;
                    nodeData.gatewayType = asnNodeInfo.gatewayType.intValue();
                    nodeData.gatewayAddress = new String(asnNodeInfo.gatewayAddress);
                    nodeData.gatewayPort = new String(asnNodeInfo.gatewayPort);
                    nodeData.isSupport = 0;
                    nodeData.isGateway = asnNodeInfo.isGWType;
                    for (AsnToolkitFuncIDAndSupport item : asnNodeInfo.supportFuncIDList) {
                        support = new TKSupport(item.funcID.intValue(), item.isSupport.intValue());
                        nodeData.supportFuncIDList.add(support);
                    }
                    nodeData.setISUseSSH(asnNodeInfo.bUseSSH);
                    if (null != asnNodeInfo.iSSHLoginMode) {
                        nodeData.setSSHLoginMode(asnNodeInfo.iSSHLoginMode.intValue());
                    }
                    if (null != asnNodeInfo.strSSHLoginKey) {
                        nodeData.setSSHLoginKey(DCCommonUtil.convertByteArrayToChar(asnNodeInfo.strSSHLoginKey));
                    }
                    if (null != asnNodeInfo.strSSHPassPhrase) {
                        nodeData.setSSHPassPhrase(DCCommonUtil.convertByteArrayToChar(asnNodeInfo.strSSHPassPhrase));
                    }
                    nodeList.add(nodeData);
                    continue;
                }
                TKBoardStruct board = new TKBoardStruct();
                board.fatherID = asnNodeInfo.fatherID.intValue();
                board.slotID = asnNodeInfo.nodeID.intValue();
                board.boardType = new String(asnNodeInfo.nodeName);
                board.boardKind = asnNodeInfo.boardKind.intValue();
                boolean isSupport = false;
                for (AsnToolkitFuncIDAndSupport item : asnNodeInfo.supportFuncIDList) {
                    support = new TKSupport(item.funcID.intValue(), item.isSupport.intValue());
                    if (support.funcID != funcId) continue;
                    isSupport = true;
                }
                if (!isSupport || (node = this.findNodeFromListById(board.fatherID, nodeList)) == null) continue;
                node.boardList.add(board);
            }
        }
        return nodeList;
    }

    public TKNodeStruct findNodeFromListById(int nodeId, ArrayList nodeList) {
        TKNodeStruct node = null;
        for (int i = 0; i < nodeList.size(); ++i) {
            TKNodeStruct nodeStruct = (TKNodeStruct)nodeList.get(i);
            if (nodeStruct.nodeType == 2 || nodeStruct.nodeID != nodeId) continue;
            return nodeStruct;
        }
        return node;
    }

    public ArrayList getDeviceInterfaceList() {
        return this.notifierList;
    }

    public void addNotifier(TKDeviceInterface deviceInterface) {
        if (!this.notifierList.contains(deviceInterface)) {
            this.notifierList.add(deviceInterface);
        }
    }

    public void removeDeviceInterface(TKDeviceInterface deviceInterface) {
        this.notifierList.remove(deviceInterface);
    }

    private void processNodeChangeRpt(int oprType, final ArrayList nodeStructList) {
        switch (oprType) {
            case 1: 
            case 2: 
            case 4: {
                new Thread(){

                    @Override
                    public void run() {
                        TKDeviceFactory.this.updateChildrenNodes(0, nodeStructList);
                    }
                }.start();
                break;
            }
            case 3: {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TKDeviceFactory.this.removeNodes(nodeStructList);
                    }
                });
                break;
            }
        }
    }

    public void updateChildrenNodes(int fatherId, ArrayList children) {
        int notifierCount = this.notifierList.size();
        for (int i = 0; i < notifierCount; ++i) {
            TKDeviceInterface notifier = (TKDeviceInterface)this.notifierList.get(i);
            if (notifier == null) continue;
            notifier.updateChildrenNodes(fatherId, children);
        }
    }

    public void updateNeInfo(TKNeStruct neInfo) {
        int notifierCount = this.notifierList.size();
        for (int i = 0; i < notifierCount; ++i) {
            TKDeviceInterface notifier = (TKDeviceInterface)this.notifierList.get(i);
            if (notifier == null) continue;
            notifier.updateNeInfo(neInfo);
        }
    }

    public void updateNodeInfo(TKNodeStruct nodeInfo) {
        int notifierCount = this.notifierList.size();
        for (int i = 0; i < notifierCount; ++i) {
            TKDeviceInterface notifier = (TKDeviceInterface)this.notifierList.get(i);
            if (notifier == null) continue;
            notifier.updateNodeInfo(nodeInfo);
        }
    }

    public void removeNodes(ArrayList nodeStructList) {
        int notifierCount = this.notifierList.size();
        for (int i = 0; i < notifierCount; ++i) {
            TKDeviceInterface notifier = (TKDeviceInterface)this.notifierList.get(i);
            if (notifier == null) continue;
            notifier.removeNodes(nodeStructList);
        }
    }

    public void updateNeLoginState(int neID, boolean isLogin) {
        int notifierCount = this.notifierList.size();
        for (int i = 0; i < notifierCount; ++i) {
            TKDeviceInterface notifier = (TKDeviceInterface)this.notifierList.get(i);
            if (notifier == null) continue;
            notifier.updateNeLoginState(neID, isLogin);
        }
    }

    @Override
    public byte handleNotice(char cmdCode, TKCmdMSG data) {
        AsnToolkitTreeChangedRpt asnRpt;
        boolean result;
        if (cmdCode == '\u010b') {
            AsnToolkitNeLoginStateRpt asnRpt2 = new AsnToolkitNeLoginStateRpt();
            boolean result2 = TKCommUtility.getASNData(data, (FStruct)asnRpt2);
            if (result2) {
                if (asnRpt2.isLogin) {
                    this.queryNeInfo(asnRpt2.neID.intValue(), asnRpt2.isLogin);
                }
                this.updateNeLoginState(asnRpt2.neID.intValue(), asnRpt2.isLogin);
            }
        } else if (cmdCode == '\u0116' && (result = TKCommUtility.getASNData(data, (FStruct)(asnRpt = new AsnToolkitTreeChangedRpt())))) {
            Iterator nodeItr = asnRpt.nodeChangedInfoList.iterator();
            ArrayList nodeStructList = this.getNodeStructList(nodeItr, data.msgHead.receiverModule, false);
            this.processNodeChangeRpt(asnRpt.operateType.intValue(), nodeStructList);
        }
        return 0;
    }

    protected void queryNeInfo(final int neId, final boolean isLogin) {
        new Thread(){

            @Override
            public void run() {
                AsnToolkitGetNEPropertyReq req = new AsnToolkitGetNEPropertyReq();
                req.neID = BigInteger.valueOf(neId);
                AsnToolkitGetNEPropertyRsp rsp = new AsnToolkitGetNEPropertyRsp();
                char cmdCodeNP = '\u010c';
                byte recvModuleNP = 1;
                TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCodeNP, recvModuleNP, 120);
                if (!ret.isSuccess) {
                    TKDebug.inmAssert(false, "query_NE_property  failed or timeout.");
                    return;
                }
                TKNeStruct neData = new TKNeStruct();
                neData.neID = neId;
                neData.isLogin = isLogin;
                neData.isServerLogin = isLogin;
                if (rsp.ret.isSuccess) {
                    String neType_NEW = new String(rsp.neType);
                    String neName_NEW = new String(rsp.neName);
                    String neGateAdr_NEW = new String(rsp.gateAddress);
                    String port_NEW = new String(rsp.port);
                    neData.neType = neType_NEW;
                    neData.neName = neName_NEW;
                    neData.gatewayIP = neGateAdr_NEW;
                    neData.isGateway = rsp.isGWType;
                    neData.actionVersion = new String(rsp.activeVersion);
                    TKLogManager.writeToDebug("neData.actionVersion " + neData.actionVersion);
                    try {
                        neData.ipPort = Integer.parseInt(port_NEW);
                    }
                    catch (Exception ex) {
                        ex.toString();
                    }
                    if (neData.isTL1NE) {
                        neData.TID = neName_NEW;
                    }
                    for (AsnToolkitFuncIDAndSupport asnSptInfo : rsp.supportFuncIDList) {
                        TKSupport support = new TKSupport(asnSptInfo.funcID.intValue(), asnSptInfo.isSupport.intValue());
                        neData.supportList.add(support);
                    }
                    TKDeviceFactory.this.updateNeInfo(neData);
                }
            }
        }.start();
    }

    public static void setDeviceList(List nodeList) {
        AsnToolkitSetNEListInfoReq req = null;
        if (nodeList == null || nodeList.size() < 1) {
            req = new AsnToolkitSetNEListInfoReq();
        } else {
            req = new AsnToolkitSetNEListInfoReq();
            for (int i = 0; i < nodeList.size(); ++i) {
                AsnToolkitNodeChangedInfo nodeInfo = new AsnToolkitNodeChangedInfo();
                TKNodeStruct nodeData = (TKNodeStruct)nodeList.get(i);
                TKDeviceFactory.fillNodeAsnInfo(nodeData, nodeInfo);
                req.nodeInfoList.add((Object)nodeInfo);
            }
        }
        AsnSingleReturn rsp = new AsnSingleReturn();
        char cmdCode = '\u0103';
        byte recvModule = 1;
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), true);
        TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, recvModule, TIMEOUT);
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), false);
        if (!ret.isSuccess) {
            TKLogManager.writeToDebug("set neList:" + ret.resultInfo);
            return;
        }
        if (!rsp.isSuccess) {
            TKLogManager.writeToDebug("set neList error:" + rsp.retCode);
        }
    }

    private static void fillNodeAsnInfo(TKNodeStruct nodeData, AsnToolkitNodeChangedInfo asnNodeInfo) {
        asnNodeInfo.fatherID = BigInteger.valueOf(nodeData.fatherID);
        asnNodeInfo.nodeID = BigInteger.valueOf(nodeData.nodeID);
        asnNodeInfo.nodeName = TKDeviceFactory.getMemberBytes(nodeData.nodeName);
        asnNodeInfo.nodeType = BigInteger.valueOf(nodeData.nodeType);
        asnNodeInfo.nodeRemark = TKDeviceFactory.getMemberBytes(nodeData.nodeRemark);
        asnNodeInfo.boardKind = BigInteger.valueOf(nodeData.boardKind);
        asnNodeInfo.neType = TKDeviceFactory.getMemberBytes(nodeData.neType);
        asnNodeInfo.userName = TKDeviceFactory.getMemberBytes(nodeData.neUserName);
        asnNodeInfo.userPwd = TKDeviceFactory.getMemberBytes(String.valueOf(nodeData.nePass));
        asnNodeInfo.isLogin = nodeData.isLogin;
        asnNodeInfo.isTL1NE = nodeData.isTL1NE;
        asnNodeInfo.gatewayType = BigInteger.valueOf(nodeData.gatewayType);
        asnNodeInfo.gatewayAddress = TKDeviceFactory.getMemberBytes(nodeData.gatewayAddress);
        asnNodeInfo.gatewayPort = TKDeviceFactory.getMemberBytes(nodeData.gatewayPort);
        asnNodeInfo.isGWType = nodeData.isGateway;
        asnNodeInfo.nodeVersion = TKDeviceFactory.getMemberBytes(nodeData.nodeVersion);
        asnNodeInfo._bUseSSH = true;
        asnNodeInfo.bUseSSH = nodeData.isUseSSH();
        asnNodeInfo.iSSHLoginMode = BigInteger.valueOf(nodeData.getSSHLoginMode());
        asnNodeInfo.strSSHLoginKey = TKDeviceFactory.getMemberBytes(String.valueOf(nodeData.getSSHLoginKey()));
        asnNodeInfo.strSSHPassPhrase = TKDeviceFactory.getMemberBytes(String.valueOf(nodeData.getSSHPassPhrase()));
    }

    private static byte[] getMemberBytes(String member) {
        byte[] data = "".getBytes();
        if (member != null) {
            data = member.getBytes();
        }
        return data;
    }

    public static void switchGateway(int neID, String oldGateway, String newGateway, String port, int gatewayType) {
        AsnTkSwitchGatewayReq req = new AsnTkSwitchGatewayReq();
        req.neID = BigInteger.valueOf(neID);
        req.oldGateway = oldGateway.getBytes();
        req.newGateway = newGateway.getBytes();
        req.port = port.getBytes();
        req.gatewayType = BigInteger.valueOf(gatewayType);
        char cmdCode = '\u011a';
        byte recvModule = 1;
        AsnTkSwitchGatewayRsp rsp = new AsnTkSwitchGatewayRsp();
        TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, recvModule, 120);
        TKLogManager.writeToDebug("switchGateway.isSuccess: " + ret.isSuccess);
    }
}

