/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.nbpld;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.communicate.TKCommUtility;
import com.huawei.dc.toolkit.client.base.communicate.TKCommandResult;
import com.huawei.dc.toolkit.client.base.util.TKCommonUtil;
import com.huawei.dc.toolkit.client.base.util.TKDebug;
import com.huawei.dc.toolkit.client.base.util.TKFileUtilities;
import com.huawei.dc.toolkit.client.base.util.TKFtpStruct;
import com.huawei.dc.toolkit.client.base.util.TKLoadFileStruct;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.TKUIStyleManager;
import com.huawei.dc.toolkit.client.base.util.component.TKButtonRenderer;
import com.huawei.dc.toolkit.client.base.util.component.TKPopMenuItem;
import com.huawei.dc.toolkit.client.base.util.filechooser.TKFileChooser;
import com.huawei.dc.toolkit.client.base.util.filtertable.TKFilterTable;
import com.huawei.dc.toolkit.client.base.util.filtertable.TKFilterTableModel;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultStruct;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultVector;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperationShowMgr;
import com.huawei.dc.toolkit.client.te.toolkit.nbpld.TKNBPLoadDataStruct;
import com.huawei.dc.toolkit.client.te.toolkit.nbpld.TKNBPLoadInterFrame;
import com.huawei.dc.toolkit.client.te.toolkit.nbpld.TKNBPRes;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKASNTool;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKButtonEditor;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKButtonEditorInterface;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKConfirmOperationDlg;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKFileFilterMananger;
import com.huawei.te.toolkit.AsnBulkReturn;
import com.huawei.te.toolkit.AsnOneReturn;
import com.huawei.te.toolkit.AsnTkGetPkgFileInfoReq;
import com.huawei.te.toolkit.AsnTkGetPkgFileInfoRsp;
import com.huawei.te.toolkit.AsnTkSPHActReq;
import com.huawei.te.toolkit.AsnTkSPHInfo;
import com.huawei.te.toolkit.AsnTkSPHInfoQueryReq;
import com.huawei.te.toolkit.AsnTkSPHInfoQueryRsp;
import com.huawei.te.toolkit.AsnTkSPHLoadInfo;
import com.huawei.te.toolkit.AsnTkSPHLoadReq;
import com.huawei.te.toolkit.AsnTkSPHRollbackReq;
import com.huawei.te.toolkit.AsnToolkitBdPatchActReq;
import com.huawei.te.toolkit.AsnToolkitBdPatchConfReq;
import com.huawei.te.toolkit.AsnToolkitBdPatchRbackReq;
import com.huawei.te.toolkit.AsnToolkitBdPatchRbackRsp;
import com.huawei.te.toolkit.AsnToolkitBoardRet;
import com.huawei.te.toolkit.AsnToolkitClientQueryCanCloseRsp;
import com.huawei.te.toolkit.AsnToolkitLoadBoard;
import com.huawei.te.toolkit.AsnToolkitOperObjAndState;
import com.huawei.te.toolkit.AsnToolkitPatchGetInfoReq;
import com.huawei.te.toolkit.AsnToolkitPatchGetInfoRsp;
import com.huawei.te.toolkit.AsnToolkitPatchInfo;
import com.huawei.te.toolkit.AsnToolkitPatchSoftCopyInfo;
import com.huawei.te.toolkit.AsnToolkitPatchSoftCopyReq;
import com.huawei.te.toolkit.AsnToolkitPatchSoftCopyRsp;
import com.huawei.te.toolkit.AsnToolkitQueryReq;
import com.huawei.te.toolkit.AsnToolkitQueryRsp;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.commustru.fstru.FStruct;

public class TKNBPLoadTablePaneDef
extends JPanel
implements TKButtonEditorInterface {
    private static final long serialVersionUID = -6905111105215186316L;
    protected static final int STATE_SPH_NORMAL = 1;
    protected static final int STATE_SPH_COPY = 2;
    protected static final int STATE_SPH_WAITACT = 3;
    protected static final int STATE_SPH_ACTIVE = 4;
    protected static final int STATE_SPH_RBACK = 5;
    protected static final int STATE_SPH_WCONFIRM = 6;
    protected static final int STATE_SPH_ABNORMAL = 7;
    protected static final int STATE_BD_NORMAL = 1;
    protected static final int STATE_BD_ABNORMAL = 2;
    protected static final int STATE_BD_COPY = 3;
    protected static final int STATE_BD_WAITACT = 4;
    protected static final int STATE_BD_ACTIVE = 5;
    protected static final int STATE_BD_WCONFIRM = 6;
    protected static final int STATE_BD_RBACK = 7;
    protected static final String CMD_SELECT_SOFT = "PATCH_SELECT_SOFT";
    protected static final int COL_NENAME = 0;
    protected static final int COL_NETYPE = 1;
    protected static final int COL_BOARD = 2;
    protected static final int COL_STATUS = 3;
    protected static final int COL_GUAGE = 4;
    protected static final int COL_RUNSOFTVER = 5;
    protected static final int COL_PATCHSOFTVER = 6;
    protected static final int COL_FILE = 7;
    protected static Icon iconNe = TKResourceManager.getIcon("ne.gif");
    protected static Icon iconBoard = TKResourceManager.getIcon("board3-0.gif");
    protected static Icon iconBoardScc = TKResourceManager.getIcon("board1-0.gif");
    protected static Icon iconBoardSB = TKResourceManager.getIcon("board2-0.gif");
    protected static Icon iconNeLogout = TKResourceManager.getIcon("nelogout.gif");
    protected Icon iconFileOpen = TKResourceManager.getIcon("fileopen.gif");
    protected JPopupMenu popupMenu = new JPopupMenu();
    protected TKPopMenuItem miClearFile = new TKPopMenuItem();
    protected TKNBPLoadInterFrame tkframe = null;
    protected TKNBPRes res = TKNBPRes.instance();
    String[] tableColName = new String[]{this.res.getString("NeName"), this.res.getString("NeType"), this.res.getString("BoardType"), this.res.getString("Status"), this.res.getString("Guage"), this.res.getString("DevSoftVer"), this.res.getString("PatchSoftVer"), this.res.getString("LoadPatchSoftVer")};
    protected TKFilterTableModel tableModel = new TKFilterTableModel(this.tableColName);
    protected TKFilterTable loadTable = new TKFilterTable(this.tableModel){

        @Override
        public Icon getIcon(int row) {
            TKNBPLoadDataStruct rowData = (TKNBPLoadDataStruct)this.getRow(row);
            Icon icon = TKNBPLoadTablePaneDef.getIcon(rowData);
            if (icon == null) {
                return super.getIcon(row);
            }
            return icon;
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            if (column == 7) {
                return new TKButtonEditor(TKNBPLoadTablePaneDef.this, "", TKNBPLoadTablePaneDef.CMD_SELECT_SOFT, TKNBPLoadTablePaneDef.this.iconFileOpen);
            }
            return super.getCellEditor(row, column);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            if (column == 7) {
                return new TKButtonRenderer("", TKNBPLoadTablePaneDef.this.iconFileOpen);
            }
            return new StateCellRenderer();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            TKNBPLoadDataStruct rowData = (TKNBPLoadDataStruct)this.getRow(row);
            if (rowData.isNEPkg) {
                if (column == 7) {
                    return !TKNBPLoadTablePaneDef.this.isSPHLoadState(rowData.status) && rowData.status != 7;
                }
            } else if (column == 7) {
                return !TKNBPLoadTablePaneDef.this.isBoardLoadState(rowData.status);
            }
            return false;
        }
    };

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isSPHLoadState(int status) {
        if (status == 4) return true;
        if (status == 2) return true;
        if (status == 5) return true;
        if (status == 6) return true;
        if (status != 3) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isBoardLoadState(int status) {
        if (status == 5) return true;
        if (status == 3) return true;
        if (status == 7) return true;
        if (status == 6) return true;
        if (status != 4) return false;
        return true;
    }

    protected static Icon getIcon(TKNBPLoadDataStruct rowData) {
        if (rowData != null) {
            if (rowData.isNEPkg) {
                if (!rowData.nedata.isLogin) {
                    return iconNeLogout;
                }
                return iconNe;
            }
            if (rowData.board.boardKind == 1) {
                return iconBoardScc;
            }
            if (rowData.board.boardKind == 2) {
                return iconBoardSB;
            }
            return iconBoard;
        }
        return null;
    }

    private Color getStateColor(TKNBPLoadDataStruct rowData, int column) {
        block12: {
            int state;
            block14: {
                block13: {
                    block10: {
                        block11: {
                            state = rowData.status;
                            if (!rowData.isNEPkg) break block10;
                            if (state == 3) break block11;
                            if (state == 2) break block11;
                            if (state == 5) break block11;
                            if (state == 6) break block11;
                            if (state != 4) break block12;
                        }
                        if (column == 3 && state == 3) {
                            return TKUIStyleManager.getImportantAlterColor();
                        }
                        return UIManager.getColor("controlShadow");
                    }
                    if (state == 4) break block13;
                    if (state == 3) break block13;
                    if (state == 7) break block13;
                    if (state == 2) break block13;
                    if (state == 6) break block13;
                    if (state != 5) break block14;
                }
                if (column == 3 && state == 2) {
                    return TKUIStyleManager.getMostAlterColor();
                }
                if (column == 3 && (state == 4 || state == 6)) {
                    return TKUIStyleManager.getImportantAlterColor();
                }
                return UIManager.getColor("controlShadow");
            }
            if (column == 3 && state == 2) {
                return TKUIStyleManager.getMostAlterColor();
            }
        }
        return this.loadTable.getForeground();
    }

    public TKNBPLoadTablePaneDef() {
    }

    public TKNBPLoadTablePaneDef(LayoutManager layout) {
        super(layout);
    }

    public TKNBPLoadTablePaneDef(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public TKNBPLoadTablePaneDef(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    private void patch_rollbackSPH() {
        int[] selectedRows = this.loadTable.getSelectedRows();
        TKOperResultVector resultV = new TKOperResultVector();
        AsnTkSPHRollbackReq req = new AsnTkSPHRollbackReq();
        TKNBPLoadDataStruct startDataObj = null;
        char cmdCode = '\u2004';
        byte receiveModule = 32;
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), true);
        for (int i = 0; i < selectedRows.length; ++i) {
            req.neIDList.removeAllElements();
            startDataObj = (TKNBPLoadDataStruct)this.tableModel.getRow(selectedRows[i]);
            if (!startDataObj.isNEPkg) continue;
            req.neIDList.add((Object)BigInteger.valueOf(startDataObj.nedata.neID));
            AsnBulkReturn rsp = new AsnBulkReturn();
            TKCommandResult ret2 = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, receiveModule, 120);
            if (!ret2.isSuccess) {
                String operObj = startDataObj.nedata.neName;
                String operResult = this.res.getString("StartRollbackSPHFail");
                String operReason = ret2.resultInfo;
                TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                resultV.addElement(struct);
                continue;
            }
            for (AsnOneReturn asnRtn : rsp) {
                TKNBPLoadDataStruct HideData = this.getTableDatabyID(asnRtn.id.intValue(), 0);
                if (HideData == null || asnRtn.ret.isSuccess) continue;
                String dateInfo = ret2.serverDateTime + "    ";
                String operObj = HideData.nedata.neName;
                String operResult = this.res.getString("StartRollbackSPHFail");
                String operReason = TKASNTool.getErrorInfo(asnRtn.ret);
                TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                resultV.addElement(struct);
                if (HideData.resultInfo.trim().length() > 1) {
                    String tmp = HideData.resultInfo.endsWith("\n") ? "" : "\n";
                    HideData.resultInfo = HideData.resultInfo + tmp;
                }
                HideData.resultInfo = HideData.resultInfo + dateInfo + operResult + "    " + operReason;
                this.tkframe.infoTablePanel.updateObjectResult(HideData);
            }
        }
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), false);
        if (resultV.size() > 0) {
            TKOperationShowMgr.showOperationDlg((Component)this.tkframe, this.res.getString("OperResult"), resultV);
        }
    }

    protected void patch_load() {
        int[] selectedRows;
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().stopCellEditing();
        }
        if ((selectedRows = this.loadTable.getSelectedRows()) == null || selectedRows.length < 1) {
            return;
        }
        TKOperResultVector resultV = new TKOperResultVector();
        boolean isSPH = false;
        for (int j = 0; j < selectedRows.length; ++j) {
            TKNBPLoadDataStruct data = (TKNBPLoadDataStruct)this.tableModel.getRow(selectedRows[j]);
            isSPH = data.isNEPkg;
            if (data.patchFile != null) continue;
            String nename = data.nedata.neName;
            if (!data.isNEPkg) {
                nename = data.nedata.neName + "-" + data.board.slotID + "-" + data.board.boardType;
            }
            String operResult = this.res.getString("LoadFailure");
            String operReason = this.res.getString("NotSelectedFile");
            TKOperResultStruct struct = new TKOperResultStruct(nename, operResult, operReason);
            resultV.addElement(struct);
        }
        if (resultV.size() > 0) {
            TKOperationShowMgr.showOperationDlg((Component)this.getParent(), this.res.getString("NotSetParam"), resultV);
            return;
        }
        if (!this.operNumberCheck(true)) {
            return;
        }
        if (isSPH) {
            this.patch_loadSPH();
        } else {
            this.patch_loadBoard();
        }
    }

    protected boolean operNumberCheck(boolean needCheckAct) {
        TKOperResultVector resultV = new TKOperResultVector();
        int hintIndex = 1;
        int[] selectedRows = this.loadTable.getSelectedRows();
        String dlgDesc = this.res.getString("OperationEffact");
        int limit = TKResourceManager.getNumberOfLoadObject();
        if (needCheckAct) {
            AsnToolkitQueryReq numberReq = new AsnToolkitQueryReq();
            numberReq.queryInfo = BigInteger.ZERO;
            AsnToolkitQueryRsp numberRsp = new AsnToolkitQueryRsp();
            char cmdCode1 = '\u1108';
            byte receiveModule1 = 17;
            TKScreenToolKit.setComponentCursorBusy(this.tkframe, true);
            TKCommandResult ret1 = TKCommUtility.sendCommand((FStruct)numberReq, (FStruct)numberRsp, cmdCode1, receiveModule1, 120);
            TKScreenToolKit.setComponentCursorBusy(this.tkframe, false);
            if (!ret1.isSuccess) {
                TKOperationShowMgr.showOperationDlg((Component)this.getParent(), ret1.resultInfo, false);
                return false;
            }
            int activeNum = numberRsp.activenum.intValue();
            if (activeNum > 0) {
                resultV.addElement(hintIndex++ + "." + this.res.getString("WaitForActicving"));
            }
        }
        AsnToolkitClientQueryCanCloseRsp numberOptRsp = new AsnToolkitClientQueryCanCloseRsp();
        char cmdCodeOpt = '\u010f';
        byte receiveModule1Opt = 1;
        TKScreenToolKit.setComponentCursorBusy(this.tkframe, true);
        TKCommandResult ret3 = TKCommUtility.sendCommand(null, (FStruct)numberOptRsp, cmdCodeOpt, receiveModule1Opt, 120);
        TKScreenToolKit.setComponentCursorBusy(this.tkframe, false);
        if (!ret3.isSuccess) {
            TKOperationShowMgr.showOperationDlg((Component)this.getParent(), ret3.resultInfo, false);
            return false;
        }
        Vector<String> vc2 = new Vector<String>();
        Iterator loadInfoItr = numberOptRsp.objAndOperList.iterator();
        if (null != loadInfoItr) {
            while (loadInfoItr.hasNext()) {
                AsnToolkitOperObjAndState operObjAndState = (AsnToolkitOperObjAndState)loadInfoItr.next();
                String loadID = String.valueOf(operObjAndState.neID);
                vc2.add(loadID);
            }
        }
        for (int i = 0; i < selectedRows.length; ++i) {
            TKNBPLoadDataStruct data = (TKNBPLoadDataStruct)this.tableModel.getRow(selectedRows[i]);
            String neKey = String.valueOf(data.nedata.neID);
            if (vc2.contains(neKey)) continue;
            vc2.add(neKey);
        }
        int objNumber = vc2.size();
        if (objNumber > limit) {
            resultV.addElement(hintIndex++ + "." + this.res.getString("LoadNumBeyondLimit") + limit);
        }
        if (hintIndex > 1) {
            TKConfirmOperationDlg confDlg = new TKConfirmOperationDlg(TKResourceManager.getMainFrame(), this.res.getString("Warning"), dlgDesc, resultV, true, true);
            confDlg.setDefaultCloseOperation(2);
            confDlg.hideDetailColumn();
            TKScreenToolKit.centerLocateToScreen(confDlg);
            int willContinue = confDlg.showDialog();
            if (willContinue == 1) {
                return false;
            }
        }
        resultV.clear();
        return true;
    }

    protected void patch_rollback() {
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().stopCellEditing();
        }
        TKConfirmOperationDlg confDlg = new TKConfirmOperationDlg(TKResourceManager.getMainFrame(), this.res.getString("Hint"), this.res.getString("NtcRollbackInfo"), null, true, false);
        confDlg.setDefaultCloseOperation(2);
        int willContinue = confDlg.showDialog();
        if (willContinue == 1) {
            return;
        }
        int[] selectedRows = this.loadTable.getSelectedRows();
        if (selectedRows == null || selectedRows.length < 1) {
            return;
        }
        boolean isSPH = false;
        TKNBPLoadDataStruct data = (TKNBPLoadDataStruct)this.tableModel.getRow(selectedRows[0]);
        isSPH = data.isNEPkg;
        if (isSPH) {
            this.patch_rollbackSPH();
        } else {
            this.patch_rollbackBoard();
        }
    }

    protected void patch_active() {
        int[] selectedRows;
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().stopCellEditing();
        }
        if ((selectedRows = this.loadTable.getSelectedRows()) == null || selectedRows.length < 1) {
            return;
        }
        TKNBPLoadDataStruct data = (TKNBPLoadDataStruct)this.tableModel.getRow(selectedRows[0]);
        boolean isSPH = data.isNEPkg;
        if (isSPH) {
            this.patch_activeSPH();
        } else {
            this.patch_activeBoard();
        }
    }

    protected void patch_activeSPH() {
        int[] selectedRows;
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().stopCellEditing();
        }
        if ((selectedRows = this.loadTable.getSelectedRows()) == null || selectedRows.length == 0) {
            return;
        }
        TKOperResultVector resultV = new TKOperResultVector();
        AsnTkSPHActReq req = new AsnTkSPHActReq();
        TKNBPLoadDataStruct startDataObj = null;
        char cmdCode = '\u2003';
        byte receiveModule = 32;
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), true);
        for (int i = 0; i < selectedRows.length; ++i) {
            req.neIDList.removeAllElements();
            startDataObj = (TKNBPLoadDataStruct)this.tableModel.getRow(selectedRows[i]);
            if (!startDataObj.isNEPkg) continue;
            req.neIDList.add((Object)BigInteger.valueOf(startDataObj.nedata.neID));
            AsnBulkReturn rsp = new AsnBulkReturn();
            TKCommandResult ret2 = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, receiveModule, 120);
            String dateInfo = ret2.serverDateTime + "    ";
            if (!ret2.isSuccess) {
                String operObj = startDataObj.nedata.neName;
                String operResult = this.res.getString("StartActSPHFail");
                String operReason = ret2.resultInfo;
                TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                resultV.addElement(struct);
                continue;
            }
            Iterator retItr = rsp.iterator();
            if (null == retItr) {
                TKDebug.inmAssert(false, this.res.getString("ReturnDataNull"));
                continue;
            }
            while (retItr.hasNext()) {
                AsnOneReturn asnRtn = (AsnOneReturn)retItr.next();
                TKNBPLoadDataStruct HideData = this.getTableDatabyID(asnRtn.id.intValue(), 0);
                if (HideData == null || asnRtn.ret.isSuccess) continue;
                String operObj = HideData.nedata.neName;
                String operResult = this.res.getString("StartActSPHFail");
                String operReason = TKASNTool.getErrorInfo(asnRtn.ret);
                TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                resultV.addElement(struct);
                if (HideData.resultInfo.trim().length() > 1) {
                    String tmp = HideData.resultInfo.endsWith("\n") ? "" : "\n";
                    HideData.resultInfo = HideData.resultInfo + tmp;
                }
                HideData.resultInfo = HideData.resultInfo + dateInfo + operResult + "    " + operReason;
                this.tkframe.infoTablePanel.updateObjectResult(HideData);
            }
        }
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), false);
        if (resultV.size() > 0) {
            TKOperationShowMgr.showOperationDlg((Component)this.tkframe, this.res.getString("OperResult"), resultV);
        }
    }

    protected void patch_loadBoard() {
        int[] selectedRows;
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().stopCellEditing();
        }
        if ((selectedRows = this.loadTable.getSelectedRows()) == null || selectedRows.length == 0) {
            return;
        }
        TKOperResultVector resultV = new TKOperResultVector();
        AsnToolkitPatchSoftCopyReq req = new AsnToolkitPatchSoftCopyReq();
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), true);
        char cmdCode = '\u1102';
        byte receiveModule = 17;
        TKNBPLoadDataStruct startDataObj = null;
        for (int i = 0; i < selectedRows.length; ++i) {
            req.copyInfoList.removeAllElements();
            startDataObj = (TKNBPLoadDataStruct)this.tableModel.getRow(selectedRows[i]);
            AsnToolkitPatchSoftCopyInfo copyInfo = new AsnToolkitPatchSoftCopyInfo();
            copyInfo.neID = BigInteger.valueOf(startDataObj.nedata.neID);
            copyInfo.slotID = BigInteger.valueOf(startDataObj.board.slotID);
            copyInfo.patchFile = TKASNTool.toAsn1SoftInfo(startDataObj.patchFile);
            req.copyInfoList.add((Object)copyInfo);
            AsnToolkitPatchSoftCopyRsp rsp = new AsnToolkitPatchSoftCopyRsp();
            TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, receiveModule, 120);
            if (!ret.isSuccess) {
                String operObj = startDataObj.nedata.neName;
                String operResult = this.res.getString("StartCopyNBPFail");
                String operReason = ret.resultInfo;
                TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                resultV.addElement(struct);
                continue;
            }
            String dateInfo = ret.serverDateTime + "    ";
            for (AsnToolkitBoardRet asnRtn : rsp.retInfoList) {
                TKNBPLoadDataStruct HideData = this.getTableDatabyID(asnRtn.neID.intValue(), asnRtn.slotID.intValue());
                if (HideData == null || asnRtn.ret.isSuccess) continue;
                String operObj = HideData.nedata.neName + "-" + HideData.board.slotID + "-" + HideData.board.boardType;
                String operResult = this.res.getString("StartCopyNBPFail");
                String operReason = TKRes.getErrorInfo(asnRtn.ret);
                TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                resultV.addElement(struct);
                if (HideData.resultInfo.trim().length() > 1) {
                    String tmp = HideData.resultInfo.endsWith("\n") ? "" : "\n";
                    HideData.resultInfo = HideData.resultInfo + tmp + dateInfo + operResult + "    " + operReason;
                } else {
                    HideData.resultInfo = HideData.resultInfo + dateInfo + operResult + "    " + operReason;
                }
                this.tkframe.infoTablePanel.updateObjectResult(HideData);
            }
        }
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), false);
        if (resultV.size() > 0) {
            TKOperationShowMgr.showOperationDlg((Component)this.tkframe, this.res.getString("OperResult"), resultV);
        }
    }

    protected void patch_activeBoard() {
        int[] selectedRows;
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().stopCellEditing();
        }
        if ((selectedRows = this.loadTable.getSelectedRows()) == null || selectedRows.length == 0) {
            return;
        }
        TKOperResultVector resultV = new TKOperResultVector();
        AsnToolkitBdPatchActReq req = new AsnToolkitBdPatchActReq();
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), true);
        char cmdCode = '\u1104';
        byte receiveModule = 17;
        TKNBPLoadDataStruct startDataObj = null;
        for (int i = 0; i < selectedRows.length; ++i) {
            req.patchActiveInfoList.removeAllElements();
            startDataObj = (TKNBPLoadDataStruct)this.tableModel.getRow(selectedRows[i]);
            AsnToolkitLoadBoard bdInfo = new AsnToolkitLoadBoard();
            bdInfo.neID = BigInteger.valueOf(startDataObj.nedata.neID);
            bdInfo.slotID = BigInteger.valueOf(startDataObj.board.slotID);
            req.patchActiveInfoList.add((Object)bdInfo);
            AsnToolkitPatchSoftCopyRsp rsp = new AsnToolkitPatchSoftCopyRsp();
            TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, receiveModule, 120);
            if (!ret.isSuccess) {
                String operObj = startDataObj.nedata.neName;
                String operResult = this.res.getString("StartActivateNBPFail");
                String operReason = ret.resultInfo;
                TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                resultV.addElement(struct);
                continue;
            }
            for (AsnToolkitBoardRet asnRtn : rsp.retInfoList) {
                TKNBPLoadDataStruct HideData = this.getTableDatabyID(asnRtn.neID.intValue(), asnRtn.slotID.intValue());
                if (HideData == null || asnRtn.ret.isSuccess) continue;
                String dateInfo = ret.serverDateTime + "    ";
                String operObj = HideData.nedata.neName + "-" + HideData.board.slotID + "-" + HideData.board.boardType;
                String operResult = this.res.getString("StartActivateNBPFail");
                String operReason = TKRes.getErrorInfo(asnRtn.ret);
                TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                resultV.addElement(struct);
                if (HideData.resultInfo.trim().length() > 1) {
                    String tmp = HideData.resultInfo.endsWith("\n") ? "" : "\n";
                    HideData.resultInfo = HideData.resultInfo + tmp + dateInfo + operResult + "    " + operReason;
                } else {
                    HideData.resultInfo = HideData.resultInfo + dateInfo + operResult + "    " + operReason;
                }
                this.tkframe.infoTablePanel.updateObjectResult(HideData);
            }
        }
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), false);
        if (resultV.size() > 0) {
            TKOperationShowMgr.showOperationDlg((Component)this.tkframe, this.res.getString("OperResult"), resultV);
        }
    }

    protected void patch_confirmBoard() {
        int[] selectedRows;
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().stopCellEditing();
        }
        if ((selectedRows = this.loadTable.getSelectedRows()) == null || selectedRows.length == 0) {
            return;
        }
        TKOperResultVector resultV = new TKOperResultVector();
        AsnToolkitBdPatchConfReq req = new AsnToolkitBdPatchConfReq();
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), true);
        char cmdCode = '\u1105';
        byte receiveModule = 17;
        TKNBPLoadDataStruct startDataObj = null;
        for (int i = 0; i < selectedRows.length; ++i) {
            req.patchActiveInfoList.removeAllElements();
            startDataObj = (TKNBPLoadDataStruct)this.tableModel.getRow(selectedRows[i]);
            AsnToolkitLoadBoard bdInfo = new AsnToolkitLoadBoard();
            bdInfo.neID = BigInteger.valueOf(startDataObj.nedata.neID);
            bdInfo.slotID = BigInteger.valueOf(startDataObj.board.slotID);
            req.patchActiveInfoList.add((Object)bdInfo);
            AsnToolkitPatchSoftCopyRsp rsp = new AsnToolkitPatchSoftCopyRsp();
            TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, receiveModule, 120);
            if (!ret.isSuccess) {
                String operObj = startDataObj.nedata.neName;
                String operResult = this.res.getString("ConfirmNBPFail");
                String operReason = ret.resultInfo;
                TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                resultV.addElement(struct);
                continue;
            }
            for (AsnToolkitBoardRet asnRtn : rsp.retInfoList) {
                TKNBPLoadDataStruct HideData = this.getTableDatabyID(asnRtn.neID.intValue(), asnRtn.slotID.intValue());
                if (HideData == null || asnRtn.ret.isSuccess) continue;
                String dateInfo = ret.serverDateTime + "    ";
                String operObj = HideData.nedata.neName + "-" + HideData.board.slotID + "-" + HideData.board.boardType;
                String operResult = this.res.getString("ConfirmNBPFail");
                String operReason = TKRes.getErrorInfo(asnRtn.ret);
                TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                resultV.addElement(struct);
                if (HideData.resultInfo.trim().length() > 1) {
                    String tmp = HideData.resultInfo.endsWith("\n") ? "" : "\n";
                    HideData.resultInfo = HideData.resultInfo + tmp + dateInfo + operResult + "    " + operReason;
                } else {
                    HideData.resultInfo = HideData.resultInfo + dateInfo + operResult + "    " + operReason;
                }
                this.tkframe.infoTablePanel.updateObjectResult(HideData);
            }
        }
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), false);
        if (resultV.size() > 0) {
            TKOperationShowMgr.showOperationDlg((Component)this.tkframe, this.res.getString("OperResult"), resultV);
        }
    }

    protected void patch_rollbackBoard() {
        int[] selectedRows;
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().stopCellEditing();
        }
        if ((selectedRows = this.loadTable.getSelectedRows()) == null || selectedRows.length == 0) {
            return;
        }
        TKOperResultVector resultV = new TKOperResultVector();
        AsnToolkitBdPatchRbackReq req = new AsnToolkitBdPatchRbackReq();
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), true);
        char cmdCode = '\u1106';
        byte receiveModule = 17;
        TKNBPLoadDataStruct startDataObj = null;
        for (int i = 0; i < selectedRows.length; ++i) {
            startDataObj = (TKNBPLoadDataStruct)this.tableModel.getRow(selectedRows[i]);
            AsnToolkitLoadBoard bdPatch = new AsnToolkitLoadBoard();
            bdPatch.neID = BigInteger.valueOf(startDataObj.nedata.neID);
            bdPatch.slotID = BigInteger.valueOf(startDataObj.board.slotID);
            req.patchActiveInfoList.removeAllElements();
            req.patchActiveInfoList.add((Object)bdPatch);
            AsnToolkitBdPatchRbackRsp rsp = new AsnToolkitBdPatchRbackRsp();
            TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, receiveModule, 120);
            if (!ret.isSuccess) {
                String operObj = startDataObj.nedata.neName;
                String operResult = this.res.getString("StartRollbackNBPFail");
                String operReason = ret.resultInfo;
                TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                resultV.addElement(struct);
                continue;
            }
            String dateInfo = ret.serverDateTime + "    ";
            for (AsnToolkitBoardRet asnRtn : rsp.retInfoList) {
                TKNBPLoadDataStruct HideData = this.getTableDatabyID(asnRtn.neID.intValue(), asnRtn.slotID.intValue());
                if (HideData == null || asnRtn.ret.isSuccess) continue;
                String operObj = HideData.nedata.neName + "-" + HideData.board.slotID + "-" + HideData.board.boardType;
                String operResult = this.res.getString("StartRollbackNBPFail");
                String operReason = TKRes.getErrorInfo(asnRtn.ret);
                TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                resultV.addElement(struct);
                if (HideData.resultInfo.trim().length() > 1) {
                    String tmp = HideData.resultInfo.endsWith("\n") ? "" : "\n";
                    HideData.resultInfo = HideData.resultInfo + tmp + dateInfo + operResult + "    " + operReason;
                } else {
                    HideData.resultInfo = HideData.resultInfo + dateInfo + operResult + "    " + operReason;
                }
                this.tkframe.infoTablePanel.updateObjectResult(HideData);
            }
        }
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), false);
        if (resultV.size() > 0) {
            TKOperationShowMgr.showOperationDlg((Component)this.tkframe, this.res.getString("OperResult"), resultV);
        }
    }

    protected void patch_loadSPH() {
        int[] selectedRows;
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().stopCellEditing();
        }
        if ((selectedRows = this.loadTable.getSelectedRows()) == null || selectedRows.length == 0) {
            return;
        }
        TKOperResultVector resultV = new TKOperResultVector();
        AsnTkSPHLoadReq req = new AsnTkSPHLoadReq();
        TKNBPLoadDataStruct startDataObj = null;
        AsnTkSPHLoadInfo sphInfo = null;
        char cmdCode = '\u2002';
        byte receiveModule = 32;
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), true);
        for (int i = 0; i < selectedRows.length; ++i) {
            req.pathList.removeAllElements();
            startDataObj = (TKNBPLoadDataStruct)this.tableModel.getRow(selectedRows[i]);
            if (!startDataObj.isNEPkg) continue;
            sphInfo = new AsnTkSPHLoadInfo();
            sphInfo.neID = BigInteger.valueOf(startDataObj.nedata.neID);
            sphInfo.loadPkg = TKASNTool.toAsn1SoftInfo(startDataObj.patchFile);
            req.pathList.add((Object)sphInfo);
            AsnBulkReturn rsp = new AsnBulkReturn();
            TKCommandResult ret2 = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, receiveModule, 120);
            String dateInfo = ret2.serverDateTime + "    ";
            if (!ret2.isSuccess) {
                String operObj = startDataObj.nedata.neName;
                String operResult = this.res.getString("StartCopySPHFail");
                String operReason = ret2.resultInfo;
                TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                resultV.addElement(struct);
                continue;
            }
            for (AsnOneReturn asnRtn : rsp) {
                TKNBPLoadDataStruct HideData = this.getTableDatabyID(asnRtn.id.intValue(), 0);
                if (HideData == null || asnRtn.ret.isSuccess) continue;
                String operObj = HideData.nedata.neName;
                String operResult = this.res.getString("StartCopySPHFail");
                String operReason = TKASNTool.getErrorInfo(asnRtn.ret);
                TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                resultV.addElement(struct);
                if (HideData.resultInfo.trim().length() > 1) {
                    String tmp = HideData.resultInfo.endsWith("\n") ? "" : "\n";
                    HideData.resultInfo = HideData.resultInfo + tmp;
                }
                HideData.resultInfo = HideData.resultInfo + dateInfo + operResult + "    " + operReason;
                this.tkframe.infoTablePanel.updateObjectResult(HideData);
            }
        }
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), false);
        if (resultV.size() > 0) {
            TKOperationShowMgr.showOperationDlg((Component)this.tkframe, this.res.getString("OperResult"), resultV);
        }
    }

    public TKNBPLoadDataStruct getTableDatabyID(int neID, int slotID) {
        Vector tableDatas = new Vector(this.tableModel.getDatas());
        TKNBPLoadDataStruct dataRet = null;
        try {
            for (TKNBPLoadDataStruct data : tableDatas) {
                if (data.nedata.neID != neID || data.board.slotID != slotID && (slotID > 0 || !data.isNEPkg)) continue;
                dataRet = data;
                break;
            }
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
        tableDatas.removeAllElements();
        return dataRet;
    }

    protected boolean patch_queryBoard(TKNBPLoadDataStruct neData, TKOperResultVector resultV) {
        AsnToolkitPatchGetInfoReq req = new AsnToolkitPatchGetInfoReq();
        AsnToolkitLoadBoard bdInfo = new AsnToolkitLoadBoard();
        bdInfo.neID = BigInteger.valueOf(neData.nedata.neID);
        bdInfo.slotID = BigInteger.valueOf(neData.board.slotID);
        req.bdList.add((Object)bdInfo);
        AsnToolkitPatchGetInfoRsp rsp = new AsnToolkitPatchGetInfoRsp();
        char cmdCode = '\u1101';
        byte recvModule = 17;
        TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, recvModule, 120);
        if (!ret.isSuccess) {
            TKOperationShowMgr.showOperationDlg((Component)this.tkframe, ret.resultInfo, false);
            return false;
        }
        Iterator bdinfoItr = rsp.patchInfoList.iterator();
        Iterator retItr = rsp.retInfoList.iterator();
        while (bdinfoItr.hasNext()) {
            AsnToolkitPatchInfo patchInfo = (AsnToolkitPatchInfo)bdinfoItr.next();
            AsnToolkitBoardRet asnRtn = (AsnToolkitBoardRet)retItr.next();
            if (!asnRtn.ret.isSuccess) {
                String operObj = neData.nedata.neName;
                String operResult = this.res.getString("QueryFail");
                String operReason = TKASNTool.getErrorInfo(asnRtn.ret);
                TKOperResultStruct result = new TKOperResultStruct(operObj, operResult, operReason);
                resultV.addElement(result);
                continue;
            }
            this.updateBoardInfoData(neData, patchInfo);
        }
        return true;
    }

    protected boolean patch_querySPH(TKNBPLoadDataStruct neData, TKOperResultVector resultV) {
        AsnTkSPHInfoQueryReq req = new AsnTkSPHInfoQueryReq();
        req.neIdlist.add((Object)BigInteger.valueOf(neData.nedata.neID));
        AsnTkSPHInfoQueryRsp rsp = new AsnTkSPHInfoQueryRsp();
        char cmdCode = '\u2001';
        byte recvModule = 32;
        TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, recvModule, 120);
        if (!ret.isSuccess) {
            TKOperationShowMgr.showOperationDlg((Component)this.tkframe, ret.resultInfo, false);
            return false;
        }
        Iterator sphInfoItr = rsp.neSPHInfoList.iterator();
        Iterator retItr = rsp.ret.iterator();
        if (null != sphInfoItr && null != retItr) {
            while (sphInfoItr.hasNext()) {
                AsnTkSPHInfo sphInfo = (AsnTkSPHInfo)sphInfoItr.next();
                AsnOneReturn asnRtn = (AsnOneReturn)retItr.next();
                if (!asnRtn.ret.isSuccess) {
                    String operObj = neData.nedata.neName;
                    String operResult = this.res.getString("QueryFail");
                    String operReason = TKASNTool.getErrorInfo(asnRtn.ret);
                    TKOperResultStruct result = new TKOperResultStruct(operObj, operResult, operReason);
                    resultV.addElement(result);
                    continue;
                }
                this.updateSPHInfoData(neData, sphInfo);
            }
        }
        return true;
    }

    protected void updateSPHInfoData(TKNBPLoadDataStruct neData, AsnTkSPHInfo sphInfo) {
        neData.status = sphInfo.loadState.intValue();
        neData.startTime = new String(sphInfo.startTime);
        neData.endTime = new String(sphInfo.endTime);
        neData.guage = sphInfo.guage.intValue();
        neData.runVer = new String(sphInfo.runVer);
        neData.patchVer = new String(sphInfo.patchVer);
        TKFtpStruct tempPatchFile = TKASNTool.softInfoToTKFile(sphInfo.loadPkg);
        if (this.isSPHLoadState(neData.status) && tempPatchFile != null) {
            neData.patchFile = tempPatchFile;
        }
    }

    protected void updateBoardInfoData(TKNBPLoadDataStruct boardData, AsnToolkitPatchInfo patchInfo) {
        boardData.status = patchInfo.loadState.intValue();
        boardData.guage = patchInfo.guage.intValue();
        boardData.startTime = new String(patchInfo.startTime);
        boardData.endTime = new String(patchInfo.endTime);
        boardData.runVer = new String(patchInfo.bdSoftVer);
        boardData.patchVer = new String(patchInfo.patchSoftVer);
        TKFtpStruct tempPatchFile = TKASNTool.softInfoToTKFile(patchInfo.patchFile);
        if (this.isBoardLoadState(boardData.status) && tempPatchFile != null) {
            boardData.patchFile = tempPatchFile;
        }
    }

    @Override
    public void actionPerformedByEditor(ActionEvent e) {
        int[] selectedRows;
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().stopCellEditing();
        }
        if ((selectedRows = this.loadTable.getSelectedRows()) == null || selectedRows.length == 0) {
            return;
        }
        TKNBPLoadDataStruct firstData = (TKNBPLoadDataStruct)this.tableModel.getRow(selectedRows[0]);
        for (int i = 0; i < selectedRows.length; ++i) {
            TKNBPLoadDataStruct data = (TKNBPLoadDataStruct)this.tableModel.getRow(selectedRows[i]);
            if (firstData.isNEPkg != data.isNEPkg) {
                return;
            }
            if (!(data.isNEPkg ? this.isSPHLoadState(data.status) || data.status == 7 : this.isBoardLoadState(data.status))) continue;
            return;
        }
        this.patch_selectPatch();
    }

    public boolean queryPatchVersion(TKFtpStruct pkgFile) {
        AsnTkGetPkgFileInfoReq req = new AsnTkGetPkgFileInfoReq();
        req.neID = BigInteger.valueOf(0L);
        req.pkgSoftInfo = TKASNTool.toAsn1SoftInfo(pkgFile);
        AsnTkGetPkgFileInfoRsp rsp = new AsnTkGetPkgFileInfoRsp();
        char cmdCode = '\u1706';
        byte receiveModule = 23;
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), true);
        TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, receiveModule, 120);
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), false);
        if (!ret.isSuccess) {
            TKOperationShowMgr.showOperationDlg((Component)this.getParent(), ret.resultInfo, false);
            return false;
        }
        if (!rsp.ret.isSuccess) {
            String operReason = this.res.getString("QuerySWPFail") + "\n" + TKASNTool.getErrorInfo(rsp.ret);
            TKOperationShowMgr.showOperationDlg((Component)this, operReason, false);
            return false;
        }
        pkgFile.softVersion = new String(rsp.pkgVer);
        return true;
    }

    private void patch_selectPatch() {
        int result;
        TKFtpStruct lastFile;
        int[] selectedRows = this.loadTable.getSelectedRows();
        if (selectedRows == null || selectedRows.length == 0) {
            return;
        }
        TKNBPLoadDataStruct rowData = (TKNBPLoadDataStruct)this.tableModel.getRow(selectedRows[0]);
        TKFileChooser fc = new TKFileChooser(TKCommonUtil.getRootPath());
        fc.setMultiSelectionEnabled(false);
        if (rowData.isNEPkg) {
            fc.addFileFilter(TKFileFilterMananger.sphFilter);
        } else {
            fc.addFileFilter(TKFileFilterMananger.patchFilter);
        }
        fc.setFileSelectionMode(0);
        if (selectedRows.length == 1 && (lastFile = rowData.patchFile) != null && lastFile != TKLoadFileStruct.nullFile) {
            if (lastFile.isFtp) {
                fc.initFtp(lastFile.ftpIP, lastFile.ftpPort, lastFile.ftpUser, lastFile.ftpPass);
                fc.setBrowseType(100);
            }
            fc.setCurrentDirectory(TKFileUtilities.getParent(lastFile));
        }
        if ((result = fc.showFileDialog()) == 0) {
            TKFtpStruct selectedFile = (TKFtpStruct)fc.getSelectedFile();
            boolean isSuccessQueryVersion = this.queryPatchVersion(selectedFile);
            if (!isSuccessQueryVersion) {
                selectedFile = null;
                return;
            }
            if (null != this.loadTable.getCellEditor()) {
                this.loadTable.getCellEditor().cancelCellEditing();
            }
            for (int i = 0; i < selectedRows.length; ++i) {
                TKNBPLoadDataStruct data = (TKNBPLoadDataStruct)this.tableModel.getRow(selectedRows[i]);
                data.patchFile = selectedFile;
                this.tkframe.infoTablePanel.updateObjectBasicInfo(data);
            }
            this.miClearFile.setEnabled(true);
            this.loadTable.repaint();
        }
    }

    @Override
    public JPopupMenu getPopupMenu(int row, int column) {
        return this.popupMenu;
    }

    class StateCellRenderer
    extends DefaultTableCellRenderer {
        StateCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TKNBPLoadDataStruct rowObj = (TKNBPLoadDataStruct)TKNBPLoadTablePaneDef.this.loadTable.getRow(row);
            if (rowObj != null) {
                this.setForeground(TKNBPLoadTablePaneDef.this.getStateColor(rowObj, column));
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

