/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.nbpld;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.communicate.TKCommUtility;
import com.huawei.dc.toolkit.client.base.communicate.TKCommandResult;
import com.huawei.dc.toolkit.client.base.util.TKFtpStruct;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.TKUIStyleManager;
import com.huawei.dc.toolkit.client.base.util.component.TKButton;
import com.huawei.dc.toolkit.client.base.util.component.TKPopMenuItem;
import com.huawei.dc.toolkit.client.base.util.filtertable.TKFilterMenuItem;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultStruct;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultVector;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperationShowMgr;
import com.huawei.dc.toolkit.client.te.toolkit.nbpld.TKNBPLoadDataStruct;
import com.huawei.dc.toolkit.client.te.toolkit.nbpld.TKNBPLoadInterFrame;
import com.huawei.dc.toolkit.client.te.toolkit.nbpld.TKNBPLoadTablePaneDef;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKASNTool;
import com.huawei.te.toolkit.AsnTkGetPkgFileInfoReq;
import com.huawei.te.toolkit.AsnTkGetPkgFileInfoRsp;
import com.huawei.te.toolkit.AsnToolkitStateGuageRpt;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.commustru.fstru.FStruct;

public class TKNBPLoadTablePane
extends TKNBPLoadTablePaneDef {
    private TKPopMenuItem miSelectFile = new TKPopMenuItem();
    private TKPopMenuItem miRefresh = new TKPopMenuItem();
    private TKPopMenuItem miRmvFrList = new TKPopMenuItem();
    private TKPopMenuItem selectedFileMenu = new TKPopMenuItem();
    protected JScrollPane jScrollPane1 = new JScrollPane();
    private JPanel jPanel1 = new JPanel();
    private TKButton btnStart = new TKButton();
    private TKButton btnActive = new TKButton();
    private TKButton btnFinish = new TKButton();
    private TKButton btnRollback = new TKButton();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    ActionListener actionClearSoft = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (null != TKNBPLoadTablePane.this.loadTable.getCellEditor()) {
                TKNBPLoadTablePane.this.loadTable.getCellEditor().stopCellEditing();
            }
            int[] selectRows = TKNBPLoadTablePane.this.loadTable.getSelectedRows();
            for (int j = 0; j < selectRows.length; ++j) {
                TKNBPLoadDataStruct rowDataStep = (TKNBPLoadDataStruct)TKNBPLoadTablePane.this.tableModel.getRow(selectRows[j]);
                rowDataStep.patchFile = null;
                TKNBPLoadTablePane.this.tkframe.infoTablePanel.updateObjectBasicInfo(rowDataStep);
            }
            TKNBPLoadTablePane.this.miClearFile.setEnabled(false);
            TKNBPLoadTablePane.this.loadTable.repaint();
        }
    };
    ActionListener actionRemoveList = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TKNBPLoadTablePane.this.removeSelectObjectFromList();
        }
    };
    ActionListener actionRefresh = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            new Thread(){

                @Override
                public void run() {
                    TKNBPLoadTablePane.this.patch_query();
                }
            }.start();
        }
    };
    ActionListener actionSelectSoft = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TKNBPLoadTablePane.this.actionPerformedByEditor(e);
        }
    };

    public TKNBPLoadTablePane(TKNBPLoadInterFrame tkframe) {
        this.tkframe = tkframe;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    private void jbInit() {
        this.setLayout(this.gridBagLayout1);
        this.btnStart.setEnabled(false);
        this.btnRollback.setEnabled(false);
        this.btnActive.setEnabled(false);
        this.btnFinish.setEnabled(false);
        Border border = BorderFactory.createEtchedBorder();
        this.jScrollPane1.setBorder(BorderFactory.createTitledBorder(border, this.res.getString("LoadOperForm")));
        this.add((Component)this.jScrollPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.loadTable, null);
        this.loadTable.setRowSelectionAllowed(true);
        this.loadTable.getTableHeader().setReorderingAllowed(false);
        this.loadTable.setRowHeight(22);
        this.loadTable.addColumnFilterAction(0);
        this.loadTable.addColumnFilterAction(1);
        this.loadTable.addColumnFilterAction(2);
        this.loadTable.addColumnFilterAction(3);
        this.loadTable.isShowControlIcon(false);
        this.loadTable.getColumnModel().getColumn(7).setPreferredWidth(150);
        this.add((Component)this.jPanel1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jPanel1.add((Component)this.btnStart, null);
        this.jPanel1.add((Component)this.btnActive, null);
        this.jPanel1.add((Component)this.btnFinish, null);
        this.jPanel1.add((Component)this.btnRollback, null);
        this.initStrings();
        this.initPopupMenu();
        this.initAction();
    }

    private void initStrings() {
        this.btnActive.setText(this.res.getString("Active"));
        this.btnStart.setText(this.res.getString("Start"));
        this.btnFinish.setText(this.res.getString("ButtonFinish"));
        this.btnRollback.setText(this.res.getString("ButtonRollback"));
        this.btnStart.setName("_Button_Start");
        this.btnActive.setName("_Button_Activate");
        this.btnRollback.setName("_Button_Rollback");
        this.btnRollback.setName("_Button_Finish");
        this.loadTable.setName("_Table_Operation");
        this.selectedFileMenu.setName("_MenuItem_SetFile");
        this.miSelectFile.setText(this.res.getString("ButtonSelectModifyFile"));
        this.miClearFile.setText(this.res.getString("ButtonClearFile"));
        this.miRefresh.setText(this.res.getString("Refresh"));
        this.miRmvFrList.setText(this.res.getString("ButtonRemoveFrList"));
        this.miSelectFile.setName("_PopupMenu_SelectModifyFile");
        this.miClearFile.setName("_PopupMenu_ClearFile");
        this.miRefresh.setName("_PopupMenu_Refresh");
        this.miRmvFrList.setName("_PopupMenu_RemoveFrList");
        this.popupMenu.setName("_PopupMenu_Table");
    }

    private void initPopupMenu() {
        this.popupMenu.removeAll();
        TKFilterMenuItem topItem = new TKFilterMenuItem("topItem");
        this.popupMenu.add(topItem);
        topItem.setVisible(false);
        this.popupMenu.add(this.miSelectFile);
        this.popupMenu.add(this.miClearFile);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.miRefresh);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.miRmvFrList);
    }

    private void initAction() {
        this.btnStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    @Override
                    public void run() {
                        TKNBPLoadTablePane.this.patch_load();
                    }
                }.start();
            }
        });
        this.btnRollback.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    @Override
                    public void run() {
                        TKNBPLoadTablePane.this.patch_rollback();
                    }
                }.start();
            }
        });
        this.btnActive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    @Override
                    public void run() {
                        TKNBPLoadTablePane.this.patch_active();
                    }
                }.start();
            }
        });
        this.btnFinish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    @Override
                    public void run() {
                        TKNBPLoadTablePane.this.patch_confirmBoard();
                    }
                }.start();
            }
        });
        this.miSelectFile.addActionListener(this.actionSelectSoft);
        this.miSelectFile.setActionCommand("PATCH_SELECT_SOFT");
        this.miClearFile.addActionListener(this.actionClearSoft);
        this.miRefresh.addActionListener(this.actionRefresh);
        this.miRmvFrList.addActionListener(this.actionRemoveList);
        this.loadTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    TKNBPLoadTablePane.this.processOperatorState();
                    TKNBPLoadTablePane.this.processTableJoin();
                }
            }
        });
        this.loadTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TKNBPLoadTablePane.this.checkMouseOnNeTable(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TKNBPLoadTablePane.this.checkMouseOnNeTable(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                TKNBPLoadTablePane.this.checkMouseOnNeTable(e);
            }
        });
    }

    private void checkMouseOnNeTable(MouseEvent e) {
        Point p = e.getPoint();
        int row = this.loadTable.rowAtPoint(p);
        if (row < 0) {
            return;
        }
        if (e.isPopupTrigger()) {
            JPopupMenu popMenu = this.getPopupMenu(0, 0);
            if (popMenu == null) {
                return;
            }
            Point point = TKScreenToolKit.getPopupMenuShowupPosition(this.loadTable, popMenu, p.x, p.y);
            popMenu.show(this.loadTable, point.x, point.y);
        }
    }

    public ArrayList getBoardListbyID(int neID) {
        Vector tableDatas = this.tableModel.getDatas();
        ArrayList<TKNBPLoadDataStruct> boardList = new ArrayList<TKNBPLoadDataStruct>();
        for (int i = 0; i < tableDatas.size(); ++i) {
            TKNBPLoadDataStruct data = (TKNBPLoadDataStruct)tableDatas.get(i);
            if (data.nedata.neID != neID || data.isNEPkg) continue;
            boardList.add(data);
        }
        return boardList;
    }

    public int getTableRowbyID(int neID, int slotID) {
        int totalRow = this.tableModel.getRowCount();
        int row = -1;
        for (int r = 0; r < totalRow; ++r) {
            TKNBPLoadDataStruct data = (TKNBPLoadDataStruct)this.tableModel.getRow(r);
            if (data.nedata.neID != neID || data.board.slotID != slotID && slotID > 0) continue;
            row = r;
            break;
        }
        return row;
    }

    public synchronized void updateStatusGuageMsg(AsnToolkitStateGuageRpt info) {
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().stopCellEditing();
        }
        int neId = info.neID.intValue();
        int slotId = info.slotID.intValue();
        int row = this.getTableRowbyID(neId, slotId);
        TKNBPLoadDataStruct data = this.getTableDatabyID(neId, slotId);
        if (null == data || row < 0) {
            return;
        }
        int oldstate = data.status;
        int guageInt = info.guage.intValue();
        int stateInt = info.loadState.intValue();
        if (guageInt > 100 || guageInt < 0) {
            guageInt = 0;
        }
        data.guage = guageInt;
        data.status = stateInt;
        this.loadTable.repaintRow(row);
        this.tkframe.infoTablePanel.updateObjectBasicInfo(data);
        if (stateInt != oldstate) {
            this.processOperatorState();
        }
    }

    protected void patch_query() {
        int[] selectedRows;
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().stopCellEditing();
        }
        if ((selectedRows = this.loadTable.getSelectedRows()) == null || selectedRows.length == 0) {
            return;
        }
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), true);
        TKOperResultVector resultV = new TKOperResultVector();
        for (int i = 0; i < selectedRows.length; ++i) {
            TKNBPLoadDataStruct patchData = (TKNBPLoadDataStruct)this.loadTable.getRow(selectedRows[i]);
            if (patchData.isNEPkg) {
                this.patch_querySPH(patchData, resultV);
                continue;
            }
            this.patch_queryBoard(patchData, resultV);
        }
        this.processOperatorState();
        this.processTableJoin();
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), false);
        if (resultV.size() > 0) {
            TKOperationShowMgr.showOperationDlg((Component)this.getParent(), this.res.getString("OperResult"), resultV);
        }
    }

    protected void updateTableObject(TKNBPLoadDataStruct dataStruct, boolean updateMenu) {
        if (dataStruct == null) {
            return;
        }
        int row = this.getTableRowbyID(dataStruct.nedata.neID, dataStruct.board.slotID);
        if (row < 0) {
            this.loadTable.repaint();
            return;
        }
        if (updateMenu) {
            this.processOperatorState();
        }
        this.loadTable.repaintRow(row);
    }

    public synchronized void processTableJoin() {
        int row = -1;
        try {
            row = this.loadTable.getSelectedRow();
            if (row < 0) {
                this.tkframe.infoTablePanel.updateTableData(null);
            } else {
                TKNBPLoadDataStruct rowDataObj = (TKNBPLoadDataStruct)this.tableModel.getRow(row);
                this.tkframe.infoTablePanel.updateTableData(rowDataObj);
            }
        }
        catch (Exception e) {
            this.tkframe.infoTablePanel.updateTableData(null);
        }
    }

    /*
     * Unable to fully structure code
     */
    void processOperatorState() {
        rowInt = -1;
        try {
            rowInt = this.loadTable.getSelectedRow();
        }
        catch (Exception e) {
            rowInt = -1;
        }
        if (rowInt < 0) {
            this.btnStart.setEnabled(false);
            this.btnRollback.setEnabled(false);
            this.btnActive.setEnabled(false);
            this.btnFinish.setEnabled(false);
            return;
        }
        selectRows = this.loadTable.getSelectedRows();
        rowData = (TKNBPLoadDataStruct)this.tableModel.getRow(selectRows[0]);
        isStartable = true;
        isActivable = true;
        isRollbackable = true;
        isFinshable = true;
        isRemovable = true;
        isClearSoft = true;
        isAllNotSetPatch = true;
        for (j = 0; j < selectRows.length; ++j) {
            block27: {
                block26: {
                    rowDataStep = (TKNBPLoadDataStruct)this.tableModel.getRow(selectRows[j]);
                    if (rowDataStep == null) continue;
                    if (rowDataStep.patchFile != null) {
                        isAllNotSetPatch = false;
                    }
                    if (rowData.isNEPkg != rowDataStep.isNEPkg) {
                        isStartable = false;
                        isActivable = false;
                        isRollbackable = false;
                        isFinshable = false;
                    }
                    if (rowDataStep.isNEPkg) {
                        if (isRemovable && (this.isSPHLoadState(rowDataStep.status) || rowDataStep.status == 7)) {
                            isRemovable = false;
                        }
                        isClearSoft = this.isSPHLoadState(rowDataStep.status) == false;
                        isFinshable = false;
                    } else {
                        if (isRemovable) {
                            isRemovable = this.isBoardLoadState(rowDataStep.status) == false;
                        }
                        v0 = isClearSoft = this.isBoardLoadState(rowDataStep.status) == false;
                    }
                    if (isFinshable) {
                        if (rowDataStep.status != 6) {
                            isFinshable = false;
                        }
                    }
                    if (!isRollbackable) break block26;
                    if (rowDataStep.isNEPkg) ** GOTO lbl-1000
                    if (rowDataStep.status == 3) ** GOTO lbl-1000
                    if (rowDataStep.status == 4) ** GOTO lbl-1000
                    if (rowDataStep.status != 6) {
                        isRollbackable = false;
                    } else if (rowDataStep.isNEPkg) {
                        if (rowDataStep.status != 2) {
                            if (rowDataStep.status != 6) {
                                if (rowDataStep.status != 3) {
                                    isRollbackable = false;
                                }
                            }
                        }
                    }
                }
                if (!isActivable) break block27;
                if (rowDataStep.isNEPkg) ** GOTO lbl-1000
                if (rowDataStep.status != 4) {
                    isActivable = false;
                } else if (rowDataStep.isNEPkg) {
                    if (rowDataStep.status != 3) {
                        isActivable = false;
                    }
                }
            }
            if (!isStartable) continue;
            if (!rowDataStep.isNEPkg) {
                if (rowDataStep.status != 2) {
                    if (rowDataStep.status != 1) {
                        isStartable = false;
                    }
                }
            }
            if (!rowDataStep.isNEPkg) continue;
            if (rowDataStep.status == 7) continue;
            if (rowDataStep.status == 1) continue;
            isStartable = false;
        }
        if (isClearSoft && (isAllNotSetPatch || !isStartable)) {
            isClearSoft = false;
        }
        this.btnStart.setEnabled(isStartable);
        this.btnRollback.setEnabled(isRollbackable);
        this.btnActive.setEnabled(isActivable);
        this.btnFinish.setEnabled(isFinshable);
        this.miClearFile.setEnabled(isClearSoft);
        this.miRmvFrList.setEnabled(isRemovable);
        this.miSelectFile.setEnabled(isStartable);
    }

    protected void replaceData(TKNBPLoadDataStruct data) {
        int neId = data.nedata.neID;
        int slotId = data.board.slotID;
        TKNBPLoadDataStruct oldData = this.getTableDatabyID(neId, slotId);
        if (oldData == null) {
            return;
        }
        oldData.status = data.status;
        oldData.guage = data.guage;
        oldData.startTime = data.startTime;
        oldData.endTime = data.endTime;
        oldData.runVer = data.runVer;
        oldData.patchVer = data.patchVer;
        oldData.nedata = data.nedata;
        if (oldData.isNEPkg) {
            if (this.isSPHLoadState(data.status)) {
                oldData.patchFile = data.patchFile;
            }
        } else {
            oldData.board = data.board;
            if (this.isBoardLoadState(data.status)) {
                oldData.loadFile.clear();
                oldData.loadFile.putFiles(data.loadFile.fileList());
            }
        }
        this.tableModel.fireTableDataChanged();
    }

    public synchronized void updateTableData(ArrayList nbpLoadInfoList) {
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().stopCellEditing();
        }
        for (int i = 0; i < nbpLoadInfoList.size(); ++i) {
            TKNBPLoadDataStruct data = (TKNBPLoadDataStruct)nbpLoadInfoList.get(i);
            if (this.tableModel.getDatas().contains(data)) {
                this.replaceData(data);
                continue;
            }
            this.tableModel.addRow(data);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TKNBPLoadTablePane.this.loadTable.repaint();
            }
        });
    }

    public void deleteRowbyId(int neId, int slotID) {
        TKNBPLoadDataStruct data;
        int i;
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().stopCellEditing();
        }
        this.loadTable.clearSelection();
        Vector tableDatas = new Vector(this.tableModel.getDatas());
        ArrayList<TKNBPLoadDataStruct> objList = new ArrayList<TKNBPLoadDataStruct>();
        for (i = 0; i < tableDatas.size(); ++i) {
            data = (TKNBPLoadDataStruct)tableDatas.get(i);
            if (data.nedata.neID != neId || null == objList) continue;
            if (slotID <= 0) {
                objList.add(data);
                continue;
            }
            if (slotID != data.board.slotID) continue;
            objList.add(data);
        }
        if (objList != null && objList.size() > 0) {
            for (i = 0; i < objList.size(); ++i) {
                data = (TKNBPLoadDataStruct)objList.get(i);
                this.tableModel.removeRow(data);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TKNBPLoadTablePane.this.loadTable.repaint();
            }
        });
    }

    private void removeSelectObjectFromList() {
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().stopCellEditing();
        }
        int[] selectRows = this.loadTable.getSelectedRows();
        Arrays.sort(selectRows);
        for (int i = selectRows.length - 1; i >= 0; --i) {
            TKNBPLoadDataStruct data = (TKNBPLoadDataStruct)this.loadTable.getRow(selectRows[i]);
            this.tableModel.removeRow(data);
        }
        this.loadTable.clearSelection();
    }

    public boolean hasWorkingObjects(TKOperResultVector resultVct) {
        boolean working = false;
        TKNBPLoadDataStruct data = null;
        Vector tableDatas = this.tableModel.getDatas();
        for (int i = 0; i < tableDatas.size(); ++i) {
            String operObj;
            boolean isWork;
            block5: {
                block6: {
                    block3: {
                        block4: {
                            data = (TKNBPLoadDataStruct)tableDatas.get(i);
                            isWork = false;
                            operObj = "";
                            if (!data.isNEPkg) break block3;
                            if (this.isSPHLoadState(data.status)) break block4;
                            if (data.status != 7) break block3;
                        }
                        operObj = data.nedata.neName;
                        isWork = true;
                        break block5;
                    }
                    if (data.isNEPkg) break block5;
                    if (this.isBoardLoadState(data.status)) break block6;
                    if (data.status != 2) break block5;
                }
                operObj = data.nedata.neName + "-" + data.board.slotID + "-" + data.board.boardType;
                isWork = true;
            }
            if (!isWork) continue;
            TKOperResultStruct oper = new TKOperResultStruct(operObj, this.res.getString("Working"), data.getValueAt(3).toString());
            resultVct.addElement(oper);
            working = true;
        }
        return working;
    }

    private Color getStateColor(TKNBPLoadDataStruct rowData, int column) {
        block12: {
            int state;
            block14: {
                block13: {
                    block10: {
                        block11: {
                            state = rowData.status;
                            if (!rowData.isNEPkg) break block10;
                            if (state == 3) break block11;
                            if (state == 2) break block11;
                            if (state == 5) break block11;
                            if (state == 6) break block11;
                            if (state != 4) break block12;
                        }
                        if (column == 3 && state == 3) {
                            return TKUIStyleManager.getImportantAlterColor();
                        }
                        return UIManager.getColor("controlShadow");
                    }
                    if (state == 4) break block13;
                    if (state == 3) break block13;
                    if (state == 7) break block13;
                    if (state == 2) break block13;
                    if (state == 6) break block13;
                    if (state != 5) break block14;
                }
                if (column == 3 && state == 2) {
                    return TKUIStyleManager.getMostAlterColor();
                }
                if (column == 3 && (state == 4 || state == 6)) {
                    return TKUIStyleManager.getImportantAlterColor();
                }
                return UIManager.getColor("controlShadow");
            }
            if (column == 3 && state == 2) {
                return TKUIStyleManager.getMostAlterColor();
            }
        }
        return this.loadTable.getForeground();
    }

    @Override
    public boolean queryPatchVersion(TKFtpStruct pkgFile) {
        AsnTkGetPkgFileInfoReq req = new AsnTkGetPkgFileInfoReq();
        req.neID = BigInteger.valueOf(0L);
        req.pkgSoftInfo = TKASNTool.toAsn1SoftInfo(pkgFile);
        AsnTkGetPkgFileInfoRsp rsp = new AsnTkGetPkgFileInfoRsp();
        char cmdCode = '\u1706';
        byte receiveModule = 23;
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), true);
        TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, receiveModule, 120);
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), false);
        if (!ret.isSuccess) {
            TKOperationShowMgr.showOperationDlg((Component)this.getParent(), ret.resultInfo, false);
            return false;
        }
        if (!rsp.ret.isSuccess) {
            String operReason = this.res.getString("QuerySWPFail") + "\n" + TKASNTool.getErrorInfo(rsp.ret);
            TKOperationShowMgr.showOperationDlg((Component)this, operReason, false);
            return false;
        }
        pkgFile.softVersion = new String(rsp.pkgVer);
        return true;
    }
}

