/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.nbpld;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.communicate.TKCmdMSG;
import com.huawei.dc.toolkit.client.base.communicate.TKCommUtility;
import com.huawei.dc.toolkit.client.base.communicate.TKCommandResult;
import com.huawei.dc.toolkit.client.base.communicate.TKNoticeReceiver;
import com.huawei.dc.toolkit.client.base.util.TKDebug;
import com.huawei.dc.toolkit.client.base.util.TKFtpStruct;
import com.huawei.dc.toolkit.client.base.util.TKLogManager;
import com.huawei.dc.toolkit.client.base.util.TKMessageCodeRes;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.component.TKLoadProgressDialog;
import com.huawei.dc.toolkit.client.base.util.component.TKSplitPane;
import com.huawei.dc.toolkit.client.base.util.help.TKHelpMgr;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultStruct;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultVector;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperationShowMgr;
import com.huawei.dc.toolkit.client.base.util.text.TKCodeContent;
import com.huawei.dc.toolkit.client.te.toolkit.TKMainFrame;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKInternalFrame;
import com.huawei.dc.toolkit.client.te.toolkit.nbpld.TKNBPLoadDataStruct;
import com.huawei.dc.toolkit.client.te.toolkit.nbpld.TKNBPLoadInfoTablePane;
import com.huawei.dc.toolkit.client.te.toolkit.nbpld.TKNBPLoadTablePane;
import com.huawei.dc.toolkit.client.te.toolkit.nbpld.TKNBPRes;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKObjectMgrInterface;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKTreeNodeProp;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKTreePanel;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKASNTool;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKConfirmOperationDlg;
import com.huawei.te.toolkit.AsnOneReturn;
import com.huawei.te.toolkit.AsnTKResultRpt;
import com.huawei.te.toolkit.AsnTkFileLoadRpt;
import com.huawei.te.toolkit.AsnTkMessageRpt;
import com.huawei.te.toolkit.AsnTkSPHInfo;
import com.huawei.te.toolkit.AsnTkSPHInfoQueryReq;
import com.huawei.te.toolkit.AsnTkSPHInfoQueryRsp;
import com.huawei.te.toolkit.AsnToolkitBoardRet;
import com.huawei.te.toolkit.AsnToolkitError;
import com.huawei.te.toolkit.AsnToolkitLoadBoard;
import com.huawei.te.toolkit.AsnToolkitPatchGetInfoReq;
import com.huawei.te.toolkit.AsnToolkitPatchGetInfoRsp;
import com.huawei.te.toolkit.AsnToolkitPatchInfo;
import com.huawei.te.toolkit.AsnToolkitStateGuageRpt;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import net.commustru.fstru.FStruct;

public class TKNBPLoadInterFrame
extends TKInternalFrame
implements TKNoticeReceiver,
TKObjectMgrInterface {
    private static final String NTC_ERR_MARK = "SPHMsgErrRpt";
    private static final String NTC_OK_MARK = "SPHMsgOKRpt";
    private TKNBPRes res = TKNBPRes.instance();
    TKLoadProgressDialog loadDlg = new TKLoadProgressDialog(this.res.getString("QueryData"));
    private String OperReportMark = "OperReportMark";
    private JSplitPane jSplitPane1 = new TKSplitPane();
    private JSplitPane jSplitPane2 = new TKSplitPane();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    public TKTreePanel objectTreePanel = null;
    public TKNBPLoadTablePane loadTablePanel = null;
    public TKNBPLoadInfoTablePane infoTablePanel = null;
    private TKMainFrame parent = null;
    private int funcID = 17;
    TKOperResultVector resultV = new TKOperResultVector();
    double modulusX = 0.3;
    double modulusY = 0.3;
    double oldArea = -1.0;
    double newArea = 1.0;

    public TKNBPLoadInterFrame() {
        this((TKMainFrame)null);
    }

    public TKNBPLoadInterFrame(TKMainFrame parent) {
        this.parent = parent;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    public TKNBPLoadTablePane getLoadTablePanel() {
        return this.loadTablePanel;
    }

    public String getDlgMark() {
        return this.OperReportMark;
    }

    @Override
    public void dispose() {
        if (TKCommUtility.comm != null) {
            TKCommUtility.comm.unregisterListener('\u1140', this);
            TKCommUtility.comm.unregisterListener('\u1142', this);
            TKCommUtility.comm.unregisterListener('\u1141', this);
            TKCommUtility.comm.unregisterListener('\u1143', this);
            TKCommUtility.comm.unregisterListener('\u2040', this);
            TKCommUtility.comm.unregisterListener('\u2041', this);
            TKCommUtility.comm.unregisterListener('\u2042', this);
            TKCommUtility.comm.unregisterListener('\u2044', this);
            TKCommUtility.comm.unregisterListener('\u2043', this);
        }
        this.objectTreePanel.dispose();
        super.dispose();
    }

    private void jbInit() throws Exception {
        this.setTitle(this.res.getString("NBPSoftLoad"));
        this.loadDlg.setTipText(this.res.getString("NtcWhileQueryLoadInfo"));
        this.loadDlg.setStoppingText(this.res.getString("StopQuery"));
        TKHelpMgr.instance().helpRootPane(this.getRootPane());
        TKHelpMgr.instance().helpComponent(this, "patchframe");
        this.setFrameIcon(TKResourceManager.getMainIcon());
        this.objectTreePanel = new TKTreePanel(this, 13, this.funcID);
        this.objectTreePanel.treeMgr.setObjectMgrInterface(this);
        this.loadTablePanel = new TKNBPLoadTablePane(this);
        this.infoTablePanel = new TKNBPLoadInfoTablePane();
        this.infoTablePanel.setLoadTablePanel(this.loadTablePanel);
        this.getContentPane().setLayout(this.gridBagLayout1);
        JScrollPane scrolPanel = new JScrollPane();
        scrolPanel.setVerticalScrollBarPolicy(21);
        scrolPanel.getViewport().add(this.objectTreePanel);
        this.jSplitPane1.setLeftComponent(scrolPanel);
        this.jSplitPane1.setRightComponent(this.jSplitPane2);
        this.jSplitPane1.setDividerSize(7);
        this.jSplitPane1.setDividerLocation(0.215);
        this.jSplitPane2.setTopComponent(this.loadTablePanel);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setBottomComponent(this.infoTablePanel);
        this.jSplitPane2.setDividerSize(7);
        this.jSplitPane2.setDividerLocation(0.5);
        this.getContentPane().add((Component)this.jSplitPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                TKNBPLoadInterFrame.this.newArea = TKNBPLoadInterFrame.this.getWidth() * TKNBPLoadInterFrame.this.getHeight();
                if (TKNBPLoadInterFrame.this.oldArea == -1.0) {
                    TKNBPLoadInterFrame.this.oldArea = TKNBPLoadInterFrame.this.newArea;
                }
                if (TKNBPLoadInterFrame.this.oldArea >= TKNBPLoadInterFrame.this.newArea) {
                    DCDebugTracer.trace("oldArea" + TKNBPLoadInterFrame.this.oldArea + ";" + "newArea" + TKNBPLoadInterFrame.this.newArea);
                    TKNBPLoadInterFrame.this.jSplitPane1.setDividerLocation((int)((double)TKNBPLoadInterFrame.this.getSize().width * TKNBPLoadInterFrame.this.modulusX));
                    TKNBPLoadInterFrame.this.jSplitPane2.setDividerLocation((int)((double)TKNBPLoadInterFrame.this.getSize().height * TKNBPLoadInterFrame.this.modulusY));
                } else {
                    TKNBPLoadInterFrame.this.jSplitPane1.setDividerLocation((int)((double)TKNBPLoadInterFrame.this.getSize().width * 0.3));
                    TKNBPLoadInterFrame.this.jSplitPane2.setDividerLocation((int)((double)TKNBPLoadInterFrame.this.getSize().height * 0.5));
                }
                TKNBPLoadInterFrame.this.oldArea = TKNBPLoadInterFrame.this.newArea;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TKNBPLoadInterFrame.this.modulusX = (float)TKNBPLoadInterFrame.this.jSplitPane1.getDividerLocation() / (float)TKNBPLoadInterFrame.this.getWidth();
                TKNBPLoadInterFrame.this.modulusY = (float)TKNBPLoadInterFrame.this.jSplitPane2.getDividerLocation() / (float)TKNBPLoadInterFrame.this.getHeight();
            }
        });
        new DropTarget(this.loadTablePanel.jScrollPane1, new TableDropTargetListener());
        new DropTarget(this.loadTablePanel.loadTable, new TableDropTargetListener());
    }

    @Override
    public byte handleNotice(char cmdCode, TKCmdMSG data) {
        if (cmdCode == '\u1140' || cmdCode == '\u2040') {
            AsnToolkitStateGuageRpt stateGuage = new AsnToolkitStateGuageRpt();
            boolean result = TKCommUtility.getASNData(data, (FStruct)stateGuage);
            if (!result) {
                TKDebug.inmAssert(false, this.res.getString("DecodeFail"));
                return 0;
            }
            this.loadTablePanel.updateStatusGuageMsg(stateGuage);
        } else if (cmdCode == '\u1141' || cmdCode == '\u2042') {
            AsnTkMessageRpt rptEvt = new AsnTkMessageRpt();
            boolean result = TKCommUtility.getASNData(data, (FStruct)rptEvt);
            if (!result) {
                TKDebug.inmAssert(false, this.res.getString("DecodeFail"));
                return 0;
            }
            this.processErrorMsg(rptEvt, data.msgHead.dateTime + "    ");
        } else if (cmdCode == '\u1142') {
            AsnToolkitPatchInfo rptEvt = new AsnToolkitPatchInfo();
            boolean result = TKCommUtility.getASNData(data, (FStruct)rptEvt);
            if (!result) {
                TKDebug.inmAssert(false, this.res.getString("DecodeFail"));
                return 0;
            }
            this.processBdPatchInfoRpt(rptEvt);
        } else if (cmdCode == '\u2041') {
            AsnTkSPHInfo rptEvt = new AsnTkSPHInfo();
            boolean result = TKCommUtility.getASNData(data, (FStruct)rptEvt);
            if (!result) {
                TKDebug.inmAssert(false, this.res.getString("DecodeFail"));
                return 0;
            }
            this.processSPHPatchInfoRpt(rptEvt);
        } else if (cmdCode == '\u2044' || cmdCode == '\u1143') {
            AsnTKResultRpt rptEvt = new AsnTKResultRpt();
            boolean result = TKCommUtility.getASNData(data, (FStruct)rptEvt);
            if (!result) {
                TKDebug.inmAssert(false, this.res.getString("DecodeFail"));
                return 0;
            }
            this.processResultRpt(rptEvt, data.msgHead.dateTime + "    ");
        } else if (cmdCode == '\u2043') {
            AsnTkFileLoadRpt fileRpt = new AsnTkFileLoadRpt();
            boolean result = TKCommUtility.getASNData(data, (FStruct)fileRpt);
            if (!result) {
                TKDebug.inmAssert(false, this.res.getString("DecodeFail"));
                return 0;
            }
            this.processFileReport(fileRpt, data.msgHead.dateTime + "    ");
        }
        return 1;
    }

    @Override
    public void refreshTableData(ArrayList neList) {
        ArrayList<TKNBPLoadDataStruct> removeList = new ArrayList<TKNBPLoadDataStruct>();
        int rowCount = this.loadTablePanel.loadTable.getRowCountX();
        if (rowCount <= 0) {
            return;
        }
        for (int i = 0; i < rowCount; ++i) {
            TKNBPLoadDataStruct data = (TKNBPLoadDataStruct)this.loadTablePanel.loadTable.getRowX(i);
            if (data.isNEPkg) {
                if (this.objectTreePanel.treeMgr.getNodeByID(data.nedata.neID) != null) continue;
                removeList.add(data);
                continue;
            }
            if (this.objectTreePanel.treeMgr.getBoardNode(data.nedata.neID, data.board.slotID) != null) continue;
            removeList.add(data);
        }
        int size = removeList.size();
        if (size > 0) {
            if (null != this.loadTablePanel.loadTable.getCellEditor()) {
                this.loadTablePanel.loadTable.getCellEditor().stopCellEditing();
            }
            this.loadTablePanel.loadTable.clearSelection();
            for (int i = 0; i < size; ++i) {
                TKNBPLoadDataStruct data = (TKNBPLoadDataStruct)removeList.get(i);
                this.loadTablePanel.tableModel.removeRow(data);
            }
            this.loadTablePanel.repaint();
        }
    }

    @Override
    public void noticeNELoginState(int neId, boolean isLogin) {
        TKNBPLoadDataStruct object = this.loadTablePanel.getTableDatabyID(neId, 0);
        String objectName = "(" + neId + ")";
        if (object != null) {
            objectName = "(" + neId + ")" + object.nedata.neName;
            object.nedata.isLogin = isLogin;
            this.loadTablePanel.updateTableObject(object, false);
        }
        TKLogManager.writeToDebug(objectName + ".isLogin: " + isLogin);
    }

    @Override
    public Object getObject(int neId, int slotId) {
        return null;
    }

    @Override
    public boolean isObjectRemovable(int neId, int slotId) {
        return true;
    }

    @Override
    public int getObjectCount() {
        return 0;
    }

    @Override
    public void deleteRowbyId(int neID, int slotID) {
        this.loadTablePanel.deleteRowbyId(neID, slotID);
    }

    @Override
    public void doLoadInfoQuery(ArrayList devList) {
        TKOperResultVector resultV = new TKOperResultVector();
        this.filterList(devList, resultV);
        if (resultV.size() > 0) {
            if (devList.size() > 0) {
                TKConfirmOperationDlg confDlg = new TKConfirmOperationDlg(TKResourceManager.getMainFrame(), this.res.getString("Hint"), this.res.getString("NtcLoadObjectConflict"), resultV, true, false);
                confDlg.setDefaultCloseOperation(2);
                confDlg.showDetail();
                int willContinue = confDlg.showDialog();
                if (willContinue == 1) {
                    return;
                }
            } else {
                TKOperationShowMgr.showOperationDlg((Component)this, this.res.getString("OperResult"), resultV);
                return;
            }
        }
        if (devList.size() == 0) {
            return;
        }
        this.doPatchLoadInfoQuery(devList);
    }

    @Override
    public void updateTableNEData(TKTreeNodeProp neNode) {
        if (this.loadTablePanel == null) {
            return;
        }
        if (neNode.getNodeType() == 2) {
            int row = this.loadTablePanel.getTableRowbyID(neNode.fatherID, neNode.nodeID);
            TKNBPLoadDataStruct loadData = this.loadTablePanel.getTableDatabyID(neNode.fatherID, neNode.nodeID);
            if (loadData == null) {
                return;
            }
            if (!loadData.board.boardType.equals(neNode.board.boardType)) {
                loadData.board.boardType = neNode.board.boardType;
                loadData.board.boardKind = neNode.board.boardKind;
                this.infoTablePanel.updateObjectBasicInfo(loadData);
                this.loadTablePanel.loadTable.repaintRow(row);
            }
        } else if (neNode.getNodeType() == 1) {
            int row = this.loadTablePanel.getTableRowbyID(neNode.nodeID, 0);
            TKNBPLoadDataStruct loadData = this.loadTablePanel.getTableDatabyID(neNode.nodeID, 0);
            if (loadData == null) {
                return;
            }
            loadData.nedata = neNode.nedata;
            this.infoTablePanel.updateObjectBasicInfo(loadData);
            this.loadTablePanel.loadTable.repaintRow(row);
        }
    }

    private void doPatchLoadInfoQuery(final ArrayList devList) {
        this.loadDlg.initail();
        int stepLen = 10;
        this.loadDlg.step(devList.size(), 10);
        new Thread(){

            @Override
            public void run() {
                while (!TKNBPLoadInterFrame.this.loadDlg.isVisible()) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (Exception ex) {
                        DCDebugTracer.trace(ex);
                    }
                }
                Iterator itr = devList.iterator();
                TKCommandResult ret = new TKCommandResult();
                TKOperResultVector resultV = new TKOperResultVector();
                int step = 0;
                TKNBPLoadInterFrame.this.loadDlg.startStep(step);
                while (itr.hasNext() && !TKNBPLoadInterFrame.this.loadDlg.isCanceled()) {
                    TKTreeNodeProp prop = (TKTreeNodeProp)itr.next();
                    TKOperResultStruct result = TKNBPLoadInterFrame.this.executePatchLoadInfoQuery(prop, ret);
                    TKNBPLoadInterFrame.this.loadDlg.startStep(++step);
                    if (result != null) {
                        resultV.addElement(result);
                    }
                    if (!TKNBPLoadInterFrame.this.loadDlg.isCanceled()) continue;
                    break;
                }
                TKNBPLoadInterFrame.this.loadDlg.completeOpration();
                if (resultV.size() > 0) {
                    TKOperationShowMgr.showOperationDlg((Component)TKNBPLoadInterFrame.this, TKNBPLoadInterFrame.this.res.getString("OperResult"), resultV);
                }
            }
        }.start();
        if (!this.loadDlg.isFullProgressValue()) {
            this.loadDlg.setVisible(true);
        }
    }

    private TKOperResultStruct executePatchLoadInfoQuery(TKTreeNodeProp prop, TKCommandResult ret) {
        if (prop.nodeType == 1) {
            return this.querySPHLoadInfo(prop, ret);
        }
        if (prop.nodeType == 2) {
            return this.queryBoardPatchLoadInfo(prop, ret);
        }
        return null;
    }

    private TKOperResultStruct querySPHLoadInfo(TKTreeNodeProp prop, TKCommandResult ret) {
        TKLogManager.writeToDebug("Select sph info:" + prop.nedata.neID);
        AsnTkSPHInfoQueryReq req = new AsnTkSPHInfoQueryReq();
        req.neIdlist.add((Object)BigInteger.valueOf(prop.nedata.neID));
        AsnTkSPHInfoQueryRsp rsp = new AsnTkSPHInfoQueryRsp();
        char cmdCode = '\u2001';
        byte recvModule = 32;
        ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, recvModule, 1);
        if (!ret.isSuccess) {
            String operObj = prop.nedata.neName;
            String operResult = this.res.getString("QueryFail");
            String operReason = ret.resultInfo;
            TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
            return struct;
        }
        Iterator sphInfoItr = rsp.neSPHInfoList.iterator();
        Iterator retItr = rsp.ret.iterator();
        ArrayList<TKNBPLoadDataStruct> bdLoadInfoList = new ArrayList<TKNBPLoadDataStruct>();
        TKOperResultStruct result = null;
        if (null != sphInfoItr && null != retItr) {
            while (sphInfoItr.hasNext()) {
                AsnTkSPHInfo sphInfo = (AsnTkSPHInfo)sphInfoItr.next();
                AsnOneReturn asnRtn = (AsnOneReturn)retItr.next();
                if (!asnRtn.ret.isSuccess) {
                    String operObj = prop.nedata.neName;
                    String operResult = this.res.getString("QueryFail");
                    String operReason = TKASNTool.getErrorInfo(asnRtn.ret);
                    result = new TKOperResultStruct(operObj, operResult, operReason);
                    return result;
                }
                TKNBPLoadDataStruct loadData = this.fillSPHInfoData(sphInfo);
                loadData.nedata = prop.nedata;
                loadData.isNEPkg = true;
                bdLoadInfoList.add(loadData);
            }
        }
        this.loadTablePanel.updateTableData(bdLoadInfoList);
        return null;
    }

    private TKOperResultStruct queryBoardPatchLoadInfo(TKTreeNodeProp prop, TKCommandResult ret) {
        TKLogManager.writeToDebug("Select bdpatch info:" + prop.nedata.neID + "  " + prop.board.slotID);
        AsnToolkitPatchGetInfoReq req = new AsnToolkitPatchGetInfoReq();
        AsnToolkitLoadBoard bdInfo = new AsnToolkitLoadBoard();
        bdInfo.neID = BigInteger.valueOf(prop.nedata.neID);
        bdInfo.slotID = BigInteger.valueOf(prop.board.slotID);
        req.bdList.add((Object)bdInfo);
        AsnToolkitPatchGetInfoRsp rsp = new AsnToolkitPatchGetInfoRsp();
        char cmdCode = '\u1101';
        byte recvModule = 17;
        ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, recvModule, 120);
        if (!ret.isSuccess) {
            String operObj = prop.nedata.neName + "-" + prop.board.slotID + "-" + prop.board.boardType;
            String operResult = this.res.getString("QueryFail");
            String operReason = ret.resultInfo;
            TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
            return struct;
        }
        Iterator bdinfoItr = rsp.patchInfoList.iterator();
        Iterator retItr = rsp.retInfoList.iterator();
        while (bdinfoItr.hasNext()) {
            AsnToolkitPatchInfo patchInfo = (AsnToolkitPatchInfo)bdinfoItr.next();
            AsnToolkitBoardRet asnRtn = (AsnToolkitBoardRet)retItr.next();
            if (!asnRtn.ret.isSuccess) {
                String operObj = prop.nedata.neName + "-" + prop.board.slotID + "-" + prop.board.boardType;
                String operResult = this.res.getString("QueryFail");
                String operReason = TKASNTool.getErrorInfo(asnRtn.ret);
                TKOperResultStruct result = new TKOperResultStruct(operObj, operResult, operReason);
                return result;
            }
            ArrayList<TKNBPLoadDataStruct> bdLoadInfoList = new ArrayList<TKNBPLoadDataStruct>();
            TKNBPLoadDataStruct loadData = this.fillBoardInfoData(patchInfo);
            loadData.nedata = prop.nedata;
            loadData.board = prop.board;
            bdLoadInfoList.add(loadData);
            this.loadTablePanel.updateTableData(bdLoadInfoList);
        }
        return null;
    }

    private TKNBPLoadDataStruct fillSPHInfoData(AsnTkSPHInfo sphInfo) {
        TKNBPLoadDataStruct loadData = new TKNBPLoadDataStruct();
        loadData.runVer = new String(sphInfo.runVer);
        loadData.patchVer = new String(sphInfo.patchVer);
        loadData.patchFile = TKASNTool.softInfoToTKFile(sphInfo.loadPkg);
        loadData.status = sphInfo.loadState.intValue();
        loadData.startTime = new String(sphInfo.startTime);
        loadData.endTime = new String(sphInfo.endTime);
        loadData.guage = sphInfo.guage.intValue();
        return loadData;
    }

    private TKNBPLoadDataStruct fillBoardInfoData(AsnToolkitPatchInfo patchInfo) {
        TKNBPLoadDataStruct loadData = new TKNBPLoadDataStruct();
        loadData.runVer = new String(patchInfo.bdSoftVer);
        loadData.status = patchInfo.loadState.intValue();
        loadData.guage = patchInfo.guage.intValue();
        loadData.patchVer = new String(patchInfo.patchSoftVer);
        loadData.patchFile = TKASNTool.softInfoToTKFile(patchInfo.patchFile);
        loadData.startTime = new String(patchInfo.startTime);
        loadData.endTime = new String(patchInfo.endTime);
        return loadData;
    }

    @Override
    public TKTreePanel getObjectTreePanel() {
        return this.objectTreePanel;
    }

    @Override
    public void doDefaultCloseAction() {
        TKOperResultVector resultVct = new TKOperResultVector();
        if (this.loadTablePanel.hasWorkingObjects(resultVct)) {
            TKConfirmOperationDlg confDlg = new TKConfirmOperationDlg(TKResourceManager.getMainFrame(), this.res.getString("Hint"), this.res.getString("ConfirmDisposeWorking"), resultVct, true);
            TKScreenToolKit.centerLocateToScreen(confDlg);
            confDlg.showDetail();
            int willContinue = confDlg.showDialog();
            if (willContinue == 1) {
                return;
            }
        }
        this.dispose();
    }

    @Override
    public boolean isNeedRevertLayout() {
        int dividerLocation2 = this.jSplitPane2.getDividerLocation();
        int heigthFrame = this.getHeight();
        return heigthFrame - dividerLocation2 < 50 || dividerLocation2 < 5;
    }

    @Override
    public void revertLayout() {
        this.jSplitPane1.setDividerLocation(0.215);
        this.jSplitPane2.setDividerLocation(0.5);
    }

    private synchronized void processBdPatchInfoRpt(AsnToolkitPatchInfo bdPatchInfo) {
        int slotId;
        int neId = bdPatchInfo.neID.intValue();
        TKNBPLoadDataStruct data = this.loadTablePanel.getTableDatabyID(neId, slotId = bdPatchInfo.slotID.intValue());
        if (data == null) {
            TKLogManager.writeToDebug("SPGBDLD processBdUpgradeInfoRpt:get null with " + neId + "\t" + slotId);
            return;
        }
        this.loadTablePanel.updateBoardInfoData(data, bdPatchInfo);
        this.loadTablePanel.updateTableObject(data, true);
        this.infoTablePanel.updateObjectBasicInfo(data);
    }

    private synchronized void processSPHPatchInfoRpt(AsnTkSPHInfo sphInfo) {
        int slotId;
        int neId = sphInfo.neID.intValue();
        TKNBPLoadDataStruct data = this.loadTablePanel.getTableDatabyID(neId, slotId = 0);
        if (data == null) {
            TKLogManager.writeToDebug("SPGBDLD processBdUpgradeInfoRpt:get null with " + neId + "\t" + slotId);
            return;
        }
        this.loadTablePanel.updateSPHInfoData(data, sphInfo);
        this.loadTablePanel.updateTableObject(data, true);
        this.infoTablePanel.updateObjectBasicInfo(data);
    }

    private synchronized void processErrorMsg(AsnTkMessageRpt rpt, String dateInfo) {
        int slotId;
        int neId = rpt.neID.intValue();
        TKNBPLoadDataStruct data = this.loadTablePanel.getTableDatabyID(neId, slotId = rpt.slotID.intValue());
        if (data == null) {
            TKLogManager.writeToDebug("PATCHLD processErrorMsg:get null with ne-id " + neId);
            return;
        }
        String titleConcent = this.res.getString("OperReport");
        Iterator errorItr = rpt.msgList.iterator();
        TKOperResultVector resultV = new TKOperResultVector();
        while (errorItr.hasNext()) {
            AsnToolkitError error = (AsnToolkitError)errorItr.next();
            String operObj = data.nedata.neName;
            if (!data.isNEPkg) {
                operObj = data.nedata.neName + "-" + data.board.slotID + "-" + data.board.boardType;
            }
            String operResult = TKRes.getResultInfo(rpt);
            String operReason = TKASNTool.getErrorInfo(error, rpt.msgType.intValue());
            TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
            resultV.addElement(struct);
            if (data.resultInfo.trim().length() > 1) {
                String tmp = data.resultInfo.endsWith("\n") ? "" : "\n";
                data.resultInfo = data.resultInfo + tmp + dateInfo + operReason;
                continue;
            }
            data.resultInfo = data.resultInfo + dateInfo + operReason;
        }
        this.infoTablePanel.updateObjectResult(data);
        if (resultV.size() > 0) {
            TKOperationShowMgr.showMutexOperationDlg((Component)this, titleConcent, resultV, NTC_ERR_MARK);
        }
    }

    private synchronized void processResultRpt(AsnTKResultRpt rpt, String dateInfo) {
        int slotId;
        int neId = rpt.neID.intValue();
        TKNBPLoadDataStruct data = this.loadTablePanel.getTableDatabyID(neId, slotId = rpt.slotID.intValue());
        if (data == null) {
            TKLogManager.writeToDebug("SPHLD processResultRpt:get null with " + neId + "\t" + slotId);
            return;
        }
        String operMsgInfo = TKMessageCodeRes.getResultInfo(rpt);
        if (data.resultInfo.trim().length() > 1) {
            String tmp = (data.resultInfo.endsWith("\n") ? "" : "\n") + dateInfo;
            data.resultInfo = data.resultInfo + tmp + operMsgInfo;
        } else {
            data.resultInfo = data.resultInfo + dateInfo + operMsgInfo;
        }
        this.infoTablePanel.updateObjectResult(data);
    }

    private void processFileReport(AsnTkFileLoadRpt asnRtn, String dateInfo) {
        int neId = asnRtn.neID.intValue();
        TKNBPLoadDataStruct data = this.loadTablePanel.getTableDatabyID(neId, 0);
        if (data == null) {
            TKLogManager.writeToDebug("SPHLD processFileReport:get null with " + neId);
            return;
        }
        TKFtpStruct patchFile = TKASNTool.pkgSoftLoadInfoToTKFile(asnRtn.fileCurInfo);
        String fileName = patchFile.toString();
        if (data.resultInfo.trim().length() > 1) {
            String tmp = data.resultInfo.endsWith("\n") ? "" : "\n";
            data.resultInfo = data.resultInfo + tmp;
        }
        data.resultInfo = data.resultInfo + dateInfo;
        if (asnRtn.ret.isSuccess) {
            String operResult = this.res.getString("CopyFileFinish");
            data.resultInfo = data.resultInfo + TKCodeContent.formatFtpPath(fileName) + "    " + operResult;
        } else {
            String operReason = TKRes.getErrorInfo(asnRtn.ret);
            data.resultInfo = data.resultInfo + TKCodeContent.formatFtpPath(fileName) + "    " + this.res.getString("CopyFileFail") + "    " + operReason;
        }
        this.infoTablePanel.updateObjectResult(data);
    }

    private void filterList(ArrayList devList, TKOperResultVector resultV) {
        Iterator itr = devList.iterator();
        String operResult = this.res.getString("QueryFail");
        ArrayList<Integer> sphLoad = new ArrayList<Integer>();
        ArrayList removeList = new ArrayList();
        while (itr.hasNext()) {
            Object obj = itr.next();
            TKTreeNodeProp prop = (TKTreeNodeProp)obj;
            if (prop.nodeType == 1) {
                ArrayList boardList;
                if (prop.isExpanded) {
                    removeList.add(obj);
                    continue;
                }
                sphLoad.add(new Integer(prop.nedata.neID));
                int boardSupport = prop.nedata.supportState(17);
                int sphSupport = prop.nedata.supportState(32);
                if (boardSupport == 1 && sphSupport != 1 && (null == (boardList = prop.nedata.boardList) || boardList.size() == 0)) {
                    removeList.add(obj);
                    String operObj = prop.nedata.neName;
                    String operReason = this.res.getString("NoBoardSelectForPatch");
                    TKOperResultStruct result = new TKOperResultStruct(operObj, operResult, operReason);
                    TKOperResultVector resultv = new TKOperResultVector();
                    resultv.add(result);
                    resultV.addElement(result);
                    continue;
                }
                if (this.loadTablePanel.getTableDatabyID(prop.nedata.neID, -1) != null || this.loadTablePanel.getBoardListbyID(prop.nedata.neID).size() <= 0) continue;
                removeList.add(obj);
                String operObj = prop.nedata.neName;
                String operReason = this.res.getString("ErrSPHWIthBoard");
                TKOperResultStruct result = new TKOperResultStruct(operObj, operResult, operReason);
                resultV.addElement(result);
                continue;
            }
            if (prop.nodeType != 2) continue;
            if (sphLoad.contains(new Integer(prop.nedata.neID))) {
                removeList.add(obj);
                continue;
            }
            if (this.loadTablePanel.getTableDatabyID(prop.nedata.neID, -1) == null) continue;
            removeList.add(obj);
            String operObj = prop.nedata.neName + "-" + prop.board.slotID + "-" + prop.board.boardType;
            String operReason = this.res.getString("ErrBoardLoadWithSPH");
            TKOperResultStruct result = new TKOperResultStruct(operObj, operResult, operReason);
            resultV.addElement(result);
        }
        devList.removeAll(removeList);
    }

    @Override
    public void registerCmd() {
        try {
            TKCommUtility.comm.registerListener('\u1140', this);
            TKCommUtility.comm.registerListener('\u1142', this);
            TKCommUtility.comm.registerListener('\u1141', this);
            TKCommUtility.comm.registerListener('\u1143', this);
            TKCommUtility.comm.registerListener('\u2040', this);
            TKCommUtility.comm.registerListener('\u2041', this);
            TKCommUtility.comm.registerListener('\u2042', this);
            TKCommUtility.comm.registerListener('\u2044', this);
            TKCommUtility.comm.registerListener('\u2043', this);
        }
        catch (Exception e) {
            DCDebugTracer.trace("register cmd failed");
            DCDebugTracer.trace(e);
        }
    }

    private class TableDropTargetListener
    implements DropTargetListener {
        @Override
        public void dragEnter(DropTargetDragEvent event) {
        }

        @Override
        public void dragExit(DropTargetEvent event) {
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
            if (!this.isDragAcceptable(event)) {
                event.rejectDrag();
                return;
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            if (!this.isDropAcceptable(event)) {
                event.rejectDrop();
                return;
            }
            event.dropComplete(true);
        }

        public boolean isDragAcceptable(DropTargetDragEvent event) {
            return (event.getDropAction() & 3) != 0;
        }

        public boolean isDropAcceptable(DropTargetDropEvent event) {
            return (event.getDropAction() & 3) != 0;
        }
    }
}

