/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.nbpld;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.component.TKBlankRenderer;
import com.huawei.dc.toolkit.client.base.util.component.TKFileListEditor;
import com.huawei.dc.toolkit.client.base.util.component.TKGuageRenderer;
import com.huawei.dc.toolkit.client.base.util.component.TKInfoEditor;
import com.huawei.dc.toolkit.client.base.util.component.TKInfoRenderer;
import com.huawei.dc.toolkit.client.base.util.component.TKPopMenuItem;
import com.huawei.dc.toolkit.client.base.util.component.TKTable;
import com.huawei.dc.toolkit.client.base.util.resource.TKErrorCodeRes;
import com.huawei.dc.toolkit.client.te.toolkit.nbpld.TKNBPLoadDataStruct;
import com.huawei.dc.toolkit.client.te.toolkit.nbpld.TKNBPLoadTablePane;
import com.huawei.dc.toolkit.client.te.toolkit.nbpld.TKNBPRes;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKTableRowResizer;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TKNBPLoadInfoTablePane
extends JPanel {
    TKNBPLoadDataStruct data = null;
    private TKErrorCodeRes errorRes = TKErrorCodeRes.instance();
    private TKNBPRes res = TKNBPRes.instance();
    JPopupMenu clearMenu = new JPopupMenu();
    boolean ifShowPopMenu = false;
    private TKPopMenuItem clearMenuItem = new TKPopMenuItem();
    TKNBPLoadTablePane loadTablePanel;
    JScrollPane jScrollPane1 = new JScrollPane();
    String[] colNames = new String[]{this.res.getString("Name"), this.res.getString("Value")};
    private static final int ROW_NENAME = 0;
    private static final int PATCHFILE_ROW = 1;
    private static final int GUAGE_ROW = 2;
    private static final int STARTTIME_ROW = 3;
    private static final int ROW_RESULTINFO = 4;
    Object[][] tableData2 = new Object[][]{{this.res.getString("NeName"), ""}, {this.res.getString("PatchFile"), ""}, {this.res.getString("Guage"), ""}, {this.res.getString("Start-EndTime"), ""}, {this.res.getString("OperResult"), ""}};
    DefaultTableModel infoTableModel = new DefaultTableModel(this.tableData2, this.colNames);
    TKGuageRenderer guageRender = new TKGuageRenderer(0, 100);
    TKInfoRenderer textrender = new TKInfoRenderer();
    TKInfoEditor texteditor = new TKInfoEditor();
    TKFileListEditor fileEditor = new TKFileListEditor();
    TKTable infoTable = new TKTable(this.infoTableModel){

        @Override
        public boolean isCellEditable(int row, int column) {
            return row == 4 && column == 1;
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            if (row == 4 && column == 1) {
                return TKNBPLoadInfoTablePane.this.texteditor;
            }
            return super.getCellEditor(row, column);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            if (column == 1 && row == 2) {
                return TKNBPLoadInfoTablePane.this.guageRender;
            }
            if (column == 1 && row == 4) {
                return TKNBPLoadInfoTablePane.this.textrender;
            }
            return new TKBlankRenderer();
        }
    };
    TKTableRowResizer rowResize = new TKTableRowResizer(this.infoTable);
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    String neObject = this.res.getString("NeName");
    String bdObject = this.res.getString("Board");

    public TKNBPLoadInfoTablePane() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    private void jbInit() throws Exception {
        this.guageRender.setValue(0);
        this.rowResize.addResizableRow(4);
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this.jScrollPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.infoTable, null);
        this.infoTable.getTableHeader().setReorderingAllowed(false);
        this.infoTable.setRowHeight(22);
        this.infoTable.setRowHeight(4, 195);
        this.infoTable.getColumnModel().getColumn(0).setMaxWidth(220);
        this.infoTable.getColumnModel().getColumn(0).setPreferredWidth(120);
        this.texteditor.getTextArea().add(this.createPopMenu());
        this.infoTable.add(this.createPopMenu());
        this.infoTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point p = e.getPoint();
                int row = TKNBPLoadInfoTablePane.this.infoTable.rowAtPoint(p);
                if (row == 4) {
                    TKNBPLoadInfoTablePane.this.checkMouse(e, TKNBPLoadInfoTablePane.this.infoTable);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Point p = e.getPoint();
                int row = TKNBPLoadInfoTablePane.this.infoTable.rowAtPoint(p);
                if (row == 4) {
                    TKNBPLoadInfoTablePane.this.checkMouse(e, TKNBPLoadInfoTablePane.this.infoTable);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                Point p = e.getPoint();
                int row = TKNBPLoadInfoTablePane.this.infoTable.rowAtPoint(p);
                if (row == 4) {
                    TKNBPLoadInfoTablePane.this.checkMouse(e, TKNBPLoadInfoTablePane.this.infoTable);
                }
            }
        });
        this.texteditor.getTextArea().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TKNBPLoadInfoTablePane.this.checkMouse(e, TKNBPLoadInfoTablePane.this.texteditor.getTextArea());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TKNBPLoadInfoTablePane.this.checkMouse(e, TKNBPLoadInfoTablePane.this.texteditor.getTextArea());
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                TKNBPLoadInfoTablePane.this.checkMouse(e, TKNBPLoadInfoTablePane.this.texteditor.getTextArea());
            }
        });
    }

    public void updateTableData(TKNBPLoadDataStruct data) {
        this.data = data;
        if (this.infoTable.getCellEditor() != null) {
            this.infoTable.getCellEditor().stopCellEditing();
        }
        this.infoTable.setValueAt("", 0, 1);
        this.infoTable.setValueAt("", 1, 1);
        TKGuageRenderer guageRen = (TKGuageRenderer)this.infoTable.getCellRenderer(2, 1);
        guageRen.setValue(0);
        this.infoTable.setValueAt("", 3, 1);
        this.infoTable.setValueAt("", 4, 1);
        this.infoTable.setValueAt("", 1, 1);
        if (data != null) {
            this.setBasicInfo();
            this.infoTableModel.setValueAt(data.resultInfo, 4, 1);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TKNBPLoadInfoTablePane.this.infoTable.repaint();
            }
        });
    }

    protected synchronized void updateObjectBasicInfo(TKNBPLoadDataStruct data) {
        if (this.data == null || data == null) {
            return;
        }
        if (this.data.equals(data)) {
            this.setBasicInfo();
            this.infoTable.repaintRow(0, 3);
        }
    }

    private void setBasicInfo() {
        if (this.data.isNEPkg) {
            this.infoTable.setValueAt(this.neObject, 0, 0);
            String neName = this.data.nedata.getNeName();
            this.infoTableModel.setValueAt(neName, 0, 1);
        } else {
            this.infoTable.setValueAt(this.bdObject, 0, 0);
            String bdName = this.data.nedata.getNeName() + "-" + this.data.board.slotID + "-" + this.data.board.boardType;
            this.infoTableModel.setValueAt(bdName, 0, 1);
        }
        TKGuageRenderer guageRen = (TKGuageRenderer)this.infoTable.getCellRenderer(2, 1);
        if (this.data.guage <= 100) {
            guageRen.setValue(this.data.guage);
        } else {
            guageRen.setValue(0);
        }
        if (this.data.startTime.equals("")) {
            this.infoTableModel.setValueAt(this.data.startTime, 3, 1);
        }
        if (!this.data.startTime.equals("")) {
            this.infoTableModel.setValueAt(this.res.getString("StartTime:") + this.data.startTime + " ", 3, 1);
            if (!this.data.endTime.equals("")) {
                this.infoTableModel.setValueAt(this.res.getString("StartTime:") + this.data.startTime + " " + "   " + this.res.getString("EndTime:") + this.data.endTime + " ", 3, 1);
            }
        }
        if (this.data.patchFile != null) {
            this.infoTableModel.setValueAt(this.data.patchFile.toString(), 1, 1);
        } else {
            this.infoTableModel.setValueAt("", 1, 1);
        }
    }

    protected synchronized void updateObjectResult(TKNBPLoadDataStruct data) {
        if (this.data == null || data == null) {
            return;
        }
        if (this.data.equals(data)) {
            if (this.infoTable.getEditingRow() == 4 && this.infoTable.getCellEditor() != null) {
                this.infoTable.getCellEditor().stopCellEditing();
            }
            this.infoTableModel.setValueAt(data.resultInfo, 4, 1);
            if (SwingUtilities.isEventDispatchThread()) {
                this.infoTable.repaint();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TKNBPLoadInfoTablePane.this.infoTable.repaint();
                    }
                });
            }
        }
    }

    private JPopupMenu createPopMenu() {
        this.clearMenu = new JPopupMenu();
        this.clearMenuItem.setText(this.res.getString("Clear"));
        this.clearMenu.add(this.clearMenuItem);
        this.clearMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKNBPLoadInfoTablePane.this.clearMenuItem_ActionPerformed();
            }
        });
        return this.clearMenu;
    }

    public void clearMenuItem_ActionPerformed() {
        this.texteditor.getTextArea().setText("");
        this.data.resultInfo = "";
        this.updateObjectResult(this.data);
    }

    public void setLoadTablePanel(TKNBPLoadTablePane loadTablePanel) {
        this.loadTablePanel = loadTablePanel;
    }

    private void checkMouse(MouseEvent e, Container con) {
        if (e.isPopupTrigger()) {
            int x = e.getX();
            int y = e.getY();
            Point point = TKScreenToolKit.getPopupMenuShowupPosition(con, this.clearMenu, x, y);
            this.ifShowPopMenu = true;
            this.clearMenu.show(con, (int)point.getX(), (int)point.getY());
            this.texteditor.getTextArea().updateUI();
            if (this.infoTable.getValueAt(4, 1).equals("")) {
                this.clearMenuItem.setEnabled(false);
            } else {
                this.clearMenuItem.setEnabled(true);
            }
        }
    }
}

