/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.logbackup;

import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.communicate.TKCommUtility;
import com.huawei.dc.toolkit.client.base.communicate.TKCommandResult;
import com.huawei.dc.toolkit.client.base.util.TKDebug;
import com.huawei.dc.toolkit.client.base.util.TKFile;
import com.huawei.dc.toolkit.client.base.util.TKFtpStruct;
import com.huawei.dc.toolkit.client.base.util.TKLoadFileStruct;
import com.huawei.dc.toolkit.client.base.util.TKNameValuePair;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.component.TKButton;
import com.huawei.dc.toolkit.client.base.util.component.TKButtonRenderer;
import com.huawei.dc.toolkit.client.base.util.component.TKComboxRenderer;
import com.huawei.dc.toolkit.client.base.util.filechooser.TKFileChooser;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultStruct;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultVector;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperationShowMgr;
import com.huawei.dc.toolkit.client.base.util.sorttable.TKSortButtonRenderer;
import com.huawei.dc.toolkit.client.base.util.sorttable.TKSortTable;
import com.huawei.dc.toolkit.client.te.toolkit.TKMainFrame;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKLoadDataStruct;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKLoadTablePanelInterface;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKNeStruct;
import com.huawei.dc.toolkit.client.te.toolkit.logbackup.TKSLUDataStruct;
import com.huawei.dc.toolkit.client.te.toolkit.logbackup.TKSLUInterFrame;
import com.huawei.dc.toolkit.client.te.toolkit.logbackup.TKSLUTablePaneDef;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKConfirmOperationDlg;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKFileSetEditor;
import com.huawei.te.toolkit.AsnBulkReturn;
import com.huawei.te.toolkit.AsnOneReturn;
import com.huawei.te.toolkit.AsnToolkitClientQueryCanCloseRsp;
import com.huawei.te.toolkit.AsnToolkitGetSecuLogInfoReq;
import com.huawei.te.toolkit.AsnToolkitGetSecuLogInfoRsp;
import com.huawei.te.toolkit.AsnToolkitOperObjAndState;
import com.huawei.te.toolkit.AsnToolkitSecuLogCopyInfo;
import com.huawei.te.toolkit.AsnToolkitSecuLogCopyReq;
import com.huawei.te.toolkit.AsnToolkitSecuLogInfo;
import com.huawei.te.toolkit.AsnToolkitSecuLogRollbackReq;
import com.huawei.te.toolkit.AsnToolkitStateGuageRpt;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.commustru.fstru.FStruct;

public class TKSLUTablePane
extends TKSLUTablePaneDef
implements TKLoadTablePanelInterface {
    private Icon iconFileOpen = TKResourceManager.getIcon("fileopen.gif");
    Point p = new Point();
    JScrollPane mSecuLogScrollPane = new JScrollPane();
    JPanel mSecuLogPanel = new JPanel();
    TKButton mButtonQuery = new TKButton();
    TKButton mButtonStart = new TKButton();
    TKButton mButtonRollback = new TKButton();
    private JMenuItem setFileItem = new JMenuItem(this.res.getString("SelectFile"));
    private JComboBox protocolComBox = this.getSoftTypeComboBox(0);
    JComboBox mStatusComboBox = new JComboBox();
    private JComboBox logTybeComBox = this.getLogTypeComboBox(0);
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private int SFTPPORT = 22;
    private int FTPPORT = 21;
    protected TKSortTable loadTable = new TKSortTable(this.tableModel){

        @Override
        public boolean isCellEditable(int row, int column) {
            if (column == 5 || column == 6 || column == 4) {
                int state = ((TKNameValuePair)TKSLUTablePane.this.tableModel.getValueAt((int)row, (int)3)).value;
                return state == TKSLUTablePane.this.normStateNVP.value || state == TKSLUTablePane.this.normFailedStateNVP.value;
            }
            return false;
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            TKSLUTablePane.this.editrow = row;
            if (column == 4) {
                TKSLUDataStruct data = (TKSLUDataStruct)TKSLUTablePane.this.tableModel.getValueAt(row, 0);
                return new DefaultCellEditor(TKSLUTablePane.this.getLogTypeComboBox(data.logType));
            }
            if (column == 5) {
                TKSLUDataStruct data = (TKSLUDataStruct)TKSLUTablePane.this.tableModel.getValueAt(row, 0);
                return new DefaultCellEditor(TKSLUTablePane.this.getSoftTypeComboBox(data.protocol));
            }
            if (column == 6) {
                TKFileSetEditor fileSet = new TKFileSetEditor(TKSLUTablePane.this);
                return fileSet;
            }
            return super.getCellEditor(row, column);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            if (column == 6) {
                return new TKButtonRenderer("", TKSLUTablePane.this.iconFileOpen);
            }
            if (column == 5 || column == 4) {
                return new TKComboxRenderer();
            }
            return new CellRenderer();
        }

        class CellRenderer
        extends DefaultTableCellRenderer {
            CellRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        }
    };

    public TKSLUTablePane(TKSLUInterFrame tkframe) {
        this.tkframe = tkframe;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    void test() {
        TKSLUDataStruct neLoadDataStruct = new TKSLUDataStruct();
        neLoadDataStruct.endTime = "endTime";
        neLoadDataStruct.status = 1;
        neLoadDataStruct.startTime = "startTime";
        neLoadDataStruct.nedata.isLogin = true;
        neLoadDataStruct.nedata.isSupport = 1;
        neLoadDataStruct.nedata.neID = 111;
        neLoadDataStruct.nedata.neName = "neName";
        neLoadDataStruct.nedata.neType = "neType";
        ArrayList<TKSLUDataStruct> al = new ArrayList<TKSLUDataStruct>();
        al.add(neLoadDataStruct);
        this.updateTableData(al);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.mStatusComboBox.addItem(this.normStateNVP);
        this.mStatusComboBox.addItem(this.copyStateNVP);
        this.mStatusComboBox.addItem(this.rollbackNVP);
        this.mStatusComboBox.addItem(this.haltStateNVP);
        this.mStatusComboBox.addItem(this.normFailedStateNVP);
        this.mStatusComboBox.setSelectedIndex(0);
        this.mButtonRollback.setVisible(false);
        this.mButtonQuery.setText(this.res.getString("Query"));
        this.mButtonStart.setText(this.res.getString("Start"));
        this.mButtonRollback.setText(this.res.getString("Rollback"));
        this.mButtonQuery.setName("_Button_Query");
        this.mButtonStart.setName("_Button_Start");
        this.mButtonRollback.setName("_Button_Rollback");
        this.mButtonQuery.setEnabled(false);
        this.mButtonStart.setEnabled(false);
        this.mButtonRollback.setEnabled(false);
        this.loadTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    TKSLUTablePane.this.processButtonStatus();
                    TKSLUTablePane.this.processTableJoin();
                }
            }
        });
        Border border = BorderFactory.createEtchedBorder();
        this.mSecuLogScrollPane.setBorder(BorderFactory.createTitledBorder(border, this.res.getString("LoadOperForm")));
        this.add((Component)this.mSecuLogScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mSecuLogScrollPane.getViewport().add((Component)this.loadTable, null);
        this.loadTable.removeColumn(this.loadTable.getColumnModel().getColumn(0));
        this.loadTable.getTableHeader().setReorderingAllowed(false);
        this.loadTable.setRowSelectionAllowed(true);
        this.loadTable.setRowHeight(22);
        this.loadTable.addColumnSortAction(0);
        this.loadTable.addColumnSortAction(1);
        this.loadTable.addColumnSortAction(2);
        this.loadTable.getColumnModel().getColumn(6).setPreferredWidth(214);
        this.setFileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKSLUTablePane.this.setFileItem_actionPerformed(e);
            }
        });
        this.loadTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                TKSLUTablePane.this.p = e.getPoint();
                int row = TKSLUTablePane.this.loadTable.rowAtPoint(TKSLUTablePane.this.p);
                if (row < 0) {
                    return;
                }
                int column = TKSLUTablePane.this.loadTable.columnAtPoint(TKSLUTablePane.this.p);
                if (TKSLUTablePane.this.loadTable.getSelectedRows().length < 2) {
                    TKSLUTablePane.this.loadTable.setRowSelectionInterval(row, row);
                }
                if (column == 6 && e.isPopupTrigger()) {
                    TKSLUTablePane.this.setFile(row, TKSLUTablePane.this.p, 1);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TKSLUTablePane.this.p = e.getPoint();
                int row = TKSLUTablePane.this.loadTable.rowAtPoint(TKSLUTablePane.this.p);
                if (row < 0) {
                    return;
                }
                int column = TKSLUTablePane.this.loadTable.columnAtPoint(TKSLUTablePane.this.p);
                if (TKSLUTablePane.this.loadTable.getSelectedRows().length < 2) {
                    TKSLUTablePane.this.loadTable.setRowSelectionInterval(row, row);
                }
                if (column == 6 && e.isPopupTrigger()) {
                    TKSLUTablePane.this.setFile(row, TKSLUTablePane.this.p, 1);
                }
            }
        });
        this.add((Component)this.mSecuLogPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mSecuLogPanel.setLayout(new FlowLayout(2));
        this.mSecuLogPanel.add((Component)this.mButtonQuery, null);
        this.mSecuLogPanel.add((Component)this.mButtonStart, null);
        this.mSecuLogPanel.add((Component)this.mButtonRollback, null);
        this.mButtonQuery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    @Override
                    public void run() {
                        TKSLUTablePane.this.queryBtn_actionPerformed();
                    }
                }.start();
            }
        });
        this.mButtonStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    @Override
                    public void run() {
                        TKSLUTablePane.this.startBtn_actionPerformed();
                    }
                }.start();
            }
        });
        this.mButtonRollback.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKSLUTablePane.this.rollbackBtn_actionPerformed(e);
            }
        });
    }

    public synchronized void processStateReport(AsnToolkitSecuLogInfo asnRtn) {
        int neId = asnRtn.neID.intValue();
        int row = this.getTableRowbyID(neId);
        TKSLUDataStruct loadData = this.getTableDatabyID(neId);
        if (null == loadData || row < 0) {
            return;
        }
        int stateInt = asnRtn.loadState.intValue();
        int oldstate = ((TKNameValuePair)this.tableModel.getValueAt((int)row, (int)3)).value;
        loadData.guage = asnRtn.guage.intValue();
        if (loadData.guage > 100) {
            loadData.guage = 0;
        }
        loadData.nedata.neID = asnRtn.neID.intValue();
        loadData.protocol = asnRtn.allowedProt.intValue();
        loadData.logType = asnRtn.supportOperType.intValue();
        loadData.status = asnRtn.loadState.intValue();
        String asnFileName = "";
        asnFileName = asnRtn.protocol.intValue() == 1 ? (loadData.selectLogType == 1 ? loadData.FTPFileName_SEC : loadData.FTPFileName_OPER) : (loadData.selectLogType == 1 ? loadData.HFCPFileName_SEC : loadData.HFCPFileName_OPER);
        if (asnRtn.fileName != null && asnRtn.fileName.length > 0) {
            asnFileName = new String(asnRtn.fileName);
        }
        if ("".equals(loadData.resultInfo) && (loadData.status == 1 || loadData.status == 5)) {
            loadData.startTime = "";
            loadData.endTime = "";
        } else {
            loadData.startTime = new String(asnRtn.startTime);
            loadData.endTime = new String(asnRtn.endTime);
        }
        int statusValue = loadData.status;
        boolean isUpdateStatus = this.isUpdateWithServer(statusValue);
        if (isUpdateStatus) {
            loadData.selectedProtocol = asnRtn.protocol.intValue();
            loadData.selectLogType = asnRtn.downLoadType.intValue();
        }
        if (loadData.selectedProtocol == 1) {
            if (isUpdateStatus) {
                loadData.ftpSvrIP = new String(asnRtn.ftpSvrIP);
                loadData.ftpSvrPort = asnRtn.ftpSvrPort.intValue();
                loadData.userName = new String(asnRtn.userName);
                loadData.userPwd = new String(asnRtn.userPwd);
                TKFtpStruct ftpFile = new TKFtpStruct(asnFileName);
                ftpFile.ftpIP = loadData.ftpSvrIP;
                ftpFile.ftpPort = loadData.ftpSvrPort;
                ftpFile.ftpUser = loadData.userName;
                ftpFile.ftpPass = loadData.userPwd;
                loadData.loadFile.update(ftpFile);
                if (loadData.selectLogType == 1) {
                    loadData.FTPFileName_SEC = asnFileName;
                } else {
                    loadData.FTPFileName_OPER = asnFileName;
                }
            }
        } else if (isUpdateStatus) {
            TKFile file = new TKFile(asnFileName);
            loadData.loadFile.update(file);
            if (loadData.selectLogType == 1) {
                loadData.HFCPFileName_SEC = asnFileName;
            } else {
                loadData.HFCPFileName_OPER = asnFileName;
            }
        }
        this.tableModel.setValueAt(loadData.loadFile, row, 7);
        this.tableModel.setValueAt(loadData.nedata.neName, row, 1);
        this.tableModel.setValueAt(loadData.nedata.neType, row, 2);
        this.tableModel.setValueAt(this.mStatusComboBox.getItemAt(loadData.status - 1), row, 3);
        if (loadData.guage > 100) {
            loadData.guage = 0;
        }
        this.tableModel.setValueAt(String.valueOf(loadData.guage), row, 4);
        this.tableModel.setValueAt(loadData, row, 0);
        this.loadTable.repaintRow(row);
        this.tkframe.infoTablePanel.updateObjectBasicInfo(loadData);
        if (stateInt != oldstate) {
            this.processButtonStatus();
        }
    }

    public synchronized void updateStatusGuageMsg(AsnToolkitStateGuageRpt info) {
        int oldstate;
        int neId = info.neID.intValue();
        int row = this.getTableRowbyID(neId);
        TKSLUDataStruct data = this.getTableDatabyID(neId);
        if (null == data || row < 0) {
            return;
        }
        int guageInt = info.guage.intValue();
        int stateInt = info.loadState.intValue();
        if (guageInt > 100) {
            guageInt = 0;
        }
        if ((oldstate = ((TKNameValuePair)this.tableModel.getValueAt((int)row, (int)3)).value) != this.copyStateNVP.value && oldstate != this.rollbackNVP.value) {
            return;
        }
        int oldguage = Integer.parseInt(String.valueOf(this.tableModel.getValueAt(row, 4)));
        if (guageInt > 0 && guageInt < oldguage) {
            return;
        }
        data.guage = guageInt;
        data.status = stateInt;
        this.tableModel.setValueAt(data, row, 0);
        if (data.guage > 100) {
            data.guage = 0;
        }
        this.tableModel.setValueAt(String.valueOf(data.guage), row, 4);
        this.tableModel.setValueAt(this.mStatusComboBox.getItemAt(data.status - 1), row, 3);
        this.loadTable.repaintRow(row);
        this.tkframe.infoTablePanel.updateObjectBasicInfo(data);
        if (stateInt != oldstate) {
            this.processButtonStatus();
        }
    }

    private synchronized void processTableJoin() {
        int row = -1;
        try {
            row = this.loadTable.getSelectedRow();
            if (row < 0) {
                this.tkframe.infoTablePanel.updateTableData(null);
            } else {
                TKSLUDataStruct rowDataObj = (TKSLUDataStruct)this.tableModel.getValueAt(row, 0);
                this.tkframe.infoTablePanel.updateTableData(rowDataObj);
            }
        }
        catch (Exception e) {
            this.tkframe.infoTablePanel.updateTableData(null);
        }
    }

    @Override
    public void setFile(ActionEvent e) {
        this.setFileItem_actionPerformed(e);
    }

    public void setChooseButtonAction(ActionEvent e) {
    }

    public void setChooseButtonAction(int row, Point p, int flag) {
    }

    public JPopupMenu getFilePopupMenu() {
        JPopupMenu SelectFile = new JPopupMenu();
        SelectFile.add(this.setFileItem);
        return SelectFile;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu SelectFile = new JPopupMenu();
        SelectFile.add(this.setFileItem);
        return SelectFile;
    }

    public JPopupMenu getTimePopupMenu() {
        return null;
    }

    @Override
    public void setFile(int row, Point p, int inTable) {
        if (inTable == 1) {
            if (this.loadTable.getSelectedRows().length < 2) {
                this.loadTable.setRowSelectionInterval(row, row);
            }
            JPopupMenu SelectFile = new JPopupMenu();
            SelectFile.add(this.setFileItem);
            Point point = TKScreenToolKit.getPopupMenuShowupPosition(this.loadTable, SelectFile, p.x, p.y);
            SelectFile.show(this.loadTable, point.x, point.y);
        }
        this.setFileItem.setEnabled(true);
        int[] selectedRows = this.loadTable.getSelectedRows();
        Object obj = this.tableModel.getValueAt(selectedRows[0], 6);
        if (obj == null) {
            this.setFileItem.setEnabled(false);
            return;
        }
        int firstprotocoltype = ((TKNameValuePair)this.tableModel.getValueAt((int)selectedRows[0], (int)6)).value;
        for (int i = 0; i < selectedRows.length; ++i) {
            int protocoltype = ((TKNameValuePair)this.tableModel.getValueAt((int)selectedRows[i], (int)6)).value;
            int state = ((TKNameValuePair)this.tableModel.getValueAt((int)selectedRows[i], (int)3)).value;
            if ((state == this.normStateNVP.value || state == this.normFailedStateNVP.value) && protocoltype == firstprotocoltype) continue;
            this.setFileItem.setEnabled(false);
            break;
        }
    }

    private void setFileItem_actionPerformed(ActionEvent e) {
        int[] selectedRows = this.loadTable.getSelectedRows();
        int firstProtocolType = ((TKNameValuePair)this.tableModel.getValueAt((int)selectedRows[0], (int)6)).value;
        for (int i = 0; i < selectedRows.length; ++i) {
            int protocolType = ((TKNameValuePair)this.tableModel.getValueAt((int)selectedRows[i], (int)6)).value;
            int state = ((TKNameValuePair)this.tableModel.getValueAt((int)selectedRows[i], (int)3)).value;
            if ((state == this.normStateNVP.value || state == this.normFailedStateNVP.value) && protocolType == firstProtocolType) continue;
            TKOperationShowMgr.showMessageDialog(this.getParent(), this.res.getString("CannotSelect"), this.res.getString("Hint"), 1);
            return;
        }
        if (firstProtocolType == 1) {
            this.doFtpFileSet(selectedRows);
        } else if (firstProtocolType == 2) {
            this.doNormalFileSet(selectedRows);
        }
    }

    private void doFtpFileSet(int[] selectedRows) {
        TKFile lastFile;
        TKSLUDataStruct spData = (TKSLUDataStruct)this.tableModel.getValueAt(selectedRows[0], 0);
        TKFileChooser fc = new TKFileChooser();
        fc.initFtp(spData.ftpSvrIP, spData.ftpSvrPort, spData.userName, spData.userPwd);
        fc.setBrowseType(100);
        fc.setShowToolkitEnable(false);
        if (selectedRows.length >= 1 && !(lastFile = spData.loadFile.getCurrentFile()).getPath().equals("") && lastFile != TKLoadFileStruct.nullFile && lastFile instanceof TKFtpStruct) {
            fc.setCurrentDirectory(lastFile);
        }
        fc.setFileSelectionMode(1);
        fc.showFileDialog();
        this.setFileItem.setEnabled(false);
        TKFtpStruct ftpParam = null;
        if (fc.getResultOption() != 0) {
            return;
        }
        TKMainFrame.lastFtpStruct = ftpParam = (TKFtpStruct)fc.getSelectedFile();
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().cancelCellEditing();
        }
        for (int i = 0; i < selectedRows.length; ++i) {
            TKSLUDataStruct data = (TKSLUDataStruct)this.tableModel.getValueAt(selectedRows[i], 0);
            data.loadFile.update(ftpParam);
            data.ftpSvrIP = ftpParam.ftpIP;
            data.ftpSvrPort = ftpParam.ftpPort;
            data.userName = ftpParam.ftpUser;
            data.userPwd = ftpParam.ftpPass;
            this.tableModel.setValueAt(data.loadFile, selectedRows[i], 7);
            if (data.selectLogType == 1) {
                data.FTPFileName_SEC = data.loadFile.getCurrentFile().getAbsolutePath();
            } else {
                data.FTPFileName_OPER = data.loadFile.getCurrentFile().getAbsolutePath();
            }
            this.tableModel.setValueAt(data, selectedRows[i], 0);
            this.tkframe.infoTablePanel.updateObjectBasicInfo(data);
        }
    }

    private void doNormalFileSet(int[] selectedRows) {
        TKFile lastFile;
        TKSLUDataStruct spData = (TKSLUDataStruct)this.tableModel.getValueAt(selectedRows[0], 0);
        SystemManager oSystemManager = new SystemManager();
        TKFileChooser fc = new TKFileChooser(oSystemManager.getSystemRootDirectory());
        fc.setMultiSelectionEnabled(false);
        fc.initFtp(spData.ftpSvrIP, spData.ftpSvrPort, spData.userName, spData.userPwd);
        fc.setFileSelectionMode(1);
        if (selectedRows.length >= 1 && !(lastFile = spData.loadFile.getCurrentFile()).getPath().equals("") && lastFile != TKLoadFileStruct.nullFile) {
            String lastFilePath = lastFile.getAbsolutePath();
            if (lastFilePath.startsWith("ftp://") || lastFilePath.startsWith("sftp://")) {
                fc.setBrowseType(100);
                if (lastFile instanceof TKFtpStruct) {
                    TKFtpStruct ftpLastFile = (TKFtpStruct)lastFile;
                    fc.initFtp(ftpLastFile.ftpIP, ftpLastFile.ftpPort, ftpLastFile.ftpUser, ftpLastFile.ftpPass);
                    fc.setCurrentDirectory(lastFile);
                }
            } else {
                fc.setCurrentDirectory(lastFile);
            }
        }
        int result = fc.showFileDialog();
        TKFtpStruct selectedFile = null;
        if (result != 0) {
            return;
        }
        selectedFile = (TKFtpStruct)fc.getSelectedFile();
        boolean bl = selectedFile.isFtp = fc.getBrowseType() == 100;
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().cancelCellEditing();
        }
        for (int i = 0; i < selectedRows.length; ++i) {
            TKSLUDataStruct data = (TKSLUDataStruct)this.tableModel.getValueAt(selectedRows[i], 0);
            data.loadFile.update(selectedFile);
            if (fc.getBrowseType() == 100) {
                data.ftpSvrIP = selectedFile.ftpIP;
                data.ftpSvrPort = selectedFile.ftpPort;
                data.userName = selectedFile.ftpUser;
                data.userPwd = selectedFile.ftpPass;
            }
            if (data.selectLogType == 1) {
                data.HFCPFileName_SEC = data.loadFile.getCurrentFile().getAbsolutePath();
            } else {
                data.HFCPFileName_OPER = data.loadFile.getCurrentFile().getAbsolutePath();
            }
            this.tableModel.setValueAt(data.loadFile, selectedRows[i], 7);
            this.tableModel.setValueAt(data, selectedRows[i], 0);
            this.tkframe.infoTablePanel.updateObjectBasicInfo(data);
        }
    }

    private boolean isUpdateWithServer(int statusValue) {
        boolean isUpdateStatus = statusValue != this.normStateNVP.value && statusValue != this.normFailedStateNVP.value && statusValue != this.haltStateNVP.value;
        return isUpdateStatus;
    }

    private void processButtonStatus() {
        int rowInt = -1;
        try {
            rowInt = this.loadTable.getSelectedRow();
        }
        catch (Exception e) {
            rowInt = -1;
        }
        if (rowInt < 0) {
            this.mButtonQuery.setEnabled(false);
            this.mButtonStart.setEnabled(false);
            this.mButtonRollback.setEnabled(false);
            return;
        }
        this.mButtonQuery.setEnabled(true);
        this.mButtonStart.setEnabled(true);
        this.mButtonRollback.setEnabled(true);
        TKNameValuePair buttStateData = null;
        try {
            int[] selectRows = this.loadTable.getSelectedRows();
            for (int j = 0; j < selectRows.length; ++j) {
                buttStateData = (TKNameValuePair)this.tableModel.getValueAt(selectRows[j], 3);
                int statusValue = buttStateData.value;
                if (statusValue != this.normStateNVP.value && statusValue != this.normFailedStateNVP.value && statusValue != this.haltStateNVP.value) {
                    this.mButtonStart.setEnabled(false);
                }
                if (statusValue != this.normStateNVP.value && statusValue != this.normFailedStateNVP.value && statusValue != this.rollbackNVP.value) continue;
                this.mButtonRollback.setEnabled(false);
            }
        }
        catch (Exception e) {
            rowInt = -1;
            this.mButtonQuery.setEnabled(false);
            this.mButtonStart.setEnabled(false);
            this.mButtonRollback.setEnabled(false);
        }
    }

    private ArrayList replaceListData(ArrayList sluLoadInfoList) {
        ArrayList<TKSLUDataStruct> newList = new ArrayList<TKSLUDataStruct>();
        if (sluLoadInfoList == null || sluLoadInfoList.size() < 1) {
            return newList;
        }
        for (int k = 0; k < sluLoadInfoList.size(); ++k) {
            boolean isUpdateWithLocal;
            TKSLUDataStruct data = (TKSLUDataStruct)sluLoadInfoList.get(k);
            int statusValue = data.status;
            boolean bl = isUpdateWithLocal = !this.isUpdateWithServer(statusValue);
            if (isUpdateWithLocal) {
                data.loadFile.clear();
            }
            for (int c = 0; c < this.lastDataList.size(); ++c) {
                TKSLUDataStruct olddata = (TKSLUDataStruct)this.lastDataList.get(c);
                if (data.nedata.neID == olddata.nedata.neID) {
                    data.resultInfo = olddata.resultInfo;
                    data.startTime = olddata.startTime;
                    data.endTime = olddata.endTime;
                }
                if (data.nedata.neID != olddata.nedata.neID || !isUpdateWithLocal) continue;
                data.selectedProtocol = olddata.selectedProtocol;
                data.selectLogType = olddata.selectLogType;
                data.loadFile = olddata.loadFile;
                data.FTPFileName_SEC = olddata.FTPFileName_SEC;
                data.FTPFileName_OPER = olddata.FTPFileName_OPER;
                data.HFCPFileName_SEC = olddata.HFCPFileName_SEC;
                data.HFCPFileName_OPER = olddata.HFCPFileName_OPER;
                data.ftpSvrIP = olddata.ftpSvrIP;
                data.ftpSvrPort = olddata.ftpSvrPort;
                data.userName = olddata.userName;
                data.userPwd = olddata.userPwd;
                break;
            }
            newList.add(data);
        }
        return newList;
    }

    public synchronized void addedTableData(ArrayList sluLoadInfoList) {
        ArrayList newlist = this.replaceListData(sluLoadInfoList);
        if (newlist == null || newlist.size() < 1) {
            this.loadTable.repaint();
            return;
        }
        for (int i = 0; i < newlist.size(); ++i) {
            TKSLUDataStruct data = (TKSLUDataStruct)newlist.get(i);
            Vector<Object> rowData = new Vector<Object>();
            rowData.add(data);
            rowData.add(data.nedata.neName);
            rowData.add(data.nedata.neType);
            rowData.add(this.mStatusComboBox.getItemAt(data.status - 1));
            if (data.guage > 100) {
                data.guage = 0;
            }
            rowData.add(String.valueOf(data.guage));
            if (data.logType == 0) {
                if (data.selectLogType == 1) {
                    rowData.add(this.sluNVP);
                } else if (data.selectLogType == 2) {
                    rowData.add(this.operNVP);
                }
            } else if (data.logType == 1) {
                rowData.add(this.sluNVP);
            } else if (data.logType == 2) {
                rowData.add(this.operNVP);
            }
            if (data.protocol == 0) {
                if (data.selectedProtocol == 1) {
                    rowData.add(this.ftpNVP);
                } else if (data.selectedProtocol == 2) {
                    rowData.add(this.hfcpNVP);
                }
            } else if (data.protocol == 1) {
                rowData.add(this.ftpNVP);
            } else if (data.protocol == 2) {
                rowData.add(this.hfcpNVP);
            }
            rowData.add(data.loadFile);
            this.tableModel.addRow(rowData);
        }
        this.loadTable.repaint();
    }

    protected void recordData() {
        int count = this.tableModel.getRowCount();
        StringBuffer neIds = new StringBuffer("aa");
        String separator = "aa";
        for (int i = 0; i < count; ++i) {
            TKLoadDataStruct data = (TKLoadDataStruct)this.tableModel.getValueAt(i, 0);
            neIds.append(data.nedata.neID);
            neIds.append(separator);
            this.lastDataList.remove(data);
            this.lastDataList.add(data);
        }
    }

    public synchronized void updateTableData(ArrayList sluLoadInfoList) {
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().cancelCellEditing();
        }
        this.loadTable.clearSelection();
        int count = this.loadTable.getColumnCount();
        for (int i = 0; i < count; ++i) {
            TableCellRenderer ren = this.loadTable.getColumnModel().getColumn(i).getHeaderRenderer();
            if (!(ren instanceof TKSortButtonRenderer)) continue;
            ((TKSortButtonRenderer)ren).clearSortFlag();
        }
        this.loadTable.getTableHeader().repaint();
        this.recordData();
        ArrayList newlist = this.replaceListData(sluLoadInfoList);
        this.tableModel.setRowCount(0);
        if (newlist == null || newlist.size() < 1) {
            this.loadTable.repaint();
            return;
        }
        for (int i = 0; i < newlist.size(); ++i) {
            TKSLUDataStruct data = (TKSLUDataStruct)newlist.get(i);
            Vector<Object> rowData = new Vector<Object>();
            rowData.add(data);
            rowData.add(data.nedata.neName);
            rowData.add(data.nedata.neType);
            rowData.add(this.mStatusComboBox.getItemAt(data.status - 1));
            if (data.guage > 100) {
                data.guage = 0;
            }
            rowData.add(String.valueOf(data.guage));
            if (data.logType == 0) {
                if (data.selectLogType == 1) {
                    rowData.add(this.sluNVP);
                } else {
                    rowData.add(this.operNVP);
                }
            } else if (data.logType == 1) {
                rowData.add(this.sluNVP);
            } else if (data.logType == 2) {
                rowData.add(this.operNVP);
            }
            if (data.protocol == 0) {
                if (data.selectedProtocol == 1) {
                    rowData.add(this.ftpNVP);
                } else if (data.selectedProtocol == 2) {
                    rowData.add(this.hfcpNVP);
                }
            } else if (data.protocol == 1) {
                rowData.add(this.ftpNVP);
            } else if (data.protocol == 2) {
                rowData.add(this.hfcpNVP);
            }
            rowData.add(data.loadFile);
            this.tableModel.addRow(rowData);
        }
        this.mButtonQuery.setEnabled(false);
        this.mButtonStart.setEnabled(false);
        this.mButtonRollback.setEnabled(false);
        this.loadTable.repaint();
    }

    public void refreshTableData(ArrayList neIdList) {
        int i;
        int total = this.tableModel.getRowCount();
        if (total < 1) {
            return;
        }
        if (neIdList == null || neIdList.size() < 1) {
            if (null != this.loadTable.getCellEditor()) {
                this.loadTable.getCellEditor().stopCellEditing();
            }
            this.loadTable.clearSelection();
            int count = this.loadTable.getColumnCount();
            for (int i2 = 0; i2 < count; ++i2) {
                TableCellRenderer ren = this.loadTable.getColumnModel().getColumn(i2).getHeaderRenderer();
                if (!(ren instanceof TKSortButtonRenderer)) continue;
                ((TKSortButtonRenderer)ren).clearSortFlag();
            }
            this.loadTable.getTableHeader().repaint();
            this.tableModel.setRowCount(0);
            this.loadTable.repaint();
            return;
        }
        int[] indexs = this.tableModel.getIndexes();
        ArrayList<Integer> deleteRows = new ArrayList<Integer>();
        for (i = 0; i < this.tableModel.getRowCount(); ++i) {
            TKSLUDataStruct data = (TKSLUDataStruct)this.tableModel.getValueAt(i, 0);
            boolean find = false;
            for (int j = 0; j < neIdList.size(); ++j) {
                int neId = ((TKNeStruct)neIdList.get((int)j)).neID;
                if (data.nedata.neID != neId) continue;
                find = true;
                break;
            }
            if (find) continue;
            deleteRows.add(indexs[i]);
        }
        Collections.sort(deleteRows);
        for (i = deleteRows.size() - 1; i >= 0; --i) {
            int row = (Integer)deleteRows.get(i);
            this.tableModel.removeRow(row);
        }
    }

    private void startBtn_actionPerformed() {
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().stopCellEditing();
        }
        int[] selectedRows = this.loadTable.getSelectedRows();
        TKOperResultVector resultV = new TKOperResultVector();
        this.validateInfomationResult(selectedRows, resultV);
        if (resultV.size() > 0) {
            TKOperationShowMgr.showOperationDlg((Component)this.getParent(), this.res.getString("NotSetParam"), resultV);
            return;
        }
        int hintIndex = 1;
        int limit = TKResourceManager.getNumberOfLoadObject();
        String dlgDesc = this.res.getString("OperationEffact");
        AsnToolkitClientQueryCanCloseRsp numberOptRsp = new AsnToolkitClientQueryCanCloseRsp();
        char cmdCodeOpt1 = '\u010f';
        byte receiveModule1Opt1 = 1;
        TKScreenToolKit.setComponentCursorBusy(this.tkframe, true);
        TKCommandResult ret3 = TKCommUtility.sendCommand(null, (FStruct)numberOptRsp, cmdCodeOpt1, receiveModule1Opt1, 120);
        TKScreenToolKit.setComponentCursorBusy(this.tkframe, false);
        if (!ret3.isSuccess) {
            TKOperationShowMgr.showOperationDlg((Component)this.getParent(), ret3.resultInfo, false);
            return;
        }
        Vector<String> vc2 = new Vector<String>();
        Iterator loadInfoItr = numberOptRsp.objAndOperList.iterator();
        if (null != loadInfoItr) {
            while (loadInfoItr.hasNext()) {
                AsnToolkitOperObjAndState operObjAndState = (AsnToolkitOperObjAndState)loadInfoItr.next();
                String loadID = String.valueOf(operObjAndState.neID);
                vc2.add(loadID);
            }
        }
        for (int i = 0; i < selectedRows.length; ++i) {
            TKSLUDataStruct data = (TKSLUDataStruct)this.tableModel.getValueAt(selectedRows[i], 0);
            if (data.ftpSvrPort == this.SFTPPORT && data.ftpSvrPort == this.FTPPORT) {
                TKOperationShowMgr.showOperationDlg((Component)this.getParent(), this.res.getString("InfoFail"), true);
                return;
            }
            String neKey = String.valueOf(data.nedata.neID);
            if (vc2.contains(neKey)) continue;
            vc2.add(neKey);
        }
        if (vc2.size() > limit) {
            resultV.addElement(hintIndex++ + "." + this.res.getString("LoadNumBeyondLimit") + limit);
        }
        if (hintIndex > 1) {
            TKConfirmOperationDlg confDlg = new TKConfirmOperationDlg(TKResourceManager.getMainFrame(), this.res.getString("Warning"), dlgDesc, resultV, true, true);
            confDlg.setDefaultCloseOperation(2);
            confDlg.hideDetailColumn();
            TKScreenToolKit.centerLocateToScreen(confDlg);
            int willContinue = confDlg.showDialog();
            if (willContinue == 1) {
                return;
            }
        }
        resultV.clear();
        AsnToolkitSecuLogCopyReq req = this.initRequest(selectedRows);
        AsnBulkReturn rsp = new AsnBulkReturn();
        char cmdCode = '\u1902';
        byte receiveModule = 25;
        TKScreenToolKit.setComponentCursorBusy(this.tkframe, true);
        TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, receiveModule, 120);
        TKScreenToolKit.setComponentCursorBusy(this.tkframe, false);
        if (!ret.isSuccess) {
            TKOperationShowMgr.showOperationDlg((Component)this.getParent(), ret.resultInfo, true);
            return;
        }
        Iterator retItr = rsp.iterator();
        if (null == retItr) {
            TKDebug.inmAssert(false, this.res.getString("ReturnDataNull"));
            return;
        }
        String dateInfo = ret.serverDateTime + "    ";
        while (retItr.hasNext()) {
            AsnOneReturn asnRtn = (AsnOneReturn)retItr.next();
            TKSLUDataStruct HideData = this.getTableDatabyID(asnRtn.id.intValue());
            int row = this.getTableRowbyID(asnRtn.id.intValue());
            if (HideData == null || row < 0) continue;
            if (!asnRtn.ret.isSuccess) {
                String operObj = HideData.nedata.neName;
                String operResult = this.res.getString("StartCopySLUFail");
                String operReason = TKRes.getErrorInfo(asnRtn.ret);
                TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                resultV.addElement(struct);
                if (HideData.resultInfo.trim().length() > 1) {
                    String tmp = HideData.resultInfo.endsWith("\n") ? "" : "\n";
                    HideData.resultInfo = HideData.resultInfo + tmp + dateInfo + operReason;
                } else {
                    HideData.resultInfo = HideData.resultInfo + dateInfo + operReason;
                }
                this.tkframe.infoTablePanel.updateObjectResult(HideData);
            }
            this.tableModel.setValueAt(HideData, row, 0);
        }
        if (resultV.size() > 0) {
            TKOperationShowMgr.showMutexOperationDlg((Component)this.tkframe, this.res.getString("OperReport"), resultV, this.tkframe.getDlgMark());
        }
        this.processButtonStatus();
    }

    private void validateInfomationResult(int[] selectedRows, TKOperResultVector resultV) {
        for (int j = 0; j < selectedRows.length; ++j) {
            TKOperResultStruct struct;
            String operReason;
            String operResult;
            String nename;
            Object protocol = this.tableModel.getValueAt(selectedRows[j], 6);
            String file = "";
            Object objfile = this.tableModel.getValueAt(selectedRows[j], 7);
            if (objfile != null) {
                file = objfile.toString();
            }
            if (file.trim().length() < 1) {
                nename = this.tableModel.getValueAt(selectedRows[j], 1).toString();
                operResult = this.res.getString("LoadFailure");
                operReason = this.res.getString("NotSelectedFile");
                struct = new TKOperResultStruct(nename, operResult, operReason);
                resultV.addElement(struct);
                continue;
            }
            if (protocol instanceof TKNameValuePair) continue;
            nename = this.tableModel.getValueAt(selectedRows[j], 1).toString();
            operResult = this.res.getString("LoadFailure");
            operReason = this.res.getString("IncorrectProtocolType");
            struct = new TKOperResultStruct(nename, operResult, operReason);
            resultV.addElement(struct);
        }
    }

    private AsnToolkitSecuLogCopyReq initRequest(int[] selectedRows) {
        AsnToolkitSecuLogCopyReq req = new AsnToolkitSecuLogCopyReq();
        TKSLUDataStruct startDataObj = null;
        AsnToolkitSecuLogCopyInfo copyInfo = null;
        for (int i = 0; i < selectedRows.length; ++i) {
            copyInfo = new AsnToolkitSecuLogCopyInfo();
            startDataObj = (TKSLUDataStruct)this.tableModel.getValueAt(selectedRows[i], 0);
            copyInfo.neID = BigInteger.valueOf(startDataObj.nedata.neID);
            int selectedProtocol = ((TKNameValuePair)this.tableModel.getValueAt((int)selectedRows[i], (int)6)).value;
            int selectLogType = ((TKNameValuePair)this.tableModel.getValueAt((int)selectedRows[i], (int)5)).value;
            copyInfo.protocol = BigInteger.valueOf(selectedProtocol);
            copyInfo.downLoadType = BigInteger.valueOf(selectLogType);
            if (selectedProtocol == 1) {
                copyInfo.ftpServer = startDataObj.ftpSvrIP.getBytes();
                copyInfo.ftpPort = BigInteger.valueOf(startDataObj.ftpSvrPort);
                copyInfo.userName = startDataObj.userName.getBytes();
                copyInfo.userPwd = startDataObj.userPwd.getBytes();
            } else {
                copyInfo.ftpServer = "".getBytes();
                copyInfo.ftpPort = BigInteger.valueOf(0L);
                copyInfo.userName = "".getBytes();
                copyInfo.userPwd = "".getBytes();
            }
            TKSLUDataStruct obj = (TKSLUDataStruct)this.tableModel.getValueAt(selectedRows[i], 0);
            String file = obj.loadFile.getCurrentFile().getAbsolutePath();
            copyInfo.fileName = file.getBytes();
            req.copyInfoList.add((Object)copyInfo);
        }
        return req;
    }

    private void queryBtn_actionPerformed() {
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().stopCellEditing();
        }
        int[] selectedRows = this.loadTable.getSelectedRows();
        TKScreenToolKit.setComponentCursorBusy(this.tkframe, true);
        try {
            this.mButtonQuery.setEnabled(false);
            Thread.currentThread();
            Thread.sleep(1000L);
            this.mButtonQuery.setEnabled(true);
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
        AsnToolkitGetSecuLogInfoRsp rsp = new AsnToolkitGetSecuLogInfoRsp();
        AsnToolkitGetSecuLogInfoReq req = new AsnToolkitGetSecuLogInfoReq();
        TKSLUDataStruct queryDataObj = null;
        for (int i = 0; i < selectedRows.length; ++i) {
            queryDataObj = (TKSLUDataStruct)this.tableModel.getValueAt(selectedRows[i], 0);
            req.neIdList.add((Object)BigInteger.valueOf(queryDataObj.nedata.neID));
        }
        char cmdCode = '\u1901';
        byte receiveModule = 25;
        this.mButtonQuery.setEnabled(false);
        TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, receiveModule, 120);
        TKScreenToolKit.setComponentCursorBusy(this.tkframe, false);
        this.mButtonQuery.setEnabled(true);
        if (!ret.isSuccess) {
            TKOperationShowMgr.showOperationDlg((Component)this, ret.resultInfo, false);
            return;
        }
        TKOperResultVector resultV = new TKOperResultVector();
        Iterator infoItr = rsp.seculogInfoList.iterator();
        Iterator retItr = rsp.ret.iterator();
        if (null == infoItr) {
            TKDebug.inmAssert(false, this.res.getString("ReturnDataNull"));
            return;
        }
        String dateInfo = ret.serverDateTime + "    ";
        if (infoItr != null && retItr != null) {
            this.processResult(resultV, infoItr, retItr, dateInfo);
        }
        if (resultV.size() > 0) {
            TKOperationShowMgr.showOperationDlg((Component)this.getParent(), this.res.getString("OperResult"), resultV);
        }
        this.processButtonStatus();
    }

    private void processResult(TKOperResultVector resultV, Iterator infoItr, Iterator retItr, String dateInfo) {
        while (infoItr.hasNext()) {
            AsnToolkitSecuLogInfo asnInfo = (AsnToolkitSecuLogInfo)infoItr.next();
            AsnOneReturn asnRtn = (AsnOneReturn)retItr.next();
            TKSLUDataStruct HideData = this.getTableDatabyID(asnInfo.neID.intValue());
            int row = this.getTableRowbyID(asnRtn.id.intValue());
            if (HideData == null || row < 0) continue;
            int statusValue = HideData.status = asnInfo.loadState.intValue();
            boolean isUpdateStatus = this.isUpdateWithServer(statusValue);
            this.updateConfigInfo(asnInfo, HideData, isUpdateStatus);
            HideData.guage = asnInfo.guage.intValue();
            if ("".equals(HideData.resultInfo) && (HideData.status == 1 || HideData.status == 7)) {
                HideData.startTime = "";
                HideData.endTime = "";
            } else {
                HideData.startTime = new String(asnInfo.startTime);
                HideData.endTime = new String(asnInfo.endTime);
            }
            if (asnInfo.fileName.length <= 0 && (HideData.status == this.copyStateNVP.value || HideData.status == this.rollbackNVP.value || HideData.status == this.haltStateNVP.value)) {
                String operObj = HideData.nedata.neName;
                String operResult = this.res.getString("OperResult");
                String operReason = this.res.getString("PleaseRollback");
                TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                resultV.addElement(struct);
                if (HideData.resultInfo.trim().length() > 1) {
                    String tmp = HideData.resultInfo.endsWith("\n") ? "" : "\n";
                    HideData.resultInfo = HideData.resultInfo + tmp + dateInfo + operReason;
                } else {
                    HideData.resultInfo = HideData.resultInfo + dateInfo + operReason;
                }
                this.tkframe.infoTablePanel.updateObjectResult(HideData);
            }
            if (!asnRtn.ret.isSuccess) {
                String operObj = HideData.nedata.neName;
                String operResult = this.res.getString("QuerySLUFail");
                String operReason = TKRes.getErrorInfo(asnRtn.ret);
                TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                resultV.addElement(struct);
                if (HideData.resultInfo.trim().length() > 1) {
                    String tmp = HideData.resultInfo.endsWith("\n") ? "" : "\n";
                    HideData.resultInfo = HideData.resultInfo + tmp + dateInfo + operResult + "    " + operReason;
                } else {
                    HideData.resultInfo = HideData.resultInfo + dateInfo + operResult + "    " + operReason;
                }
                this.tkframe.infoTablePanel.updateObjectResult(HideData);
            }
            this.tableModel.setValueAt(HideData, row, 0);
            this.tableModel.setValueAt(HideData.nedata.neName, row, 1);
            this.tableModel.setValueAt(HideData.nedata.neType, row, 2);
            if (HideData.selectLogType == 1) {
                this.tableModel.setValueAt(this.sluNVP, row, 5);
            } else if (HideData.selectLogType == 2) {
                this.tableModel.setValueAt(this.operNVP, row, 5);
            }
            if (HideData.selectedProtocol == 1) {
                this.tableModel.setValueAt(this.ftpNVP, row, 6);
            } else if (HideData.selectedProtocol == 2) {
                this.tableModel.setValueAt(this.hfcpNVP, row, 6);
            }
            this.tableModel.setValueAt(this.mStatusComboBox.getItemAt(HideData.status - 1), row, 3);
            if (HideData.guage > 100) {
                HideData.guage = 0;
            }
            this.tableModel.setValueAt(String.valueOf(HideData.guage), row, 4);
            this.tableModel.setValueAt(HideData.loadFile, row, 7);
            this.loadTable.repaintRow(row);
            this.tkframe.infoTablePanel.updateObjectBasicInfo(HideData);
        }
    }

    private void updateConfigInfo(AsnToolkitSecuLogInfo asnInfo, TKSLUDataStruct HideData, boolean isUpdateStatus) {
        if (isUpdateStatus) {
            HideData.protocol = asnInfo.allowedProt.intValue();
            HideData.logType = asnInfo.supportOperType.intValue();
            HideData.selectLogType = asnInfo.downLoadType.intValue();
            HideData.selectedProtocol = asnInfo.protocol.intValue();
            String fileName = "";
            if (asnInfo.fileName != null && asnInfo.fileName.length > 0) {
                fileName = new String(asnInfo.fileName);
                if (HideData.selectedProtocol == 1) {
                    if (HideData.selectLogType == 1) {
                        HideData.FTPFileName_SEC = fileName;
                    } else {
                        HideData.FTPFileName_OPER = fileName;
                    }
                } else if (HideData.selectLogType == 1) {
                    HideData.HFCPFileName_SEC = fileName;
                } else {
                    HideData.HFCPFileName_OPER = fileName;
                }
                if (HideData.selectedProtocol == 1) {
                    HideData.ftpSvrIP = new String(asnInfo.ftpSvrIP);
                    HideData.ftpSvrPort = asnInfo.ftpSvrPort.intValue();
                    HideData.userName = new String(asnInfo.userName);
                    HideData.userPwd = new String(asnInfo.userPwd);
                    TKFtpStruct file = new TKFtpStruct(fileName);
                    file.ftpIP = HideData.ftpSvrIP;
                    file.ftpPort = HideData.ftpSvrPort;
                    file.ftpUser = HideData.userName;
                    file.ftpPass = HideData.userPwd;
                    HideData.loadFile.update(file);
                } else {
                    HideData.loadFile.update(fileName);
                }
            }
        }
    }

    private void rollbackBtn_actionPerformed(ActionEvent e) {
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().stopCellEditing();
        }
        int[] selectedRows = this.loadTable.getSelectedRows();
        TKOperResultVector resultV = new TKOperResultVector();
        TKScreenToolKit.setComponentCursorBusy(this.tkframe, true);
        for (int j = 0; j < selectedRows.length; ++j) {
            AsnToolkitSecuLogRollbackReq req = new AsnToolkitSecuLogRollbackReq();
            TKSLUDataStruct rollbackDataObj = (TKSLUDataStruct)this.tableModel.getValueAt(selectedRows[j], 0);
            req.neIDList.add((Object)BigInteger.valueOf(rollbackDataObj.nedata.neID));
            AsnBulkReturn rsp = new AsnBulkReturn();
            char cmdCode = '\u1903';
            byte receiveModule = 25;
            TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, receiveModule, 120);
            if (!ret.isSuccess) {
                TKOperationShowMgr.showOperationDlg((Component)this.getParent(), ret.resultInfo, true);
                resultV.clear();
                break;
            }
            Iterator retItr = rsp.iterator();
            if (null == retItr) {
                TKDebug.inmAssert(false, this.res.getString("ReturnDataNull"));
                break;
            }
            String dateInfo = ret.serverDateTime + "    ";
            while (retItr.hasNext()) {
                AsnOneReturn asnRtn = (AsnOneReturn)retItr.next();
                TKSLUDataStruct HideData = this.getTableDatabyID(asnRtn.id.intValue());
                int row = this.getTableRowbyID(asnRtn.id.intValue());
                if (HideData == null || row < 0) continue;
                if (!asnRtn.ret.isSuccess) {
                    String operObj = HideData.nedata.neName;
                    String operResult = this.res.getString("RollbackSLUFail");
                    String operReason = TKRes.getErrorInfo(asnRtn.ret);
                    TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                    resultV.addElement(struct);
                    if (HideData.resultInfo.trim().length() > 1) {
                        String tmp = HideData.resultInfo.endsWith("\n") ? "" : "\n";
                        HideData.resultInfo = HideData.resultInfo + tmp + dateInfo + operResult + "    " + operReason;
                    } else {
                        HideData.resultInfo = HideData.resultInfo + dateInfo + operResult + "    " + operReason;
                    }
                    this.tkframe.infoTablePanel.updateObjectResult(HideData);
                }
                this.tableModel.setValueAt(HideData, row, 0);
            }
        }
        TKScreenToolKit.setComponentCursorBusy(this.tkframe, false);
        if (resultV.size() > 0) {
            TKOperationShowMgr.showOperationDlg((Component)this.tkframe, this.res.getString("OperResult"), resultV);
        }
        this.processButtonStatus();
        new Thread(){

            @Override
            public void run() {
                TKSLUTablePane.this.mButtonStart.requestFocus();
            }
        }.start();
    }

    public void clearNEResultInfo(int neID) {
        int row = this.getTableRowbyID(neID);
        TKSLUDataStruct loadData = this.getTableDatabyID(neID);
        if (row < 0 || loadData == null) {
            return;
        }
        loadData.resultInfo = "";
        if (loadData.status == 1 || loadData.status == 7) {
            loadData.startTime = "";
            loadData.endTime = "";
        }
        this.tableModel.setValueAt(loadData, row, 0);
        this.loadTable.repaintRow(row);
        this.tkframe.infoTablePanel.updateObjectBasicInfo(loadData);
    }

    public void updateNEInfo(TKNeStruct data) {
        int row = this.getTableRowbyID(data.neID);
        TKSLUDataStruct loadData = this.getTableDatabyID(data.neID);
        loadData.nedata.neName = data.neName;
        loadData.nedata.neType = data.neType;
        this.tableModel.setValueAt(loadData, row, 0);
        this.tableModel.setValueAt(data.neName, row, 1);
        this.tableModel.setValueAt(data.neType, row, 2);
        this.loadTable.repaintRow(row);
        this.tkframe.infoTablePanel.updateObjectBasicInfo(loadData);
    }

    class CellRenderer
    extends DefaultTableCellRenderer {
        CellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

