/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.logbackup;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.communicate.TKCmdMSG;
import com.huawei.dc.toolkit.client.base.communicate.TKCommUtility;
import com.huawei.dc.toolkit.client.base.communicate.TKCommandResult;
import com.huawei.dc.toolkit.client.base.communicate.TKNoticeReceiver;
import com.huawei.dc.toolkit.client.base.util.TKDebug;
import com.huawei.dc.toolkit.client.base.util.TKFile;
import com.huawei.dc.toolkit.client.base.util.TKFtpStruct;
import com.huawei.dc.toolkit.client.base.util.TKLogManager;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.component.TKSplitPane;
import com.huawei.dc.toolkit.client.base.util.help.TKHelpMgr;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultStruct;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultVector;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperationShowMgr;
import com.huawei.dc.toolkit.client.base.util.resource.TKErrorCodeRes;
import com.huawei.dc.toolkit.client.te.toolkit.TKMainFrame;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKInternalFrame;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKLoadDataStruct;
import com.huawei.dc.toolkit.client.te.toolkit.logbackup.TKSLUDataStruct;
import com.huawei.dc.toolkit.client.te.toolkit.logbackup.TKSLUInfoTablePanel;
import com.huawei.dc.toolkit.client.te.toolkit.logbackup.TKSLURes;
import com.huawei.dc.toolkit.client.te.toolkit.logbackup.TKSLUTablePane;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKObjectMgrInterface;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKTreeMgr;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKTreeNodeProp;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKTreePanel;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKConfirmOperationDlg;
import com.huawei.dc.toolkit.control.Toolkit4T2kInterfaceMgr;
import com.huawei.te.toolkit.AsnOneReturn;
import com.huawei.te.toolkit.AsnTkMessageRpt;
import com.huawei.te.toolkit.AsnToolkitGetSecuLogInfoReq;
import com.huawei.te.toolkit.AsnToolkitGetSecuLogInfoRsp;
import com.huawei.te.toolkit.AsnToolkitResultRpt;
import com.huawei.te.toolkit.AsnToolkitSecuLogInfo;
import com.huawei.te.toolkit.AsnToolkitStateGuageRpt;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import net.commustru.fstru.FStruct;

public class TKSLUInterFrame
extends TKInternalFrame
implements TKNoticeReceiver,
TKObjectMgrInterface {
    private TKSLURes res = TKSLURes.instance();
    private String OperReportMark = "OperReportMark";
    private TKErrorCodeRes errorRes = TKErrorCodeRes.instance();
    private JSplitPane jSplitPane1 = new TKSplitPane();
    private JSplitPane jSplitPane2 = new TKSplitPane();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    public TKTreePanel objectTreePanel = null;
    public TKSLUTablePane loadTablePanel = null;
    public TKSLUInfoTablePanel infoTablePanel = null;
    private int funcID = 25;
    private static final int FTP_PROTOCOL = 1;
    private ArrayList neList = null;
    private TKMainFrame parent = null;
    private ArrayList sluLoadInfoList = new ArrayList();
    private double modulusX = 0.3;
    private double modulusY = 0.3;
    private double initModulusX = 0.3;
    private double initModulusY = 0.5;
    private double oldArea = -1.0;
    private double newArea = -1.0;
    private double INIT_AREA = -1.0;

    public TKSLUInterFrame() {
        this((TKMainFrame)null);
    }

    public TKSLUInterFrame(TKMainFrame parent) {
        this.parent = parent;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    public TKSLUTablePane getLoadTablePanel() {
        return this.loadTablePanel;
    }

    public String getDlgMark() {
        return this.OperReportMark;
    }

    @Override
    public void dispose() {
        if (TKCommUtility.comm != null) {
            TKCommUtility.comm.unregisterListener('\u1941', this);
            TKCommUtility.comm.unregisterListener('\u1940', this);
            TKCommUtility.comm.unregisterListener('\u1942', this);
            TKCommUtility.comm.unregisterListener('\u1943', this);
        }
        if (null != this.jSplitPane1) {
            this.jSplitPane1 = null;
        }
        if (null != this.jSplitPane2) {
            this.jSplitPane2 = null;
        }
        if (null != this.objectTreePanel) {
            this.objectTreePanel.dispose();
            this.objectTreePanel = null;
        }
        if (null != this.loadTablePanel) {
            this.loadTablePanel = null;
        }
        if (null != this.infoTablePanel) {
            this.infoTablePanel = null;
        }
        if (null != this.parent) {
            this.parent = null;
        }
        this.removeAll();
        super.dispose();
    }

    private void jbInit() throws Exception {
        this.setTitle(this.res.getString("SecurityLogUpLoad"));
        TKHelpMgr.instance().helpRootPane(this.getRootPane());
        TKHelpMgr.instance().helpComponent(this, "sluframe");
        Toolkit4T2kInterfaceMgr.getInstance();
        this.setFrameIcon(TKResourceManager.getMainIcon());
        this.objectTreePanel = new TKTreePanel(this, 11, this.funcID);
        this.loadTablePanel = new TKSLUTablePane(this);
        this.infoTablePanel = new TKSLUInfoTablePanel();
        this.infoTablePanel.setLoadTablePanel(this.loadTablePanel);
        this.getContentPane().setLayout(this.gridBagLayout1);
        JScrollPane scrolPanel = new JScrollPane();
        scrolPanel.setVerticalScrollBarPolicy(21);
        scrolPanel.getViewport().add(this.objectTreePanel);
        this.jSplitPane1.setLeftComponent(scrolPanel);
        this.jSplitPane1.setRightComponent(this.jSplitPane2);
        this.jSplitPane1.setDividerSize(7);
        this.jSplitPane1.setDividerLocation(0.215);
        this.jSplitPane2.setTopComponent(this.loadTablePanel);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setBottomComponent(this.infoTablePanel);
        this.jSplitPane2.setDividerSize(7);
        this.jSplitPane2.setDividerLocation(0.5);
        this.getContentPane().add((Component)this.jSplitPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (TKSLUInterFrame.this.getWidth() != 0 && TKSLUInterFrame.this.getHeight() != 0) {
                    TKSLUInterFrame.this.newArea = TKSLUInterFrame.this.getWidth() * TKSLUInterFrame.this.getHeight();
                }
                if (TKSLUInterFrame.this.oldArea == TKSLUInterFrame.this.INIT_AREA) {
                    TKSLUInterFrame.this.oldArea = TKSLUInterFrame.this.newArea;
                }
                if (TKSLUInterFrame.this.oldArea >= TKSLUInterFrame.this.newArea) {
                    TKSLUInterFrame.this.jSplitPane1.setDividerLocation((int)((double)TKSLUInterFrame.this.getSize().width * TKSLUInterFrame.this.modulusX));
                    TKSLUInterFrame.this.jSplitPane2.setDividerLocation((int)((double)TKSLUInterFrame.this.getSize().height * TKSLUInterFrame.this.modulusY));
                } else {
                    TKSLUInterFrame.this.jSplitPane1.setDividerLocation((int)((double)TKSLUInterFrame.this.getSize().width * TKSLUInterFrame.this.initModulusX));
                    TKSLUInterFrame.this.jSplitPane2.setDividerLocation((int)((double)TKSLUInterFrame.this.getSize().height * TKSLUInterFrame.this.initModulusY));
                }
                TKSLUInterFrame.this.oldArea = TKSLUInterFrame.this.newArea;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int width = TKSLUInterFrame.this.getWidth();
                int leight = TKSLUInterFrame.this.getHeight();
                if (width != 0 && leight != 0) {
                    TKSLUInterFrame.this.modulusX = (float)TKSLUInterFrame.this.jSplitPane1.getDividerLocation() / (float)TKSLUInterFrame.this.getWidth();
                    TKSLUInterFrame.this.modulusY = (float)TKSLUInterFrame.this.jSplitPane2.getDividerLocation() / (float)TKSLUInterFrame.this.getHeight();
                }
            }
        });
        new DropTarget(this.loadTablePanel.mSecuLogScrollPane, new TableDropTargetListener());
        new DropTarget(this.loadTablePanel.loadTable, new TableDropTargetListener());
    }

    @Override
    public byte handleNotice(char cmdCode, TKCmdMSG data) {
        new TKOperResultVector();
        if (cmdCode == '\u1941') {
            AsnToolkitStateGuageRpt stateGuage = new AsnToolkitStateGuageRpt();
            boolean result = TKCommUtility.getASNData(data, (FStruct)stateGuage);
            if (!result) {
                TKDebug.inmAssert(false, this.res.getString("DecodeFail"));
                return 0;
            }
            this.loadTablePanel.updateStatusGuageMsg(stateGuage);
        } else if (cmdCode == '\u1940') {
            AsnTkMessageRpt rptEvt = new AsnTkMessageRpt();
            boolean result = TKCommUtility.getASNData(data, (FStruct)rptEvt);
            if (!result) {
                TKDebug.inmAssert(false, this.res.getString("DecodeFail"));
                return 0;
            }
            this.loadTablePanel.processErrorMsg(rptEvt, data.msgHead.dateTime + "    ");
        } else if (cmdCode == '\u1942') {
            AsnToolkitSecuLogInfo rptEvt = new AsnToolkitSecuLogInfo();
            boolean result = TKCommUtility.getASNData(data, (FStruct)rptEvt);
            if (!result) {
                TKDebug.inmAssert(false, this.res.getString("DecodeFail"));
                return 0;
            }
            this.loadTablePanel.processStateReport(rptEvt);
        } else if (cmdCode == '\u1943') {
            AsnToolkitResultRpt rptEvt = new AsnToolkitResultRpt();
            boolean result = TKCommUtility.getASNData(data, (FStruct)rptEvt);
            if (!result) {
                TKDebug.inmAssert(false, this.res.getString("DecodeFail"));
                return 0;
            }
            this.loadTablePanel.processResultMsg(rptEvt, data.msgHead.dateTime + "    ");
        }
        return 1;
    }

    @Override
    public void refreshTableData(ArrayList neList) {
        this.loadTablePanel.refreshTableData(neList);
    }

    public void updateTableData(ArrayList loadInfoList) {
        this.loadTablePanel.updateTableData(loadInfoList);
    }

    @Override
    public void deleteRowbyId(int neId, int slot) {
        this.loadTablePanel.deleteRowbyNeId(neId);
    }

    @Override
    public void doLoadInfoQuery(ArrayList devList) {
        this.doAddedSLULoadInfoQuery(devList);
    }

    @Override
    public void updateTableNEData(TKTreeNodeProp neNode) {
        int row = this.loadTablePanel.getTableRowbyID(neNode.nedata.neID);
        if (row >= 0) {
            this.loadTablePanel.updateNEInfo(neNode.nedata);
        }
    }

    private void doAddedSLULoadInfoQuery(ArrayList selectedNeList) {
        Iterator itr = selectedNeList.iterator();
        ArrayList lst = new ArrayList();
        int count = 0;
        boolean isFirst = true;
        ArrayList currentTableData = this.loadTablePanel.getcurrentTableData();
        TKOperResultVector resultV = new TKOperResultVector();
        while (itr.hasNext()) {
            Object obj = itr.next();
            TKTreeNodeProp prop = (TKTreeNodeProp)obj;
            if (prop.nodeType != 1) continue;
            lst.add(obj);
            if (++count < 3) continue;
            TKCommandResult ret = new TKCommandResult();
            Object[] rets = this.executeSLULoadInfoQuery(currentTableData, lst, isFirst, ret);
            if (!ret.isSuccess) {
                TKOperationShowMgr.showOperationDlg((Component)this, ret.resultInfo, false);
                return;
            }
            if (rets != null) {
                resultV.addElement(rets);
            }
            lst.clear();
            count = 0;
            isFirst = false;
        }
        if (count > 0 && count <= 3) {
            TKCommandResult ret = new TKCommandResult();
            Object[] rets = this.executeSLULoadInfoQuery(currentTableData, lst, isFirst, ret);
            if (!ret.isSuccess) {
                TKOperationShowMgr.showOperationDlg((Component)this, ret.resultInfo, false);
                return;
            }
            if (rets != null) {
                resultV.addElement(rets);
            }
        }
        if (resultV.size() > 0) {
            TKOperationShowMgr.showOperationDlg((Component)this, this.res.getString("OperResult"), resultV);
        }
    }

    private Object[] executeSLULoadInfoQuery(ArrayList currentTableData, ArrayList selectedList, boolean isFirst, TKCommandResult ret) {
        this.sluLoadInfoList.clear();
        AsnToolkitGetSecuLogInfoReq req = new AsnToolkitGetSecuLogInfoReq();
        if (null == selectedList || selectedList.size() < 1) {
            return null;
        }
        for (int i = 0; i < selectedList.size(); ++i) {
            TKTreeNodeProp prop = (TKTreeNodeProp)selectedList.get(i);
            if (prop.nodeType != 1) continue;
            req.neIdList.add((Object)BigInteger.valueOf(prop.nedata.neID));
        }
        AsnToolkitGetSecuLogInfoRsp rsp = new AsnToolkitGetSecuLogInfoRsp();
        char cmdCode = '\u1901';
        byte recvModule = 25;
        TKScreenToolKit.setComponentCursorBusy(this, true);
        ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, recvModule, 120);
        TKScreenToolKit.setComponentCursorBusy(this, false);
        if (!ret.isSuccess) {
            TKOperationShowMgr.showOperationDlg((Component)this, ret.resultInfo, false);
            return null;
        }
        Iterator infoItr = rsp.seculogInfoList.iterator();
        Iterator retItr = rsp.ret.iterator();
        TKOperResultVector resultV = new TKOperResultVector();
        if (null != infoItr) {
            block1: while (infoItr.hasNext()) {
                AsnToolkitSecuLogInfo asnSluInfo = (AsnToolkitSecuLogInfo)infoItr.next();
                AsnOneReturn asnRtn = (AsnOneReturn)retItr.next();
                TKTreeNodeProp nodeProp = TKTreeMgr.getNodePropFromList(asnSluInfo.neID.intValue(), -1, selectedList);
                if (!asnRtn.ret.isSuccess) {
                    String operObj = nodeProp.nedata.neName;
                    String operResult = this.res.getString("QueryFail");
                    String operReason = TKRes.getErrorInfo(asnRtn.ret);
                    TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                    resultV.addElement(struct);
                    String neIds = "aa";
                    String separator = "aa";
                    for (int i = 0; i < currentTableData.size(); ++i) {
                        TKLoadDataStruct oldData = (TKLoadDataStruct)currentTableData.get(i);
                        if ((neIds = neIds + oldData.nedata.neID + separator).indexOf("aa" + nodeProp.nedata.neID + "aa") < 0) continue;
                        this.sluLoadInfoList.add(oldData);
                        continue block1;
                    }
                    continue;
                }
                TKSLUDataStruct loadData = this.fillSLUInfoData(nodeProp, asnSluInfo);
                if (null == loadData) continue;
                this.sluLoadInfoList.add(loadData);
            }
        }
        if (isFirst) {
            this.loadTablePanel.updateTableData(this.sluLoadInfoList);
        } else {
            this.loadTablePanel.addedTableData(this.sluLoadInfoList);
        }
        if (resultV.size() > 0) {
            return resultV.toArray();
        }
        return null;
    }

    private TKSLUDataStruct fillSLUInfoData(TKTreeNodeProp neProp, AsnToolkitSecuLogInfo asnRtn) {
        TKSLUDataStruct loadData = new TKSLUDataStruct();
        if (neProp != null) {
            loadData.nedata = neProp.nedata;
            if (neProp.nedata.isTL1NE) {
                loadData.nedata.neName = neProp.nedata.TID;
            }
        }
        loadData.protocol = asnRtn.allowedProt.intValue();
        loadData.logType = asnRtn.supportOperType.intValue();
        loadData.selectedProtocol = asnRtn.protocol.intValue();
        loadData.selectLogType = asnRtn.downLoadType.intValue();
        loadData.status = asnRtn.loadState.intValue();
        loadData.guage = asnRtn.guage.intValue();
        if ("".equals(loadData.resultInfo) && (loadData.status == 1 || loadData.status == 7)) {
            loadData.startTime = "";
            loadData.endTime = "";
        } else {
            loadData.startTime = new String(asnRtn.startTime);
            loadData.endTime = new String(asnRtn.endTime);
        }
        loadData.showFileName = loadData.loadFile.toString();
        loadData.loadFile.clear();
        if (loadData.selectedProtocol == 1) {
            loadData.ftpSvrIP = new String(asnRtn.ftpSvrIP);
            loadData.ftpSvrPort = asnRtn.ftpSvrPort.intValue();
            loadData.userName = new String(asnRtn.userName);
            loadData.userPwd = new String(asnRtn.userPwd);
            if (asnRtn.fileName != null && asnRtn.fileName.length > 0) {
                TKFtpStruct file = new TKFtpStruct(new String(asnRtn.fileName));
                file.ftpIP = loadData.ftpSvrIP;
                file.ftpPort = loadData.ftpSvrPort;
                file.ftpUser = loadData.userName;
                file.ftpPass = loadData.userPwd;
                loadData.loadFile.add(file);
            }
        } else if (asnRtn.fileName != null && asnRtn.fileName.length > 0) {
            loadData.loadFile.add(new TKFile(new String(asnRtn.fileName)));
        }
        if (asnRtn.fileName.length <= 0 && (loadData.status == 2 || loadData.status == 3 || loadData.status == 4)) {
            TKOperResultVector resultV = new TKOperResultVector();
            String operObj = loadData.nedata.neName;
            String operResult = this.res.getString("OperResult");
            String operReason = this.res.getString("PleaseRollback");
            TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
            resultV.addElement(struct);
            if (resultV.size() > 0) {
                TKOperationShowMgr.showOperationDlg((Component)this.getParent(), this.res.getString("OperResult"), resultV);
            }
        }
        return loadData;
    }

    @Override
    public TKTreePanel getObjectTreePanel() {
        return this.objectTreePanel;
    }

    @Override
    public void doDefaultCloseAction() {
        TKOperResultVector resultVct = new TKOperResultVector();
        if (this.loadTablePanel.hasWorkingObjects(resultVct)) {
            TKConfirmOperationDlg confDlg = new TKConfirmOperationDlg(TKResourceManager.getMainFrame(), this.res.getString("Hint"), this.res.getString("ConfirmDisposeWorking"), resultVct, true);
            TKScreenToolKit.centerLocateToScreen(confDlg);
            confDlg.showDetail();
            int willContinue = confDlg.showDialog();
            if (willContinue == 1) {
                return;
            }
        }
        this.dispose();
    }

    @Override
    public boolean isNeedRevertLayout() {
        int dividerLocation2 = this.jSplitPane2.getDividerLocation();
        int heigthFrame = this.getHeight();
        return heigthFrame - dividerLocation2 < 50 || dividerLocation2 < 5;
    }

    @Override
    public void revertLayout() {
        this.jSplitPane1.setDividerLocation(0.215);
        this.jSplitPane2.setDividerLocation(0.5);
    }

    @Override
    public Object getObject(int neId, int slotId) {
        return this.loadTablePanel.getTableDatabyID(neId);
    }

    @Override
    public int getObjectCount() {
        return this.loadTablePanel.loadTable.getRowCount();
    }

    @Override
    public boolean isObjectRemovable(int neId, int slotId) {
        return false;
    }

    @Override
    public void noticeNELoginState(int neId, boolean isLogin) {
        TKSLUDataStruct object = this.loadTablePanel.getTableDatabyID(neId);
        String objectName = "(" + neId + ")";
        if (object != null) {
            objectName = "(" + neId + ")" + object.nedata.neName;
            object.nedata.isLogin = isLogin;
            ArrayList<TKSLUDataStruct> list = new ArrayList<TKSLUDataStruct>();
            list.add(object);
            this.loadTablePanel.updateTableData(list);
        }
        TKLogManager.writeToDebug(objectName + ".isLogin: " + isLogin);
    }

    @Override
    public void registerCmd() {
        try {
            TKLogManager.writeToFile("RegisterListener CommandCode on " + this.getTitle());
            TKCommUtility.comm.registerListener('\u1941', this);
            TKCommUtility.comm.registerListener('\u1940', this);
            TKCommUtility.comm.registerListener('\u1942', this);
            TKCommUtility.comm.registerListener('\u1943', this);
            TKLogManager.writeToFile("RegisterListener CommandCode on " + this.getTitle() + " Successfully.");
        }
        catch (Exception e) {
            DCDebugTracer.trace("register cmd failed");
            DCDebugTracer.trace(e);
        }
    }

    private class TableDropTargetListener
    implements DropTargetListener {
        @Override
        public void dragEnter(DropTargetDragEvent event) {
        }

        @Override
        public void dragExit(DropTargetEvent event) {
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
            if (!this.isDragAcceptable(event)) {
                event.rejectDrag();
                return;
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            if (!this.isDropAcceptable(event)) {
                event.rejectDrop();
                return;
            }
            event.dropComplete(true);
        }

        public boolean isDragAcceptable(DropTargetDragEvent event) {
            return (event.getDropAction() & 3) != 0;
        }

        public boolean isDropAcceptable(DropTargetDropEvent event) {
            return (event.getDropAction() & 3) != 0;
        }
    }
}

