/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.license;

import com.huawei.dc.toolkit.client.base.communicate.TKCommUtility;
import com.huawei.dc.toolkit.client.base.communicate.TKCommandResult;
import com.huawei.dc.toolkit.client.base.util.TKDebug;
import com.huawei.dc.toolkit.client.base.util.TKFile;
import com.huawei.dc.toolkit.client.base.util.TKFtpStruct;
import com.huawei.dc.toolkit.client.base.util.TKLoadFileStruct;
import com.huawei.dc.toolkit.client.base.util.TKLogManager;
import com.huawei.dc.toolkit.client.base.util.TKNameValuePair;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.component.TKButton;
import com.huawei.dc.toolkit.client.base.util.component.TKButtonRenderer;
import com.huawei.dc.toolkit.client.base.util.component.TKComboxRenderer;
import com.huawei.dc.toolkit.client.base.util.filechooser.TKFileChooser;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultStruct;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultVector;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperationShowMgr;
import com.huawei.dc.toolkit.client.base.util.sorttable.TKSortButtonRenderer;
import com.huawei.dc.toolkit.client.base.util.sorttable.TKSortTable;
import com.huawei.dc.toolkit.client.base.util.sorttable.TKSortTableModel;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKLoadDataStruct;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKLoadTablePanelInterface;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKNeStruct;
import com.huawei.dc.toolkit.client.te.toolkit.license.TKLicenseLoadDataStruct;
import com.huawei.dc.toolkit.client.te.toolkit.license.TKLicenseLoadInterFrame;
import com.huawei.dc.toolkit.client.te.toolkit.license.TKLicenseLoadTablePanelDef;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKConfirmOperationDlg;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKFileFilterMananger;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKFileSetEditor;
import com.huawei.te.toolkit.AsnOneReturn;
import com.huawei.te.toolkit.AsnTkMessageRpt;
import com.huawei.te.toolkit.AsnToolkitError;
import com.huawei.te.toolkit.AsnToolkitGetLICInfoReq;
import com.huawei.te.toolkit.AsnToolkitGetLICInfoRsp;
import com.huawei.te.toolkit.AsnToolkitLICCopyInfo;
import com.huawei.te.toolkit.AsnToolkitLICCopyReq;
import com.huawei.te.toolkit.AsnToolkitLICCopyRsp;
import com.huawei.te.toolkit.AsnToolkitLICInfo;
import com.huawei.te.toolkit.AsnToolkitLICUpdateOKReq;
import com.huawei.te.toolkit.AsnToolkitLicenseRet;
import com.huawei.te.toolkit.AsnToolkitStateGuageRpt;
import com.huawei.te.toolkit.AsnToolkitUpdateLICInfo;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.commustru.fstru.FStruct;

public class TKLicenseLoadTablePanel
extends TKLicenseLoadTablePanelDef
implements TKLoadTablePanelInterface {
    private Icon iconFileOpen = TKResourceManager.getIcon("fileopen.gif");
    private TKRes res = TKRes.instance();
    private JScrollPane jScrollPane1;
    private JPanel jPanel1;
    private JPanel buttonPanel;
    private TKButton queryBtn;
    private TKButton startBtn;
    private Point p = new Point();
    private GridBagLayout gridBagLayout1;
    private TKLicenseLoadInterFrame tkframe;
    private ArrayList lastDataList = new ArrayList();
    private boolean isTimeout = false;
    private TKNameValuePair normStateNVP = new TKNameValuePair(1, this.res.getString("NormState"));
    private TKNameValuePair abnorStateNVP = new TKNameValuePair(2, this.res.getString("ExcepState"));
    private TKNameValuePair copyStateNVP = new TKNameValuePair(3, this.res.getString("CopyState"));
    private TKNameValuePair bakStateNVP = new TKNameValuePair(4, this.res.getString("BakState"));
    private TKNameValuePair rollbackStateNVP = new TKNameValuePair(5, this.res.getString("RollbackState"));
    private JComboBox statusComBox = this.getStatusComBox();
    private TKNameValuePair backupNVP = new TKNameValuePair(1, this.res.getString("Backup"));
    private TKNameValuePair loadNVP = new TKNameValuePair(2, this.res.getString("Load"));
    private TKNameValuePair validNVP = new TKNameValuePair(1, this.res.getString("Valid"));
    private TKNameValuePair invalidNVP = new TKNameValuePair(2, this.res.getString("Invalid"));
    private TKNameValuePair partInvalidNVP = new TKNameValuePair(3, this.res.getString("PartInvalid"));
    private JComboBox loadTypeComBox = this.getLoadTypeComBox();
    private JComboBox licenseStateComBox = this.getLicenseStateComBox();
    private JMenuItem setFileItem = new JMenuItem(this.res.getString("SelectFile"));
    private JPopupMenu selectFile = new JPopupMenu();
    private String[] tableColName = new String[]{"HideCol", this.res.getString("NeName"), this.res.getString("NeType"), this.res.getString("Status"), this.res.getString("Guage"), this.res.getString("ESN"), this.res.getString("LicStatus"), this.res.getString("LoadBak"), this.res.getString("File")};
    private TKSortTableModel tableModel = new TKSortTableModel(this.tableColName, 0){

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            int oldBakLoadValue;
            if (aValue == null || row < 0 || column < 0 || row == this.getRowCount()) {
                return;
            }
            int newBakLoadValue = oldBakLoadValue = ((TKNameValuePair)this.getValueAt((int)row, (int)7)).value;
            if (column == 7) {
                newBakLoadValue = ((TKNameValuePair)aValue).value;
            }
            super.setValueAt(aValue, row, column);
            if (oldBakLoadValue != newBakLoadValue) {
                TKLicenseLoadDataStruct data = (TKLicenseLoadDataStruct)TKLicenseLoadTablePanel.this.tableModel.getValueAt(row, 0);
                data.loadFile.clear();
                data.bakLoad = newBakLoadValue;
                TKLicenseLoadTablePanel.this.tableModel.setValueAt(data, row, 0);
                TKLicenseLoadTablePanel.this.tableModel.setValueAt(data.loadFile, row, 8);
                ((TKLicenseLoadTablePanel)TKLicenseLoadTablePanel.this).tkframe.infoTablePanel.updateObjectBasicInfo(data);
            }
        }
    };
    private TKSortTable loadTable = new TKSortTable(this.tableModel){

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            if (column == 7) {
                return new TKButtonRenderer("", TKLicenseLoadTablePanel.this.iconFileOpen);
            }
            if (column == 6) {
                return new TKComboxRenderer();
            }
            return new CellRenderer();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            int state;
            boolean isEditable = false;
            isEditable = column == 6 || column == 7 ? (state = ((TKNameValuePair)((TKLicenseLoadTablePanel)TKLicenseLoadTablePanel.this).tableModel.getValueAt((int)row, (int)3)).value) == ((TKLicenseLoadTablePanel)TKLicenseLoadTablePanel.this).normStateNVP.value || state == ((TKLicenseLoadTablePanel)TKLicenseLoadTablePanel.this).abnorStateNVP.value : false;
            return isEditable;
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            if (column == 6) {
                return new DefaultCellEditor(TKLicenseLoadTablePanel.this.loadTypeComBox);
            }
            if (column == 7) {
                TKFileSetEditor fileEditor = new TKFileSetEditor(TKLicenseLoadTablePanel.this);
                return fileEditor;
            }
            return super.getCellEditor(row, column);
        }
    };

    public TKLicenseLoadTablePanel(TKLicenseLoadInterFrame tkframe) {
        this.tkframe = tkframe;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            TKDebug.trace("init license load table panel is failed...");
        }
    }

    private JComboBox getStatusComBox() {
        JComboBox<TKNameValuePair> statusComBoxtemp = new JComboBox<TKNameValuePair>();
        statusComBoxtemp.addItem(this.normStateNVP);
        statusComBoxtemp.addItem(this.abnorStateNVP);
        statusComBoxtemp.addItem(this.copyStateNVP);
        statusComBoxtemp.addItem(this.bakStateNVP);
        statusComBoxtemp.addItem(this.rollbackStateNVP);
        statusComBoxtemp.setSelectedIndex(0);
        return statusComBoxtemp;
    }

    private JComboBox getLicenseStateComBox() {
        JComboBox<TKNameValuePair> licenseStateComBoxtemp = new JComboBox<TKNameValuePair>();
        licenseStateComBoxtemp.addItem(this.validNVP);
        licenseStateComBoxtemp.addItem(this.invalidNVP);
        licenseStateComBoxtemp.addItem(this.partInvalidNVP);
        licenseStateComBoxtemp.setSelectedIndex(0);
        return licenseStateComBoxtemp;
    }

    private JComboBox getLoadTypeComBox() {
        JComboBox<TKNameValuePair> licenseStateComBoxtemp = new JComboBox<TKNameValuePair>();
        licenseStateComBoxtemp.addItem(this.backupNVP);
        licenseStateComBoxtemp.addItem(this.loadNVP);
        licenseStateComBoxtemp.setSelectedIndex(0);
        return licenseStateComBoxtemp;
    }

    private void jbInit() {
        this.gridBagLayout1 = new GridBagLayout();
        this.queryBtn = new TKButton();
        this.startBtn = new TKButton();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.buttonPanel = new JPanel();
        this.setLayout(this.gridBagLayout1);
        this.queryBtn.setText(this.res.getString("Query"));
        this.startBtn.setText(this.res.getString("Start"));
        this.queryBtn.setEnabled(false);
        this.startBtn.setEnabled(false);
        this.queryBtn.setMnemonic('Q');
        this.startBtn.setMnemonic('R');
        Border border = BorderFactory.createEtchedBorder();
        this.jScrollPane1.setBorder(BorderFactory.createTitledBorder(border, this.res.getString("LoadOperForm")));
        this.add((Component)this.jScrollPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.loadTable, null);
        this.loadTable.removeColumn(this.loadTable.getColumnModel().getColumn(0));
        this.loadTable.setRowSelectionAllowed(true);
        this.loadTable.getTableHeader().setReorderingAllowed(false);
        this.loadTable.setRowHeight(22);
        this.loadTable.addColumnSortAction(0);
        this.loadTable.addColumnSortAction(1);
        this.loadTable.addColumnSortAction(2);
        this.loadTable.addColumnSortAction(5);
        this.loadTable.getColumnModel().getColumn(7).setPreferredWidth(150);
        this.loadTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                TKLicenseLoadTablePanel.this.p = e.getPoint();
                int row = TKLicenseLoadTablePanel.this.loadTable.rowAtPoint(TKLicenseLoadTablePanel.this.p);
                if (row < 0) {
                    return;
                }
                int column = TKLicenseLoadTablePanel.this.loadTable.columnAtPoint(TKLicenseLoadTablePanel.this.p);
                if (TKLicenseLoadTablePanel.this.loadTable.getSelectedRows().length < 2) {
                    TKLicenseLoadTablePanel.this.loadTable.setRowSelectionInterval(row, row);
                }
                if (column == 7 && e.isPopupTrigger()) {
                    TKLicenseLoadTablePanel.this.setFile(row, TKLicenseLoadTablePanel.this.p, 1);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TKLicenseLoadTablePanel.this.p = e.getPoint();
                int row = TKLicenseLoadTablePanel.this.loadTable.rowAtPoint(TKLicenseLoadTablePanel.this.p);
                if (row < 0) {
                    return;
                }
                int column = TKLicenseLoadTablePanel.this.loadTable.columnAtPoint(TKLicenseLoadTablePanel.this.p);
                if (TKLicenseLoadTablePanel.this.loadTable.getSelectedRows().length < 2) {
                    TKLicenseLoadTablePanel.this.loadTable.setRowSelectionInterval(row, row);
                }
                if (column == 7 && e.isPopupTrigger()) {
                    TKLicenseLoadTablePanel.this.setFile(row, TKLicenseLoadTablePanel.this.p, 1);
                }
            }
        });
        this.add((Component)this.jPanel1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.setLayout(new GridLayout(1, 2));
        this.jPanel1.add(this.buttonPanel);
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.buttonPanel.add((Component)this.queryBtn, null);
        this.buttonPanel.add((Component)this.startBtn, null);
        this.loadTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    TKLicenseLoadTablePanel.this.processButtonStatus();
                    TKLicenseLoadTablePanel.this.processTableJoin();
                }
            }
        });
        this.setFileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKLicenseLoadTablePanel.this.setFileItem_actionPerformed(e);
            }
        });
        this.startBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKLicenseLoadTablePanel.this.startBtn_actionPerformed();
            }
        });
        this.queryBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKLicenseLoadTablePanel.this.queryBtn_actionPerformed();
            }
        });
        this.queryBtn.setName("_Button_Query");
        this.startBtn.setName("_Button_Start");
        this.loadTable.setName("_Table_Operation");
        this.setFileItem.setName("_MenuItem_SetFile");
    }

    public boolean hasWorkingObjects(TKOperResultVector resultVct) {
        boolean working = false;
        int totalRow = this.tableModel.getRowCount();
        TKLicenseLoadDataStruct data = null;
        for (int row = 0; row < totalRow; ++row) {
            data = (TKLicenseLoadDataStruct)this.tableModel.getValueAt(row, 0);
            if (data.status == this.normStateNVP.value) continue;
            String operObj = data.nedata.neName;
            TKOperResultStruct oper = new TKOperResultStruct(operObj, this.res.getString("Working"), this.statusComBox.getItemAt(data.status - 1).toString());
            resultVct.addElement(oper);
            working = true;
        }
        return working;
    }

    public void refreshTableData(ArrayList neList) {
        int i;
        int total;
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().cancelCellEditing();
        }
        if ((total = this.tableModel.getRowCount()) < 1) {
            return;
        }
        if (null == neList || neList.size() < 1) {
            this.loadTable.clearSelection();
            int count = this.loadTable.getColumnCount();
            for (int i2 = 0; i2 < count; ++i2) {
                TableCellRenderer ren = this.loadTable.getColumnModel().getColumn(i2).getHeaderRenderer();
                if (!(ren instanceof TKSortButtonRenderer)) continue;
                ((TKSortButtonRenderer)ren).clearSortFlag();
            }
            this.loadTable.getTableHeader().repaint();
            this.tableModel.setRowCount(0);
            this.loadTable.repaint();
            return;
        }
        int[] indexs = this.tableModel.getIndexes();
        ArrayList<Integer> deleteRows = new ArrayList<Integer>();
        for (i = 0; i < this.tableModel.getRowCount(); ++i) {
            TKLicenseLoadDataStruct data = (TKLicenseLoadDataStruct)this.tableModel.getValueAt(i, 0);
            boolean find = false;
            for (int j = 0; j < neList.size(); ++j) {
                int neId = ((TKNeStruct)neList.get((int)j)).neID;
                if (data.nedata.neID != neId) continue;
                find = true;
                break;
            }
            if (find) continue;
            deleteRows.add(indexs[i]);
        }
        Collections.sort(deleteRows);
        for (i = deleteRows.size() - 1; i >= 0; --i) {
            int row = (Integer)deleteRows.get(i);
            this.tableModel.removeRow(row);
        }
    }

    private void recordData() {
        int count = this.tableModel.getRowCount();
        StringBuffer neIds = new StringBuffer("aa");
        String separator = "aa";
        for (int i = 0; i < count; ++i) {
            TKLoadDataStruct data = (TKLoadDataStruct)this.tableModel.getValueAt(i, 0);
            neIds.append(data.nedata.neID);
            neIds.append(separator);
            this.lastDataList.remove(data);
            this.lastDataList.add(data);
        }
    }

    public synchronized void updateTableData(ArrayList loadInfoList) {
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().cancelCellEditing();
        }
        this.loadTable.clearSelection();
        int count = this.loadTable.getColumnCount();
        for (int i = 0; i < count; ++i) {
            TableCellRenderer ren = this.loadTable.getColumnModel().getColumn(i).getHeaderRenderer();
            if (!(ren instanceof TKSortButtonRenderer)) continue;
            ((TKSortButtonRenderer)ren).clearSortFlag();
        }
        this.loadTable.getTableHeader().repaint();
        this.recordData();
        ArrayList newlist = this.replaceListData(loadInfoList);
        this.tableModel.setRowCount(0);
        if (null == newlist || newlist.size() < 1) {
            this.loadTable.repaint();
            return;
        }
        for (int i = 0; i < newlist.size(); ++i) {
            TKLicenseLoadDataStruct data = (TKLicenseLoadDataStruct)newlist.get(i);
            Vector<Object> rowData = new Vector<Object>();
            rowData.add(data);
            rowData.add(data.nedata.neName);
            rowData.add(data.nedata.neType);
            rowData.add(this.statusComBox.getItemAt(data.status - 1));
            if (data.guage > 100) {
                data.guage = 0;
            }
            rowData.add(String.valueOf(data.guage));
            rowData.add(data.neESN);
            rowData.add(this.licenseStateComBox.getItemAt(data.licenseStatus - 1));
            rowData.add(this.loadTypeComBox.getItemAt(data.bakLoad - 1));
            rowData.add(data.loadFile.toString());
            this.tableModel.addRow(rowData);
        }
        this.queryBtn.setEnabled(false);
        this.startBtn.setEnabled(false);
        this.loadTable.repaint();
    }

    private ArrayList replaceListData(ArrayList loadInfoList) {
        ArrayList<TKLicenseLoadDataStruct> newList = new ArrayList<TKLicenseLoadDataStruct>();
        if (null == loadInfoList || loadInfoList.size() < 1) {
            return newList;
        }
        for (int k = 0; k < loadInfoList.size(); ++k) {
            boolean isUpdateWithLocal;
            TKLicenseLoadDataStruct data = (TKLicenseLoadDataStruct)loadInfoList.get(k);
            int statusValue = data.status;
            boolean bl = isUpdateWithLocal = !this.isUpdateWithServer(statusValue);
            if (isUpdateWithLocal) {
                data.loadFile.clear();
            }
            for (int c = 0; c < this.lastDataList.size(); ++c) {
                TKLicenseLoadDataStruct olddata = (TKLicenseLoadDataStruct)this.lastDataList.get(c);
                if (data.nedata.neID != olddata.nedata.neID) continue;
                data.resultInfo = olddata.resultInfo;
                data.startTime = olddata.startTime;
                data.endTime = olddata.endTime;
                if (!isUpdateWithLocal) continue;
                data.bakLoad = olddata.bakLoad;
                data.loadFile = olddata.loadFile;
                break;
            }
            newList.add(data);
        }
        return newList;
    }

    private boolean isUpdateWithServer(int statusValue) {
        boolean isUpdateStatus = statusValue != this.normStateNVP.value && statusValue != this.abnorStateNVP.value;
        return isUpdateStatus;
    }

    public void deleteRowbyNeId(int neId) {
        int i;
        int total;
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().cancelCellEditing();
        }
        if ((total = this.tableModel.getRowCount()) < 1) {
            return;
        }
        int[] indexs = this.tableModel.getIndexes();
        ArrayList<Integer> deleteRows = new ArrayList<Integer>();
        for (i = 0; i < this.tableModel.getRowCount(); ++i) {
            TKLicenseLoadDataStruct data = (TKLicenseLoadDataStruct)this.tableModel.getValueAt(i, 0);
            if (data.nedata.neID != neId) continue;
            deleteRows.add(indexs[i]);
            this.lastDataList.remove(data);
        }
        Collections.sort(deleteRows);
        for (i = deleteRows.size() - 1; i >= 0; --i) {
            int row = (Integer)deleteRows.get(i);
            this.tableModel.removeRow(row);
        }
    }

    public int getTableRowbyID(int neID) {
        int totalRow = this.tableModel.getRowCount();
        int row = -1;
        for (int r = 0; r < totalRow; ++r) {
            TKLicenseLoadDataStruct data = (TKLicenseLoadDataStruct)this.tableModel.getValueAt(r, 0);
            if (data.nedata.neID != neID) continue;
            row = r;
            break;
        }
        return row;
    }

    public void updateNEInfo(TKNeStruct data) {
        int row = this.getTableRowbyID(data.neID);
        TKLicenseLoadDataStruct loadData = this.getTableDatabyID(data.neID);
        loadData.nedata.neName = data.neName;
        loadData.nedata.neType = data.neType;
        this.tableModel.setValueAt(loadData, row, 0);
        this.tableModel.setValueAt(data.neName, row, 1);
        this.tableModel.setValueAt(data.neType, row, 2);
        this.loadTable.repaintRow(row);
        this.tkframe.infoTablePanel.updateObjectBasicInfo(loadData);
    }

    private synchronized TKLicenseLoadDataStruct getTableDatabyID(int neID) {
        int totalRow = this.tableModel.getRowCount();
        for (int row = 0; row < totalRow; ++row) {
            TKLicenseLoadDataStruct data = (TKLicenseLoadDataStruct)this.tableModel.getValueAt(row, 0);
            if (data.nedata.neID != neID) continue;
            return data;
        }
        return null;
    }

    public ArrayList getcurrentTableData() {
        int count = this.tableModel.getRowCount();
        ArrayList<TKLoadDataStruct> currentTableData = new ArrayList<TKLoadDataStruct>();
        for (int i = 0; i < count; ++i) {
            TKLoadDataStruct data = (TKLoadDataStruct)this.tableModel.getValueAt(i, 0);
            currentTableData.add(data);
        }
        return currentTableData;
    }

    public synchronized void addedTableData(ArrayList licenseLoadInfoList) {
        ArrayList newlist = this.replaceListData(licenseLoadInfoList);
        if (null == newlist || newlist.size() < 1) {
            this.loadTable.repaint();
            return;
        }
        for (int i = 0; i < newlist.size(); ++i) {
            TKLicenseLoadDataStruct data = (TKLicenseLoadDataStruct)newlist.get(i);
            Vector<Object> rowData = new Vector<Object>();
            rowData.add(data);
            rowData.add(data.nedata.neName);
            rowData.add(data.nedata.neType);
            rowData.add(this.statusComBox.getItemAt(data.status - 1));
            if (data.guage > 100) {
                data.guage = 0;
            }
            rowData.add(String.valueOf(data.guage));
            rowData.add(data.neESN);
            rowData.add(this.licenseStateComBox.getItemAt(data.licenseStatus - 1));
            rowData.add(this.loadTypeComBox.getItemAt(data.bakLoad - 1));
            rowData.add(data.loadFile);
            this.tableModel.addRow(rowData);
        }
        this.loadTable.repaint();
    }

    public void updateStatusGuageMsg(AsnToolkitStateGuageRpt stateGuage) {
        int oldstate;
        int neId = stateGuage.neID.intValue();
        int row = this.getTableRowbyID(neId);
        TKLicenseLoadDataStruct data = this.getTableDatabyID(neId);
        if (null == data || row < 0) {
            return;
        }
        int guageInt = stateGuage.guage.intValue();
        int stateInt = stateGuage.loadState.intValue();
        if (guageInt > 100) {
            guageInt = 0;
        }
        if ((oldstate = ((TKNameValuePair)this.tableModel.getValueAt((int)row, (int)3)).value) != this.copyStateNVP.value && oldstate != this.bakStateNVP.value && oldstate != this.rollbackStateNVP.value) {
            return;
        }
        int oldguage = Integer.parseInt(String.valueOf(this.tableModel.getValueAt(row, 4)));
        if (guageInt > 0 && guageInt < oldguage) {
            return;
        }
        data.guage = guageInt;
        data.status = stateInt;
        this.tableModel.setValueAt(data, row, 0);
        this.tableModel.setValueAt(String.valueOf(data.guage), row, 4);
        this.tableModel.setValueAt(this.statusComBox.getItemAt(data.status - 1), row, 3);
        this.loadTable.repaintRow(row);
        this.tkframe.infoTablePanel.updateObjectBasicInfo(data);
        if (stateInt != oldstate) {
            this.processButtonStatus();
        }
    }

    private void processButtonStatus() {
        int rowInt = -1;
        try {
            rowInt = this.loadTable.getSelectedRow();
        }
        catch (Exception e) {
            rowInt = -1;
        }
        if (rowInt < 0) {
            this.queryBtn.setEnabled(false);
            this.startBtn.setEnabled(false);
            return;
        }
        this.queryBtn.setEnabled(true);
        this.startBtn.setEnabled(true);
        TKNameValuePair buttStateData = null;
        try {
            int[] selectRows = this.loadTable.getSelectedRows();
            for (int j = 0; j < selectRows.length; ++j) {
                buttStateData = (TKNameValuePair)this.tableModel.getValueAt(selectRows[j], 3);
                int statusValue = buttStateData.value;
                if (statusValue == this.normStateNVP.value || statusValue == this.abnorStateNVP.value) continue;
                this.startBtn.setEnabled(false);
            }
        }
        catch (Exception e) {
            this.queryBtn.setEnabled(false);
            this.startBtn.setEnabled(false);
        }
    }

    public Object[] processErrorMsg(AsnTkMessageRpt evtRpt, String dateInfo) {
        int neId = evtRpt.neID.intValue();
        int row = this.getTableRowbyID(neId);
        TKLicenseLoadDataStruct data = this.getTableDatabyID(neId);
        if (null == data || row < 0) {
            TKLogManager.writeToDebug("NELD:get null with ne-id " + neId);
            return null;
        }
        Iterator errorItr = evtRpt.msgList.iterator();
        TKOperResultVector resultV = new TKOperResultVector();
        while (errorItr.hasNext()) {
            AsnToolkitError error = (AsnToolkitError)errorItr.next();
            String operObj = data.nedata.neName;
            String operResult = TKRes.getResultInfo(evtRpt);
            String operReason = TKRes.getErrorInfo(error, evtRpt.msgType.intValue());
            TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
            resultV.addElement(struct);
            if (data.resultInfo.trim().length() > 1) {
                String tmp = data.resultInfo.endsWith("\n") ? "" : "\n";
                data.resultInfo = data.resultInfo + tmp + dateInfo + operReason;
            } else {
                data.resultInfo = dateInfo + operReason;
            }
            this.tkframe.infoTablePanel.updateObjectResult(data);
        }
        if (resultV.size() > 0) {
            return resultV.toArray();
        }
        return null;
    }

    public void processStateReport(AsnToolkitLICInfo asnRtn, String dateInfo) {
        int neId = asnRtn.neID.intValue();
        int row = this.getTableRowbyID(neId);
        TKLicenseLoadDataStruct loadData = this.getTableDatabyID(neId);
        if (null == loadData || row < 0) {
            TKLogManager.writeToDebug("LICLD:get null with ne-id " + neId);
            return;
        }
        int stateInt = asnRtn.loadState.intValue();
        int oldstate = ((TKNameValuePair)this.tableModel.getValueAt((int)row, (int)3)).value;
        loadData.guage = asnRtn.guage.intValue();
        if (loadData.guage > 100) {
            loadData.guage = 0;
        }
        loadData.nedata.neID = asnRtn.neID.intValue();
        loadData.status = asnRtn.loadState.intValue();
        loadData.licenseStatus = asnRtn.licenseState.intValue();
        loadData.neESN = new String(asnRtn.neESN);
        loadData.licenseContent = new String(asnRtn.licenseContent);
        int statusValue = loadData.status;
        boolean isUpdateStatus = this.isUpdateWithServer(statusValue);
        String asnFileName = "";
        if (null != asnRtn.fileName) {
            asnFileName = new String(asnRtn.fileName);
        }
        if (isUpdateStatus) {
            loadData.bakLoad = asnRtn.bakLoad.intValue();
            loadData.loadFile.update(new TKFile(asnFileName));
        }
        if ("".equals(loadData.resultInfo) && (loadData.status == 1 || loadData.status == 2)) {
            loadData.startTime = "";
            loadData.endTime = "";
        } else {
            loadData.startTime = new String(asnRtn.startTime);
            loadData.endTime = new String(asnRtn.endTime);
        }
        if (stateInt != oldstate) {
            if (loadData.bakLoad == this.loadNVP.value && oldstate == this.copyStateNVP.value && stateInt == this.normStateNVP.value) {
                if (loadData.resultInfo.trim().length() > 1) {
                    String tmp = loadData.resultInfo.endsWith("\n") ? "" : "\n";
                    loadData.resultInfo = loadData.resultInfo + tmp;
                }
                loadData.resultInfo = loadData.resultInfo + dateInfo + this.res.getString("LoadLicenseFinish") + "    " + loadData.loadFile;
            } else if (loadData.bakLoad == this.loadNVP.value && oldstate == this.copyStateNVP.value && stateInt == this.abnorStateNVP.value) {
                if (loadData.resultInfo.trim().length() > 1) {
                    String tmp = loadData.resultInfo.endsWith("\n") ? "" : "\n";
                    loadData.resultInfo = loadData.resultInfo + tmp;
                }
                loadData.resultInfo = loadData.resultInfo + dateInfo + this.res.getString("LoadLicenseFailed") + "    " + loadData.loadFile;
            } else if (loadData.bakLoad == this.backupNVP.value && oldstate == this.bakStateNVP.value && stateInt == this.normStateNVP.value) {
                if (loadData.resultInfo.trim().length() > 1) {
                    String tmp = loadData.resultInfo.endsWith("\n") ? "" : "\n";
                    loadData.resultInfo = loadData.resultInfo + tmp;
                }
                loadData.resultInfo = loadData.resultInfo + dateInfo + this.res.getString("BackupLicenseFinish") + "    " + loadData.loadFile;
            } else if (loadData.bakLoad == this.backupNVP.value && oldstate == this.bakStateNVP.value && stateInt == this.abnorStateNVP.value) {
                if (loadData.resultInfo.trim().length() > 1) {
                    String tmp = loadData.resultInfo.endsWith("\n") ? "" : "\n";
                    loadData.resultInfo = loadData.resultInfo + tmp;
                }
                loadData.resultInfo = loadData.resultInfo + dateInfo + this.res.getString("BackupLicenseFailed") + "    " + loadData.loadFile;
            }
            if ("".equals(loadData.resultInfo) && (loadData.status == 1 || loadData.status == 2)) {
                loadData.startTime = "";
                loadData.endTime = "";
            } else {
                loadData.startTime = new String(asnRtn.startTime);
                loadData.endTime = new String(asnRtn.endTime);
            }
            this.tkframe.infoTablePanel.updateObjectResult(loadData);
        }
        this.tableModel.setValueAt(loadData.loadFile, row, 8);
        this.tableModel.setValueAt(loadData.nedata.neName, row, 1);
        this.tableModel.setValueAt(loadData.nedata.neType, row, 2);
        this.tableModel.setValueAt(this.statusComBox.getItemAt(loadData.status - 1), row, 3);
        if (loadData.guage > 100) {
            loadData.guage = 0;
        }
        this.tableModel.setValueAt(String.valueOf(loadData.guage), row, 4);
        if (isUpdateStatus) {
            this.tableModel.setValueAt(this.loadTypeComBox.getItemAt(loadData.bakLoad - 1), row, 7);
        }
        this.tableModel.setValueAt(loadData.neESN, row, 5);
        this.tableModel.setValueAt(this.licenseStateComBox.getItemAt(loadData.licenseStatus - 1), row, 6);
        this.tableModel.setValueAt(loadData, row, 0);
        this.loadTable.repaintRow(row);
        this.tkframe.infoTablePanel.updateObjectBasicInfo(loadData);
        if (stateInt != oldstate) {
            this.processButtonStatus();
        }
    }

    public void processUpdateConfirm(AsnToolkitUpdateLICInfo asnRtn, String dateInfo) {
        final int neId = asnRtn.neID.intValue();
        int row = this.getTableRowbyID(neId);
        final TKLicenseLoadDataStruct data = this.getTableDatabyID(neId);
        final String date = dateInfo;
        if (null == data || row < 0) {
            TKLogManager.writeToDebug("NELD:get null with ne-id " + neId);
            return;
        }
        new Thread(){

            @Override
            public void run() {
                String info = TKLicenseLoadTablePanel.this.res.getString("ConfirmUpdateLicense");
                TKOperResultVector resultV = new TKOperResultVector();
                resultV.addElement(info);
                String dlgDesc = TKLicenseLoadTablePanel.this.res.getString("OperationEffact");
                final TKConfirmOperationDlg confDlg = new TKConfirmOperationDlg(TKResourceManager.getMainFrame(), TKLicenseLoadTablePanel.this.res.getString("Warning"), dlgDesc, resultV, true, true);
                confDlg.setDefaultCloseOperation(2);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        confDlg.hideDetailColumn();
                    }
                });
                int willContinue = confDlg.showDialog();
                if (data.resultInfo.trim().length() > 1) {
                    String tmp = data.resultInfo.endsWith("\n") ? "" : "\n";
                    data.resultInfo = data.resultInfo + tmp + date + info;
                } else {
                    data.resultInfo = data.resultInfo + date + info;
                }
                resultV.clear();
                AsnToolkitLICUpdateOKReq req = new AsnToolkitLICUpdateOKReq();
                req.neID = BigInteger.valueOf(neId);
                req.confirmUpdate = BigInteger.valueOf(willContinue);
                AsnToolkitLicenseRet rsp = new AsnToolkitLicenseRet();
                char cmdCode = '\u1f05';
                byte receiveModule = 31;
                TKScreenToolKit.setComponentCursorBusy(TKLicenseLoadTablePanel.this.tkframe, true);
                TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, receiveModule, 120);
                TKScreenToolKit.setComponentCursorBusy(TKLicenseLoadTablePanel.this.tkframe, false);
                if (!ret.isSuccess) {
                    TKOperationShowMgr.showOperationDlg((Component)TKLicenseLoadTablePanel.this.getParent(), ret.resultInfo, true);
                    return;
                }
                if (!rsp.ret.isSuccess) {
                    TKLicenseLoadDataStruct hideData = TKLicenseLoadTablePanel.this.getTableDatabyID(rsp.neID.intValue());
                    int operRow = TKLicenseLoadTablePanel.this.getTableRowbyID(rsp.neID.intValue());
                    if (hideData == null) {
                        TKLogManager.writeToDebug("hideData is null!");
                        return;
                    }
                    String operObj = hideData.nedata.neName;
                    String operResult = TKLicenseLoadTablePanel.this.res.getString("UpdateConfirmFail");
                    String operReason = TKRes.getErrorInfo(rsp.ret);
                    TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                    resultV.addElement(struct);
                    if (hideData.resultInfo.trim().length() > 1) {
                        String tmp = hideData.resultInfo.endsWith("\n") ? "" : "\n";
                        hideData.resultInfo = hideData.resultInfo + tmp + ret.serverDateTime + "    " + operReason;
                    } else {
                        hideData.resultInfo = hideData.resultInfo + ret.serverDateTime + "    " + operReason;
                    }
                    ((TKLicenseLoadTablePanel)TKLicenseLoadTablePanel.this).tkframe.infoTablePanel.updateObjectResult(hideData);
                    TKLicenseLoadTablePanel.this.tableModel.setValueAt(hideData, operRow, 0);
                }
                if (resultV.size() > 0) {
                    TKOperationShowMgr.showOperationDlg((Component)TKLicenseLoadTablePanel.this.getParent(), TKLicenseLoadTablePanel.this.res.getString("OperResult"), resultV);
                }
                TKLicenseLoadTablePanel.this.processButtonStatus();
            }
        }.start();
    }

    @Override
    public void setFile(ActionEvent e) {
        this.setFileItem_actionPerformed(e);
    }

    @Override
    public void setFile(int row, Point p, int flag) {
        if (flag == 1) {
            if (this.loadTable.getSelectedRows().length < 2) {
                this.loadTable.setRowSelectionInterval(row, row);
            }
            this.selectFile.add(this.setFileItem);
            Point point = TKScreenToolKit.getPopupMenuShowupPosition(this.loadTable, this.selectFile, p.x, p.y);
            this.selectFile.show(this.loadTable, point.x, point.y);
        }
        this.setFileItem.setEnabled(true);
        int[] selectedRows = this.loadTable.getSelectedRows();
        int firstBakLoadType = ((TKNameValuePair)this.tableModel.getValueAt((int)selectedRows[0], (int)7)).value;
        for (int i = 0; i < selectedRows.length; ++i) {
            int updownLoadType = ((TKNameValuePair)this.tableModel.getValueAt((int)selectedRows[i], (int)7)).value;
            int state = ((TKNameValuePair)this.tableModel.getValueAt((int)selectedRows[i], (int)3)).value;
            if ((state == this.normStateNVP.value || state == this.abnorStateNVP.value) && updownLoadType == firstBakLoadType) continue;
            this.setFileItem.setEnabled(false);
            break;
        }
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu selectFile = new JPopupMenu();
        selectFile.add(this.setFileItem);
        return selectFile;
    }

    private void setFileItem_actionPerformed(ActionEvent e) {
        int result;
        TKFile lastFile;
        int[] selectedRows = this.loadTable.getSelectedRows();
        TKLicenseLoadDataStruct loadData = (TKLicenseLoadDataStruct)this.tableModel.getValueAt(selectedRows[0], 0);
        TKFileChooser fc = new TKFileChooser();
        int operType = ((TKNameValuePair)this.tableModel.getValueAt((int)selectedRows[0], (int)7)).value;
        if (operType == 1) {
            fc.setDialogTitle(this.res.getString("SaveFile"));
            fc.setMultiSelectionEnabled(false);
            fc.setFileSelectionMode(1);
        } else if (operType == 2) {
            fc.setMultiSelectionEnabled(false);
            fc.addFileFilter(TKFileFilterMananger.lcsFilter);
            fc.setFileSelectionMode(0);
        }
        if (selectedRows.length == 1 && (lastFile = loadData.loadFile.getCurrentFile()) != null && lastFile != TKLoadFileStruct.nullFile) {
            String lastFilePath;
            if (lastFile instanceof TKFtpStruct) {
                TKFtpStruct ftpLastFile = (TKFtpStruct)lastFile;
                fc.initFtp(ftpLastFile.ftpIP, ftpLastFile.ftpPort, ftpLastFile.ftpUser, ftpLastFile.ftpPass);
            }
            if ((lastFilePath = lastFile.getAbsolutePath()).startsWith("ftp://") || lastFilePath.startsWith("sftp://")) {
                fc.setBrowseType(100);
            }
            if (!"".equals(lastFilePath)) {
                fc.setCurrentDirectory(lastFile);
            }
        }
        if ((result = fc.showFileDialog()) == 0) {
            TKFtpStruct selectedFile = (TKFtpStruct)fc.getSelectedFile();
            if (null != this.loadTable.getCellEditor()) {
                this.loadTable.getCellEditor().cancelCellEditing();
            }
            for (int i = 0; i < selectedRows.length; ++i) {
                TKLicenseLoadDataStruct data = (TKLicenseLoadDataStruct)this.tableModel.getValueAt(selectedRows[i], 0);
                data.loadFile.update(selectedFile);
                this.tableModel.setValueAt(selectedFile.toString(), selectedRows[i], 8);
                this.tableModel.setValueAt(data, selectedRows[i], 0);
                this.tkframe.infoTablePanel.updateObjectBasicInfo(data);
            }
        }
    }

    private void startBtn_actionPerformed() {
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().stopCellEditing();
        }
        int[] selectedRows = this.loadTable.getSelectedRows();
        TKOperResultVector resultV = new TKOperResultVector();
        this.validateSelectRow(selectedRows, resultV);
        resultV.clear();
        String operObj = "";
        String operResult = "";
        String operReason = "";
        for (int i = 0; i < selectedRows.length; ++i) {
            AsnToolkitLICCopyReq req = new AsnToolkitLICCopyReq();
            TKLicenseLoadDataStruct startDataObj = (TKLicenseLoadDataStruct)this.tableModel.getValueAt(selectedRows[i], 0);
            AsnToolkitLICCopyInfo copyInfo = new AsnToolkitLICCopyInfo();
            copyInfo.neID = BigInteger.valueOf(startDataObj.nedata.neID);
            copyInfo.bakLoad = BigInteger.valueOf(startDataObj.bakLoad);
            TKLicenseLoadDataStruct obj = (TKLicenseLoadDataStruct)this.tableModel.getValueAt(selectedRows[i], 0);
            String file = obj.loadFile.getCurrentFile().getAbsolutePath();
            copyInfo.fileName = file.getBytes();
            req.copyInfoList.add((Object)copyInfo);
            AsnToolkitLICCopyRsp rsp = new AsnToolkitLICCopyRsp();
            char cmdCode = '\u1f02';
            byte receiveModule = 31;
            TKScreenToolKit.setComponentCursorBusy(this.tkframe, true);
            TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, receiveModule, 120);
            TKScreenToolKit.setComponentCursorBusy(this.tkframe, false);
            String dateInfo = ret.serverDateTime + "    ";
            if (!ret.isSuccess) {
                operObj = startDataObj.nedata.neName;
                operResult = this.res.getString("StartCopyLICFail");
                operReason = ret.resultInfo;
                TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                resultV.addElement(struct);
                continue;
            }
            Iterator retItr = rsp.retInfoList.iterator();
            if (null == retItr) {
                TKDebug.inmAssert(false, this.res.getString("ReturnDataNull"));
                return;
            }
            while (retItr.hasNext()) {
                AsnToolkitLicenseRet asnRtn = (AsnToolkitLicenseRet)retItr.next();
                TKLicenseLoadDataStruct HideData = this.getTableDatabyID(asnRtn.neID.intValue());
                int row = this.getTableRowbyID(asnRtn.neID.intValue());
                if (null == HideData || row < 0) continue;
                if (asnRtn.ret.isSuccess) {
                    HideData.bakLoad = ((TKNameValuePair)this.tableModel.getValueAt((int)row, (int)7)).value;
                } else {
                    operObj = HideData.nedata.neName;
                    operResult = this.res.getString("StartCopyLICFail");
                    operReason = TKRes.getErrorInfo(asnRtn.ret);
                    TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                    resultV.addElement(struct);
                    if (HideData.resultInfo.trim().length() > 1) {
                        String tmp = HideData.resultInfo.endsWith("\n") ? "" : "\n";
                        HideData.resultInfo = HideData.resultInfo + tmp + dateInfo + operResult + "    " + operReason;
                    } else {
                        HideData.resultInfo = dateInfo + operResult + "    " + operReason;
                    }
                    this.tkframe.infoTablePanel.updateObjectResult(HideData);
                }
                this.tableModel.setValueAt(HideData, row, 0);
            }
        }
        if (resultV.size() > 0) {
            TKOperationShowMgr.showOperationDlg((Component)this.tkframe, this.res.getString("OperResult"), resultV);
        }
        this.processButtonStatus();
        new Thread(){

            @Override
            public void run() {
                TKLicenseLoadTablePanel.this.startBtn.requestFocus();
            }
        }.start();
    }

    private void validateSelectRow(int[] selectedRows, TKOperResultVector resultV) {
        for (int j = 0; j < selectedRows.length; ++j) {
            TKOperResultStruct struct;
            String operReason;
            String operResult;
            String nename;
            Object bakLoad = this.tableModel.getValueAt(selectedRows[j], 7);
            String file = "";
            Object objfile = this.tableModel.getValueAt(selectedRows[j], 8);
            if (null != objfile) {
                file = objfile.toString();
            }
            if (file.trim().length() < 1) {
                nename = this.tableModel.getValueAt(selectedRows[j], 1).toString();
                operResult = this.res.getString("LoadFailure");
                operReason = this.res.getString("NotSelectedFile");
                struct = new TKOperResultStruct(nename, operResult, operReason);
                resultV.addElement(struct);
                continue;
            }
            if (bakLoad instanceof TKNameValuePair) continue;
            nename = this.tableModel.getValueAt(selectedRows[j], 1).toString();
            operResult = this.res.getString("StartCopy");
            operReason = this.res.getString("IncorrectLoadType");
            struct = new TKOperResultStruct(nename, operResult, operReason);
            resultV.addElement(struct);
        }
        if (resultV.size() > 0) {
            TKOperationShowMgr.showOperationDlg((Component)this.getParent(), this.res.getString("NotSetParam"), resultV);
            resultV.clear();
            return;
        }
        int operType = ((TKNameValuePair)this.tableModel.getValueAt((int)selectedRows[0], (int)7)).value;
        if (operType == 2) {
            String info = this.res.getString("BakLICInfo");
            resultV.addElement(info);
            String dlgDesc = this.res.getString("OperationEffact");
            TKConfirmOperationDlg confDlg = new TKConfirmOperationDlg(TKResourceManager.getMainFrame(), this.res.getString("Hint"), dlgDesc, resultV, true, true);
            confDlg.setDefaultCloseOperation(2);
            confDlg.hideDetailColumn();
            TKScreenToolKit.centerLocateToScreen(confDlg);
            int willContinue = confDlg.showDialog();
            if (willContinue == 1) {
                return;
            }
        }
    }

    private void queryBtn_actionPerformed() {
        if (null != this.loadTable.getCellEditor()) {
            this.loadTable.getCellEditor().stopCellEditing();
        }
        int[] selectedRows = this.loadTable.getSelectedRows();
        TKOperResultVector resultV = new TKOperResultVector();
        AsnToolkitGetLICInfoReq req = new AsnToolkitGetLICInfoReq();
        TKLicenseLoadDataStruct queryDataObj = null;
        for (int i = 0; i < selectedRows.length; ++i) {
            queryDataObj = (TKLicenseLoadDataStruct)this.tableModel.getValueAt(selectedRows[i], 0);
            req.neIdList.add((Object)BigInteger.valueOf(queryDataObj.nedata.neID));
        }
        AsnToolkitGetLICInfoRsp rsp = new AsnToolkitGetLICInfoRsp();
        char cmdCode = '\u1f01';
        byte receiveModule = 31;
        TKScreenToolKit.setComponentCursorBusy(this.tkframe, true);
        this.queryBtn.setEnabled(false);
        TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, receiveModule, 120);
        TKScreenToolKit.setComponentCursorBusy(this.tkframe, false);
        this.queryBtn.setEnabled(true);
        if (!ret.isSuccess) {
            TKOperationShowMgr.showOperationDlg((Component)this, ret.resultInfo, false);
            return;
        }
        Iterator infoItr = rsp.licInfoList.iterator();
        Iterator retItr = rsp.ret.iterator();
        if (null == infoItr) {
            TKDebug.inmAssert(false, this.res.getString("ReturnDataNull"));
            return;
        }
        String dateInfo = ret.serverDateTime + "    ";
        if (null != infoItr && null != retItr) {
            this.processResult(resultV, infoItr, retItr, dateInfo);
        }
        if (resultV.size() > 0) {
            TKOperationShowMgr.showOperationDlg((Component)this.getParent(), this.res.getString("OperResult"), resultV);
        }
        this.processButtonStatus();
    }

    private void processResult(TKOperResultVector resultV, Iterator infoItr, Iterator retItr, String dateInfo) {
        while (infoItr.hasNext()) {
            AsnToolkitLICInfo asnInfo = (AsnToolkitLICInfo)infoItr.next();
            AsnOneReturn asnRtn = (AsnOneReturn)retItr.next();
            TKLicenseLoadDataStruct HideData = this.getTableDatabyID(asnInfo.neID.intValue());
            int row = this.getTableRowbyID(asnInfo.neID.intValue());
            if (null == HideData || row < 0) {
                String str = "";
                str = null == HideData ? "HideData is null." : HideData.toString();
                TKLogManager.writeToDebug("HideData of TKLicenseLoadTablePanel queryBtn_actionPerformed():" + str);
                TKLogManager.writeToDebug("row of TKLicenseLoadTablePanel queryBtn_actionPerformed():" + row);
                continue;
            }
            if (!asnRtn.ret.isSuccess) {
                String operObj = HideData.nedata.neName;
                String operResult = this.res.getString("QueryFail");
                String operReason = TKRes.getErrorInfo(asnRtn.ret);
                TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                resultV.addElement(struct);
                if (HideData.resultInfo.trim().length() > 1) {
                    String tmp = HideData.resultInfo.endsWith("\n") ? "" : "\n";
                    HideData.resultInfo = HideData.resultInfo + tmp + dateInfo + operResult + "    " + operReason;
                } else {
                    HideData.resultInfo = dateInfo + operResult + "    " + operReason;
                }
                this.tableModel.setValueAt(HideData, row, 0);
                this.tkframe.infoTablePanel.updateObjectResult(HideData);
                continue;
            }
            HideData.status = asnInfo.loadState.intValue();
            int statusValue = HideData.status;
            boolean isUpdateStatus = this.isUpdateWithServer(statusValue);
            if (isUpdateStatus) {
                HideData.bakLoad = asnInfo.bakLoad.intValue();
            }
            HideData.guage = asnInfo.guage.intValue();
            HideData.neESN = new String(asnInfo.neESN);
            HideData.licenseStatus = asnInfo.licenseState.intValue();
            HideData.licenseContent = new String(asnInfo.licenseContent);
            if ("".equals(HideData.resultInfo) && (HideData.status == 1 || HideData.status == 2)) {
                HideData.startTime = "";
                HideData.endTime = "";
            } else {
                HideData.startTime = new String(asnInfo.startTime);
                HideData.endTime = new String(asnInfo.endTime);
            }
            String asnFileName = new String(asnInfo.fileName);
            if (asnFileName.length() <= 0 && (HideData.status == this.copyStateNVP.value || HideData.status == this.bakStateNVP.value || HideData.status == this.rollbackStateNVP.value)) {
                String operObj = HideData.nedata.neName;
                String operResult = this.res.getString("OperResult");
                String operReason = this.res.getString("PleaseRollback");
                TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                resultV.addElement(struct);
                if (HideData.resultInfo.trim().length() > 1) {
                    String tmp = HideData.resultInfo.endsWith("\n") ? "" : "\n";
                    HideData.resultInfo = HideData.resultInfo + tmp + dateInfo + operResult + "    " + operReason;
                } else {
                    HideData.resultInfo = dateInfo + operResult + "    " + operReason;
                }
                this.tkframe.infoTablePanel.updateObjectResult(HideData);
            }
            this.tableModel.setValueAt(HideData, row, 0);
            this.tableModel.setValueAt(HideData.nedata.neName, row, 1);
            this.tableModel.setValueAt(HideData.nedata.neType, row, 2);
            if (isUpdateStatus) {
                this.tableModel.setValueAt(this.loadTypeComBox.getItemAt(HideData.bakLoad - 1), row, 7);
            }
            this.tableModel.setValueAt(this.statusComBox.getItemAt(HideData.status - 1), row, 3);
            this.tableModel.setValueAt(HideData.neESN, row, 5);
            this.tableModel.setValueAt(this.licenseStateComBox.getItemAt(HideData.licenseStatus - 1), row, 6);
            if (HideData.guage > 100) {
                HideData.guage = 0;
            }
            this.tableModel.setValueAt(String.valueOf(HideData.guage), row, 4);
            if (isUpdateStatus) {
                String fileName = "";
                if (null != asnInfo.fileName && asnInfo.fileName.length > 0) {
                    fileName = new String(asnInfo.fileName);
                }
                HideData.loadFile.update(fileName);
            }
            this.tableModel.setValueAt(HideData.loadFile, row, 8);
            this.loadTable.repaintRow(row);
            this.tkframe.infoTablePanel.updateObjectBasicInfo(HideData);
            this.tkframe.infoTablePanel.updateObjectLicense(HideData);
        }
    }

    private synchronized void processTableJoin() {
        int row = -1;
        try {
            row = this.loadTable.getSelectedRow();
            if (row < 0) {
                this.tkframe.infoTablePanel.updateTableData(null);
            } else {
                TKLicenseLoadDataStruct rowDataObj = (TKLicenseLoadDataStruct)this.tableModel.getValueAt(row, 0);
                this.tkframe.infoTablePanel.updateTableData(rowDataObj);
            }
        }
        catch (Exception e) {
            this.tkframe.infoTablePanel.updateTableData(null);
        }
    }

    public void clearNEResultInfo(int neID) {
        int row = this.getTableRowbyID(neID);
        TKLicenseLoadDataStruct loadData = this.getTableDatabyID(neID);
        if (row < 0 || null == loadData) {
            return;
        }
        loadData.resultInfo = "";
        if (loadData.status == 1 || loadData.status == 2) {
            loadData.startTime = "";
            loadData.endTime = "";
        }
    }

    class CellRenderer
    extends DefaultTableCellRenderer {
        CellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

