/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.license;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.communicate.TKCmdMSG;
import com.huawei.dc.toolkit.client.base.communicate.TKCommUtility;
import com.huawei.dc.toolkit.client.base.communicate.TKCommandResult;
import com.huawei.dc.toolkit.client.base.communicate.TKNoticeReceiver;
import com.huawei.dc.toolkit.client.base.util.TKDebug;
import com.huawei.dc.toolkit.client.base.util.TKFile;
import com.huawei.dc.toolkit.client.base.util.TKLogManager;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.component.TKSplitPane;
import com.huawei.dc.toolkit.client.base.util.help.TKHelpMgr;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultStruct;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultVector;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperationShowMgr;
import com.huawei.dc.toolkit.client.te.toolkit.TKMainFrame;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKInternalFrame;
import com.huawei.dc.toolkit.client.te.toolkit.license.TKLicenseDetailsTablePanel;
import com.huawei.dc.toolkit.client.te.toolkit.license.TKLicenseLoadDataStruct;
import com.huawei.dc.toolkit.client.te.toolkit.license.TKLicenseLoadTablePanel;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKTreeMgr;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKTreeNodeProp;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKTreePanel;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKConfirmOperationDlg;
import com.huawei.te.toolkit.AsnOneReturn;
import com.huawei.te.toolkit.AsnTkMessageRpt;
import com.huawei.te.toolkit.AsnToolkitGetLICInfoReq;
import com.huawei.te.toolkit.AsnToolkitGetLICInfoRsp;
import com.huawei.te.toolkit.AsnToolkitLICInfo;
import com.huawei.te.toolkit.AsnToolkitStateGuageRpt;
import com.huawei.te.toolkit.AsnToolkitUpdateLICInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import net.commustru.fstru.FStruct;

public class TKLicenseLoadInterFrame
extends TKInternalFrame
implements TKNoticeReceiver {
    private TKRes res = TKRes.instance();
    private String OperReportMark = "OperReportMark";
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private GridBagLayout gridBagLayout1;
    public TKTreePanel objectTreePanel;
    public TKLicenseLoadTablePanel loadTablePanel;
    public TKLicenseDetailsTablePanel infoTablePanel;
    private TKMainFrame parent;
    private int funcID = 31;
    private double modulusX = 0.3;
    private double modulusY = 0.3;
    private double modulus = 0.5;
    private double oldArea = -1.0;
    private double newArea = 1.0;
    private static final int NORMAL_STATE = 1;
    private static final int ABNORMAL_STATE = 2;
    private ArrayList licenseLoadInfoList = new ArrayList();

    public TKLicenseLoadInterFrame() {
        this((TKMainFrame)null);
    }

    public TKLicenseLoadInterFrame(TKMainFrame parent) {
        this.parent = parent;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            TKDebug.trace("init license interFrame is failed...");
        }
    }

    public TKLicenseLoadTablePanel getLoadTablePanel() {
        return this.loadTablePanel;
    }

    public String getDlgMark() {
        return this.OperReportMark;
    }

    private void jbInit() throws Exception {
        this.setTitle(this.res.getString("LicenseMrg"));
        TKHelpMgr.instance().helpRootPane(this.getRootPane());
        TKHelpMgr.instance().helpComponent(this, "licenseframe");
        this.setFrameIcon(TKResourceManager.getMainIcon());
        this.objectTreePanel = new TKTreePanel(this, 11, this.funcID);
        this.loadTablePanel = new TKLicenseLoadTablePanel(this);
        this.infoTablePanel = new TKLicenseDetailsTablePanel();
        this.jSplitPane1 = new TKSplitPane();
        this.jSplitPane2 = new TKSplitPane();
        this.gridBagLayout1 = new GridBagLayout();
        this.infoTablePanel.setLoadTablePanel(this.loadTablePanel);
        this.getContentPane().setLayout(this.gridBagLayout1);
        JScrollPane scrolPanel = new JScrollPane();
        scrolPanel.setVerticalScrollBarPolicy(21);
        scrolPanel.getViewport().add(this.objectTreePanel);
        this.jSplitPane1.setLeftComponent(scrolPanel);
        this.jSplitPane1.setRightComponent(this.jSplitPane2);
        this.jSplitPane1.setDividerSize(5);
        this.jSplitPane1.setDividerLocation(220);
        this.jSplitPane2.setTopComponent(this.loadTablePanel);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setBottomComponent(this.infoTablePanel);
        this.jSplitPane2.setDividerSize(5);
        int h = 350;
        if (null != this.parent) {
            h = this.parent.desk.getHeight() - 352 - 15;
        }
        this.jSplitPane2.setDividerLocation(h);
        this.getContentPane().add((Component)this.jSplitPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                TKLicenseLoadInterFrame.this.newArea = TKLicenseLoadInterFrame.this.getWidth() * TKLicenseLoadInterFrame.this.getHeight();
                if (TKLicenseLoadInterFrame.this.oldArea == -1.0) {
                    TKLicenseLoadInterFrame.this.oldArea = TKLicenseLoadInterFrame.this.newArea;
                }
                if (TKLicenseLoadInterFrame.this.oldArea >= TKLicenseLoadInterFrame.this.newArea) {
                    TKLicenseLoadInterFrame.this.jSplitPane1.setDividerLocation((int)((double)TKLicenseLoadInterFrame.this.getSize().width * TKLicenseLoadInterFrame.this.modulusX));
                    TKLicenseLoadInterFrame.this.jSplitPane2.setDividerLocation((int)((double)TKLicenseLoadInterFrame.this.getSize().height * TKLicenseLoadInterFrame.this.modulusY));
                } else {
                    TKLicenseLoadInterFrame.this.jSplitPane1.setDividerLocation((int)((double)TKLicenseLoadInterFrame.this.getSize().width * TKLicenseLoadInterFrame.this.modulusX));
                    TKLicenseLoadInterFrame.this.jSplitPane2.setDividerLocation((int)((double)TKLicenseLoadInterFrame.this.getSize().height * TKLicenseLoadInterFrame.this.modulus));
                }
                TKLicenseLoadInterFrame.this.oldArea = TKLicenseLoadInterFrame.this.newArea;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TKLicenseLoadInterFrame.this.modulusX = (float)TKLicenseLoadInterFrame.this.jSplitPane1.getDividerLocation() / (float)TKLicenseLoadInterFrame.this.getWidth();
                TKLicenseLoadInterFrame.this.modulusY = (float)TKLicenseLoadInterFrame.this.jSplitPane2.getDividerLocation() / (float)TKLicenseLoadInterFrame.this.getHeight();
            }
        });
    }

    @Override
    public void refreshTableData(ArrayList neList) {
        this.loadTablePanel.refreshTableData(neList);
    }

    public void updateTableData(ArrayList loadInfoList) {
        this.loadTablePanel.updateTableData(loadInfoList);
    }

    @Override
    public void deleteRowbyId(int neId, int slot) {
        this.loadTablePanel.deleteRowbyNeId(neId);
    }

    @Override
    public void doLoadInfoQuery(ArrayList selectedNeList) {
        this.doAddedLICLoadInfoQuery(selectedNeList);
    }

    private void doAddedLICLoadInfoQuery(ArrayList selectedNeList) {
        Iterator itr = selectedNeList.iterator();
        ArrayList lst = new ArrayList();
        int count = 0;
        boolean isFirst = true;
        ArrayList currentTableData = new ArrayList();
        currentTableData = this.loadTablePanel.getcurrentTableData();
        TKOperResultVector resultV = new TKOperResultVector();
        while (itr.hasNext()) {
            Object obj = itr.next();
            TKTreeNodeProp prop = (TKTreeNodeProp)obj;
            if (prop.nodeType != 1) continue;
            lst.add(obj);
            if (++count < 3) continue;
            TKCommandResult ret = new TKCommandResult();
            Object[] rets = this.executeLicenseLoadInfoQuery(currentTableData, lst, isFirst, ret);
            if (!ret.isSuccess) {
                TKOperationShowMgr.showOperationDlg((Component)this, ret.resultInfo, false);
                return;
            }
            if (null != rets) {
                resultV.addElement(rets);
            }
            lst.clear();
            count = 0;
            isFirst = false;
        }
        if (count > 0 && count <= 3) {
            TKCommandResult ret = new TKCommandResult();
            Object[] rets = this.executeLicenseLoadInfoQuery(currentTableData, lst, isFirst, ret);
            if (!ret.isSuccess) {
                TKOperationShowMgr.showOperationDlg((Component)this, ret.resultInfo, false);
                return;
            }
            if (null != rets) {
                resultV.addElement(rets);
            }
        }
        if (resultV.size() > 0) {
            TKOperationShowMgr.showOperationDlg((Component)this, this.res.getString("OperResult"), resultV);
        }
    }

    private Object[] executeLicenseLoadInfoQuery(ArrayList currentTableData, ArrayList selectedNeList, boolean isFirst, TKCommandResult ret) {
        this.licenseLoadInfoList.clear();
        AsnToolkitGetLICInfoReq req = new AsnToolkitGetLICInfoReq();
        if (null != selectedNeList && selectedNeList.size() > 0) {
            for (int i = 0; i < selectedNeList.size(); ++i) {
                TKTreeNodeProp prop = (TKTreeNodeProp)selectedNeList.get(i);
                if (prop.nodeType != 1) continue;
                req.neIdList.add((Object)BigInteger.valueOf(prop.nedata.neID));
            }
        }
        AsnToolkitGetLICInfoRsp rsp = new AsnToolkitGetLICInfoRsp();
        char cmdCode = '\u1f01';
        byte recvModule = 31;
        TKScreenToolKit.setComponentCursorBusy(this, true);
        ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, recvModule, 120);
        TKScreenToolKit.setComponentCursorBusy(this, false);
        if (!ret.isSuccess) {
            TKOperationShowMgr.showOperationDlg((Component)this.getParent(), ret.resultInfo, false);
            return null;
        }
        Iterator neinfoItr = rsp.licInfoList.iterator();
        Iterator retItr = rsp.ret.iterator();
        TKOperResultVector resultV = new TKOperResultVector();
        if (null != neinfoItr && null != retItr) {
            block1: while (neinfoItr.hasNext()) {
                AsnToolkitLICInfo asnLicenseInfo = (AsnToolkitLICInfo)neinfoItr.next();
                AsnOneReturn asnRtn = (AsnOneReturn)retItr.next();
                TKTreeMgr cfr_ignored_0 = this.objectTreePanel.treeMgr;
                TKTreeNodeProp neProp = TKTreeMgr.getNodePropFromList(asnLicenseInfo.neID.intValue(), -1, selectedNeList);
                if (!asnRtn.ret.isSuccess) {
                    String operObj = neProp.nedata.neName;
                    String operResult = this.res.getString("QueryFail");
                    String operReason = TKRes.getErrorInfo(asnRtn.ret);
                    TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                    resultV.addElement(struct);
                    String neIds = "aa";
                    String separator = "aa";
                    for (int i = 0; i < currentTableData.size(); ++i) {
                        TKLicenseLoadDataStruct oldData = (TKLicenseLoadDataStruct)currentTableData.get(i);
                        if ((neIds = neIds + oldData.nedata.neID + separator).indexOf(separator + neProp.nedata.neID + separator) < 0) continue;
                        this.licenseLoadInfoList.add(oldData);
                        continue block1;
                    }
                    continue;
                }
                TKLicenseLoadDataStruct loadData = this.fillLicenseInfoData(neProp, asnLicenseInfo, asnRtn);
                if (null == loadData) continue;
                this.licenseLoadInfoList.add(loadData);
            }
        }
        if (isFirst) {
            this.loadTablePanel.updateTableData(this.licenseLoadInfoList);
        } else {
            this.loadTablePanel.addedTableData(this.licenseLoadInfoList);
        }
        if (resultV.size() > 0) {
            return resultV.toArray();
        }
        return null;
    }

    private TKLicenseLoadDataStruct fillLicenseInfoData(TKTreeNodeProp neProp, AsnToolkitLICInfo asnRtn, AsnOneReturn asnRet) {
        TKLicenseLoadDataStruct loadData = new TKLicenseLoadDataStruct();
        if (null != neProp) {
            loadData.nedata = neProp.nedata;
            if (neProp.nedata.isTL1NE) {
                loadData.nedata.neName = neProp.nedata.TID;
            }
        }
        if (asnRet.ret.isSuccess) {
            loadData.status = asnRtn.loadState.intValue();
            loadData.guage = asnRtn.guage.intValue();
            loadData.licenseStatus = asnRtn.licenseState.intValue();
            loadData.neESN = new String(asnRtn.neESN);
            loadData.bakLoad = asnRtn.bakLoad.intValue();
            loadData.licenseContent = new String(asnRtn.licenseContent);
            if ("".equals(loadData.resultInfo) && (loadData.status == 1 || loadData.status == 2)) {
                loadData.startTime = "";
                loadData.endTime = "";
            } else {
                loadData.startTime = new String(asnRtn.startTime);
                loadData.endTime = new String(asnRtn.endTime);
            }
            loadData.loadFile.clear();
            if (asnRtn.fileName != null) {
                loadData.loadFile.add(new TKFile(new String(asnRtn.fileName)));
            }
        }
        return loadData;
    }

    @Override
    public void updateTableNEData(TKTreeNodeProp neNode) {
        int row = this.loadTablePanel.getTableRowbyID(neNode.nedata.neID);
        if (row >= 0) {
            this.loadTablePanel.updateNEInfo(neNode.nedata);
        }
    }

    @Override
    public TKTreePanel getObjectTreePanel() {
        return this.objectTreePanel;
    }

    @Override
    public boolean isNeedRevertLayout() {
        int dividerLocation2 = this.jSplitPane2.getDividerLocation();
        int heigthFrame = this.getHeight();
        return heigthFrame - dividerLocation2 < 50 || dividerLocation2 < 5;
    }

    @Override
    public void revertLayout() {
        this.jSplitPane1.setDividerLocation(220);
        int high = 350;
        if (null != this.parent) {
            high = this.parent.desk.getHeight() - 352 - 15;
        }
        this.jSplitPane2.setDividerLocation(high);
    }

    @Override
    public byte handleNotice(char cmdCode, TKCmdMSG data) {
        TKOperResultVector resultV = new TKOperResultVector();
        String operResult = this.res.getString("OperReport");
        if (cmdCode == '\u1f06') {
            AsnToolkitStateGuageRpt stateGuage = new AsnToolkitStateGuageRpt();
            boolean result = TKCommUtility.getASNData(data, (FStruct)stateGuage);
            if (!result) {
                TKDebug.inmAssert(false, this.res.getString("DecodeFail"));
                return 0;
            }
            this.loadTablePanel.updateStatusGuageMsg(stateGuage);
        } else if (cmdCode == '\u1f08') {
            AsnTkMessageRpt rptEvt = new AsnTkMessageRpt();
            boolean result = TKCommUtility.getASNData(data, (FStruct)rptEvt);
            if (!result) {
                TKDebug.inmAssert(false, this.res.getString("DecodeFail"));
                return 0;
            }
            Object[] rets = this.loadTablePanel.processErrorMsg(rptEvt, data.msgHead.dateTime + "    ");
            if (rets != null) {
                resultV.addElement(rets);
            }
        } else if (cmdCode == '\u1f07') {
            AsnToolkitLICInfo rptEvt = new AsnToolkitLICInfo();
            boolean result = TKCommUtility.getASNData(data, (FStruct)rptEvt);
            if (!result) {
                TKDebug.inmAssert(false, this.res.getString("DecodeFail"));
                return 0;
            }
            this.loadTablePanel.processStateReport(rptEvt, data.msgHead.dateTime + "    ");
        } else if (cmdCode == '\u1f04') {
            AsnToolkitUpdateLICInfo rptEvt = new AsnToolkitUpdateLICInfo();
            boolean result = TKCommUtility.getASNData(data, (FStruct)rptEvt);
            if (!result) {
                TKDebug.inmAssert(false, this.res.getString("DecodeFail"));
                return 0;
            }
            this.loadTablePanel.processUpdateConfirm(rptEvt, data.msgHead.dateTime + "    ");
        }
        if (resultV.size() > 0) {
            TKOperationShowMgr.showMutexOperationDlg((Component)this, operResult, resultV, this.OperReportMark);
        }
        return 1;
    }

    @Override
    public void doDefaultCloseAction() {
        TKOperResultVector resultVct = new TKOperResultVector();
        if (this.loadTablePanel.hasWorkingObjects(resultVct)) {
            TKConfirmOperationDlg confDlg = new TKConfirmOperationDlg(TKResourceManager.getMainFrame(), this.res.getString("Hint"), this.res.getString("ConfirmDisposeWorking"), resultVct, true);
            confDlg.showDetail();
            int willContinue = confDlg.showDialog();
            if (willContinue == 1) {
                return;
            }
        }
        this.dispose();
    }

    @Override
    public void dispose() {
        if (null != TKCommUtility.comm) {
            TKCommUtility.comm.unregisterListener('\u1f06', this);
            TKCommUtility.comm.unregisterListener('\u1f07', this);
            TKCommUtility.comm.unregisterListener('\u1f08', this);
            TKCommUtility.comm.unregisterListener('\u1f04', this);
        }
        if (null != this.jSplitPane1) {
            this.jSplitPane1 = null;
        }
        if (null != this.jSplitPane2) {
            this.jSplitPane2 = null;
        }
        if (null != this.objectTreePanel) {
            this.objectTreePanel.dispose();
            this.objectTreePanel = null;
        }
        if (null != this.loadTablePanel) {
            this.loadTablePanel = null;
        }
        if (null != this.infoTablePanel) {
            this.infoTablePanel = null;
        }
        if (null != this.parent) {
            this.parent = null;
        }
        this.removeAll();
        super.dispose();
    }

    @Override
    public void registerCmd() {
        try {
            TKLogManager.writeToFile("RegisterListener CommandCode on " + this.getTitle());
            TKCommUtility.comm.registerListener('\u1f08', this);
            TKCommUtility.comm.registerListener('\u1f06', this);
            TKCommUtility.comm.registerListener('\u1f07', this);
            TKCommUtility.comm.registerListener('\u1f04', this);
            TKLogManager.writeToFile("RegisterListener CommandCode on " + this.getTitle() + " Successfully.");
        }
        catch (Exception e) {
            DCDebugTracer.trace("register cmd failed");
            DCDebugTracer.trace(e);
        }
    }
}

