/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.license;

import com.huawei.dc.toolkit.client.base.util.TKDebug;
import com.huawei.dc.toolkit.client.base.util.TKLogManager;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.component.TKBlankRenderer;
import com.huawei.dc.toolkit.client.base.util.component.TKGuageRenderer;
import com.huawei.dc.toolkit.client.base.util.component.TKInfoEditor;
import com.huawei.dc.toolkit.client.base.util.component.TKInfoRenderer;
import com.huawei.dc.toolkit.client.base.util.component.TKPopMenuItem;
import com.huawei.dc.toolkit.client.base.util.component.TKSplitPane;
import com.huawei.dc.toolkit.client.base.util.component.TKTextArea;
import com.huawei.dc.toolkit.client.base.util.component.TKTooltipTable;
import com.huawei.dc.toolkit.client.te.toolkit.license.TKLicenseLoadDataStruct;
import com.huawei.dc.toolkit.client.te.toolkit.license.TKLicenseLoadTablePanel;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKTableRowResizer;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TKLicenseDetailsTablePanel
extends JPanel {
    private TKRes res = TKRes.instance();
    TKLicenseLoadTablePanel loadTablePanel;
    private JSplitPane splitPane;
    private JScrollPane detailPane;
    private JScrollPane licenseInfoPane;
    private TKInfoEditor texteditor;
    private TKTextArea licenseInfo = new TKTextArea();
    JPopupMenu clearMenu;
    private TKPopMenuItem clearMenuItem;
    private GridBagLayout gridBagLayout1;
    private String[] colNames = new String[]{this.res.getString("Name"), this.res.getString("Value")};
    private static final int NENAME_ROW = 0;
    private static final int FILE_ROW = 1;
    private static final int GUAGE_ROW = 2;
    private static final int STARTTIME_ROW = 3;
    private static final int ROW_RESULTINFO = 4;
    private static final int VALUE_COLUMN = 1;
    private int neID = -1;
    private Object[][] tableData2 = new Object[][]{{this.res.getString("NeName"), ""}, {this.res.getString("File"), ""}, {this.res.getString("Guage"), ""}, {this.res.getString("Start-EndTime"), ""}, {this.res.getString("OperResult"), ""}};
    private TKGuageRenderer guageRender = new TKGuageRenderer(0, 100);
    private TKInfoRenderer textrender = new TKInfoRenderer();
    private DefaultTableModel infoTableModel = new DefaultTableModel(this.tableData2, this.colNames);
    private TKTooltipTable infoTable = new TKTooltipTable(this.infoTableModel){

        @Override
        public boolean isCellEditable(int row, int column) {
            return row == 4 && column == 1;
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            if (row == 4 && column == 1) {
                return TKLicenseDetailsTablePanel.this.texteditor;
            }
            return super.getCellEditor(row, column);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            if (column == 1) {
                if (row == 2) {
                    return TKLicenseDetailsTablePanel.this.guageRender;
                }
                if (row == 4) {
                    return TKLicenseDetailsTablePanel.this.textrender;
                }
            }
            return new TKBlankRenderer();
        }
    };
    TKTableRowResizer rowResize = new TKTableRowResizer(this.infoTable);
    TKLicenseLoadDataStruct data = null;

    public TKLicenseDetailsTablePanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            TKDebug.trace("init license info table is failed...");
        }
    }

    private void jbInit() throws Exception {
        this.rowResize.addResizableRow(4);
        this.licenseInfo.setEditable(false);
        this.splitPane = new TKSplitPane();
        this.gridBagLayout1 = new GridBagLayout();
        this.detailPane = new JScrollPane();
        this.licenseInfoPane = new JScrollPane();
        this.texteditor = new TKInfoEditor();
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this.splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.splitPane.setTopComponent(this.detailPane);
        this.splitPane.setBottomComponent(this.licenseInfoPane);
        this.splitPane.setOrientation(0);
        this.splitPane.setDividerSize(5);
        this.splitPane.setDividerLocation(220);
        this.detailPane.getViewport().add((Component)this.infoTable, null);
        this.infoTable.getTableHeader().setReorderingAllowed(false);
        this.infoTable.setRowHeight(22);
        this.infoTable.setRowHeight(4, 112);
        this.infoTable.getColumnModel().getColumn(0).setMaxWidth(170);
        this.infoTable.getColumnModel().getColumn(0).setPreferredWidth(120);
        this.licenseInfoPane.getViewport().add((Component)this.licenseInfo, null);
        this.texteditor.getTextArea().add(this.createPopMenu());
        this.infoTable.add(this.createPopMenu());
        this.infoTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point p = e.getPoint();
                int row = TKLicenseDetailsTablePanel.this.infoTable.rowAtPoint(p);
                if (row == 4) {
                    TKLicenseDetailsTablePanel.this.checkMouse(e, TKLicenseDetailsTablePanel.this.infoTable);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Point p = e.getPoint();
                int row = TKLicenseDetailsTablePanel.this.infoTable.rowAtPoint(p);
                if (row == 4) {
                    TKLicenseDetailsTablePanel.this.checkMouse(e, TKLicenseDetailsTablePanel.this.infoTable);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                Point p = e.getPoint();
                int row = TKLicenseDetailsTablePanel.this.infoTable.rowAtPoint(p);
                if (row == 4) {
                    TKLicenseDetailsTablePanel.this.checkMouse(e, TKLicenseDetailsTablePanel.this.infoTable);
                }
            }
        });
        this.texteditor.getTextArea().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TKLogManager.writeToDebug("mousePressed");
                TKLicenseDetailsTablePanel.this.checkMouse(e, TKLicenseDetailsTablePanel.this.texteditor.getTextArea());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TKLogManager.writeToDebug("mouseReleased");
                TKLicenseDetailsTablePanel.this.checkMouse(e, TKLicenseDetailsTablePanel.this.texteditor.getTextArea());
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                TKLogManager.writeToDebug("mouseClicked");
                TKLicenseDetailsTablePanel.this.checkMouse(e, TKLicenseDetailsTablePanel.this.texteditor.getTextArea());
            }
        });
    }

    public void setLoadTablePanel(TKLicenseLoadTablePanel loadTablePanel) {
        this.loadTablePanel = loadTablePanel;
    }

    public void updateTableData(TKLicenseLoadDataStruct data) {
        this.data = data;
        if (null != this.infoTable.getCellEditor()) {
            this.infoTable.getCellEditor().stopCellEditing();
        }
        if (null == data) {
            this.infoTable.setValueAt("", 0, 1);
            this.infoTable.setValueAt("", 1, 1);
            TKGuageRenderer guageRen = (TKGuageRenderer)this.infoTable.getCellRenderer(2, 1);
            guageRen.setValue(0);
            this.infoTable.setValueAt("", 3, 1);
            this.infoTable.setValueAt("", 4, 1);
            this.licenseInfo.setText("");
        } else {
            this.neID = data.nedata.neID;
            this.setBasicInfo();
            this.infoTable.setValueAt(data.resultInfo, 4, 1);
            if (SwingUtilities.isEventDispatchThread()) {
                this.licenseInfo.setText(data.licenseContent);
                this.licenseInfo.setCaretPosition(0);
                this.licenseInfo.repaint();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TKLicenseDetailsTablePanel.this.licenseInfo.setText(TKLicenseDetailsTablePanel.this.data.licenseContent);
                        TKLicenseDetailsTablePanel.this.licenseInfo.setCaretPosition(0);
                        TKLicenseDetailsTablePanel.this.licenseInfo.repaint();
                    }
                });
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TKLicenseDetailsTablePanel.this.infoTable.repaint();
            }
        });
    }

    protected synchronized void updateObjectBasicInfo(TKLicenseLoadDataStruct data) {
        if (this.data == null || data == null) {
            return;
        }
        if (this.data.equals(data)) {
            this.setBasicInfo();
            this.infoTable.repaintRow(0, 3);
        }
    }

    private void setBasicInfo() {
        this.infoTable.setValueAt(this.data.nedata.neName, 0, 1);
        this.infoTable.setValueAt(this.data.loadFile, 1, 1);
        TKGuageRenderer guageRen = (TKGuageRenderer)this.infoTable.getCellRenderer(2, 1);
        if (this.data.guage <= 100) {
            guageRen.setValue(this.data.guage);
        } else {
            guageRen.setValue(0);
        }
        if ("".equals(this.data.startTime)) {
            this.infoTableModel.setValueAt(this.data.startTime, 3, 1);
        } else {
            this.infoTableModel.setValueAt(this.res.getString("StartTime:") + this.data.startTime + " ", 3, 1);
            if (!"".equals(this.data.endTime)) {
                this.infoTableModel.setValueAt(this.res.getString("StartTime:") + this.data.startTime + " " + "   " + this.res.getString("EndTime:") + this.data.endTime + " ", 3, 1);
            }
        }
    }

    protected synchronized void updateObjectResult(TKLicenseLoadDataStruct data) {
        if (this.data == null || data == null) {
            return;
        }
        if (this.data.equals(data)) {
            if (this.infoTable.getEditingRow() == 4 && this.infoTable.getCellEditor() != null) {
                this.infoTable.getCellEditor().stopCellEditing();
            }
            this.infoTableModel.setValueAt(data.resultInfo, 4, 1);
            if (SwingUtilities.isEventDispatchThread()) {
                this.infoTable.repaint();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TKLicenseDetailsTablePanel.this.infoTable.repaint();
                    }
                });
            }
        }
    }

    protected synchronized void updateObjectLicense(TKLicenseLoadDataStruct data) {
        if (this.data == null || data == null) {
            return;
        }
        if (this.data.equals(data)) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.licenseInfo.setText(data.licenseContent);
                this.licenseInfo.setCaretPosition(0);
                this.licenseInfo.repaint();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TKLicenseDetailsTablePanel.this.licenseInfo.setText(TKLicenseDetailsTablePanel.this.data.licenseContent);
                        TKLicenseDetailsTablePanel.this.licenseInfo.setCaretPosition(0);
                        TKLicenseDetailsTablePanel.this.licenseInfo.repaint();
                    }
                });
            }
        }
    }

    private JPopupMenu createPopMenu() {
        this.clearMenu = new JPopupMenu();
        this.clearMenuItem = new TKPopMenuItem();
        this.clearMenuItem.setText(this.res.getString("Clear"));
        this.clearMenu.add(this.clearMenuItem);
        this.clearMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKLicenseDetailsTablePanel.this.clearMenuItem_ActionPerformed();
            }
        });
        return this.clearMenu;
    }

    private void clearMenuItem_ActionPerformed() {
        this.texteditor.getTextArea().setText("");
        this.data.resultInfo = "";
        this.updateObjectResult(this.data);
    }

    private void checkMouse(MouseEvent e, Container con) {
        if (e.isPopupTrigger()) {
            int x = e.getX();
            int y = e.getY();
            Point point = TKScreenToolKit.getPopupMenuShowupPosition(con, this.clearMenu, x, y);
            this.clearMenu.show(con, (int)point.getX(), (int)point.getY());
            this.texteditor.getTextArea().updateUI();
            if (this.infoTable.getValueAt(4, 1).equals("")) {
                this.clearMenuItem.setEnabled(false);
            } else {
                this.clearMenuItem.setEnabled(true);
            }
        }
    }
}

