/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.base;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.xml.MenuItem;
import com.huawei.dc.toolkit.client.te.toolkit.TKConfigFactory;
import com.huawei.dc.toolkit.client.te.toolkit.TKMainRes;
import com.huawei.dc.toolkit.client.te.toolkit.action.TKAction;
import java.lang.reflect.Method;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class TKMenuItem
extends JMenuItem {
    private String id;
    private MenuItem info;

    public TKMenuItem(String id, MenuItem info) {
        super(TKMainRes.instance().getString(info.getText()));
        this.id = id;
        this.info = info;
        if (info.getMnemonic().trim().length() > 0) {
            this.setMnemonic(info.getMnemonic().trim().charAt(0));
        }
        if (info.getAccelerator().trim().length() > 0) {
            this.setAccelerator(KeyStroke.getKeyStroke(info.getAccelerator().trim().charAt(0), 8, true));
        }
        if (info.getVisible().trim().toLowerCase().equals("false")) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
        }
        try {
            if (info.getActiontype().trim().length() < 1 || info.getAction().trim().length() < 1) {
                return;
            }
            if (info.getActiontype().trim().toLowerCase().equals("class")) {
                Class<?> load = Class.forName(info.getAction());
                TKAction ac = (TKAction)load.newInstance();
                this.setAction(ac);
            } else {
                Method method = TKConfigFactory.class.getMethod(info.getAction(), null);
                Object retValue = method.invoke(null, null);
                if (retValue instanceof TKAction) {
                    TKAction action = (TKAction)retValue;
                    this.setAction(action);
                }
            }
            this.setText(TKMainRes.instance().getString(info.getText()));
            this.setIcon(TKResourceManager.getIcon(info.getIcon()));
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
    }

    public String getMenuItemID() {
        return this.id;
    }

    public MenuItem getMenuItemInfo() {
        return this.info;
    }
}

