/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit.base;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.te.toolkit.TKMainFrame;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKTreeNodeProp;
import com.huawei.dc.toolkit.client.te.toolkit.nemgr.TKTreePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public abstract class TKInternalFrame
extends JInternalFrame {
    JMenuItem windowItem = null;
    public boolean isMax = false;

    public TKInternalFrame() {
        try {
            this.init();
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    protected void init() {
        this.setResizable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setClosable(true);
        this.setVisible(true);
        this.setSelected(true);
        this.setDefaultCloseOperation(2);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (TKMainFrame.instance != null) {
            TKMainFrame.instance.menuBar.removeWindowItem(this.windowItem);
            TKMainFrame.instance.getRootPane().requestFocus();
        }
    }

    @Override
    public void setIcon(boolean b) {
        if (b) {
            this.isMax = false;
        }
        try {
            super.setIcon(b);
            if (TKMainFrame.instance != null) {
                TKMainFrame.instance.getRootPane().requestFocus();
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    @Override
    public void setMaximum(boolean b) {
        this.isMax = b;
        if (b) {
            boolean isNeedRevertLayout = this.isNeedRevertLayout();
            int height = this.getHeight();
            this.setSelected(true);
            this.setMyShape();
            if (height < 100 || isNeedRevertLayout) {
                this.revertLayout();
            }
            TKMainFrame.instance.setBoxContainerVisible(true);
            TKMainFrame.instance.setCurrentInternalFrame(this);
            TKMainFrame.instance.setTitleInfo(this.getTitle());
        }
    }

    public void setMyShape() {
        Insets insets = this.getInsets();
        this.setLocation(-insets.left, -this.getTitleHeight());
        Dimension dim = TKMainFrame.instance.getDeskSize();
        int w = dim.width + insets.left + insets.right;
        int h = dim.height + insets.bottom + this.getTitleHeight();
        this.setSize(w, h);
    }

    private int getTitleHeight() {
        int titleHeight = 0;
        BasicInternalFrameUI ui = (BasicInternalFrameUI)this.getUI();
        JComponent comp = ui.getNorthPane();
        if (comp != null) {
            Dimension dim = comp.getPreferredSize();
            Insets insets = this.getInsets();
            titleHeight = dim.height + insets.top;
        }
        return titleHeight;
    }

    @Override
    public void setSelected(boolean selected) {
        try {
            super.setSelected(selected);
            if (selected && TKMainFrame.instance != null) {
                TKMainFrame.instance.setCurrentInternalFrame(this);
            }
            if (null != this.windowItem && selected) {
                this.windowItem.setSelected(selected);
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    public void registryWindowMenuItem() {
        this.windowItem = new JCheckBoxMenuItem(this.getTitle());
        this.windowItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKInternalFrame.this.activateInternalFrame(e);
            }
        });
        TKMainFrame.instance.menuBar.addWindowItem(this.windowItem);
    }

    public void activateInternalFrame(ActionEvent e) {
        TKInternalFrame currentInternalFrame = TKMainFrame.instance.getCurrentInternalFrame();
        if (this.isIcon()) {
            this.setIcon(false);
        }
        if (currentInternalFrame.isMax && this.isMaximizable()) {
            this.setMaximum(true);
        }
        this.setSelected(true);
    }

    public abstract void refreshTableData(ArrayList var1);

    public void updateTableNEData(TKTreeNodeProp neNode) {
    }

    public abstract void deleteRowbyId(int var1, int var2);

    public abstract void doLoadInfoQuery(ArrayList var1);

    public TKTreePanel getObjectTreePanel() {
        return null;
    }

    public abstract void revertLayout();

    public abstract boolean isNeedRevertLayout();

    public abstract void registerCmd();

    @Override
    public Component getMostRecentFocusOwner() {
        if (this.getObjectTreePanel() == null) {
            return null;
        }
        return this.getObjectTreePanel().refreshBtn;
    }
}

