/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit;

import JACE.ASX.TimeValue;
import JACE.Reactor.EventHandler;
import JACE.Reactor.TimerQueue;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.communicate.TKCmdMSG;
import com.huawei.dc.toolkit.client.base.communicate.TKCommUtility;
import com.huawei.dc.toolkit.client.base.communicate.TKCommandResult;
import com.huawei.dc.toolkit.client.base.communicate.TKNoticeReceiver;
import com.huawei.dc.toolkit.client.base.util.TKCommonUtil;
import com.huawei.dc.toolkit.client.base.util.TKDebug;
import com.huawei.dc.toolkit.client.base.util.TKFtpStruct;
import com.huawei.dc.toolkit.client.base.util.TKLogManager;
import com.huawei.dc.toolkit.client.base.util.TKProfileFactory;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.component.TKOptionPane;
import com.huawei.dc.toolkit.client.base.util.help.TKHelpMgr;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultVector;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperationShowMgr;
import com.huawei.dc.toolkit.client.base.util.resource.TKErrorCodeRes;
import com.huawei.dc.toolkit.client.te.toolkit.TKConfigFactory;
import com.huawei.dc.toolkit.client.te.toolkit.TKMDIMainFrame;
import com.huawei.dc.toolkit.client.te.toolkit.TKMainDesktopPane;
import com.huawei.dc.toolkit.client.te.toolkit.TKMainReceiver;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKBoardStruct;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKInternalFrame;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKMenu;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKMenuBar;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKNeStruct;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKToolBar;
import com.huawei.dc.toolkit.client.te.toolkit.util.TKConfirmOperationDlg;
import com.huawei.dc.toolkit.control.TKCommNotifier;
import com.huawei.te.toolkit.AsnTkMessageRpt;
import com.huawei.te.toolkit.AsnToolkitBoardInfo;
import com.huawei.te.toolkit.AsnToolkitClientQueryCanCloseRsp;
import com.huawei.te.toolkit.AsnToolkitError;
import com.huawei.te.toolkit.AsnToolkitFtpServerInfo;
import com.huawei.te.toolkit.AsnToolkitGetFtpServerInfoRsp;
import com.huawei.te.toolkit.AsnToolkitGetNEListInfoReq;
import com.huawei.te.toolkit.AsnToolkitGetNEListInfoRsp;
import com.huawei.te.toolkit.AsnToolkitNEInfo;
import com.huawei.te.toolkit.AsnToolkitOperObjAndState;
import com.huawei.te.toolkit.AsnToolkitSetFtpServerInfoReq;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigInteger;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import javax.help.JHelp;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import net.commustru.fstru.FStruct;

public class TKMainFrame
extends TKMDIMainFrame
implements TKNoticeReceiver,
TKCommNotifier {
    private static TKRes res = TKRes.instance();
    private TKErrorCodeRes errorRes = TKErrorCodeRes.instance();
    private JPanel statusBarPanel = new JPanel();
    private JLabel statusInfoLabel1 = new JLabel();
    private JLabel statusInfoLabel2 = new JLabel();
    private JLabel systemTimeLabel = new JLabel();
    private JSplitPane jSplitPane1 = new JSplitPane();
    private JSplitPane jSplitPane2 = new JSplitPane();
    private JPanel loadTablePanel = null;
    private JPanel infoTablePanel = null;
    public TKMainDesktopPane desk = new TKMainDesktopPane();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private GridBagLayout gridBagLayout4 = new GridBagLayout();
    private GridBagLayout gridBagLayout5 = new GridBagLayout();
    private Icon selectIcon;
    private Icon unselectIcon;
    public TKInternalFrame currentInterFrame = null;
    public static TKMainFrame instance = null;
    public static String lastpath = "";
    public static TKFtpStruct lastFtpStruct = new TKFtpStruct("");
    private String statusInfoLabelText = "";
    public TKConfigFactory cfgFactory = new TKConfigFactory();
    public TKMenuBar menuBar = new TKMenuBar();
    public TKToolBar toolBar = new TKToolBar();
    private JLabel ftpStateLabel = new JLabel();
    private static final Icon ICON_FTPOK;
    private static final Icon ICON_FTPSTOP;
    private static final int FTP_SERV_STOP = 1;
    private static final int FTP_SERV_RUNNING = 0;
    private JPopupMenu popupMenu = null;
    private int timeShowerTimerId = -1;
    private Object timeShowerLock = new Object();
    private TimerQueue timerQueue;
    Calendar serverTime;
    JDialog dialogToLock = new JDialog(this);
    boolean isFTPSRunning = false;

    public TKMainFrame() {
        try {
            ToolTipManager.sharedInstance().setDismissDelay(15000);
            this.jbInit();
            this.addWindowListener(new WndCloser());
            String lp = TKProfileFactory.getBaseCfgString("option", "lastpath");
            if (lp != null && lp.trim().length() > 1) {
                lastpath = lp;
            }
            this.timerQueue = new TimerQueue(true);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    @Override
    public void notifyCommunication(boolean isConnected) {
        if (isConnected) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TKMainFrame.this.setStatusInfo1("ToolKit Server:" + TKCommUtility.comm.getServerAddress() + ":" + TKCommUtility.comm.getServerPort() + "-" + TKCommUtility.comm.getConnectID());
                    TKMainFrame.this.queryFTPState();
                    TKOptionPane.hideMutexOptionDialog();
                    TKMainFrame.this.updateTime();
                    new Thread(){

                        @Override
                        public void run() {
                            TKCommUtility.isTheSameVersion();
                        }
                    }.start();
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TKLogManager.writeToDebug("Exit.....?");
                    TKMainFrame.this.setFTPState(false);
                    TKMainFrame.this.setStatusInfo1("ToolKit Server:" + res.getString("Disconnected"));
                    TKLogManager.writeToDebug("Exit Toolkit Client System?");
                    int ret = TKOptionPane.showMutexOptionDialog(TKMainFrame.this, res.getString("ExitSystemHint"), res.getString("ConfirmExit"), 2);
                    if (ret == 0) {
                        TKMainFrame.this.dispose();
                        TKLogManager.writeToDebug("ToolKit Client exit.........");
                    }
                }
            });
        }
    }

    @Override
    public byte handleNotice(char cmdCode, TKCmdMSG data) {
        if (cmdCode == '\u1304') {
            AsnTkMessageRpt rptEvt = new AsnTkMessageRpt();
            boolean result = TKCommUtility.getASNData(data, (FStruct)rptEvt);
            if (!result) {
                TKDebug.inmAssert(false, "Decode Fail!");
                return 0;
            }
            this.processErrorMsg(rptEvt);
        }
        if (cmdCode == '\u1605') {
            TKLogManager.writeToDebug("HandleNotice: FTP Server stop.");
            this.setFTPState(false);
        }
        if (cmdCode == '\u1604') {
            TKLogManager.writeToDebug("HandleNotice: FTP Server started.");
            this.setFTPState(true);
        }
        return 1;
    }

    void processErrorMsg(AsnTkMessageRpt evtRpt) {
        Iterator errorItr = evtRpt.msgList.iterator();
        AsnToolkitError error = (AsnToolkitError)errorItr.next();
        String operReason = TKRes.getErrorInfo(error, evtRpt.msgType.intValue());
        TKOperationShowMgr.showOperationDlg((Component)this, TKRes.getResultInfo(evtRpt) + ":" + operReason, true);
    }

    public void initComm() {
        TKCommUtility.addCommunicationNotifier(this);
        TKCommUtility.init();
        if (TKCommUtility.refCount < 1) {
            TKOptionPane.showConfirmDialog((Component)this, (Object)res.getString("Comm_Fail"), res.getString("ConfirmExit"), -1);
            this.dispose();
        } else {
            TKMainReceiver mainReceiver = new TKMainReceiver();
            mainReceiver.initReceiver();
            TKCommUtility.comm.registerListener('\u1304', this);
            TKCommUtility.comm.registerListener('\u1605', this);
            TKCommUtility.comm.registerListener('\u1604', this);
        }
    }

    public void setStatusInfo1(final String strIP) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.statusInfoLabelText = strIP;
            this.statusInfoLabel1.setText(strIP);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TKMainFrame.this.statusInfoLabelText = strIP;
                    TKMainFrame.this.statusInfoLabel1.setText(strIP);
                }
            });
        }
    }

    public String getStatusInfo1() {
        return this.statusInfoLabelText;
    }

    public TKInternalFrame getInternalFrame() {
        this.currentInterFrame = this.getCurrentInternalFrame();
        return this.currentInterFrame;
    }

    public void updateTime() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = TKMainFrame.this.timeShowerLock;
                synchronized (object) {
                    if (TKMainFrame.this.timeShowerTimerId != -1) {
                        TKMainFrame.this.timerQueue.cancelTimer(TKMainFrame.this.timeShowerTimerId);
                    }
                    TimeShower timeShower = new TimeShower(TKCommUtility.serverTime);
                    TKMainFrame.this.timeShowerTimerId = TKMainFrame.this.timerQueue.scheduleTimer((EventHandler)timeShower, null, new TimeValue(1L), new TimeValue(1L));
                }
            }
        }.start();
    }

    public void setTitleInfo(String info) {
        String str = "";
        str = info.trim().length() > 1 ? res.getComInfoString("ProductName") + "-" + info : res.getComInfoString("ProductName");
        this.setTitle(str);
    }

    public Dimension getDeskSize() {
        int w = this.desk.getWidth();
        int h = this.desk.getHeight();
        return new Dimension(w, h);
    }

    public static ArrayList getDeviceListWillDelete(int operType, int funcId) {
        JFrame mainf = TKResourceManager.getMainFrame();
        ArrayList<TKNeStruct> neList = new ArrayList<TKNeStruct>();
        AsnToolkitGetNEListInfoReq req = new AsnToolkitGetNEListInfoReq();
        req.funcID = BigInteger.valueOf(funcId);
        req.isNeedBDList = operType == 12;
        AsnToolkitGetNEListInfoRsp rsp = new AsnToolkitGetNEListInfoRsp();
        char cmdCode = '\u0101';
        byte recvModule = 1;
        TKScreenToolKit.setComponentCursorBusy(mainf, true);
        TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, recvModule, 120);
        TKScreenToolKit.setComponentCursorBusy(mainf, false);
        if (!ret.isSuccess) {
            TKOperationShowMgr.showOperationDlg((Component)mainf, ret.resultInfo, false);
            return null;
        }
        Iterator neinfoItr = rsp.neInfoList.iterator();
        if (null != neinfoItr) {
            while (neinfoItr.hasNext()) {
                AsnToolkitNEInfo asnNeInfo = (AsnToolkitNEInfo)neinfoItr.next();
                TKNeStruct neData = new TKNeStruct();
                neData.neID = asnNeInfo.neID.intValue();
                neData.neType = new String(asnNeInfo.neType);
                neData.isLogin = asnNeInfo.isLogin;
                neData.isSupport = !asnNeInfo.isLogin ? 1 : asnNeInfo.isSupport.intValue();
                neData.isTL1NE = asnNeInfo.isTL1NE;
                if (neData.isTL1NE) {
                    neData.TID = new String(asnNeInfo.neName);
                }
                neData.neName = new String(asnNeInfo.neName);
                neData.gatewayType = asnNeInfo.neGNEType.intValue();
                if (neData.gatewayType == 1) {
                    neData.gatewayIP = new String(asnNeInfo.neAddress);
                    neData.ipPort = Integer.parseInt(new String(asnNeInfo.nePort));
                } else {
                    neData.tp4Address = new String(asnNeInfo.neAddress);
                    neData.tp4Port = new String(asnNeInfo.nePort);
                }
                if (null != asnNeInfo.boardList) {
                    for (AsnToolkitBoardInfo asnBd : asnNeInfo.boardList) {
                        TKBoardStruct board = new TKBoardStruct();
                        board.boardType = new String(asnBd.boardType);
                        board.slotID = asnBd.slotID.intValue();
                        neData.boardList.add(board);
                    }
                }
                neList.add(neData);
            }
        }
        Collections.sort(neList, new Comparator(){

            public int compare(Object o1, Object o2) {
                TKNeStruct data1 = (TKNeStruct)o1;
                TKNeStruct data2 = (TKNeStruct)o2;
                Collator collator = Collator.getInstance(Locale.getDefault());
                return collator.compare(data1.neName, data2.neName);
            }
        });
        return neList;
    }

    private void processInterFrame() {
        this.currentInterFrame = this.getCurrentInternalFrame();
        if (this.currentInterFrame != null) {
            Point loc = this.currentInterFrame.getLocation();
            Dimension dim = this.currentInterFrame.getSize();
            this.currentInterFrame.reshape(loc.x, loc.y, dim.width, dim.height);
        }
    }

    private void jbInit() throws Exception {
        this.selectIcon = TKResourceManager.getIcon("select.gif");
        this.unselectIcon = TKResourceManager.getIcon("unselect.gif");
        Icon logoFlag = TKResourceManager.getComIcon("logoflag.png");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TKMainFrame.this.processInterFrame();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JRootPane rootPane = TKMainFrame.this.getRootPane();
                if (rootPane.getGlassPane().isVisible()) {
                    return;
                }
                TKMainFrame.this.confirmExit();
            }
        });
        this.setTitle(res.getComInfoString("ProductName"));
        TKHelpMgr.instance().helpRootPane(this.getRootPane());
        TKHelpMgr.instance().helpComponent(this, "mainframe");
        this.ftpStateLabel.setForeground(Color.black);
        this.ftpStateLabel.setText(res.getString("FTPStateStop"));
        this.ftpStateLabel.setIcon(ICON_FTPSTOP);
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.statusInfoLabel1.setText(" ");
        this.statusInfoLabel2.setText(" ");
        this.systemTimeLabel.setHorizontalAlignment(0);
        this.systemTimeLabel.setText("                              ");
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BorderLayout());
        panel3.add((Component)this.statusInfoLabel1, "Center");
        panel3.setBorder(BorderFactory.createBevelBorder(1));
        this.statusInfoLabel1.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.statusInfoLabel2.setBorder(BorderFactory.createBevelBorder(1));
        this.systemTimeLabel.setBorder(BorderFactory.createBevelBorder(1));
        this.statusBarPanel.setLayout(this.gridBagLayout5);
        this.statusInfoLabel2.setHorizontalAlignment(0);
        this.statusInfoLabel2.setIcon(logoFlag);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)this.ftpStateLabel, "Center");
        panel2.setBorder(BorderFactory.createBevelBorder(1));
        this.ftpStateLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)panel3, "Center");
        panel.add((Component)panel2, "West");
        this.statusBarPanel.add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 150, 7));
        this.statusBarPanel.add((Component)this.systemTimeLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 50, 7));
        this.statusBarPanel.add((Component)this.statusInfoLabel2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 7));
        this.setJMenuBar(this.menuBar);
        this.getContentPane().add((Component)this.toolBar, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.desk, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 1, 0, 2), 264, 225));
        this.getContentPane().add((Component)this.statusBarPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 15, 2, new Insets(0, 1, 2, 2), 275, 2));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeiconified(WindowEvent e) {
                Component comp;
                if (TKMainFrame.this.popupMenu != null && !TKMainFrame.this.popupMenu.isShowing() && !((comp = TKMainFrame.this.popupMenu.getInvoker()) instanceof TKMenu)) {
                    TKMainFrame.this.popupMenu.setVisible(true);
                }
            }

            @Override
            public void windowIconified(WindowEvent e) {
                TKMainFrame.this.popupMenu = TKMainFrame.getLastPopup();
            }
        });
        this.dialogToLock.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 85) {
                    int shiftAndCtrl = 10;
                    if (e.getModifiers() == shiftAndCtrl) {
                        TKMainFrame.this.dialogToLock.setVisible(false);
                    }
                }
            }
        });
        this.dialogToLock.setDefaultCloseOperation(0);
        this.getRootPane().registerKeyboardAction(new FrameLockAction(), KeyStroke.getKeyStroke(76, 10, false), 1);
    }

    public static JPopupMenu getLastPopup() {
        MenuSelectionManager msm = MenuSelectionManager.defaultManager();
        MenuElement[] p = msm.getSelectedPath();
        JPopupMenu popup = null;
        for (int i = p.length - 1; popup == null && i >= 0; --i) {
            if (!(p[i] instanceof JPopupMenu)) continue;
            popup = (JPopupMenu)p[i];
        }
        return popup;
    }

    public void closeAllWindow() {
        JInternalFrame[] internalFrames = this.desk.getAllFrames();
        for (int i = 0; i < internalFrames.length; ++i) {
            JInternalFrame iframe = internalFrames[i];
            iframe.dispose();
        }
        this.desk.requestFocus();
        this.setBoxContainerVisible(false);
        this.setTitleInfo("");
    }

    public void confirmExit() {
        TKOperResultVector resultV = this.isHasWorking();
        if (resultV.size() != 0) {
            String dlgDesc = res.getString("HasWorkingInfo");
            TKConfirmOperationDlg confDlg = new TKConfirmOperationDlg(TKResourceManager.getMainFrame(), res.getString("Warning"), dlgDesc, resultV, true, true);
            confDlg.setDefaultCloseOperation(2);
            confDlg.hideDetailColumn();
            TKScreenToolKit.centerLocateToScreen(confDlg);
            int willContinue = confDlg.showDialog();
            if (willContinue == 1) {
                return;
            }
        } else {
            TKConfirmOperationDlg confDlg = new TKConfirmOperationDlg(TKResourceManager.getMainFrame(), res.getString("ConfirmExit"), res.getString("CfmExitInfo"), null, true, true);
            confDlg.setDefaultCloseOperation(2);
            int willContinue = confDlg.showDialog();
            if (willContinue == 1) {
                return;
            }
        }
        this.dispose();
        TKLogManager.writeToFile("Toolkit Exit!........");
        System.exit(0);
    }

    public void exitMenuItem_actionPerformed(ActionEvent e) {
        this.confirmExit();
    }

    @Override
    public void dispose() {
        JInternalFrame[] internalFrames = this.desk.getAllFrames();
        for (int i = 0; i < internalFrames.length; ++i) {
            internalFrames[i].dispose();
        }
        TKCommUtility.dispose();
        TKDebug.exInfoBackup();
        if (lastpath != null && lastpath.trim().length() > 1) {
            TKProfileFactory.saveCommonStringProperty("tkconfig.ini", "option", "lastpath", "value", lastpath);
        }
        TKProfileFactory.writeBackCommonFile();
        super.dispose();
    }

    public void invokeHelp(ActionEvent e) {
        TKDebug.inmAssert(null != this.getRootPane());
        TKHelpMgr.instance().helpRootPane(this.getRootPane());
        TKHelpMgr.instance().helpMenuItem(e);
    }

    public void queryFTPState() {
        Thread ftpThread = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean ftpState = false;
                boolean isReg = false;
                for (int i = 0; i < 10; ++i) {
                    boolean bl = isReg = TKCommUtility.comm.getRegisterState() == 1;
                    if (isReg) break;
                    try {
                        Thread.sleep(150L);
                        continue;
                    }
                    catch (Exception ex) {
                        ex.toString();
                    }
                }
                if (!isReg) {
                    TKLogManager.writeToDebug("Not query FTP Sever becuase of NOT REGISTERED");
                    return;
                }
                int timeout = 5;
                AsnToolkitSetFtpServerInfoReq req = new AsnToolkitSetFtpServerInfoReq();
                AsnToolkitFtpServerInfo ftpServerInfo = new AsnToolkitFtpServerInfo();
                ftpServerInfo.ftpIP = "".getBytes();
                ftpServerInfo.ftpPort = BigInteger.valueOf(0L);
                ftpServerInfo.userName = "".getBytes();
                ftpServerInfo.userPwd = "".getBytes();
                ftpServerInfo.rootDir = "".getBytes();
                req.ftpServerInfo = ftpServerInfo;
                AsnToolkitGetFtpServerInfoRsp rsp = new AsnToolkitGetFtpServerInfoRsp();
                char cmdCode = '\u1601';
                byte receiveModule = 22;
                boolean needWaitQry = false;
                for (int i = 0; i < 6; ++i) {
                    if (needWaitQry) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(10000L);
                        }
                        catch (Exception ex) {
                            ex.toString();
                        }
                    }
                    needWaitQry = true;
                    TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, receiveModule, timeout);
                    ftpState = TKMainFrame.this.getFTPState();
                    if (!ret.isSuccess) {
                        if (!ftpState) continue;
                        break;
                    }
                    if (rsp == null || rsp.tkFtpServState == null) break;
                    ftpState = rsp.tkFtpServState.intValue() == 0;
                    break;
                }
                TKMainFrame.this.setFTPState(ftpState);
                TKLogManager.writeToDebug("Is FTP Server running:" + ftpState);
            }
        });
        ftpThread.start();
    }

    public void setFTPState(boolean isStart) {
        this.isFTPSRunning = isStart;
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.isFTPSRunning) {
                this.ftpStateLabel.setText(res.getString("FTPStateStart"));
                this.ftpStateLabel.setIcon(ICON_FTPOK);
            } else {
                this.ftpStateLabel.setText(res.getString("FTPStateStop"));
                this.ftpStateLabel.setIcon(ICON_FTPSTOP);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (TKMainFrame.this.isFTPSRunning) {
                        TKMainFrame.this.ftpStateLabel.setText(res.getString("FTPStateStart"));
                        TKMainFrame.this.ftpStateLabel.setIcon(ICON_FTPOK);
                    } else {
                        TKMainFrame.this.ftpStateLabel.setText(res.getString("FTPStateStop"));
                        TKMainFrame.this.ftpStateLabel.setIcon(ICON_FTPSTOP);
                    }
                }
            });
        }
    }

    public boolean getFTPState() {
        return this.isFTPSRunning;
    }

    public static int getTitleHeight() {
        return 35;
    }

    public TKOperResultVector isHasWorking() {
        TKOperResultVector resultV = new TKOperResultVector();
        AsnToolkitClientQueryCanCloseRsp rsp = new AsnToolkitClientQueryCanCloseRsp();
        char cmdCode = '\u0110';
        byte receiveModule = 1;
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), true);
        TKCommandResult ret = TKCommUtility.sendCommand(null, (FStruct)rsp, cmdCode, receiveModule, 120);
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), false);
        if (!ret.isSuccess) {
            return resultV;
        }
        if (rsp.canExit) {
            return resultV;
        }
        Iterator loadInfoItr = rsp.objAndOperList.iterator();
        if (null != loadInfoItr) {
            while (loadInfoItr.hasNext()) {
                AsnToolkitOperObjAndState operObjAndState = (AsnToolkitOperObjAndState)loadInfoItr.next();
                String neName = new String(operObjAndState.neName);
                String operResult = neName + "  " + res.getString(operObjAndState.moduleID.toString());
                resultV.addElement(operResult);
            }
        }
        return resultV;
    }

    public void isSameVersion() {
        String hintInformation = TKCommUtility.getServerVersion();
        if (!"".equals(hintInformation)) {
            TKOptionPane.showConfirmDialog((Component)this, (Object)hintInformation, res.getString("ConfirmExit"), -1);
            this.dispose();
        }
    }

    static {
        TKMainFrame.lastFtpStruct.ftpPort = 21;
        ICON_FTPOK = TKResourceManager.getIcon("ftpok.gif");
        ICON_FTPSTOP = TKResourceManager.getIcon("ftpstop.gif");
    }

    private class FrameLockAction
    implements ActionListener {
        private FrameLockAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TKMainFrame.this.dialogToLock.isDisplayable()) {
                JPanel panel = new JPanel(new BorderLayout());
                JLabel label_1 = new JLabel(TKResourceManager.getComIcon("logo.gif"));
                JLabel label_2 = new JLabel(TKResourceManager.getComIcon("tkabout.jpg"));
                label_1.setText(res.getString("LockInfo"));
                panel.add((Component)label_2, "North");
                panel.add((Component)label_1, "Center");
                panel.setOpaque(true);
                TKMainFrame.this.dialogToLock.setContentPane(panel);
                TKMainFrame.this.dialogToLock.setTitle("OptiX Toolkit");
                TKMainFrame.this.dialogToLock.setModal(true);
                TKMainFrame.this.dialogToLock.setSize(420, 230);
                TKMainFrame.this.dialogToLock.setResizable(false);
            }
            TKScreenToolKit.centerLocateToScreen(TKMainFrame.this.dialogToLock);
            TKMainFrame.this.dialogToLock.toFront();
            TKMainFrame.this.dialogToLock.setVisible(true);
        }
    }

    class TimeShower
    implements EventHandler {
        Calendar calendar = null;

        public TimeShower(Calendar calendar) {
            this.calendar = calendar;
        }

        public int handleTimeout(TimeValue tv, Object obj) {
            this.calendar.add(13, 1);
            TKMainFrame.this.systemTimeLabel.setText(TKCommonUtil.convertCalendarToStr(this.calendar, (byte)3));
            return 0;
        }
    }

    class WndCloser
    extends WindowAdapter {
        WndCloser() {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            Frame[] frames = instance.getFrames();
            for (int k = 0; k < frames.length; ++k) {
                Component c;
                JFrame jf;
                if (!(frames[k] instanceof JFrame) || (jf = (JFrame)frames[k]).getContentPane().getComponentCount() == 0 || (c = jf.getContentPane().getComponent(0)) == null || !(c instanceof JHelp)) continue;
                jf.setIconImage(((ImageIcon)TKResourceManager.getMainIcon()).getImage());
                jf.setTitle(res.getComInfoString("HelpTitle"));
            }
        }
    }
}

