/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.te.toolkit;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.TKUIStyleManager;
import com.huawei.dc.toolkit.client.te.toolkit.TKMainFrame;
import com.huawei.dc.toolkit.client.te.toolkit.base.TKInternalFrame;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class TKMDIMainFrame
extends JFrame {
    private TKRes res = TKRes.instance();
    public TKInternalFrame currentInternalFrame = null;
    private static final int ORIGINAL_WIDTH = 600;
    private static final int ORIGINAL_HEIGHT = 500;
    private static final int X_OFF = 24;
    private static final int Y_OFF = 4;
    private static final int BOXWIDTH = 21;
    private static final int BOXHEIGHT = 20;
    private static final int GAP = 2;
    static final int X_INCREMENT = 25;
    static final int Y_INCREMENT = 25;
    static final double ORIGINAL_HEIGHT_PORTION = 0.8;
    static final double ORIGINAL_WIDTH_PORTION = 0.8;
    static final int GAP_TO_BOUNDS = 5;
    boolean frameSizeAdjusted = false;
    private Icon maxIcon;
    private Icon iconIcon;
    private Icon closeIcon;
    private JButton maxBtn;
    private JButton closeBtn;
    private JButton iconBtn;
    private JPanel boxContainer = new JPanel(null);

    public TKMDIMainFrame() {
        this.getContentPane().setLayout(null);
        this.setSize(600, 500);
        this.setVisible(false);
        ImageIcon frameIcon = (ImageIcon)TKResourceManager.getMainIcon();
        this.setIconImage(frameIcon.getImage());
        this.initBoxContainer();
        SymComponentAdapter aSymComponent = new SymComponentAdapter();
        this.addComponentListener(aSymComponent);
    }

    private void initBoxContainer() {
        String sUIStyle = TKUIStyleManager.getUIStyle();
        if (sUIStyle.equals("Metal") || sUIStyle.equals("Huawei")) {
            this.maxIcon = TKResourceManager.getIcon("metalrestore.gif");
            this.iconIcon = TKResourceManager.getIcon("metalmin.gif");
            this.closeIcon = TKResourceManager.getIcon("metalclose.gif");
        } else if (sUIStyle.equals("Windows")) {
            this.maxIcon = TKResourceManager.getIcon("windowrestore.gif");
            this.iconIcon = TKResourceManager.getIcon("windowmin.gif");
            this.closeIcon = TKResourceManager.getIcon("windowclose.gif");
        } else if (sUIStyle.equals("Motif")) {
            this.maxIcon = TKResourceManager.getIcon("motifrestore.gif");
            this.iconIcon = TKResourceManager.getIcon("motifmin.gif");
            this.closeIcon = TKResourceManager.getIcon("motifclose.gif");
        }
        SymAction lSymAction = new SymAction();
        EmptyBorder handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
        this.iconBtn = new NoFocusButton(this.iconIcon);
        this.iconBtn.putClientProperty("paintActive", Boolean.TRUE);
        this.iconBtn.setBorder(handyEmptyBorder);
        this.iconBtn.setOpaque(false);
        this.iconBtn.setFocusPainted(false);
        this.iconBtn.addActionListener(lSymAction);
        this.iconBtn.setActionCommand("Iconify");
        this.iconBtn.getAccessibleContext().setAccessibleName("Iconify");
        this.maxBtn = new NoFocusButton(this.maxIcon);
        this.maxBtn.putClientProperty("paintActive", Boolean.TRUE);
        this.maxBtn.setOpaque(false);
        this.maxBtn.setFocusPainted(false);
        this.maxBtn.setBorder(handyEmptyBorder);
        this.maxBtn.addActionListener(lSymAction);
        this.maxBtn.setActionCommand("Maximize");
        this.maxBtn.getAccessibleContext().setAccessibleName("Maximize");
        this.closeBtn = new NoFocusButton(this.closeIcon);
        this.closeBtn.putClientProperty("paintActive", Boolean.TRUE);
        this.closeBtn.setBorder(handyEmptyBorder);
        this.closeBtn.setOpaque(false);
        this.closeBtn.setFocusPainted(false);
        this.closeBtn.addActionListener(lSymAction);
        this.closeBtn.setActionCommand("Close");
        this.closeBtn.getAccessibleContext().setAccessibleName("Close");
        this.boxContainer.add(this.iconBtn);
        this.iconBtn.setBounds(0, 0, 21, 20);
        this.boxContainer.add(this.maxBtn);
        this.maxBtn.setBounds(21, 0, 21, 20);
        this.boxContainer.add(this.closeBtn);
        this.closeBtn.setBounds(44, 0, 21, 20);
        this.getLayeredPane().add(this.boxContainer, JLayeredPane.PALETTE_LAYER, 0);
        this.boxContainer.setBounds(this.getWidth() - 65 - 24, 4, 65, 20);
        this.boxContainer.setVisible(false);
    }

    public TKMDIMainFrame(String sTitle) {
        this();
        this.setTitle(sTitle);
    }

    @Override
    public void setVisible(boolean b) {
        DCDebugTracer.trace("TKMDIMainFrame setVisible");
        super.setVisible(b);
    }

    public void moveCoolbar() {
        if (null != this.boxContainer) {
            this.boxContainer.setLocation(this.getWidth() - 51 - 24, 4);
        }
    }

    void updateCoolbar(TKInternalFrame _currentInternalFrame) {
        this.boxContainer.setVisible(_currentInternalFrame.isMax);
        if (_currentInternalFrame.isMax) {
            _currentInternalFrame.setMyShape();
        }
        this.closeBtn.setEnabled(true);
        this.iconBtn.setEnabled(true);
    }

    public void setCurrentInternalFrame(TKInternalFrame internalFrame) {
        this.currentInternalFrame = internalFrame;
        EventListener[] lis = this.currentInternalFrame.getListeners(InternalFrameListener.class);
        for (int i = 0; i < lis.length; ++i) {
            this.currentInternalFrame.removeInternalFrameListener((InternalFrameListener)lis[i]);
        }
        this.currentInternalFrame.addInternalFrameListener(new TKInternalFrameListener());
        this.updateCoolbar(internalFrame);
    }

    public TKInternalFrame getCurrentInternalFrame() {
        return this.currentInternalFrame;
    }

    public synchronized void setBoxContainerVisible(boolean bVisible) {
        this.boxContainer.setVisible(bVisible);
    }

    void resizeChildForm() {
        if (this.boxContainer.isVisible() && this.currentInternalFrame != null) {
            this.currentInternalFrame.setMaximum(true);
        }
    }

    @Override
    public void setLocation(int mx, int my) {
        super.setLocation(mx, my);
        this.moveCoolbar();
    }

    public void cascadeInternalFrames() {
        int posX = 5;
        int posY = 5;
        int desktopPaneWidth = TKMainFrame.instance.desk.getWidth();
        int desktopPaneHeight = TKMainFrame.instance.desk.getHeight();
        JInternalFrame[] internalFrames = TKMainFrame.instance.desk.getAllFrames();
        Vector<TKInternalFrame> internalFramesIn = new Vector<TKInternalFrame>();
        TKInternalFrame tempFrame = null;
        for (int i = 0; i < internalFrames.length; ++i) {
            tempFrame = (TKInternalFrame)internalFrames[i];
            tempFrame.setMaximum(false);
            internalFramesIn.add(tempFrame);
        }
        TKInternalFrame tempFrameIn = null;
        for (int i = internalFramesIn.size() - 1; i >= 0; --i) {
            tempFrameIn = (TKInternalFrame)internalFramesIn.elementAt(i);
            int internalFrameWidth = (int)((double)desktopPaneWidth * 0.8);
            int internalFrameHeight = (int)((double)desktopPaneHeight * 0.8);
            tempFrameIn.setBounds(posX, posY, internalFrameWidth, internalFrameHeight);
            if ((posX += 25) + internalFrameWidth > desktopPaneWidth - 5 || (posY += 25) + internalFrameHeight > desktopPaneHeight - 5) {
                posX = 5;
                posY = 5;
            }
            tempFrameIn.setSelected(false);
        }
        if (null != tempFrameIn) {
            tempFrameIn.setSelected(true);
        }
        this.currentInternalFrame = tempFrameIn;
    }

    @Override
    public void addNotify() {
        Dimension size = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        JMenuBar menuBar = this.getRootPane().getJMenuBar();
        int menuBarHeight = 0;
        if (menuBar != null) {
            menuBarHeight = menuBar.getPreferredSize().height;
        }
        this.setSize(insets.left + insets.right + size.width, insets.top + insets.bottom + size.height + menuBarHeight);
    }

    void iconButton_actionPerformed(ActionEvent event) {
        TKMainFrame.instance.setTitleInfo("");
        try {
            this.cascadeInternalFrames();
            this.currentInternalFrame.setIcon(true);
            this.boxContainer.setVisible(false);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    void closeButton_actionPerformed(ActionEvent event) {
        this.currentInternalFrame.doDefaultCloseAction();
    }

    void maxButton_actionPerformed(ActionEvent event) {
        TKMainFrame.instance.setTitleInfo("");
        try {
            this.cascadeInternalFrames();
            this.boxContainer.setVisible(false);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    void TKMDIMainFrame_componentResized(ComponentEvent event) {
        this.moveCoolbar();
        this.resizeChildForm();
    }

    void TKMDIMainFrame_componentMoved(ComponentEvent event) {
        this.moveCoolbar();
    }

    private class TKInternalFrameListener
    implements InternalFrameListener {
        @Override
        public void internalFrameActivated(InternalFrameEvent e) {
        }

        @Override
        public void internalFrameDeactivated(InternalFrameEvent e) {
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent e) {
            JInternalFrame[] frames = TKMainFrame.instance.desk.getAllFrames();
            int count = frames.length;
            TKMainFrame.instance.setTitleInfo("");
            if (count < 1) {
                TKMDIMainFrame.this.boxContainer.setVisible(false);
            } else {
                TKMDIMainFrame.this.currentInternalFrame = (TKInternalFrame)frames[0];
                TKMDIMainFrame.this.currentInternalFrame.setSelected(true);
                if (!TKMDIMainFrame.this.currentInternalFrame.isMax) {
                    TKMDIMainFrame.this.boxContainer.setVisible(false);
                } else {
                    TKMainFrame.instance.setTitleInfo(TKMDIMainFrame.this.currentInternalFrame.getTitle());
                }
            }
        }

        @Override
        public void internalFrameDeiconified(InternalFrameEvent e) {
        }

        @Override
        public void internalFrameIconified(InternalFrameEvent e) {
        }

        @Override
        public void internalFrameOpened(InternalFrameEvent e) {
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent e) {
        }
    }

    private static class NoFocusButton
    extends JButton {
        public NoFocusButton(Icon icon) {
            super(icon);
            this.setFocusPainted(false);
        }

        public NoFocusButton() {
            this.setFocusPainted(false);
        }

        @Override
        public boolean isFocusable() {
            return false;
        }

        @Override
        public void requestFocus() {
        }

        @Override
        public boolean isOpaque() {
            return false;
        }

        @Override
        public boolean isContentAreaFilled() {
            return false;
        }
    }

    class SymComponentAdapter
    extends ComponentAdapter {
        SymComponentAdapter() {
        }

        @Override
        public void componentMoved(ComponentEvent event) {
            Object object = event.getSource();
            if (object == TKMDIMainFrame.this) {
                TKMDIMainFrame.this.TKMDIMainFrame_componentMoved(event);
            }
        }

        @Override
        public void componentResized(ComponentEvent event) {
            Object object = event.getSource();
            if (object == TKMDIMainFrame.this) {
                TKMDIMainFrame.this.TKMDIMainFrame_componentResized(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == TKMDIMainFrame.this.iconBtn) {
                TKMDIMainFrame.this.iconButton_actionPerformed(event);
            } else if (object == TKMDIMainFrame.this.closeBtn) {
                TKMDIMainFrame.this.closeButton_actionPerformed(event);
            } else if (object == TKMDIMainFrame.this.maxBtn) {
                TKMDIMainFrame.this.maxButton_actionPerformed(event);
            }
        }
    }
}

