/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.treetable;

import com.huawei.dc.toolkit.client.base.util.TKLogManager;
import com.huawei.dc.toolkit.client.base.util.component.TKTableUI;
import com.huawei.dc.toolkit.client.base.util.treetable.TKTreeRowEntry;
import com.huawei.dc.toolkit.client.base.util.treetable.TKTreeTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TKTreeTableUI
extends TKTableUI {
    public static final Icon blank_icon = new Icon(){

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 0;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }
    };
    static final int headCellSpace = 4;
    static final int tailCellSpace = 1;
    static final int cellSpace = 8;
    static final transient int NodeIconHeight = 10;
    static final transient int NodeIconWidth = 10;
    static final int nodeCellSpace = 15;
    private TKTreeTable tabletree;
    private ArrayList iconLocations = new ArrayList();

    public static ComponentUI createUI(JComponent c) {
        return new TKTreeTableUI();
    }

    protected void installDefaults() {
        this.tabletree = (TKTreeTable)this.table;
        this.tabletree.addMouseListener(this.createMouseListener());
        super.installDefaults();
    }

    public void paint(Graphics graph, JComponent container) {
        this.iconLocations.clear();
        if (this.tabletree.getRowCount() <= 0 || this.tabletree.getColumnCount() <= 0) {
            return;
        }
        Rectangle rect = graph.getClipBounds();
        Point topLeft = rect.getLocation();
        Point bottomRgt = new Point(rect.x + rect.width - 1, rect.y + rect.height - 1);
        int indextopLeft = this.tabletree.rowAtPoint(topLeft);
        int indexBottomRgt = this.tabletree.rowAtPoint(bottomRgt);
        indextopLeft = indextopLeft == -1 ? 0 : indextopLeft;
        indexBottomRgt = indexBottomRgt == -1 ? this.tabletree.getRowCount() - 1 : indexBottomRgt;
        boolean isLeftToRight = this.tabletree.getComponentOrientation().isLeftToRight();
        int indexMin = this.tabletree.columnAtPoint(isLeftToRight ? topLeft : bottomRgt);
        int indexMax = this.tabletree.columnAtPoint(isLeftToRight ? bottomRgt : topLeft);
        indexMin = indexMin == -1 ? 0 : indexMin;
        indexMax = indexMax == -1 ? this.tabletree.getColumnCount() - 1 : indexMax;
        this.paintGrid(graph, indextopLeft, indexBottomRgt, indexMin, indexMax);
        this.paintCells(graph, indextopLeft, indexBottomRgt, indexMin, indexMax);
    }

    private void paintCells(Graphics graph, int intRowLow, int intRowHigh, int intColLow, int intColHigh) {
        if (this.tabletree.getComponentOrientation().isLeftToRight()) {
            this.paintCellsLR(graph, intRowLow, intRowHigh, intColLow, intColHigh);
        } else {
            this.paintCellsRL(graph, intRowLow, intRowHigh, intColLow, intColHigh);
        }
    }

    private void paintCellsLR(Graphics graph, int intRowLow, int intRowHigh, int intColLow, int intColHigh) {
        TableColumnModel cm = this.tabletree.getColumnModel();
        JTableHeader header = this.tabletree.getTableHeader();
        int columnMargin = cm.getColumnMargin();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        for (int row = intRowLow; row <= intRowHigh; ++row) {
            Rectangle cellRect = this.tabletree.getCellRect(row, intColLow, false);
            if (null != ((TKTreeTable)this.table).getRow(row)) {
                TableColumn aColumn;
                int column;
                int columnWidth;
                TKTreeRowEntry rowEntry = ((TKTreeTable)this.table).getRow(row);
                if (rowEntry.mixColumns()) {
                    columnWidth = 0;
                    for (column = 0; column <= intColHigh; ++column) {
                        aColumn = cm.getColumn(column);
                        columnWidth += aColumn.getWidth();
                    }
                    int minMixClomun = rowEntry.minMixColumn();
                    if (minMixClomun > 0) {
                        for (int column2 = intColLow; column2 < minMixClomun; ++column2) {
                            TableCellRenderer renderer = this.tabletree.getDefaultRenderer(this.tabletree.getColumnClass(column2));
                            Component component = this.tabletree.prepareRenderer(renderer, row, column2);
                            Rectangle cellRectTemp = this.tabletree.getCellRect(row, column2, false);
                            this.rendererPane.paintComponent(graph, component, this.tabletree, cellRectTemp.x, cellRectTemp.y, cellRectTemp.width, cellRectTemp.height, true);
                        }
                        cellRect = this.tabletree.getCellRect(row, minMixClomun, false);
                    } else {
                        minMixClomun = 0;
                        cellRect.x = 0;
                    }
                    cellRect.width = columnWidth - columnMargin;
                    this.paintCell(graph, cellRect, row, minMixClomun);
                    continue;
                }
                for (column = intColLow; column <= intColHigh; ++column) {
                    aColumn = cm.getColumn(column);
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    if (aColumn != draggedColumn) {
                        this.paintCell(graph, cellRect, row, column);
                    }
                    cellRect.x += columnWidth;
                }
                continue;
            }
            TKLogManager.writeToDebug("paintCells() of TKTreeTableUI get ((TKTreeTable)table).getRow(row) is null");
            return;
        }
        this.rendererPane.removeAll();
    }

    private void paintCellsRL(Graphics graph, int intRowLow, int intRowHigh, int intColLow, int intColHigh) {
        JTableHeader header = this.tabletree.getTableHeader();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        TableColumnModel cm = this.tabletree.getColumnModel();
        int columnMargin = cm.getColumnMargin();
        for (int row = 0; row <= intRowHigh; ++row) {
            int colWidth;
            if (intRowLow > row) continue;
            Rectangle oCellRect = this.tabletree.getCellRect(row, intColLow, false);
            TableColumn aColumn = cm.getColumn(intColLow);
            if (aColumn != draggedColumn) {
                colWidth = aColumn.getWidth();
                oCellRect.width = colWidth - columnMargin;
                this.paintCell(graph, oCellRect, row, intColLow);
            }
            for (int col = intColLow + 1; col <= intColHigh; ++col) {
                aColumn = cm.getColumn(col);
                colWidth = aColumn.getWidth();
                oCellRect.width = colWidth - columnMargin;
                oCellRect.x -= colWidth;
                if (aColumn == draggedColumn) continue;
                this.paintCell(graph, oCellRect, row, col);
            }
        }
        this.rendererPane.removeAll();
    }

    private void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        g.setColor(this.tabletree.getGridColor());
        Rectangle minCell = this.tabletree.getCellRect(rMin, cMin, true);
        Rectangle maxCell = this.tabletree.getCellRect(rMax, cMax, true);
        Rectangle damagedArea = minCell.union(maxCell);
        if (this.tabletree.getShowHorizontalLines()) {
            int tableWidth = damagedArea.x + damagedArea.width;
            int y = damagedArea.y;
            for (int row = 0; row <= rMax; ++row) {
                if (rMin > row) continue;
                g.drawLine(damagedArea.x, (y += this.tabletree.getRowHeight(row)) - 1, tableWidth - 1, y - 1);
            }
        }
        if (this.tabletree.getShowVerticalLines()) {
            this.paintVerticalLine(g, rMin, rMax, cMin, cMax);
        }
    }

    private void paintVerticalLine(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        g.setColor(this.tabletree.getGridColor());
        TableColumnModel cm = this.tabletree.getColumnModel();
        for (int row = 0; row <= rMax; ++row) {
            int width;
            int column;
            int xLocation;
            if (rMin > row || row % 2 == 0) continue;
            Rectangle damagedArea = this.tabletree.getCellRect(row, cMin, true);
            int tableHeight = damagedArea.y + damagedArea.height;
            if (this.tabletree.getComponentOrientation().isLeftToRight()) {
                xLocation = damagedArea.x;
                for (column = cMin; column <= cMax; ++column) {
                    width = cm.getColumn(column).getWidth();
                    g.drawLine((xLocation += width) - 1, 0, xLocation - 1, tableHeight - 1);
                }
                continue;
            }
            xLocation = damagedArea.x + damagedArea.width;
            for (column = cMin; column < cMax; ++column) {
                width = cm.getColumn(column).getWidth();
                g.drawLine((xLocation -= width) - 1, 0, xLocation - 1, tableHeight - 1);
            }
            g.drawLine(xLocation -= cm.getColumn(cMax).getWidth(), 0, xLocation, tableHeight - 1);
        }
    }

    private void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
        if (this.tabletree.isEditing() && this.tabletree.getEditingRow() == row && this.tabletree.getEditingColumn() == column) {
            Component component = this.tabletree.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        } else {
            TableCellRenderer renderer = this.tabletree.getCellRenderer(row, column);
            Component component = this.tabletree.prepareRenderer(renderer, row, column);
            TKTreeRowEntry rowEntry = ((TKTreeTable)this.table).getRow(row);
            if (column == 0 && rowEntry.paintIcon()) {
                Icon icon = this.getIconForRow(row);
                this.rendererPane.paintComponent(g, component, this.tabletree, cellRect.x + icon.getIconWidth() + 1, cellRect.y, cellRect.width - icon.getIconWidth(), cellRect.height, true);
                icon.paintIcon(this.tabletree, g, cellRect.x, cellRect.y);
            } else {
                this.rendererPane.paintComponent(g, component, this.tabletree, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
            }
        }
    }

    private int rowAtExpandControlWithPonit(int x, int y) {
        int row = this.tabletree.rowAtPoint(new Point(x, y));
        for (int i = 0; i < this.iconLocations.size(); ++i) {
            Point point = (Point)this.iconLocations.get(i);
            int row1 = this.tabletree.rowAtPoint(point);
            int xWrap = x - point.x;
            int yWrap = y - point.y;
            if (row1 != row || 0 > xWrap) continue;
            if (xWrap > 10 || 0 > yWrap) continue;
            if (yWrap > 10) continue;
            return row;
        }
        return -1;
    }

    private Shape getTextShape(Graphics2D g2d, String str, Font font) {
        FontRenderContext frc = g2d.getFontRenderContext();
        TextLayout tl = new TextLayout(str, font, frc);
        return tl.getOutline(null);
    }

    private int getTextWidth(Graphics2D g2d, String str, Font font) {
        return this.getTextShape((Graphics2D)g2d, (String)str, (Font)font).getBounds().width;
    }

    private Icon getIconForRow(int row) {
        Icon ctrlIcon = blank_icon;
        Icon styleIcon = this.tabletree.getIcon(row);
        TKTreeRowEntry rowEntry = this.tabletree.getRow(row);
        if (rowEntry != null && this.tabletree.isShowControlIcon()) {
            String text = this.tabletree.getTextForIcon(row);
            if (rowEntry.getRowType() == 16) {
                ctrlIcon = new ControlIcon(text, 0);
            } else {
                int rowState = rowEntry.getRowState();
                ctrlIcon = new ControlIcon(text, rowState);
                if (rowEntry.getChildCount() == 0) {
                    ctrlIcon = new ControlIcon(text, 0);
                }
            }
        }
        if (styleIcon == null || styleIcon.getIconWidth() <= 0 || styleIcon.getIconHeight() <= 0) {
            styleIcon = UIManager.getIcon("Tree.leafIcon");
            if (rowEntry != null && rowEntry.getChildCount() > 0) {
                styleIcon = UIManager.getIcon("Tree.closedIcon");
                if (rowEntry.getRowState() == 1) {
                    styleIcon = UIManager.getIcon("Tree.openIcon");
                }
            }
        }
        int columnWidth = this.tabletree.getColumnModel().getColumn(0).getWidth();
        if (null != rowEntry && rowEntry.mixColumns()) {
            columnWidth = -1;
        }
        NodeIcon icon3 = new NodeIcon(ctrlIcon, styleIcon, TKTreeTable.getDepth(rowEntry), columnWidth);
        return icon3;
    }

    protected MouseListener createMouseListener() {
        return new TKMouseHandler();
    }

    public class NodeIcon
    implements Icon {
        Icon nodeIcon = null;
        Icon expandIcon = null;
        int depth = 0;
        int actualWidth = -1;

        public NodeIcon(Icon nodeIcon, Icon expandIcon, int depth, int actualWidth) {
            this.nodeIcon = nodeIcon;
            this.expandIcon = expandIcon;
            this.depth = depth;
            this.actualWidth = actualWidth;
        }

        public NodeIcon(Icon nodeIcon, Icon expandIcon, int depth) {
            this.nodeIcon = nodeIcon;
            this.expandIcon = expandIcon;
            this.depth = depth;
        }

        public NodeIcon(Icon nodeIcon, Icon expandIcon) {
            this.nodeIcon = nodeIcon;
            this.expandIcon = expandIcon;
        }

        public void setDepth(int depth) {
            this.depth = depth;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int x1 = x + this.depth * 15 + 4;
            int x2 = x1 + this.nodeIcon.getIconWidth() + 8;
            if (!TKTreeTableUI.this.tabletree.isShowControlIcon()) {
                x2 = x1 = x + this.depth * 15;
            }
            int y1 = (this.expandIcon.getIconHeight() - this.nodeIcon.getIconHeight()) / 2;
            this.nodeIcon.paintIcon(c, g, x1, y + y1);
            this.expandIcon.paintIcon(c, g, x2, y);
            if (this.actualWidth >= 0 && this.actualWidth < this.getIconWidth()) {
                g.setColor(TKTreeTableUI.this.tabletree.getBackground());
                g.fillRect(x + this.actualWidth, y, this.getIconWidth() - this.actualWidth, TKTreeTableUI.this.tabletree.getRowHeight() - 1);
            }
        }

        public void setIconColumnWidth(int width) {
            this.actualWidth = width;
        }

        @Override
        public int getIconWidth() {
            int w = this.nodeIcon.getIconWidth() + this.depth * 15 + 4 + 8 + this.expandIcon.getIconWidth();
            if (!TKTreeTableUI.this.tabletree.isShowControlIcon()) {
                w = this.depth * 15 + this.expandIcon.getIconWidth();
            }
            return w;
        }

        @Override
        public int getIconHeight() {
            return this.nodeIcon.getIconHeight();
        }
    }

    public class ControlIcon
    implements Icon {
        private int type = 0;
        public boolean isEnable = true;
        public String text = "";
        static final int NULL_TYPE = 0;
        static final int ADD_TYPE = 2;
        static final int MINU_TYPE = 1;

        public void setType(int type) {
            this.type = type;
        }

        public ControlIcon(String text, int type) {
            this.type = type;
            this.text = text;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }

        @Override
        public int getIconWidth() {
            if (this.type == 0) {
                return 20;
            }
            return 10;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int warp = 0;
            int iconWidth = this.getIconWidth() - warp;
            int iconHeight = this.getIconHeight() - warp;
            int crossX1 = warp + 2;
            int crossX2 = iconWidth / 2;
            int crossX3 = iconWidth - 2;
            int crossY1 = 2;
            int crossY2 = iconHeight / 2;
            int crossY3 = iconHeight - 2;
            g.translate(x, y);
            if (this.type != 0) {
                TKTreeTableUI.this.iconLocations.add(new Point(x, y));
                g.setColor(Color.white);
                g.fillRect(warp, warp, iconWidth, iconHeight);
                g.setColor(UIManager.getColor("controlShadow"));
                g.drawLine(warp, warp, warp, iconHeight);
                g.drawLine(warp, warp, iconWidth, warp);
                g.drawLine(warp, iconHeight, iconWidth, iconHeight);
                g.drawLine(iconWidth, warp, iconWidth, iconHeight);
                if (this.isEnable) {
                    g.setColor(Color.BLACK);
                }
                if (this.type == 2) {
                    g.drawLine(crossX2, crossY1, crossX2, crossY3);
                }
                g.drawLine(crossX1, crossY2, crossX3, crossY2);
            } else if (this.text != null && !this.text.trim().equals("")) {
                int fontWidth = TKTreeTableUI.this.getTextWidth((Graphics2D)g, this.text, g.getFont());
                g.setColor(Color.BLACK);
                g.drawChars(this.text.toCharArray(), 0, this.text.length(), iconWidth - fontWidth + 4, iconHeight);
            }
            g.translate(-x, -y);
        }
    }

    public class TKMouseHandler
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            if (!TKTreeTableUI.this.tabletree.isShowControlIcon()) {
                return;
            }
            int row = TKTreeTableUI.this.tabletree.rowAtPoint(e.getPoint());
            int column = TKTreeTableUI.this.tabletree.columnAtPoint(e.getPoint());
            if (row < 0 || column < 0 || column > 0) {
                return;
            }
            if (e.getClickCount() % 2 != 0 && TKTreeTableUI.this.rowAtExpandControlWithPonit(e.getX(), e.getY()) < 0) {
                return;
            }
            TKTreeRowEntry rowEntry = TKTreeTableUI.this.tabletree.getRow(row);
            if (rowEntry == null || rowEntry.getRowType() == 16) {
                return;
            }
            int state = rowEntry.getRowState();
            if ((state & 2) > 0) {
                TKTreeTableUI.this.tabletree.expandRow(row);
            } else if ((state & 1) > 0) {
                TKTreeTableUI.this.tabletree.collapseRow(row);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TKTreeTableUI.this.tabletree.repaint();
        }
    }
}

