/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.treetable;

import com.huawei.dc.toolkit.client.base.util.treetable.TKDefaultTreeRow;
import com.huawei.dc.toolkit.client.base.util.treetable.TKTreeRowEntry;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;

public class TKTreeTableModel
extends DefaultTableModel {
    protected Vector myDataVector = new Vector();

    public TKTreeTableModel(Object[] columns) {
        super(columns, 0);
    }

    public Vector getDatas() {
        return this.myDataVector;
    }

    public void expandRow(int row) {
        TKTreeRowEntry rowData = this.getRow(row);
        if (rowData == null || rowData.getChildCount() == 0 || (rowData.getRowState() & 2) == 0) {
            return;
        }
        Vector vChildren = rowData.children();
        Object[] children = new TKTreeRowEntry[vChildren.size()];
        vChildren.copyInto(children);
        for (int i = 0; i < children.length; ++i) {
            this.insertRow(row + i + 1, (TKTreeRowEntry)children[i]);
        }
        rowData.setRowState(1);
    }

    public void collapseRow(int row) {
        TKTreeRowEntry rowData = this.getRow(row);
        if (rowData == null || rowData.getChildCount() == 0 || (rowData.getRowState() & 1) == 0) {
            return;
        }
        Vector children = rowData.children();
        for (int i = 0; i < children.size(); ++i) {
            TKTreeRowEntry child = (TKTreeRowEntry)children.get(i);
            this.removeRowWithChildren(child);
        }
        rowData.setRowState(2);
        this.fireTableRowsDeleted(row, row);
    }

    public void removeRow(TKTreeRowEntry rowData) {
        this.removeRowWithChildren(rowData);
        this.fireTableDataChanged();
    }

    protected void removeRowWithChildren(TKTreeRowEntry rowData) {
        rowData.setRowState(2);
        int index1 = this.myDataVector.indexOf(rowData);
        if (index1 < 0) {
            return;
        }
        this.myDataVector.removeElement(rowData);
        Vector children = rowData.children();
        for (int i = 0; i < children.size(); ++i) {
            TKTreeRowEntry child = (TKTreeRowEntry)children.get(i);
            this.removeRowWithChildren(child);
        }
    }

    public TKTreeRowEntry getRow(int row) {
        if (row >= this.myDataVector.size() || row < 0) {
            return null;
        }
        return (TKTreeRowEntry)this.myDataVector.get(row);
    }

    @Override
    public int getRowCount() {
        if (this.myDataVector == null) {
            return 0;
        }
        return this.myDataVector.size();
    }

    public void addRow(TKTreeRowEntry rowData) {
        this.insertRow(this.getRowCount(), rowData);
    }

    public ArrayList collapseAllRows() {
        int row = 0;
        ArrayList<TKTreeRowEntry> collapsdNodes = new ArrayList<TKTreeRowEntry>();
        block0: while (row < this.getRowCount() - 1) {
            int rowCount = this.getRowCount();
            int i = row;
            while (i < rowCount) {
                TKTreeRowEntry rowData = this.getRow(i);
                row = i++;
                if (rowData.getRowState() != 1) continue;
                collapsdNodes.add(rowData);
                this.collapseRow(i);
                continue block0;
            }
        }
        if (collapsdNodes.size() > 0) {
            return collapsdNodes;
        }
        return null;
    }

    public void insertRow(int row, TKTreeRowEntry rowData) {
        this.myDataVector.insertElementAt(rowData, row);
        this.justifyRows1(row, row + 1);
        this.fireTableRowsInserted(row, row);
    }

    @Override
    public void insertRow(int row, Object[] rowData) {
        this.myDataVector.insertElementAt(new TKDefaultTreeRow(rowData), row);
        this.justifyRows1(row, row + 1);
        this.fireTableRowsInserted(row, row);
    }

    public void insertRow(int row, Vector rowData) {
        this.myDataVector.insertElementAt(new TKDefaultTreeRow(rowData), row);
        this.justifyRows1(row, row + 1);
        this.fireTableRowsInserted(row, row);
    }

    @Override
    public void removeRow(int row) {
        this.removeRow(this.getRow(row));
        super.removeRow(row);
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        TKTreeRowEntry rowData = this.getRow(row);
        if (rowData != null) {
            rowData.setValueAt(column, aValue);
        } else {
            new IllegalArgumentException(" setValueAt: " + row + "," + column).printStackTrace();
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        TKTreeRowEntry rowData = this.getRow(row);
        if (rowData == null) {
            throw new IllegalArgumentException(" getValueAt: " + row + "," + column);
        }
        return rowData.getValueAt(column);
    }

    private void justifyRows1(int from, int to) {
        for (int i = 0; i < to; ++i) {
            if (from > i || this.myDataVector.elementAt(i) != null) continue;
            this.myDataVector.setElementAt(new TKDefaultTreeRow(), i);
        }
    }
}

