/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.treetable;

import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.component.TKTooltipTable;
import com.huawei.dc.toolkit.client.base.util.treetable.TKTreeRowEntry;
import com.huawei.dc.toolkit.client.base.util.treetable.TKTreeTableModel;
import com.huawei.dc.toolkit.client.base.util.treetable.TKTreeTableUI;
import java.util.EventObject;
import javax.swing.Icon;

public class TKTreeTable
extends TKTooltipTable {
    TKTreeTableModel treeModel;
    protected transient Icon collapsedIcon;
    protected transient Icon expandedIcon;
    protected transient Icon leafIcon;
    TKTreeTableUI tableUI;
    private boolean isShowControlIcon = true;

    public TKTreeTable(Object[] columns) {
        this(new TKTreeTableModel(columns));
    }

    public TKTreeTable(TKTreeTableModel model) {
        super(model);
        this.treeModel = model;
        this.setUI(TKTreeTableUI.createUI(this));
        this.setExpandedIcon(TKResourceManager.getIcon("ne.gif"));
        this.setCollapsedIcon(TKResourceManager.getIcon("ne.gif"));
        this.setLeafIcon(TKResourceManager.getIcon("board.gif"));
        this.getTableHeader().setReorderingAllowed(false);
    }

    public void expandRow(int row) {
        this.treeModel.expandRow(row);
        this.repaint();
    }

    public void collapseRow(int row) {
        this.treeModel.collapseRow(row);
        this.repaint();
    }

    public void collapseAllRows() {
        int row = 0;
        block0: while (row < this.getRowCount() - 1) {
            int rowCount = this.getRowCount();
            int i = row;
            while (i < rowCount) {
                TKTreeRowEntry rowData = this.getRow(i);
                row = i++;
                if (rowData.getRowState() != 1) continue;
                this.collapseRow(i);
                continue block0;
            }
        }
    }

    public boolean isShowControlIcon() {
        return this.isShowControlIcon;
    }

    public void isShowControlIcon(boolean isShowControlIcon) {
        this.isShowControlIcon = isShowControlIcon;
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.treeModel.getValueAt(row, column);
    }

    public TKTreeRowEntry getRow(int row) {
        return this.treeModel.getRow(row);
    }

    public static int getDepth(TKTreeRowEntry rowEntry) {
        int depth = 0;
        if (rowEntry == null) {
            return 0;
        }
        TKTreeRowEntry parent = rowEntry.getParent();
        if (parent != null) {
            ++depth;
            for (parent = parent.getParent(); parent != null; parent = parent.getParent()) {
                ++depth;
            }
        }
        return depth;
    }

    public void setLeafIcon(Icon icon) {
        this.leafIcon = icon;
    }

    public void setExpandedIcon(Icon icon) {
        this.expandedIcon = icon;
    }

    public void setCollapsedIcon(Icon icon) {
        this.collapsedIcon = icon;
    }

    public Icon getCollapsedIcon(int row) {
        return this.collapsedIcon;
    }

    public String getTextForIcon(int row) {
        return "";
    }

    public Icon getIcon(int row) {
        TKTreeRowEntry rowData = this.getRow(row);
        if (rowData != null) {
            if (!rowData.getAllowsChildren() || rowData.getRowType() == 16 || rowData.getChildCount() == 0) {
                return this.leafIcon;
            }
            if (rowData.getRowState() == 2) {
                return this.collapsedIcon;
            }
            return this.expandedIcon;
        }
        return this.leafIcon;
    }

    @Override
    public final boolean editCellAt(int row, int column, EventObject e) {
        if (column == 0) {
            return false;
        }
        return super.editCellAt(row, column, e);
    }

    @Override
    public final boolean getShowVerticalLines() {
        return false;
    }

    public void updateRow(int row) {
        TKTreeRowEntry rowData = this.getRow(row);
        if (rowData == null) {
            return;
        }
        if (rowData.getRowState() == 1) {
            this.collapseRow(row);
            this.expandRow(row);
        } else if (rowData.getRowState() == 2) {
            this.expandRow(row);
            this.collapseRow(row);
        }
    }
}

