/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.treetable;

import com.huawei.dc.toolkit.client.base.util.treetable.TKTreeRowEntry;
import java.util.Vector;

public class TKDefaultTreeRow
implements TKTreeRowEntry {
    private boolean mixColumns = false;
    private boolean paintIcon = true;
    private boolean isVisible = true;
    private TKTreeRowEntry parent = null;
    private Vector children = new Vector();
    private int childCount = 0;
    private Vector datas = new Vector();
    private int rowState = 2;
    private int rowType = 8;
    private boolean allowsChildren = true;

    public TKDefaultTreeRow(Object[] datas) {
        this.datas = TKDefaultTreeRow.convertToVector(datas);
    }

    public TKDefaultTreeRow(Vector datas) {
        this.datas = datas;
    }

    public TKDefaultTreeRow() {
        this.datas = new Vector();
    }

    @Override
    public void setRowState(int rowState) {
        this.rowState = rowState;
    }

    @Override
    public int getRowState() {
        return this.rowState;
    }

    public void setDatas(Vector datas) {
        this.datas = datas;
    }

    @Override
    public Vector getValues() {
        return this.datas;
    }

    @Override
    public void setValueAt(int column, Object value) {
        if (column >= this.datas.size()) {
            this.datas.setSize(column + 1);
            this.datas.insertElementAt(value, column);
        } else {
            this.datas.set(column, value);
        }
    }

    @Override
    public Object getValueAt(int column) {
        if (column >= this.datas.size()) {
            return null;
        }
        return this.datas.get(column);
    }

    @Override
    public TKTreeRowEntry getParent() {
        return this.parent;
    }

    @Override
    public void setParent(TKTreeRowEntry newParent) {
        this.parent = newParent;
    }

    @Override
    public void insertChild(TKTreeRowEntry childRow) {
        childRow.setParent(this);
        if (!this.children.contains(childRow)) {
            this.children.add(childRow);
            ++this.childCount;
        }
    }

    @Override
    public void removeChild(TKTreeRowEntry childRow) {
        if (this.children.contains(childRow)) {
            this.children.remove(childRow);
            --this.childCount;
        }
    }

    @Override
    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public Vector children() {
        if (this.children == null) {
            return null;
        }
        return this.children;
    }

    @Override
    public int getRowType() {
        return this.rowType;
    }

    public int getObjectType() {
        return 0;
    }

    @Override
    public void setRowType(int rowType) {
        this.rowType = rowType;
    }

    @Override
    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    @Override
    public void setAllowsChildren(boolean allowsChildren) {
        this.allowsChildren = allowsChildren;
    }

    protected static Vector convertToVector(Object[] anArray) {
        if (anArray == null) {
            return null;
        }
        Vector<Object> v = new Vector<Object>(anArray.length);
        for (int i = 0; i < anArray.length; ++i) {
            v.addElement(anArray[i]);
        }
        return v;
    }

    public int compareTo(Object o) {
        if (!(o instanceof TKTreeRowEntry)) {
            return -1;
        }
        TKTreeRowEntry obj = (TKTreeRowEntry)o;
        return obj.hashCode() - this.hashCode();
    }

    public int hashCode() {
        String hashCode = "HashCode" + this.parent.hashCode() + this.children.hashCode() + this.datas.hashCode();
        return hashCode.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TKDefaultTreeRow)) {
            return false;
        }
        TKDefaultTreeRow obj = (TKDefaultTreeRow)o;
        return obj.hashCode() == this.hashCode();
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public boolean mixColumns() {
        return this.mixColumns;
    }

    public void mixColumns(boolean mixColumns) {
        this.mixColumns = mixColumns;
    }

    @Override
    public int minMixColumn() {
        return 0;
    }

    public void paintIcon(boolean paintIcon) {
        this.paintIcon = paintIcon;
    }

    @Override
    public boolean paintIcon() {
        return this.paintIcon;
    }
}

