/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.text;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.text.TKCommandLine;

public class TKPasswordRule {
    public static final char COLON = ':';
    public static final char COMMA = ',';
    public static final char SEMICOLON = ';';
    boolean isByKeyWord = false;
    boolean cmaValid = true;
    int colonNum = 0;
    int commaNum = 0;
    String cmdKey = "";
    String keyWord = "";

    public TKPasswordRule(String cmd, int cln, int cma, String key, boolean byKeyWord) {
        this.colonNum = cln;
        this.commaNum = cma;
        this.cmdKey = cmd;
        this.keyWord = key;
        this.isByKeyWord = byKeyWord;
        this.cmaValid = this.commaNum >= 0;
    }

    public TKPasswordRule(String cmd, int cln, int cma, String key) {
        this(cmd, cln, cma, key, true);
    }

    public TKPasswordRule(String cmd, int cln, int cma) {
        this(cmd, cln, cma, null, false);
    }

    public boolean isPwdPosition(String cmdLine, int offset) {
        if (this.isByKeyWord) {
            return this.isPwdPositionByKeyword(cmdLine, offset);
        }
        return this.isPwdPositionByPosition(cmdLine, offset);
    }

    private boolean isPwdPositionByPosition(String cmdLine, int offset) {
        int commasNIQuot;
        int colonsNIQuot;
        if (cmdLine.toLowerCase().indexOf(this.cmdKey.toLowerCase()) < 0) {
            return false;
        }
        if (offset > cmdLine.length()) {
            return false;
        }
        String headText = cmdLine.toLowerCase().substring(0, offset);
        if (!TKPasswordRule.checkQuotationmarks(headText)) {
            return false;
        }
        int cmdPosition = TKCommandLine.getWholeWordIndex(headText.toLowerCase(), this.cmdKey.toLowerCase());
        if (cmdPosition < 0) {
            return false;
        }
        String validText = headText.substring(cmdPosition);
        if (validText.indexOf(String.valueOf(';')) >= 0) {
            return false;
        }
        int colons = TKCommandLine.getCharNumber(validText, ':');
        if (colons - (colonsNIQuot = TKPasswordRule.getCharNumberInQuotationmark(validText, ':')) != this.colonNum) {
            return false;
        }
        if (!this.cmaValid) {
            return true;
        }
        int lastClnPs = validText.lastIndexOf(String.valueOf(':'));
        String forCmaText = validText.substring(lastClnPs);
        int commas = TKCommandLine.getCharNumber(forCmaText, ',');
        return commas - (commasNIQuot = TKPasswordRule.getCharNumberInQuotationmark(forCmaText, ',')) == this.commaNum;
    }

    private boolean isPwdPositionByKeyword(String cmdLine, int offset) {
        int commasNIQuot1;
        int colonsNIQuot2;
        int colonsNIQuot1;
        if (cmdLine.toLowerCase().indexOf(this.cmdKey.toLowerCase()) < 0) {
            return false;
        }
        if (offset > cmdLine.length()) {
            return false;
        }
        String headText = cmdLine.substring(0, offset);
        if (!TKPasswordRule.checkQuotationmarks(headText)) {
            return false;
        }
        int cmdPosition = TKCommandLine.getWholeWordIndex(headText.toLowerCase(), this.cmdKey.toLowerCase());
        if (cmdPosition < 0) {
            return false;
        }
        String validText = headText.substring(cmdPosition);
        if (validText.indexOf(String.valueOf(';')) >= 0) {
            return false;
        }
        int keyPosition = TKCommandLine.getLeftWordIndex(validText.toLowerCase(), this.keyWord.toLowerCase());
        if (keyPosition < 0) {
            return false;
        }
        String textAfterKey = headText.substring(keyPosition + 1);
        if (textAfterKey.indexOf(44) >= 0) {
            return false;
        }
        String keyText = validText.substring(0, keyPosition);
        int colons1 = TKCommandLine.getCharNumber(keyText, ':');
        if (colons1 - (colonsNIQuot1 = TKPasswordRule.getCharNumberInQuotationmark(keyText, ':')) != this.colonNum) {
            return false;
        }
        int colons2 = TKCommandLine.getCharNumber(validText, ':');
        if (colons2 - (colonsNIQuot2 = TKPasswordRule.getCharNumberInQuotationmark(validText, ':')) != this.colonNum) {
            return false;
        }
        if (!this.cmaValid) {
            return true;
        }
        int lastClnPs = validText.lastIndexOf(String.valueOf(':'));
        String forCmaText = validText.substring(lastClnPs);
        int commas1 = TKCommandLine.getCharNumber(forCmaText, ',');
        return commas1 - (commasNIQuot1 = TKPasswordRule.getCharNumberInQuotationmark(forCmaText, ',')) == this.commaNum;
    }

    public static boolean checkQuotationmarks(String commandText) {
        int questionMarks = TKCommandLine.getWordNumber(commandText, "\\\"");
        int quotationMarks = TKCommandLine.getCharNumber(commandText, '\"');
        return (quotationMarks - questionMarks) % 2 == 0;
    }

    public static int getCharNumberInQuotationmark(String commandText, char c) {
        int i;
        if (commandText.indexOf(34) < 0) {
            return 0;
        }
        String[] quots = TKCommandLine.split(commandText, '\"');
        String[] quots2 = new String[quots.length];
        int number = 0;
        int k = 0;
        for (i = 0; i < quots.length; ++i) {
            quots2[i] = "";
            String quot = quots[i];
            if (quot.endsWith("\\")) {
                int tempI;
                StringBuffer subQuot = new StringBuffer();
                for (int j = tempI = i + 1; j < quots.length; ++j) {
                    subQuot.append(quots[j]);
                    quots2[++i] = "";
                    if (!quots[j].endsWith("\\")) break;
                }
                quot = quot + subQuot.toString();
            }
            quots2[k] = quot;
            ++k;
        }
        for (i = 0; i < quots2.length; ++i) {
            DCDebugTracer.trace(i + "\t" + quots2[i]);
            if (i % 2 == 0) continue;
            number += TKCommandLine.getCharNumber(quots2[i], c);
        }
        return number;
    }
}

